/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.kev;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONObject;

public class KevData {
    private String vulnerability;
    private String vendor;
    private String product;
    private String summary;
    private String description;
    private String notes;
    private String recommendation;
    private Date publishDate;
    private Date exploitDate;
    private Date dueDate;
    private RansomwareState ransomwareState;

    public KevData(String vulnerability, RansomwareState state) {
        this.vulnerability = vulnerability;
        this.ransomwareState = state;
    }

    public Document toDocument() {
        Document document = new Document();
        this.addFieldToDocument(document, "vulnerability", this.vulnerability);
        this.addFieldToDocument(document, "vendor", this.vendor);
        this.addFieldToDocument(document, "product", this.product);
        this.addFieldToDocument(document, "summary", this.summary);
        this.addFieldToDocument(document, "description", this.description);
        this.addFieldToDocument(document, "recommendation", this.recommendation);
        this.addFieldToDocument(document, "notes", this.notes);
        this.addFieldToDocument(document, "publishDate", this.publishDate == null ? null : Long.toString(this.publishDate.getTime()));
        this.addFieldToDocument(document, "exploitDate", this.exploitDate == null ? null : Long.toString(this.exploitDate.getTime()));
        this.addFieldToDocument(document, "dueDate", this.dueDate == null ? null : Long.toString(this.dueDate.getTime()));
        this.addFieldToDocument(document, "knownRansomwareCampaignUse", String.valueOf((Object)this.ransomwareState));
        return document;
    }

    public static KevData fromDocument(Document document) {
        KevData kevData = new KevData();
        kevData.setVulnerability(KevData.returnNullIfEmpty(document.get("vulnerability")));
        kevData.setVendor(KevData.returnNullIfEmpty(document.get("vendor")));
        kevData.setProduct(KevData.returnNullIfEmpty(document.get("product")));
        kevData.setSummary(KevData.returnNullIfEmpty(document.get("summary")));
        kevData.setDescription(KevData.returnNullIfEmpty(document.get("description")));
        kevData.setRecommendation(KevData.returnNullIfEmpty(document.get("recommendation")));
        kevData.setNotes(KevData.returnNullIfEmpty(document.get("notes")));
        kevData.setPublishDate(TimeUtils.tryParse(document.get("publishDate")));
        kevData.setExploitDate(TimeUtils.tryParse(document.get("exploitDate")));
        kevData.setDueDate(TimeUtils.tryParse(document.get("dueDate")));
        if (document.get("knownRansomwareCampaignUse") != null) {
            kevData.setRansomwareState(RansomwareState.valueOf(document.get("knownRansomwareCampaignUse")));
        }
        return kevData;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("vulnerability", (Object)this.vulnerability);
        jsonObject.put("vendor", (Object)this.vendor);
        jsonObject.put("product", (Object)this.product);
        jsonObject.put("summary", (Object)this.summary);
        jsonObject.put("description", (Object)this.description);
        jsonObject.put("recommendation", (Object)this.recommendation);
        jsonObject.put("notes", (Object)this.notes);
        jsonObject.put("publishDate", this.publishDate == null ? null : Long.valueOf(this.publishDate.getTime()));
        jsonObject.put("exploitDate", this.exploitDate == null ? null : Long.valueOf(this.exploitDate.getTime()));
        jsonObject.put("dueDate", this.dueDate == null ? null : Long.valueOf(this.dueDate.getTime()));
        jsonObject.put("knownRansomwareCampaignUse", (Object)this.ransomwareState);
        return jsonObject;
    }

    public static KevData fromJson(JSONObject json) {
        if (json == null) {
            return null;
        }
        return KevData.fromInputMap(json.toMap());
    }

    public static KevData fromInputMap(Map<String, Object> map) {
        KevData kevData = new KevData();
        kevData.setVulnerability((String)map.get("vulnerability"));
        kevData.setVendor((String)map.get("vendor"));
        kevData.setProduct((String)map.get("product"));
        kevData.setSummary((String)map.get("summary"));
        kevData.setDescription((String)map.get("description"));
        kevData.setRecommendation((String)map.get("recommendation"));
        kevData.setNotes((String)map.get("notes"));
        kevData.setPublishDate(TimeUtils.tryParse(map.get("publishDate")));
        kevData.setExploitDate(TimeUtils.tryParse(map.get("exploitDate")));
        kevData.setDueDate(TimeUtils.tryParse(map.get("dueDate")));
        if (map.containsKey("knownRansomwareCampaignUse")) {
            Object knownRansomwareCampaignUse = map.get("knownRansomwareCampaignUse");
            if (knownRansomwareCampaignUse instanceof Boolean) {
                kevData.setRansomwareState((Boolean)knownRansomwareCampaignUse != false ? RansomwareState.KNOWN : RansomwareState.UNKNOWN);
            } else if (knownRansomwareCampaignUse instanceof String) {
                kevData.setRansomwareState(RansomwareState.valueOf((String)knownRansomwareCampaignUse));
            } else if (knownRansomwareCampaignUse instanceof RansomwareState) {
                kevData.setRansomwareState((RansomwareState)((Object)knownRansomwareCampaignUse));
            } else {
                throw new IllegalArgumentException("Unknown type for knownRansomwareCampaignUse: " + knownRansomwareCampaignUse.getClass() + " on " + map);
            }
        }
        return kevData;
    }

    public static KevData fromCisaKev(JSONObject json) {
        Map map = json.toMap();
        KevData kevData = new KevData();
        kevData.setVulnerability(map.getOrDefault("cveID", null));
        kevData.setVendor(map.getOrDefault("vendorProject", null));
        kevData.setProduct(map.getOrDefault("product", null));
        kevData.setSummary(map.getOrDefault("vulnerabilityName", null));
        kevData.setRecommendation(map.getOrDefault("requiredAction", null));
        kevData.setNotes(map.getOrDefault("notes", null));
        kevData.setDescription(map.getOrDefault("shortDescription", null));
        kevData.setPublishDate(TimeUtils.tryParse(map.getOrDefault("dateAdded", null)));
        kevData.setDueDate(TimeUtils.tryParse(map.getOrDefault("dueDate", null)));
        String ransomwareKnown = map.getOrDefault("knownRansomwareCampaignUse", null);
        if (ransomwareKnown != null) {
            switch (ransomwareKnown) {
                case "Known": {
                    kevData.setRansomwareState(RansomwareState.KNOWN);
                    break;
                }
                default: {
                    kevData.setRansomwareState(RansomwareState.UNKNOWN);
                }
            }
        }
        return kevData;
    }

    private void addFieldToDocument(Document document, String fieldName, String fieldValue) {
        if (fieldValue != null && !fieldValue.equals("null")) {
            document.add((IndexableField)new TextField(fieldName, fieldValue, Field.Store.YES));
        }
    }

    private static String returnNullIfEmpty(String string) {
        return StringUtils.isEmpty(string) ? null : string;
    }

    public String getVulnerability() {
        return this.vulnerability;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProduct() {
        return this.product;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    public Date getPublishDate() {
        return this.publishDate;
    }

    public Date getExploitDate() {
        return this.exploitDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public RansomwareState getRansomwareState() {
        return this.ransomwareState;
    }

    public void setVulnerability(String vulnerability) {
        this.vulnerability = vulnerability;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setRecommendation(String recommendation) {
        this.recommendation = recommendation;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public void setExploitDate(Date exploitDate) {
        this.exploitDate = exploitDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setRansomwareState(RansomwareState ransomwareState) {
        this.ransomwareState = ransomwareState;
    }

    private KevData(String vulnerability, String vendor, String product, String summary, String description, String notes, String recommendation, Date publishDate, Date exploitDate, Date dueDate, RansomwareState ransomwareState) {
        this.vulnerability = vulnerability;
        this.vendor = vendor;
        this.product = product;
        this.summary = summary;
        this.description = description;
        this.notes = notes;
        this.recommendation = recommendation;
        this.publishDate = publishDate;
        this.exploitDate = exploitDate;
        this.dueDate = dueDate;
        this.ransomwareState = ransomwareState;
    }

    public KevData() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KevData)) {
            return false;
        }
        KevData other = (KevData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$vulnerability = this.getVulnerability();
        String other$vulnerability = other.getVulnerability();
        if (this$vulnerability == null ? other$vulnerability != null : !this$vulnerability.equals(other$vulnerability)) {
            return false;
        }
        String this$vendor = this.getVendor();
        String other$vendor = other.getVendor();
        if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        String this$recommendation = this.getRecommendation();
        String other$recommendation = other.getRecommendation();
        if (this$recommendation == null ? other$recommendation != null : !this$recommendation.equals(other$recommendation)) {
            return false;
        }
        Date this$publishDate = this.getPublishDate();
        Date other$publishDate = other.getPublishDate();
        if (this$publishDate == null ? other$publishDate != null : !((Object)this$publishDate).equals(other$publishDate)) {
            return false;
        }
        Date this$exploitDate = this.getExploitDate();
        Date other$exploitDate = other.getExploitDate();
        if (this$exploitDate == null ? other$exploitDate != null : !((Object)this$exploitDate).equals(other$exploitDate)) {
            return false;
        }
        Date this$dueDate = this.getDueDate();
        Date other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        RansomwareState this$ransomwareState = this.getRansomwareState();
        RansomwareState other$ransomwareState = other.getRansomwareState();
        return !(this$ransomwareState == null ? other$ransomwareState != null : !((Object)((Object)this$ransomwareState)).equals((Object)other$ransomwareState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KevData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $vulnerability = this.getVulnerability();
        result = result * 59 + ($vulnerability == null ? 43 : $vulnerability.hashCode());
        String $vendor = this.getVendor();
        result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        String $recommendation = this.getRecommendation();
        result = result * 59 + ($recommendation == null ? 43 : $recommendation.hashCode());
        Date $publishDate = this.getPublishDate();
        result = result * 59 + ($publishDate == null ? 43 : ((Object)$publishDate).hashCode());
        Date $exploitDate = this.getExploitDate();
        result = result * 59 + ($exploitDate == null ? 43 : ((Object)$exploitDate).hashCode());
        Date $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        RansomwareState $ransomwareState = this.getRansomwareState();
        result = result * 59 + ($ransomwareState == null ? 43 : ((Object)((Object)$ransomwareState)).hashCode());
        return result;
    }

    public static enum RansomwareState {
        UNKNOWN,
        KNOWN;

    }
}

