/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.msrcdata;

import com.metaeffekt.mirror.contents.base.Reference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class MsrcRemediation
implements Comparable<MsrcRemediation> {
    private final String type;
    private final String subType;
    private final String description;
    private final Reference url;
    private final Set<String> affectedProductIds;
    private final String fixedBuild;
    private final String supercedence;

    public MsrcRemediation(String type, String subType, String description, Reference url, Set<String> affectedProductIds, String fixedBuild, String supercedence) {
        this.type = type;
        this.subType = subType;
        this.description = description;
        this.url = url;
        this.affectedProductIds = affectedProductIds;
        this.fixedBuild = fixedBuild;
        this.supercedence = supercedence;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getDescription() {
        return this.description;
    }

    public Reference getUrl() {
        return this.url;
    }

    public Set<String> getAffectedProductIds() {
        return this.affectedProductIds;
    }

    public String getFixedBuild() {
        return this.fixedBuild;
    }

    public String getSupercedence() {
        return this.supercedence;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.type);
        json.put("subType", (Object)this.subType);
        json.put("description", (Object)this.description);
        json.put("url", this.url == null ? null : this.url.toJson());
        json.put("affectedProductIds", (Object)new JSONArray(this.affectedProductIds));
        json.put("fixedBuild", (Object)this.fixedBuild);
        json.put("supercedence", (Object)this.supercedence);
        return json;
    }

    public static MsrcRemediation fromJson(JSONObject json) {
        return new MsrcRemediation(json.optString("type", null), json.optString("subType", null), json.optString("description", null), json.has("url") ? Reference.fromJson(json.getJSONObject("url")) : null, json.getJSONArray("affectedProductIds").toList().stream().map(Object::toString).collect(Collectors.toSet()), json.optString("fixedBuild", null), json.optString("supercedence", null));
    }

    public static MsrcRemediation fromMap(Map<String, Object> map) {
        return new MsrcRemediation((String)map.get("type"), (String)map.get("subType"), (String)map.get("description"), map.containsKey("url") ? Reference.fromMap((Map)map.get("url")) : null, ((List)map.get("affectedProductIds")).stream().collect(Collectors.toSet()), (String)map.get("fixedBuild"), (String)map.get("supercedence"));
    }

    public static List<MsrcRemediation> fromJson(JSONArray json) {
        ArrayList<MsrcRemediation> threats = new ArrayList<MsrcRemediation>();
        for (Object object : json) {
            threats.add(MsrcRemediation.fromJson((JSONObject)object));
        }
        return threats;
    }

    public static List<MsrcRemediation> fromMap(List<Map<String, Object>> map) {
        ArrayList<MsrcRemediation> threats = new ArrayList<MsrcRemediation>();
        for (Map<String, Object> threat : map) {
            threats.add(MsrcRemediation.fromMap(threat));
        }
        return threats;
    }

    @Override
    public int compareTo(MsrcRemediation o) {
        return Comparator.comparing(MsrcRemediation::toDescription).compare(this, o);
    }

    private static String toDescription(MsrcRemediation msrcRemediation) {
        if (msrcRemediation == null) {
            return "";
        }
        String description = msrcRemediation.getDescription();
        return description == null ? "" : description;
    }
}

