/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.msrcdata;

import com.metaeffekt.mirror.contents.msrcdata.MsrcSupersedeNodeRelations;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONObject;

public class MsrcSupersedeNode {
    private final String kbId;
    private final String articleUrl;
    private final String downloadUrl;
    private final Map<String, MsrcSupersedeNodeRelations> productRelations = new HashMap<String, MsrcSupersedeNodeRelations>();

    public MsrcSupersedeNode(String kbId) {
        this(kbId, null, null);
    }

    public MsrcSupersedeNode(String kbId, String articleUrl, String downloadUrl) {
        this.kbId = kbId;
        this.articleUrl = articleUrl;
        this.downloadUrl = downloadUrl;
    }

    public void addSupersededBy(String product, MsrcSupersedeNode node) {
        this.productRelations.computeIfAbsent(product, k -> new MsrcSupersedeNodeRelations()).addSupersededBy(node);
    }

    public void addSupersededBy(String product, Collection<MsrcSupersedeNode> supersededBy) {
        this.productRelations.computeIfAbsent(product, k -> new MsrcSupersedeNodeRelations()).addSupersededBy(supersededBy);
    }

    public void addSupersedes(String product, MsrcSupersedeNode node) {
        this.productRelations.computeIfAbsent(product, k -> new MsrcSupersedeNodeRelations()).addSupersedes(node);
    }

    public void addSupersedes(String product, Collection<MsrcSupersedeNode> superseded) {
        this.productRelations.computeIfAbsent(product, k -> new MsrcSupersedeNodeRelations()).addSupersedes(superseded);
    }

    public void addAffectsVulnerability(String product, String vulnerabilityId) {
        this.productRelations.computeIfAbsent(product, k -> new MsrcSupersedeNodeRelations()).addAffectsVulnerability(vulnerabilityId);
    }

    public void addAffectsVulnerability(String product, Collection<String> vulnerabilityIds) {
        this.productRelations.computeIfAbsent(product, k -> new MsrcSupersedeNodeRelations()).addAffectsVulnerability(vulnerabilityIds);
    }

    public String getKbId() {
        return this.kbId;
    }

    public String getArticleUrl() {
        return this.articleUrl;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public Map<String, MsrcSupersedeNodeRelations> getProductRelations() {
        return this.productRelations;
    }

    public Set<String> getProductNames() {
        return this.productRelations.keySet();
    }

    public MsrcSupersedeNodeRelations getProductRelationsByProduct(String product) {
        return this.productRelations.get(product);
    }

    public boolean containsVulnerability(String vulnerability) {
        return this.productRelations.values().stream().anyMatch(p -> p.getAffectsVulnerabilities().contains(vulnerability));
    }

    public boolean containsVulnerability(String vulnerability, String product) {
        return this.productRelations.containsKey(product) && this.productRelations.get(product).getAffectsVulnerabilities().contains(vulnerability);
    }

    public boolean containsSupersededKbId(String kbId) {
        return this.productRelations.values().stream().anyMatch(p -> p.getSupersedes().stream().anyMatch(s -> s.getKbId().equals(kbId)));
    }

    public boolean containsSupersededKbId(String kbId, String product) {
        return this.productRelations.containsKey(product) && this.productRelations.get(product).getSupersedes().stream().anyMatch(s -> s.getKbId().equals(kbId));
    }

    public boolean containsSupersededByKbId(String kbId) {
        return this.productRelations.values().stream().anyMatch(p -> p.getSupersededBy().stream().anyMatch(s -> s.getKbId().equals(kbId)));
    }

    public boolean containsSupersededByKbId(String kbId, String product) {
        return this.productRelations.containsKey(product) && this.productRelations.get(product).getSupersededBy().stream().anyMatch(s -> s.getKbId().equals(kbId));
    }

    public String toString() {
        return this.kbId;
    }

    public JSONObject toJson() {
        return new JSONObject().put("kbId", (Object)this.kbId).put("articleUrl", (Object)this.articleUrl).put("downloadUrl", (Object)this.downloadUrl).put("rel", this.productRelations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MsrcSupersedeNodeRelations)e.getValue()).toJson())));
    }

    public Document toDocument() {
        Document doc = new Document();
        doc.add((IndexableField)new TextField("kbId", this.kbId, Field.Store.YES));
        if (this.articleUrl != null) {
            doc.add((IndexableField)new TextField("articleUrl", this.articleUrl, Field.Store.YES));
        }
        if (this.downloadUrl != null) {
            doc.add((IndexableField)new TextField("downloadUrl", this.downloadUrl, Field.Store.YES));
        }
        JSONObject relationJson = new JSONObject(this.productRelations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MsrcSupersedeNodeRelations)e.getValue()).toJson())));
        doc.add((IndexableField)new TextField("rel", relationJson.toString(), Field.Store.YES));
        return doc;
    }

    public static MsrcSupersedeNode fromJson(JSONObject json, Map<String, MsrcSupersedeNode> nodes) {
        MsrcSupersedeNode node = nodes.computeIfAbsent(json.getString("kbId"), kb -> {
            String articleUrl = json.optString("articleUrl", null);
            String downloadUrl = json.optString("downloadUrl", null);
            return new MsrcSupersedeNode((String)kb, articleUrl, downloadUrl);
        });
        JSONObject productRelationsJson = json.getJSONObject("rel");
        for (String product : productRelationsJson.keySet()) {
            MsrcSupersedeNodeRelations parsed = MsrcSupersedeNodeRelations.fromJson(productRelationsJson.getJSONObject(product), nodes);
            node.productRelations.put(product, parsed);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MsrcSupersedeNode fromDocument(Document document, Map<String, MsrcSupersedeNode> nodes) {
        MsrcSupersedeNode node;
        Map<String, MsrcSupersedeNode> map = nodes;
        synchronized (map) {
            node = nodes.computeIfAbsent(document.get("kbId"), kb -> {
                String articleUrl = document.get("articleUrl");
                String downloadUrl = document.get("downloadUrl");
                return new MsrcSupersedeNode((String)kb, articleUrl, downloadUrl);
            });
        }
        JSONObject productRelationsJson = new JSONObject(document.get("rel"));
        for (String product : productRelationsJson.keySet()) {
            MsrcSupersedeNodeRelations parsed = MsrcSupersedeNodeRelations.fromJson(productRelationsJson.getJSONObject(product), nodes);
            node.productRelations.put(product, parsed);
        }
        return node;
    }

    public static Map<String, MsrcSupersedeNode> mergeNodes(Collection<Collection<MsrcSupersedeNode>> nodeArrays) {
        HashMap<String, MsrcSupersedeNode> mergedNodes = new HashMap<String, MsrcSupersedeNode>();
        for (Collection<MsrcSupersedeNode> nodes : nodeArrays) {
            nodes.forEach(node -> mergedNodes.computeIfAbsent(node.getKbId(), MsrcSupersedeNode.cloneNodeWithBaseProperties(node)));
        }
        for (Collection<MsrcSupersedeNode> nodes : nodeArrays) {
            MsrcSupersedeNode.mergeNodesDeepCopyAllNodes(mergedNodes, nodes);
        }
        return mergedNodes;
    }

    private static Function<String, MsrcSupersedeNode> cloneNodeWithBaseProperties(MsrcSupersedeNode node) {
        return kb -> {
            String articleUrl = node.getArticleUrl();
            String downloadUrl = node.getDownloadUrl();
            return new MsrcSupersedeNode((String)kb, articleUrl, downloadUrl);
        };
    }

    private static void mergeNodesDeepCopyAllNodes(Map<String, MsrcSupersedeNode> mergedNodes, Collection<MsrcSupersedeNode> nodes) {
        for (MsrcSupersedeNode referenceNode : nodes) {
            MsrcSupersedeNode node = mergedNodes.get(referenceNode.getKbId());
            for (String productName : referenceNode.getProductNames()) {
                MsrcSupersedeNode otherNode;
                MsrcSupersedeNodeRelations relation = referenceNode.getProductRelationsByProduct(productName);
                for (String vulnerability : relation.getAffectsVulnerabilities()) {
                    node.addAffectsVulnerability(productName, vulnerability);
                }
                for (MsrcSupersedeNode supersededByNode : relation.getSupersededBy()) {
                    otherNode = mergedNodes.computeIfAbsent(supersededByNode.getKbId(), MsrcSupersedeNode.cloneNodeWithBaseProperties(supersededByNode));
                    node.addSupersededBy(productName, otherNode);
                    otherNode.addSupersedes(productName, node);
                }
                for (MsrcSupersedeNode supersededNode : relation.getSupersedes()) {
                    otherNode = mergedNodes.computeIfAbsent(supersededNode.getKbId(), MsrcSupersedeNode.cloneNodeWithBaseProperties(supersededNode));
                    node.addSupersedes(productName, otherNode);
                    otherNode.addSupersededBy(productName, node);
                }
            }
        }
    }
}

