/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.store;

import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.OtherTypeIdentifier;
import com.metaeffekt.mirror.contents.store.OtherTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentIdentifierStore<T extends ContentIdentifier> {
    private static final Logger log = LoggerFactory.getLogger(ContentIdentifierStore.class);
    private final ReadWriteLock accessContentIdentifierLock = new ReentrantReadWriteLock();
    private final List<T> contentIdentifiers = new ArrayList<T>();

    protected ContentIdentifierStore() {
        this.contentIdentifiers.addAll(this.createDefaultIdentifiers());
    }

    protected abstract T createIdentifier(@NonNull String var1, @NonNull String var2);

    protected abstract Collection<T> createDefaultIdentifiers();

    public List<T> values() {
        return Collections.unmodifiableList(this.contentIdentifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T registerIdentifier(T contentIdentifier) {
        Lock readLock = this.accessContentIdentifierLock.readLock();
        readLock.lock();
        try {
            ContentIdentifier existing;
            if (contentIdentifier == null) {
                log.warn("Skipping registration of content identifier [null] in {}: {}", (Object)this.getClass().getSimpleName(), this.contentIdentifiers.stream().map(ContentIdentifier::getName).collect(Collectors.toList()));
                T t = null;
                return t;
            }
            if (((ContentIdentifier)contentIdentifier).getName() == null) {
                log.warn("Skipping registration of content identifier [null] in {}->{}: {}", new Object[]{this.getClass().getSimpleName(), contentIdentifier.getClass().getSimpleName(), this.contentIdentifiers.stream().map(ContentIdentifier::getName).collect(Collectors.toList())});
                T t = null;
                return t;
            }
            if (((ContentIdentifier)contentIdentifier).getWellFormedName() == null) {
                ((ContentIdentifier)contentIdentifier).setWellFormedName(ContentIdentifier.deriveWellFormedName(((ContentIdentifier)contentIdentifier).getName()));
                log.warn("Deriving missing well-formed name for content identifier [{}] in {}->{}: {}", new Object[]{((ContentIdentifier)contentIdentifier).getName(), this.getClass().getSimpleName(), contentIdentifier.getClass().getSimpleName(), this.contentIdentifiers.stream().map(ContentIdentifier::getName).collect(Collectors.toList())});
            }
            if ((existing = (ContentIdentifier)this.contentIdentifiers.stream().filter(ci -> ci.getName().equals(contentIdentifier.getName()) && ci.getImplementation().equals(contentIdentifier.getImplementation())).findFirst().orElse(null)) != null) {
                log.debug("Skipping registration of content identifier with name [{}], already present in {}->{}: {}", new Object[]{((ContentIdentifier)contentIdentifier).getName(), this.getClass().getSimpleName(), contentIdentifier.getClass().getSimpleName(), this.contentIdentifiers.stream().map(ContentIdentifier::getName).collect(Collectors.toList())});
                ContentIdentifier contentIdentifier2 = existing;
                return (T)contentIdentifier2;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.accessContentIdentifierLock.writeLock();
        writeLock.lock();
        try {
            this.contentIdentifiers.add(contentIdentifier);
        }
        finally {
            writeLock.unlock();
        }
        return contentIdentifier;
    }

    public List<T> fromMapNamesAndImplementations(Map<String, String> entries) {
        return entries.entrySet().stream().map(entry -> this.fromNameAndImplementation((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T fromNameAndImplementation(String name, String implementation) {
        boolean hasImplementation;
        boolean hasName = !StringUtils.isEmpty((CharSequence)name);
        boolean bl = hasImplementation = !StringUtils.isEmpty((CharSequence)implementation);
        if (!hasName) {
            throw new IllegalArgumentException("Name must not be blank or null for content identifier in " + this.getClass().getSimpleName());
        }
        String effectiveImplementation = hasImplementation ? implementation : name;
        Lock readLock = this.accessContentIdentifierLock.readLock();
        readLock.lock();
        try {
            Optional<ContentIdentifier> byNameAndImplementation = this.contentIdentifiers.stream().filter(ci -> (name.equals(ci.getName()) || name.equals(ci.getWellFormedName())) && effectiveImplementation.equals(ci.getImplementation())).findFirst();
            if (byNameAndImplementation.isPresent()) {
                ContentIdentifier contentIdentifier = byNameAndImplementation.get();
                return (T)contentIdentifier;
            }
            Optional<ContentIdentifier> byName = this.contentIdentifiers.stream().filter(ci -> name.equals(ci.getName()) || name.equals(ci.getWellFormedName())).findFirst();
            if (byName.isPresent()) {
                ContentIdentifier contentIdentifier = byName.get();
                return (T)contentIdentifier;
            }
        }
        finally {
            readLock.unlock();
        }
        return this.registerIdentifier(this.createIdentifier(name, effectiveImplementation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T fromNameWithoutCreation(String name) {
        boolean hasName;
        boolean bl = hasName = !StringUtils.isEmpty((CharSequence)name);
        if (!hasName) {
            throw new IllegalArgumentException("Name must not be blank or null for content identifier in " + this.getClass().getSimpleName());
        }
        Lock readLock = this.accessContentIdentifierLock.readLock();
        readLock.lock();
        try {
            Optional<ContentIdentifier> byName = this.contentIdentifiers.stream().filter(ci -> name.equals(ci.getName()) || name.equals(ci.getWellFormedName())).findFirst();
            ContentIdentifier contentIdentifier = byName.orElse(null);
            return (T)contentIdentifier;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T fromNameAndImplementationWithoutCreation(String name, String implementation) {
        boolean hasImplementation;
        boolean hasName = !StringUtils.isEmpty((CharSequence)name);
        boolean bl = hasImplementation = !StringUtils.isEmpty((CharSequence)implementation);
        if (!hasName) {
            throw new IllegalArgumentException("Name must not be blank or null for content identifier in " + this.getClass().getSimpleName());
        }
        Lock readLock = this.accessContentIdentifierLock.readLock();
        readLock.lock();
        try {
            Optional<ContentIdentifier> byName = this.contentIdentifiers.stream().filter(ci -> !(!name.equals(ci.getName()) && !name.equals(ci.getWellFormedName()) || hasImplementation && !implementation.equals(ci.getImplementation()))).findFirst();
            ContentIdentifier contentIdentifier = byName.orElse(null);
            return (T)contentIdentifier;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> fromId(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("Id must not be blank or null for content identifier in " + this.getClass().getSimpleName());
        }
        Lock readLock = this.accessContentIdentifierLock.readLock();
        readLock.lock();
        try {
            Optional<ContentIdentifier> optional = this.contentIdentifiers.stream().filter(ci -> ci.patternMatchesId(id)).findFirst();
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    public SingleContentIdentifierParseResult<T> fromJsonNameAndImplementation(JSONObject json) {
        String name = (String)ObjectUtils.firstNonNull((Object[])new String[]{json.optString("source", null), json.optString("name", null), "unknown"});
        String implementation = (String)ObjectUtils.firstNonNull((Object[])new String[]{json.optString("implementation", null), name, "unknown"});
        T identifier = this.fromNameAndImplementation(name, implementation);
        String id = json.optString("id", null);
        return new SingleContentIdentifierParseResult<T>(identifier, id);
    }

    public List<T> fromJsonNamesAndImplementations(JSONArray json) {
        ArrayList<T> identifiers = new ArrayList<T>();
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jsonObject = json.getJSONObject(i);
            SingleContentIdentifierParseResult<T> pair = this.fromJsonNameAndImplementation(jsonObject);
            identifiers.add(pair.getIdentifier());
        }
        return identifiers;
    }

    public Map<T, Set<String>> fromJsonMultipleReferencedIds(JSONArray json) {
        HashMap<ContentIdentifier, Set> referencedIds = new HashMap<ContentIdentifier, Set>();
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jsonObject = json.getJSONObject(i);
            SingleContentIdentifierParseResult<T> pair = this.fromJsonNameAndImplementation(jsonObject);
            T identifier = pair.getIdentifier();
            String id = pair.getId();
            referencedIds.computeIfAbsent((ContentIdentifier)identifier, k -> new HashSet()).add(id);
        }
        return referencedIds;
    }

    public SingleContentIdentifierParseResult<T> fromMap(Map<String, Object> map) {
        String name = ObjectUtils.firstNonNull((Object[])new Object[]{map.get("source"), map.get("name"), "unknown"}).toString();
        String implementation = ObjectUtils.firstNonNull((Object[])new Object[]{map.get("implementation"), name, "unknown"}).toString();
        T identifier = this.fromNameAndImplementation(name, implementation);
        String id = map.get("id") == null ? null : map.get("id").toString();
        return new SingleContentIdentifierParseResult<T>(identifier, id);
    }

    public Map<T, Set<String>> fromListMultipleReferencedIds(List<Map<String, Object>> map) {
        HashMap<ContentIdentifier, Set> referencedIds = new HashMap<ContentIdentifier, Set>();
        for (Map<String, Object> entry : map) {
            SingleContentIdentifierParseResult<T> pair = this.fromMap(entry);
            T identifier = pair.getIdentifier();
            String id = pair.getId();
            referencedIds.computeIfAbsent((ContentIdentifier)identifier, k -> new HashSet()).add(id);
        }
        return referencedIds;
    }

    public static <T extends ContentIdentifier> JSONArray toJson(Map<T, Set<String>> referencedIds) {
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<T, Set<String>> entry : referencedIds.entrySet()) {
            String name = ((ContentIdentifier)entry.getKey()).getName();
            String implementation = ((ContentIdentifier)entry.getKey()).getImplementation();
            Set<String> ids = entry.getValue();
            for (String id : ids) {
                jsonArray.put((Object)new JSONObject().put("name", (Object)name).put("implementation", (Object)implementation).put("id", (Object)id));
            }
        }
        return jsonArray;
    }

    public static Map<ContentIdentifier, Set<String>> parseLegacyJsonReferencedIds(JSONObject referencedIds) {
        HashMap mapFormatReferencedIds = new HashMap();
        referencedIds.toMap().forEach((key, value) -> {
            if (value instanceof Collection) {
                mapFormatReferencedIds.put(key, new HashSet((Collection)value));
            } else {
                log.warn("Could not parse referenced ids of type [{}]: {}", key, value);
            }
        });
        return ContentIdentifierStore.parseLegacyJsonReferencedIds(mapFormatReferencedIds);
    }

    public static <T extends Collection<String>> Map<ContentIdentifier, Set<String>> parseLegacyJsonReferencedIds(Map<String, T> referencedIds) {
        AdvisoryTypeStore advisoryTypeStore = AdvisoryTypeStore.get();
        VulnerabilityTypeStore vulnerabilityTypeStore = VulnerabilityTypeStore.get();
        OtherTypeStore otherTypeStore = OtherTypeStore.get();
        HashMap<ContentIdentifier, Set<String>> parsedReferencedIds = new HashMap<ContentIdentifier, Set<String>>();
        for (Map.Entry<String, T> entry : referencedIds.entrySet()) {
            AdvisoryTypeIdentifier advisoryIdentifier = (AdvisoryTypeIdentifier)advisoryTypeStore.fromNameWithoutCreation(entry.getKey());
            VulnerabilityTypeIdentifier vulnerabilityIdentifier = (VulnerabilityTypeIdentifier)vulnerabilityTypeStore.fromNameWithoutCreation(entry.getKey());
            OtherTypeIdentifier otherIdentifier = (OtherTypeIdentifier)otherTypeStore.fromNameWithoutCreation(entry.getKey());
            if (advisoryIdentifier != null) {
                parsedReferencedIds.computeIfAbsent(advisoryIdentifier, k -> new HashSet()).addAll((Collection)entry.getValue());
                continue;
            }
            if (vulnerabilityIdentifier != null) {
                parsedReferencedIds.computeIfAbsent(vulnerabilityIdentifier, k -> new HashSet()).addAll((Collection)entry.getValue());
                continue;
            }
            if (otherIdentifier != null) {
                parsedReferencedIds.computeIfAbsent(otherIdentifier, k -> new HashSet()).addAll((Collection)entry.getValue());
                continue;
            }
            log.warn("Could not find content identifier for referenced ids of type [{}]: {}", (Object)entry.getKey(), entry.getValue());
        }
        return parsedReferencedIds;
    }

    public static <T extends ContentIdentifier> JSONObject mergeIntoLegacyJson(List<Map<? extends T, Set<String>>> contentIdentifiersTypes) {
        JSONObject json = new JSONObject();
        for (Map<T, Set<String>> contentIdentifiers : contentIdentifiersTypes) {
            for (Map.Entry<T, Set<String>> entry : contentIdentifiers.entrySet()) {
                json.put(((ContentIdentifier)entry.getKey()).getName(), (Object)new JSONArray((Collection)entry.getValue()));
            }
        }
        return json;
    }

    public static abstract class ContentIdentifier {
        private String name;
        private String wellFormedName;
        private String implementation;
        private Pattern idPattern;

        public ContentIdentifier(String name, String wellFormedName, String implementation, Pattern idPattern) {
            this.name = name;
            this.wellFormedName = wellFormedName;
            this.setImplementation(implementation);
            this.idPattern = idPattern;
        }

        public void setImplementation(String implementation) {
            this.implementation = StringUtils.isEmpty((CharSequence)implementation) ? this.name : implementation;
        }

        public String name() {
            return this.name;
        }

        public boolean patternMatchesId(String id) {
            if (this.idPattern == null) {
                return false;
            }
            return this.idPattern.matcher(id).matches();
        }

        public Set<String> fromFreeText(String text) {
            if (StringUtils.isEmpty((CharSequence)text) || this.idPattern == null) {
                return Collections.emptySet();
            }
            HashSet<String> ids = new HashSet<String>();
            Matcher matcher = this.idPattern.matcher(text);
            while (matcher.find()) {
                ids.add(matcher.group());
            }
            return ids;
        }

        public String toString() {
            return Objects.toString(this.getName());
        }

        public String toExtendedString() {
            if (this.implementation.equals(this.name)) {
                return this.getName() + " (" + this.getWellFormedName() + ")";
            }
            return this.getName() + ":" + this.getImplementation() + " (" + this.getWellFormedName() + ")";
        }

        public static String prepareName(String name) {
            return name.replaceAll("[^a-zA-Z0-9_]", "_").replaceAll("_+", "_");
        }

        public static String deriveWellFormedName(String name) {
            if ((name = name.toLowerCase().replaceAll("[-_ ]+", " ")).startsWith("cert ")) {
                return name.replaceFirst("cert ", "CERT-").toUpperCase();
            }
            return WordUtils.capitalize((String)name);
        }

        public String getName() {
            return this.name;
        }

        public String getWellFormedName() {
            return this.wellFormedName;
        }

        public String getImplementation() {
            return this.implementation;
        }

        public Pattern getIdPattern() {
            return this.idPattern;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setWellFormedName(String wellFormedName) {
            this.wellFormedName = wellFormedName;
        }

        public void setIdPattern(Pattern idPattern) {
            this.idPattern = idPattern;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentIdentifier)) {
                return false;
            }
            ContentIdentifier other = (ContentIdentifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$wellFormedName = this.getWellFormedName();
            String other$wellFormedName = other.getWellFormedName();
            if (this$wellFormedName == null ? other$wellFormedName != null : !this$wellFormedName.equals(other$wellFormedName)) {
                return false;
            }
            String this$implementation = this.getImplementation();
            String other$implementation = other.getImplementation();
            if (this$implementation == null ? other$implementation != null : !this$implementation.equals(other$implementation)) {
                return false;
            }
            Pattern this$idPattern = this.getIdPattern();
            Pattern other$idPattern = other.getIdPattern();
            return !(this$idPattern == null ? other$idPattern != null : !this$idPattern.equals(other$idPattern));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentIdentifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $wellFormedName = this.getWellFormedName();
            result = result * 59 + ($wellFormedName == null ? 43 : $wellFormedName.hashCode());
            String $implementation = this.getImplementation();
            result = result * 59 + ($implementation == null ? 43 : $implementation.hashCode());
            Pattern $idPattern = this.getIdPattern();
            result = result * 59 + ($idPattern == null ? 43 : $idPattern.hashCode());
            return result;
        }

        public ContentIdentifier() {
        }
    }

    public static class SingleContentIdentifierParseResult<T extends ContentIdentifier> {
        private final T identifier;
        private final String id;

        public SingleContentIdentifierParseResult(T identifier, String id) {
            this.identifier = identifier;
            this.id = id;
        }

        public T getIdentifier() {
            return this.identifier;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleContentIdentifierParseResult)) {
                return false;
            }
            SingleContentIdentifierParseResult other = (SingleContentIdentifierParseResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$identifier = this.getIdentifier();
            T other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SingleContentIdentifierParseResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "ContentIdentifierStore.SingleContentIdentifierParseResult(identifier=" + this.getIdentifier() + ", id=" + this.getId() + ")";
        }
    }
}

