/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.vulnerability;

import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaEcosystem;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRange;
import org.json.JSONObject;

public class VulnerableSoftwareVersionRangeEcosystem
extends VulnerableSoftwareVersionRange {
    private final String ecosystem;
    private final String name;

    public VulnerableSoftwareVersionRangeEcosystem(String ecosystem, String name, String version, String update, String versionStartExcluding, String versionStartIncluding, String versionEndIncluding, String versionEndExcluding, VersionContext context, boolean vulnerable) {
        super(version, update, versionStartExcluding, versionStartIncluding, versionEndIncluding, versionEndExcluding, context, vulnerable);
        this.ecosystem = ecosystem;
        this.name = name;
    }

    public String getEcosystem() {
        return this.ecosystem;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public JSONObject toJson() {
        return super.toJson().put("ecosystem", (Object)this.ecosystem).put("name", (Object)this.name);
    }

    @Override
    public String toString() {
        return this.name + " (" + this.ecosystem + ") " + super.toString();
    }

    public static VulnerableSoftwareVersionRangeEcosystem fromJson(JSONObject json) {
        return new VulnerableSoftwareVersionRangeEcosystem(json.optString("ecosystem", null), json.optString("name", null), json.optString("version", ""), json.optString("update", ""), json.optString("versionStartExcluding", null), json.optString("versionStartIncluding", null), json.optString("versionEndIncluding", null), json.optString("versionEndExcluding", null), VersionContext.fromGhsaProduct(json.optString("name", null)), json.optBoolean("vulnerable", true));
    }

    public String getMavenArtifactId() {
        if (GhsaEcosystem.MAVEN.getName().equals(this.ecosystem) && this.name != null && this.name.contains(":")) {
            return this.name.substring(this.name.indexOf(":") + 1);
        }
        return null;
    }

    public String getMavenGroupId() {
        if (GhsaEcosystem.MAVEN.getName().equals(this.ecosystem) && this.name != null && this.name.contains(":")) {
            return this.name.substring(0, this.name.indexOf(":"));
        }
        return null;
    }
}

