/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.advisor;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.Retry;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="certeu", mavenPropertyName="certEuDownload")
public class CertEuDownload
extends Download {
    private static final Logger log = LoggerFactory.getLogger(CertEuDownload.class);
    private static final Logger LOG = LoggerFactory.getLogger(CertEuDownload.class);
    private static final Pattern PATTERN_YEARLY_PUBLICATIONS_YEAR_EXTRACTION = Pattern.compile(".*publications/security-advisories/(\\d{4,5})\".*");
    private static final Pattern PATTERN_YEARLY_PUBLICATIONS_ENTRY_ID_EXTRACTION = Pattern.compile("/publications/security-advisories/(\\d{4,5}-\\d{3,5})/");
    private final File yearlyPublicationsDirectory = new File(super.getDownloadIntoDirectory(), "publications-summary");
    private final File publicationEntries = new File(super.getDownloadIntoDirectory(), "publications");
    private final File previousPublicationDatesFile = new File(this.yearlyPublicationsDirectory, "publication-dates.json");

    public CertEuDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CertEuDownload.class);
    }

    @Override
    protected void performDownload() {
        Map entriesToBeFetched;
        Map<Integer, List<String>> yearlyPublicationHtmlPages = this.getAllYearlyPublications();
        LinkedHashMap<Integer, Map> entriesToBeFetchedPerYear = new LinkedHashMap<Integer, Map>();
        for (Map.Entry<Integer, List<String>> entry : yearlyPublicationHtmlPages.entrySet()) {
            try {
                entriesToBeFetched = this.extractUpdatedEntryIdsForYearlyPublicationsHtml(entry.getKey(), entry.getValue());
                if (!entriesToBeFetched.isEmpty()) {
                    entriesToBeFetchedPerYear.put(entry.getKey(), entriesToBeFetched);
                    continue;
                }
                log.info("Year [{}] is already complete and up to date, no need to fetch.", (Object)entry.getKey());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to extract the yearly publication entries for CERT-EU on year " + entry.getKey(), e);
            }
        }
        if (entriesToBeFetchedPerYear.isEmpty()) {
            log.info("No new entries to fetch, skipping download.");
            return;
        }
        for (Map.Entry<Integer, List<String>> entry : entriesToBeFetchedPerYear.entrySet()) {
            entriesToBeFetched = (Map)((Object)entry.getValue());
            int year = entry.getKey();
            log.info("Starting fetching process for year [{}] with [{}] entries to be fetched.", (Object)year, (Object)entriesToBeFetched.size());
            for (Map.Entry entry2 : entriesToBeFetched.entrySet()) {
                String entryId = (String)entry2.getKey();
                this.downloadEntry(year, entryId);
            }
            try {
                this.mergePreviouslyParsedEntryPublicationDatesBackIntoFile(entriesToBeFetched);
            }
            catch (IOException e) {
                log.error("Failed to merge the fetched entries back into the publication dates file, this means that next time, all entries for year [{}] will be fetched again. This error should not occur, as it is a simple file read/write access.", (Object)year, (Object)e);
            }
        }
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        String onlineRssHash;
        String localRssHash = this.getLocalRssHash();
        if (localRssHash.equals(onlineRssHash = this.getOnlineRssHash())) {
            return false;
        }
        log.info("RSS Feed changed since last execution, mirror is required");
        this.propertyFiles.set(super.getDownloadIntoDirectory(), "info", Mirror.InfoFileAttributes.CERT_EU_PREFIX.getKey() + "rss-feed-sha256", onlineRssHash);
        return true;
    }

    private String getOnlineRssHash() {
        URL url = this.getRemoteResourceLocationUrl(ResourceLocationCertEu.RSS_FEED, new Object[0]);
        String rssContent = String.join((CharSequence)"", this.downloader.fetchResponseBodyFromUrlAsList(url));
        return DigestUtils.sha256Hex((String)rssContent);
    }

    private String getLocalRssHash() {
        return this.propertyFiles.getString(super.getDownloadIntoDirectory(), "info", Mirror.InfoFileAttributes.CERT_EU_PREFIX.getKey() + "rss-feed-sha256").orElse("");
    }

    private Map<Integer, List<String>> getAllYearlyPublications() {
        LinkedHashMap<Integer, List<String>> yearlyPublicationHtmlPages = new LinkedHashMap<Integer, List<String>>();
        ArrayList<Integer> yearsToFetchPublicationsHtmlFor = new ArrayList<Integer>();
        try {
            log.info("Fetching CERT-EU publications for initial year 2011");
            List<String> yearlyPublicationsPage2011 = this.getYearlyPublicationsPage(2011);
            yearlyPublicationHtmlPages.put(2011, yearlyPublicationsPage2011);
            for (String line : yearlyPublicationsPage2011) {
                Matcher yearMatcher = PATTERN_YEARLY_PUBLICATIONS_YEAR_EXTRACTION.matcher(line);
                if (!yearMatcher.matches()) continue;
                String year = yearMatcher.group(1);
                if (!year.matches("\\d+")) {
                    log.warn("Failed to parse year from line: [{}]", (Object)line);
                    continue;
                }
                int yearInt = Integer.parseInt(year);
                yearsToFetchPublicationsHtmlFor.add(yearInt);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to fetch the oldest year from CERT-EU publications", (Throwable)e);
        }
        log.info("Fetching found CERT-EU publications for years {}", yearsToFetchPublicationsHtmlFor);
        Iterator iterator = yearsToFetchPublicationsHtmlFor.iterator();
        while (iterator.hasNext()) {
            int year = (Integer)iterator.next();
            try {
                List<String> yearlyPublicationsPage = this.getYearlyPublicationsPage(year);
                yearlyPublicationHtmlPages.put(year, yearlyPublicationsPage);
            }
            catch (IOException e) {
                LOG.error("Failed to fetch CERT-EU publications for year " + year, (Throwable)e);
            }
        }
        return yearlyPublicationHtmlPages;
    }

    private Map<String, String> extractUpdatedEntryIdsForYearlyPublicationsHtml(int year, List<String> htmlLines) throws IOException {
        Map<String, String> previousPublicationDates = this.getPreviouslyParsedEntryPublicationDates();
        LinkedHashMap<String, String> matchedEntries = new LinkedHashMap<String, String>();
        Document htmlDocument = Jsoup.parse((String)String.join((CharSequence)"", htmlLines));
        for (Element linkTag : htmlDocument.getElementsByTag("a")) {
            String href = linkTag.attr("href");
            Matcher entryIdMatcher = PATTERN_YEARLY_PUBLICATIONS_ENTRY_ID_EXTRACTION.matcher(href);
            if (!entryIdMatcher.matches()) continue;
            String entryId = entryIdMatcher.group(1);
            String publicationDate = linkTag.getElementsByClass("publications--list--item--link--date").text();
            if (!StringUtils.hasText(publicationDate)) continue;
            File entryFile = this.getPublicationEntryFileForYearAndId(year, entryId);
            boolean publicationEntriesDirContainsEntry = entryFile.exists();
            String previousPublicationDate = previousPublicationDates.get(entryId);
            if (publicationEntriesDirContainsEntry && previousPublicationDate != null && previousPublicationDate.equals(publicationDate)) continue;
            matchedEntries.put(entryId, publicationDate);
        }
        return matchedEntries;
    }

    private Map<String, String> getPreviouslyParsedEntryPublicationDates() throws IOException {
        LinkedHashMap<String, String> previousPublicationDates = new LinkedHashMap<String, String>();
        if (this.previousPublicationDatesFile.exists()) {
            JSONObject previousPublicationDatesJson = new JSONObject(FileUtils.readFileToString((File)this.previousPublicationDatesFile, (Charset)StandardCharsets.UTF_8));
            previousPublicationDatesJson.keySet().forEach(entryId -> previousPublicationDates.put((String)entryId, previousPublicationDatesJson.getString(entryId)));
        }
        return previousPublicationDates;
    }

    private void mergePreviouslyParsedEntryPublicationDatesBackIntoFile(Map<String, String> publicationDates) throws IOException {
        Map<String, String> previouslyParsedEntryPublicationDates = this.getPreviouslyParsedEntryPublicationDates();
        previouslyParsedEntryPublicationDates.putAll(publicationDates);
        FileUtils.writeStringToFile((File)this.previousPublicationDatesFile, (String)new JSONObject(previouslyParsedEntryPublicationDates).toString(), (Charset)StandardCharsets.UTF_8);
    }

    private List<String> getYearlyPublicationsPage(int year) throws IOException {
        boolean downloadRequired;
        long maxLocalFileAge = 3600000L;
        File yearlyPublicationsPage = new File(this.yearlyPublicationsDirectory, year + ".html");
        boolean bl = downloadRequired = !yearlyPublicationsPage.exists() || yearlyPublicationsPage.lastModified() < System.currentTimeMillis() - 3600000L;
        if (downloadRequired) {
            URL url = this.getRemoteResourceLocationUrl(ResourceLocationCertEu.YEARLY_PUBLICATIONS_URL, year);
            new Retry(() -> this.downloader.fetchResponseBodyFromUrlToFile(url, yearlyPublicationsPage)).retryCount(3).withDelay(3000).withValidator(obj -> yearlyPublicationsPage.exists()).onException(Exception.class).run();
        }
        return FileUtils.readLines((File)yearlyPublicationsPage, (Charset)StandardCharsets.UTF_8);
    }

    private void downloadEntry(int year, String id) {
        File entryFile = this.getPublicationEntryFileForYearAndId(year, id);
        URL url = this.getRemoteResourceLocationUrl(ResourceLocationCertEu.SINGLE_ENTRY_URL, id);
        new Retry(() -> this.downloader.fetchResponseBodyFromUrlToFile(url, entryFile)).retryCount(3).withDelay(3000).withValidator(obj -> entryFile.exists()).onException(Exception.class).run();
    }

    private File getPublicationEntriesDirForYear(int year) {
        return new File(this.publicationEntries, String.valueOf(year));
    }

    private File getPublicationEntryFileForYearAndId(int year, String id) {
        return new File(this.getPublicationEntriesDirForYear(year), id + ".json");
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationCertEu.valueOf(location), url);
    }

    public static enum ResourceLocationCertEu implements ResourceLocation
    {
        YEARLY_PUBLICATIONS_URL("https://cert.europa.eu/publications/security-advisories/%d"),
        SINGLE_ENTRY_URL("https://cert.europa.eu/publications/security-advisories/%s/json"),
        RSS_FEED("https://cert.europa.eu/publications/security-advisories-rss");

        private final String defaultValue;

        private ResourceLocationCertEu(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

