/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.advisor;

import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="msrc", mavenPropertyName="msrcDownload")
public class MsrcDownload
extends Download {
    private static final Logger LOG = LoggerFactory.getLogger(MsrcDownload.class);

    public MsrcDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, MsrcDownload.class);
    }

    @Override
    protected void performDownload() {
        Map<String, String> changedMonths = this.getChangedMonths();
        LOG.info("Months with changed/missing contents: {}", changedMonths);
        for (Map.Entry<String, String> entry : changedMonths.entrySet()) {
            String monthId = entry.getKey();
            String currentReleaseDate = entry.getValue();
            this.executor.submit(() -> {
                String year = monthId.substring(0, 4);
                File downloadDestinationParentDirectory = new File(this.downloadIntoDirectory, year);
                File downloadDestinationFile = new File(downloadDestinationParentDirectory, monthId + ".xml");
                if (!downloadDestinationParentDirectory.exists()) {
                    downloadDestinationParentDirectory.mkdirs();
                }
                if (downloadDestinationFile.exists()) {
                    downloadDestinationFile.delete();
                }
                URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationMsrc.MSRC_CVRF_BASE_URL, monthId);
                this.downloader.fetchResponseBodyFromUrlToFile(requestUrl, downloadDestinationFile);
                this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.MSRC_PREFIX.getKey() + "month-latest-" + monthId, currentReleaseDate);
            });
        }
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for download threads to finish.", e);
        }
    }

    private Map<String, String> getChangedMonths() {
        Map<String, String> changedMonths = Collections.synchronizedMap(new HashMap());
        URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationMsrc.MSRC_UPDATES_URL, new Object[0]);
        List<String> updateLines = this.downloader.fetchResponseBodyFromUrlAsList(requestUrl);
        JSONObject updateJson = new JSONObject(String.join((CharSequence)"", updateLines));
        JSONArray monthlyUpdateData = updateJson.getJSONArray("value");
        for (int i = 0; i < monthlyUpdateData.length(); ++i) {
            JSONObject monthlyUpdate = monthlyUpdateData.getJSONObject(i);
            String monthTitle = monthlyUpdate.getString("DocumentTitle");
            String currentReleaseDate = monthlyUpdate.getString("CurrentReleaseDate");
            String monthId = this.extractOrDeriveMonthId(monthlyUpdate);
            String year = monthId.substring(0, 4);
            File monthFile = new File(this.downloadIntoDirectory, year + "/" + monthId + ".xml");
            String lastCurrentReleaseDate = this.propertyFiles.getString(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.MSRC_PREFIX.getKey() + "month-latest-" + monthId).orElse("");
            if (!monthFile.exists()) {
                LOG.info("Month [{}: {}] is missing", (Object)monthId, (Object)monthTitle);
                changedMonths.put(monthId, currentReleaseDate);
                continue;
            }
            if (lastCurrentReleaseDate.equals(currentReleaseDate)) continue;
            LOG.info("Month [{}: {}] is out-of-date: [{}] -> [{}]", new Object[]{monthId, monthTitle, lastCurrentReleaseDate, currentReleaseDate});
            changedMonths.put(monthId, currentReleaseDate);
        }
        return changedMonths;
    }

    private String extractOrDeriveMonthId(JSONObject monthlyUpdate) {
        String monthId;
        String documentMonthId = monthlyUpdate.getString("ID");
        if (String.valueOf(documentMonthId).length() < 4) {
            String initialReleaseDate = monthlyUpdate.getString("InitialReleaseDate");
            LOG.error("Invalid monthId provided by MS update document [{}] attempt to restore ID using InitialReleaseDate: [{}]", (Object)documentMonthId, (Object)initialReleaseDate);
            String[] split = initialReleaseDate.split("-");
            String month = (new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"})[Integer.parseInt(split[1]) - 1];
            monthId = split[0] + "-" + month;
            LOG.info("Derived monthId: [{}]", (Object)monthId);
        } else {
            monthId = documentMonthId;
        }
        return monthId;
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        Map<String, String> changedMonths = this.getChangedMonths();
        if (!changedMonths.isEmpty()) {
            LOG.info("Months with changed/missing contents, update required: {}", changedMonths);
            return true;
        }
        return false;
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationMsrc.valueOf(location), url);
    }

    public static enum ResourceLocationMsrc implements ResourceLocation
    {
        MSRC_UPDATES_URL("https://api.msrc.microsoft.com/cvrf/v3.0/updates"),
        MSRC_CVRF_BASE_URL("https://api.msrc.microsoft.com/cvrf/v3.0/cvrf/%s");

        private final String defaultValue;

        private ResourceLocationMsrc(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

