/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.advisor;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.contents.advisory.CertFrAdvisorEntry;
import com.metaeffekt.mirror.download.advisor.CertFrDownload;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="certfr-advisors", mavenPropertyName="certFrAdvisorIndex")
public class CertFrAdvisorIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(CertFrAdvisorIndex.class);

    public CertFrAdvisorIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CertFrAdvisorIndex.class, Collections.singletonList(CertFrDownload.class), Collections.emptyList());
    }

    @Override
    @DocRelevantMethods(value={"CertFrAdvisorEntry#fromDownloadText", "CertFrAdvisorEntry#fromApiJson"})
    protected Map<String, Document> createIndexDocuments() {
        ConcurrentHashMap<String, Document> documents = new ConcurrentHashMap<String, Document>();
        List<File> files = super.getAllFilesInSubDirectories(this.requiredDownloads[0]);
        for (File file : files) {
            this.executor.submit(() -> {
                try {
                    CertFrAdvisorEntry parsedEntry;
                    if (file.getName().endsWith(".txt")) {
                        List contents = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
                        parsedEntry = CertFrAdvisorEntry.fromDownloadText(contents);
                    } else if (file.getName().endsWith(".json")) {
                        parsedEntry = CertFrAdvisorEntry.fromApiJson(file);
                    } else {
                        LOG.warn("Unsupported file format, skipping: {}", (Object)file.getAbsolutePath());
                        return;
                    }
                    if (documents.containsKey(parsedEntry.getId())) {
                        LOG.warn("Duplicate entry found, skipping: {}", (Object)parsedEntry.toJson());
                    } else {
                        documents.put(parsedEntry.getId(), parsedEntry.toDocument());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read file contents during indexing: " + file.getAbsolutePath(), e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to parse file content during indexing: " + file.getAbsolutePath(), e);
                }
            });
        }
        this.executor.setSize(16);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for indexing to complete.", e);
        }
        return documents;
    }
}

