/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.nvd.CpeDictionaryIndex;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

@Deprecated
public class CpeDictionaryIndexQuery
extends IndexQuery {
    private static final Logger LOG = LoggerFactory.getLogger(CpeDictionaryIndexQuery.class);
    private static final List<Function<String, String>> CPE_PART_MAPPINGS = Arrays.asList(s -> s, s -> s.replace("\\_", "_"), s -> s.replace("\\.", "."), s -> s.replace("\\-", "-"), s -> s.replace("\\/", "/"));

    public CpeDictionaryIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CpeDictionaryIndex.class);
    }

    public CpeDictionaryIndexQuery(CpeDictionaryIndex index) {
        super(index);
    }

    public List<Cpe> findCpeByVendorProductVersion(String vendor, String product, String version) {
        return this.findCpeUsingSearcher(new IndexSearch().fieldEquals("vendor", vendor).fieldEquals("product", product).fieldEquals("version", version)).stream().sorted().collect(Collectors.toList());
    }

    public List<Cpe> findCpeByVendorProduct(String vendor, String product) {
        return this.findCpeUsingSearcher(new IndexSearch().fieldEquals("vendor", vendor).fieldEquals("product", product)).stream().sorted().collect(Collectors.toList());
    }

    public List<Cpe> findCpeByProduct(String product) {
        return this.findCpeUsingSearcher(new IndexSearch().fieldEquals("product", product));
    }

    public List<Cpe> findCpeByVendor(String vendor) {
        return this.findCpeUsingSearcher(new IndexSearch().fieldEquals("vendor", vendor));
    }

    public List<Cpe> findByCpeUri(String cpeUri) {
        return CommonEnumerationUtil.parseCpe(cpeUri).map(this::findByCpeUri).orElseGet(ArrayList::new);
    }

    public List<Cpe> findByCpeUri(Cpe cpeUri) {
        for (Function<String, String> mapper : CPE_PART_MAPPINGS) {
            List<Cpe> cpeList = this.findByCpeUri(cpeUri, mapper);
            if (cpeList.isEmpty()) continue;
            return cpeList;
        }
        return new ArrayList<Cpe>();
    }

    public List<Cpe> findByCpeUri(Cpe cpeUri, Function<String, String> partMapper) {
        IndexSearch search = new IndexSearch();
        search.fieldEquals("part", cpeUri.getPart().getAbbreviation());
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getVendor())) {
            search.fieldEquals("vendor", partMapper.apply(cpeUri.getVendor()));
        }
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getProduct())) {
            search.fieldEquals("product", partMapper.apply(cpeUri.getProduct()));
        }
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getVersion())) {
            search.fieldEquals("version", partMapper.apply(cpeUri.getVersion()));
        }
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getUpdate())) {
            search.fieldEquals("update", partMapper.apply(cpeUri.getUpdate()));
        }
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getEdition())) {
            search.fieldEquals("edition", partMapper.apply(cpeUri.getEdition()));
        }
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getLanguage())) {
            search.fieldEquals("language", partMapper.apply(cpeUri.getLanguage()));
        }
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getSwEdition())) {
            search.fieldEquals("sw_edition", partMapper.apply(cpeUri.getSwEdition()));
        }
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getTargetSw())) {
            search.fieldEquals("target_sw", partMapper.apply(cpeUri.getTargetSw()));
        }
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getTargetHw())) {
            search.fieldEquals("target_hw", partMapper.apply(cpeUri.getTargetHw()));
        }
        if (CpeDictionaryIndexQuery.isNotWildcardPart(cpeUri.getOther())) {
            search.fieldEquals("other", partMapper.apply(cpeUri.getOther()));
        }
        return this.findCpeUsingSearcher(search);
    }

    private static boolean isNotWildcardPart(String part) {
        if (StringUtils.isEmpty(part)) {
            return false;
        }
        return !part.equals("*");
    }

    private List<Cpe> findCpeUsingSearcher(IndexSearch search) {
        return this.index.findDocuments(search).stream().map(e -> CommonEnumerationUtil.parseCpe(e.get("cpe23Uri"))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

