/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.utils.LruLinkedHashMap;
import com.metaeffekt.mirror.contents.msrcdata.MsrcSupersedeNode;
import com.metaeffekt.mirror.contents.msrcdata.MsrcSupersedeNodeRelations;
import com.metaeffekt.mirror.index.Index;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.advisor.MsrcKbChainIndex;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;

public class MsrcKbChainIndexQuery
extends IndexQuery {
    private final Map<String, MsrcSupersedeNode> cachedMsrcNodes = new ConcurrentHashMap<String, MsrcSupersedeNode>();
    private static final int MAX_CACHED_VULNERABILITY_TO_NODES = 1000;
    private final Map<String, List<MsrcSupersedeNode>> cachedVulnerabilityToNodes = new LruLinkedHashMap<String, List<MsrcSupersedeNode>>(1000);
    private static final int MAX_CACHED_SUPERSEDING_KB_TO_NODES = 100;
    private final Map<String, List<MsrcSupersedeNode>> cachedSupersedingKbToNodes = new LruLinkedHashMap<String, List<MsrcSupersedeNode>>(100);

    public MsrcKbChainIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, MsrcKbChainIndex.class);
    }

    public MsrcKbChainIndexQuery(Index index) {
        super(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsrcSupersedeNode findNodeByKbId(String kbId) {
        Map<String, MsrcSupersedeNode> map = this.cachedMsrcNodes;
        synchronized (map) {
            if (this.cachedMsrcNodes.containsKey(kbId)) {
                return this.cachedMsrcNodes.get(kbId);
            }
        }
        List<MsrcSupersedeNode> nodes = this.createNodes(this.index.findDocuments(new IndexSearch().fieldContains("kbId", kbId)));
        nodes.removeIf(node -> !node.getKbId().equals(kbId));
        if (nodes.size() > 1) {
            throw new IllegalStateException("Found more than one node for kbId [" + kbId + "]: " + nodes.stream().map(MsrcSupersedeNode::toJson).collect(CustomCollectors.toJsonArray()));
        }
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        return null;
    }

    public List<MsrcSupersedeNode> findNodesSupersedingKbId(String supersededKbId) {
        return this.findNodesSupersedingKbId(supersededKbId, null);
    }

    public List<MsrcSupersedeNode> findNodesSupersedingKbId(String supersededKbId, String productId) {
        String cacheKey = supersededKbId + (productId != null ? "-c-" + productId : "");
        if (this.cachedSupersedingKbToNodes.containsKey(cacheKey)) {
            return new ArrayList<MsrcSupersedeNode>((Collection)this.cachedSupersedingKbToNodes.get(cacheKey));
        }
        HashSet<MsrcSupersedeNode> relationNodes = new HashSet<MsrcSupersedeNode>(this.findNodesInRelations(supersededKbId));
        if (productId != null) {
            relationNodes.removeIf(node -> !node.containsSupersededKbId(supersededKbId, productId));
        } else {
            relationNodes.removeIf(node -> !node.containsSupersededKbId(supersededKbId));
        }
        for (MsrcSupersedeNode node2 : new HashSet<MsrcSupersedeNode>(relationNodes)) {
            relationNodes.addAll(this.findNodesSupersedingKbId(node2.getKbId(), productId));
        }
        this.cachedSupersedingKbToNodes.put(cacheKey, new ArrayList<MsrcSupersedeNode>(relationNodes));
        return new ArrayList<MsrcSupersedeNode>(relationNodes);
    }

    public List<MsrcSupersedeNode> findNodesSupersededByKbId(String supersededKbId) {
        return this.findNodesSupersededByKbId(supersededKbId, null);
    }

    public List<MsrcSupersedeNode> findNodesSupersededByKbId(String supersededKbId, String productId) {
        HashSet<MsrcSupersedeNode> relationNodes = new HashSet<MsrcSupersedeNode>(this.findNodesInRelations(supersededKbId));
        if (productId != null) {
            relationNodes.removeIf(node -> !node.containsSupersededByKbId(supersededKbId, productId));
        } else {
            relationNodes.removeIf(node -> !node.containsSupersededByKbId(supersededKbId));
        }
        for (MsrcSupersedeNode node2 : new HashSet<MsrcSupersedeNode>(relationNodes)) {
            relationNodes.addAll(this.findNodesSupersededByKbId(node2.getKbId(), productId));
        }
        return new ArrayList<MsrcSupersedeNode>(relationNodes);
    }

    public List<MsrcSupersedeNode> findNodesByVulnerability(String vulnerability) {
        return this.findNodesByVulnerability(vulnerability, null);
    }

    public List<MsrcSupersedeNode> findNodesByVulnerability(String vulnerability, String productId) {
        String cacheKey = vulnerability + (productId != null ? "-c-" + productId : "");
        if (this.cachedVulnerabilityToNodes.containsKey(cacheKey)) {
            return this.cachedVulnerabilityToNodes.get(cacheKey);
        }
        List<MsrcSupersedeNode> relationNodes = this.findNodesInRelations(vulnerability);
        if (productId != null) {
            relationNodes.removeIf(node -> !node.containsVulnerability(vulnerability, productId));
        } else {
            relationNodes.removeIf(node -> !node.containsVulnerability(vulnerability));
        }
        this.cachedVulnerabilityToNodes.put(cacheKey, relationNodes);
        return relationNodes;
    }

    public Set<MsrcSupersedeNode> findFixingKbIds(String vulnerability) {
        return this.findFixingKbIds(vulnerability, null);
    }

    public Set<MsrcSupersedeNode> findFixingKbIds(String vulnerability, String productId) {
        HashSet<MsrcSupersedeNode> kbIds = new HashSet<MsrcSupersedeNode>(this.findNodesByVulnerability(vulnerability, productId));
        HashSet<MsrcSupersedeNode> toCheckKbIds = new HashSet<MsrcSupersedeNode>();
        for (MsrcSupersedeNode node : kbIds) {
            toCheckKbIds.addAll(this.findNodesSupersedingKbId(node.getKbId(), productId));
        }
        HashSet<MsrcSupersedeNode> checkedIds = new HashSet<MsrcSupersedeNode>();
        while (!toCheckKbIds.isEmpty()) {
            MsrcSupersedeNode node;
            node = (MsrcSupersedeNode)toCheckKbIds.iterator().next();
            toCheckKbIds.remove(node);
            checkedIds.add(node);
            kbIds.add(node);
            toCheckKbIds.addAll(this.findNodesSupersedingKbId(node.getKbId(), productId));
            toCheckKbIds.removeAll(checkedIds);
        }
        return kbIds;
    }

    public Map<MsrcSupersedeNode, Set<MsrcSupersedeNode>> buildTree(Collection<MsrcSupersedeNode> kbNodes, String productId, boolean limitToInputNodes) {
        HashMap<MsrcSupersedeNode, Set<MsrcSupersedeNode>> fixingKbIdsTree = new HashMap<MsrcSupersedeNode, Set<MsrcSupersedeNode>>();
        for (MsrcSupersedeNode checkNode : kbNodes) {
            boolean allowedToAdd;
            MsrcSupersedeNodeRelations relations = checkNode.getProductRelationsByProduct(productId);
            if (relations == null) continue;
            Set supersedenceIds = fixingKbIdsTree.computeIfAbsent(checkNode, k -> new HashSet());
            for (MsrcSupersedeNode node : relations.getSupersedes()) {
                allowedToAdd = !limitToInputNodes || kbNodes.contains(node);
                if (!allowedToAdd) continue;
                supersedenceIds.add(node);
            }
            for (MsrcSupersedeNode node : relations.getSupersededBy()) {
                allowedToAdd = !limitToInputNodes || kbNodes.contains(node);
                if (!allowedToAdd) continue;
                Set supersededBy = fixingKbIdsTree.computeIfAbsent(node, k -> new HashSet());
                supersededBy.add(checkNode);
            }
        }
        return fixingKbIdsTree;
    }

    public List<MsrcSupersedeNode> findNodesByProductId(String productId) {
        List<MsrcSupersedeNode> relationNodes = this.findNodesInRelations(productId);
        relationNodes.removeIf(node -> node.getProductRelationsByProduct(productId) == null);
        return relationNodes;
    }

    public List<String> findVulnerabilitiesByProductId(String productId) {
        return this.findVulnerabilitiesByProductId(productId, Collections.emptyList());
    }

    public List<String> findVulnerabilitiesByProductId(String productId, Collection<String> kbIds) {
        HashSet<String> vulnerabilities = new HashSet<String>();
        for (MsrcSupersedeNode msrcSupersedeNode : this.findNodesByProductId(productId)) {
            vulnerabilities.addAll(msrcSupersedeNode.getProductRelationsByProduct(productId).getAffectsVulnerabilities());
        }
        if (kbIds.isEmpty()) {
            return new ArrayList<String>(vulnerabilities);
        }
        HashMap<String, Set> vulnerabilitiesFixedByKb = new HashMap<String, Set>();
        for (String string : vulnerabilities) {
            Set<MsrcSupersedeNode> set = this.findFixingKbIds(string, productId);
            for (MsrcSupersedeNode fixingKbId : set) {
                vulnerabilitiesFixedByKb.computeIfAbsent(string, k -> new HashSet()).add(fixingKbId.getKbId());
            }
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : vulnerabilitiesFixedByKb.entrySet()) {
            if (!kbIds.stream().anyMatch(fixedKb -> ((Set)entry.getValue()).contains(fixedKb))) continue;
            hashSet.add(entry.getKey());
        }
        ArrayList<String> arrayList = new ArrayList<String>(vulnerabilities);
        arrayList.removeAll(hashSet);
        return arrayList;
    }

    public boolean isVulnerabilityFixed(String vulnerability, String productId, Collection<String> activeKbIds) {
        if (activeKbIds.isEmpty()) {
            return false;
        }
        Set<MsrcSupersedeNode> fixingKbIds = this.findFixingKbIds(vulnerability, productId);
        for (MsrcSupersedeNode fixingKbId : fixingKbIds) {
            if (!activeKbIds.contains(fixingKbId.getKbId())) continue;
            return true;
        }
        return false;
    }

    public void collectSupersedingKbIdentifiers(Set<String> vulnerabilities, String productId, Collection<String> appendKbIdsTo) {
        for (String vulnerabilityId : vulnerabilities) {
            boolean foundNew;
            Set<MsrcSupersedeNode> fixingKbIds = this.findFixingKbIds(vulnerabilityId, productId);
            do {
                foundNew = false;
                for (MsrcSupersedeNode fixingKbId : fixingKbIds) {
                    for (String appliedMsKbIdentifier : new HashSet<String>(appendKbIdsTo)) {
                        if (!fixingKbId.containsSupersededByKbId(appliedMsKbIdentifier) || !appendKbIdsTo.add(fixingKbId.getKbId())) continue;
                        foundNew = true;
                    }
                }
            } while (foundNew);
        }
    }

    public List<MsrcSupersedeNode> findAllNodes() {
        return this.createNodes(this.index.findAllDocuments());
    }

    public void preloadAllNodes() {
        this.findAllNodes();
    }

    private List<MsrcSupersedeNode> findNodesInRelations(String searchText) {
        List<Document> documents = this.index.findDocuments(new IndexSearch().fieldContains("rel", searchText));
        return this.createNodes(documents);
    }

    private List<MsrcSupersedeNode> createNodes(List<Document> documents) {
        return documents.stream().map(document -> MsrcSupersedeNode.fromDocument(document, this.cachedMsrcNodes)).collect(Collectors.toList());
    }
}

