/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.mirror.contents.cpe.NvdCpeMetadata;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.nvd.NvdCpeApiIndex;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

public class NvdCpeApiIndexQuery
extends IndexQuery {
    private static final Logger LOG = LoggerFactory.getLogger(NvdCpeApiIndexQuery.class);
    private static final List<Function<String, String>> CPE_PART_MAPPINGS = Arrays.asList(s -> s, s -> s.replace("\\_", "_"), s -> s.replace("\\.", "."), s -> s.replace("\\-", "-"), s -> s.replace("\\/", "/"));

    public NvdCpeApiIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, NvdCpeApiIndex.class);
    }

    public NvdCpeApiIndexQuery(NvdCpeApiIndex index) {
        super(index);
    }

    public List<Cpe> findCpeByVendorProduct(String vendor, String product) {
        return this.sortCpe(this.findCpeUsingSearcher(new IndexSearch().fieldEquals("vendor", vendor).fieldEquals("product", product)));
    }

    public List<Cpe> findCpeByVendorProductVersion(String vendor, String product, String version) {
        return this.sortCpe(this.findCpeUsingSearcher(new IndexSearch().fieldEquals("vendor", vendor).fieldEquals("product", product).fieldEquals("version", version)));
    }

    private List<Cpe> sortCpe(Collection<Cpe> cpes) {
        if (cpes == null || cpes.isEmpty()) {
            return new ArrayList<Cpe>();
        }
        try {
            return cpes.stream().sorted().collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.warn("Failed to sort CPEs {}: {}", cpes, (Object)e.getMessage());
            return new ArrayList<Cpe>(cpes);
        }
    }

    public List<Cpe> findCpeByProduct(String product) {
        return this.findCpeUsingSearcher(new IndexSearch().fieldEquals("product", product));
    }

    public List<Cpe> findCpeByVendor(String vendor) {
        return this.findCpeUsingSearcher(new IndexSearch().fieldEquals("vendor", vendor));
    }

    public List<Cpe> findCpeByProductFuzzy(String product) {
        return this.findCpeUsingSearcher(new IndexSearch().fieldContains("product", product));
    }

    public List<Cpe> findCpeByVendorFuzzy(String vendor) {
        return this.findCpeUsingSearcher(new IndexSearch().fieldContains("vendor", vendor));
    }

    public List<Cpe> findByNvdId(String nvdId) {
        return this.findCpeUsingSearcher(new IndexSearch().fieldEquals("nvdId", nvdId));
    }

    public List<Cpe> findByCpeUri(String cpeUri) {
        return CommonEnumerationUtil.parseCpe(cpeUri).map(this::findByCpeUri).orElseGet(ArrayList::new);
    }

    public List<Cpe> findByCpeUri(Cpe cpeUri) {
        for (Function<String, String> mapper : CPE_PART_MAPPINGS) {
            List<Cpe> cpeList = this.findByCpeUri(cpeUri, mapper);
            if (cpeList.isEmpty()) continue;
            return cpeList;
        }
        return new ArrayList<Cpe>();
    }

    public List<Cpe> findByCpeUri(Cpe cpeUri, Function<String, String> partMapper) {
        IndexSearch search = new IndexSearch();
        search.fieldEquals("part", cpeUri.getPart().getAbbreviation());
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("vendor", partMapper.apply(cpeUri.getVendor()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("product", partMapper.apply(cpeUri.getProduct()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("version", partMapper.apply(cpeUri.getVersion()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("update", partMapper.apply(cpeUri.getUpdate()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("edition", partMapper.apply(cpeUri.getEdition()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("language", partMapper.apply(cpeUri.getLanguage()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("sw_edition", partMapper.apply(cpeUri.getSwEdition()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("target_sw", partMapper.apply(cpeUri.getTargetSw()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("target_hw", partMapper.apply(cpeUri.getTargetHw()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("other", partMapper.apply(cpeUri.getOther()), search);
        return this.findCpeUsingSearcher(search);
    }

    private static void addToSearchIfNotWildcard(String key, String value, IndexSearch search) {
        if (NvdCpeApiIndexQuery.isNotWildcardPart(value)) {
            search.fieldEquals(key, value);
        }
    }

    public static boolean isNotWildcardPart(String part) {
        if (StringUtils.isEmpty(part)) {
            return false;
        }
        return !part.equals("*");
    }

    private List<Cpe> findCpeUsingSearcher(IndexSearch search) {
        return this.index.findDocuments(search).stream().map(e -> CommonEnumerationUtil.parseCpe(e.get("cpe23Uri"))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public List<NvdCpeMetadata> findCpeMetadataByCpeUri(String cpeUri) {
        return CommonEnumerationUtil.parseCpe(cpeUri).map(this::findCpeMetadataByCpeUri).orElseGet(ArrayList::new);
    }

    public List<NvdCpeMetadata> findCpeMetadataByCpeUri(Cpe cpeUri) {
        for (Function<String, String> mapper : CPE_PART_MAPPINGS) {
            List<NvdCpeMetadata> metadata = this.findCpeMetadataByCpeUri(cpeUri, mapper);
            if (metadata.isEmpty()) continue;
            return metadata;
        }
        return new ArrayList<NvdCpeMetadata>();
    }

    public List<NvdCpeMetadata> findCpeMetadataByCpeUri(Cpe cpeUri, Function<String, String> partMapper) {
        IndexSearch search = new IndexSearch();
        search.fieldEquals("part", cpeUri.getPart().getAbbreviation());
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("vendor", partMapper.apply(cpeUri.getVendor()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("product", partMapper.apply(cpeUri.getProduct()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("version", partMapper.apply(cpeUri.getVersion()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("update", partMapper.apply(cpeUri.getUpdate()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("edition", partMapper.apply(cpeUri.getEdition()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("language", partMapper.apply(cpeUri.getLanguage()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("sw_edition", partMapper.apply(cpeUri.getSwEdition()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("target_sw", partMapper.apply(cpeUri.getTargetSw()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("target_hw", partMapper.apply(cpeUri.getTargetHw()), search);
        NvdCpeApiIndexQuery.addToSearchIfNotWildcard("other", partMapper.apply(cpeUri.getOther()), search);
        return this.findCpeMetadataUsingSearcher(search);
    }

    private List<NvdCpeMetadata> findCpeMetadataUsingSearcher(IndexSearch search) {
        return this.index.findDocuments(search).stream().map(NvdCpeMetadata::new).collect(Collectors.toList());
    }
}

