/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.cyclonedx;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.metaeffekt.artifact.analysis.bom.LicenseProcessor;
import com.metaeffekt.artifact.analysis.bom.PatternHelper;
import com.metaeffekt.artifact.analysis.bom.cyclonedx.CycloneDxComponentMapper;
import com.metaeffekt.artifact.analysis.bom.cyclonedx.CycloneDxUtils;
import com.metaeffekt.artifact.analysis.bom.parameters.ExportParameters;
import com.metaeffekt.artifact.analysis.bom.spdx.DocumentSpec;
import com.metaeffekt.artifact.analysis.bom.spdx.LicenseStringConverter;
import com.metaeffekt.artifact.analysis.bom.spdx.mapper.MappingUtils;
import com.metaeffekt.artifact.analysis.bom.spdx.relationship.RelationshipGraph;
import com.metaeffekt.artifact.analysis.bom.spdx.relationship.RelationshipGraphEdge;
import com.metaeffekt.artifact.analysis.bom.spdx.relationship.RelationshipGraphNode;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.cyclonedx.Version;
import org.cyclonedx.generators.BomGeneratorFactory;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Tool;
import org.cyclonedx.util.LicenseResolver;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycloneDxExporter {
    private static final Logger log = LoggerFactory.getLogger(CycloneDxExporter.class);
    public static final String VERSION_LATEST = "latest";
    private final LicenseStringConverter licenseStringConverter;
    private final NormalizationMetaData normalizationMetaData;
    private final LicenseTextProvider licenseTextProvider;
    private Version version = Version.VERSION_16;
    private String generatedXmlBom = null;
    private String generatedJsonBom = null;
    private final ExportParameters exportParameters;

    public CycloneDxExporter(NormalizationMetaData normalizationMetaData, LicenseTextProvider licenseTextProvider, ExportParameters exportParameters) {
        this.exportParameters = exportParameters;
        this.normalizationMetaData = normalizationMetaData;
        this.licenseTextProvider = licenseTextProvider;
        this.licenseStringConverter = new LicenseStringConverter(normalizationMetaData, null);
    }

    public void setVersion(String versionString) {
        if (versionString.equals(VERSION_LATEST)) {
            Version[] values = Version.values();
            this.version = values[values.length - 1];
            return;
        }
        this.version = Arrays.stream(Version.values()).filter(v -> v.getVersionString().equals(versionString)).findFirst().orElseThrow(() -> new IllegalStateException("Unknown version " + versionString + "."));
    }

    public void exportToXml(Inventory inventory, DocumentSpec documentSpec, File outFile) {
        Bom bom = this.createBomFromInventory(inventory, documentSpec);
        BomXmlGenerator xml = BomGeneratorFactory.createXml((Version)this.version, (Bom)bom);
        try {
            xml.generate();
            this.generatedXmlBom = xml.toString();
            if (outFile != null) {
                FileUtils.write((File)outFile, (CharSequence)this.generatedXmlBom, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException | ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void exportToJson(Inventory inventory, DocumentSpec documentSpec, File outFile) throws ParserConfigurationException {
        Bom bom = this.createBomFromInventory(inventory, documentSpec);
        BomJsonGenerator json = BomGeneratorFactory.createJson((Version)this.version, (Bom)bom);
        JsonNode generate = json.toJsonNode();
        if (generate == null) {
            throw new ParserConfigurationException("Error generating JSON output.");
        }
        this.generatedJsonBom = this.exportParameters.isPrettyPrint() ? generate.toPrettyString() : generate.toString();
        try {
            if (outFile != null) {
                FileUtils.write((File)outFile, (CharSequence)this.generatedJsonBom, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Bom createBomFromInventory(Inventory inventory, DocumentSpec documentSpec) {
        Bom bom = this.createBomFromSpec(documentSpec);
        ArrayList<Component> allComponents = new ArrayList<Component>();
        if (!this.exportParameters.isIncludeAssets()) {
            InventoryUtils.removeAssetsAndReferences(inventory);
        }
        List<Pattern> attributeInclusionPatterns = PatternHelper.readPatternFile(this.exportParameters.getAttributeInclusionFile());
        List<Pattern> attributeExclusionsPatterns = PatternHelper.readPatternFile(this.exportParameters.getAttributeExclusionFile());
        CycloneDxComponentMapper cycloneDxComponentMapper = new CycloneDxComponentMapper(documentSpec, inventory, this.licenseStringConverter, this.normalizationMetaData, this.licenseTextProvider, attributeInclusionPatterns, attributeExclusionsPatterns, this.exportParameters);
        for (Artifact artifact : inventory.getArtifacts()) {
            allComponents.add(cycloneDxComponentMapper.map((AbstractModelBase)artifact));
        }
        List unmappedAssets = inventory.getAssetMetaData();
        unmappedAssets.removeIf(MappingUtils.getAssetToArtifactMap(inventory)::containsKey);
        for (AssetMetaData assetMetaData : unmappedAssets) {
            allComponents.add(cycloneDxComponentMapper.map((AbstractModelBase)assetMetaData));
        }
        this.addExternalReferences(bom, cycloneDxComponentMapper.getReferencedLicenses());
        this.addComponentsAndCreateAssembly(bom, allComponents, inventory);
        this.correctIds(bom);
        return bom;
    }

    private Bom createBomFromSpec(DocumentSpec documentSpec) {
        Pattern pattern;
        Matcher matcher;
        Bom bom = new Bom();
        Metadata metadata = new Metadata();
        if (StringUtils.isNotBlank((CharSequence)documentSpec.getOrganization()) || StringUtils.isNotBlank((CharSequence)documentSpec.getOrganizationUrl())) {
            OrganizationalEntity organization = new OrganizationalEntity();
            if (StringUtils.isNotBlank((CharSequence)documentSpec.getOrganization())) {
                organization.setName(documentSpec.getOrganization());
            }
            if (StringUtils.isNotBlank((CharSequence)documentSpec.getOrganizationUrl())) {
                organization.setUrls(Collections.singletonList(documentSpec.getOrganizationUrl()));
            }
            metadata.setManufacturer(organization);
        }
        if (StringUtils.isNotBlank((CharSequence)documentSpec.getTool())) {
            Tool tool = new Tool();
            tool.setName(documentSpec.getTool());
            metadata.addTool(tool);
        }
        if (StringUtils.isNotBlank((CharSequence)documentSpec.getPerson())) {
            OrganizationalContact author = new OrganizationalContact();
            author.setName(documentSpec.getPerson());
            metadata.addAuthor(author);
        }
        if (!(matcher = (pattern = Pattern.compile("^urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")).matcher(documentSpec.getDocumentId())).matches()) {
            throw new RuntimeException("Invalid UUID: " + documentSpec.getDocumentId() + " provided as DocumentId in DocumentSpec. Does not comply with CycloneDx specification.");
        }
        bom.setSerialNumber(documentSpec.getDocumentId());
        LicenseChoice documentLicense = LicenseResolver.resolve((String)this.exportParameters.getDocumentLicense(), (LicenseResolver.LicenseTextSettings)new LicenseResolver.LicenseTextSettings(this.exportParameters.isIncludeLicenseTexts(), LicenseResolver.LicenseEncoding.NONE));
        metadata.setLicenses(documentLicense);
        metadata.setTimestamp(Calendar.getInstance().getTime());
        bom.setMetadata(metadata);
        bom.setVersion(documentSpec.getDocumentVersion());
        return bom;
    }

    private void addExternalReferences(Bom bom, Set<TermsMetaData> referencedLicenses) {
        if (referencedLicenses.isEmpty()) {
            return;
        }
        Map<String, String> licenseIdentifierToText = LicenseProcessor.getReferencedLicenseText(referencedLicenses, this.licenseTextProvider, this.normalizationMetaData);
        if (licenseIdentifierToText != null) {
            for (Map.Entry<String, String> entry : licenseIdentifierToText.entrySet()) {
                ExternalReference externalReference = new ExternalReference();
                externalReference.setUrl(entry.getKey());
                if (entry.getValue() != null && this.exportParameters.isIncludeLicenseTexts()) {
                    externalReference.setComment(entry.getValue());
                } else {
                    externalReference.setComment("No license text found.");
                }
                externalReference.setType(ExternalReference.Type.LICENSE);
                bom.addExternalReference(externalReference);
            }
        }
    }

    private void addComponentsAndCreateAssembly(Bom bom, List<Component> allComponents, Inventory inventory) {
        RelationshipGraph relationshipGraph = new RelationshipGraph(inventory, MappingUtils.getAssetToArtifactMap(inventory));
        List<RelationshipGraphEdge> edges = relationshipGraph.getAllRelationships();
        if (!this.exportParameters.isMapRelationships() || edges.isEmpty()) {
            bom.setComponents(allComponents);
            return;
        }
        for (RelationshipGraphEdge edge : edges) {
            switch (edge.getRelationshipType()) {
                case CONTAINS: {
                    this.handleContainsEdge(edge, allComponents);
                    break;
                }
                case DESCRIBES: {
                    this.handleDescribesEdge(edge, allComponents, bom);
                }
            }
        }
    }

    private void handleContainsEdge(RelationshipGraphEdge edge, List<Component> allComponents) {
        Component fromComponent = allComponents.stream().filter(c -> c.getName().equals(edge.getFromNode().getId())).findFirst().orElse(null);
        if (fromComponent == null) {
            return;
        }
        List toNodeNames = edge.getToNodes().stream().map(RelationshipGraphNode::getId).collect(Collectors.toList());
        List toComponents = allComponents.stream().filter(c -> toNodeNames.contains(c.getName())).collect(Collectors.toList());
        fromComponent.setComponents(toComponents);
    }

    private void handleDescribesEdge(RelationshipGraphEdge edge, List<Component> allComponents, Bom bom) {
        List toNodeNames = edge.getToNodes().stream().map(RelationshipGraphNode::getId).collect(Collectors.toList());
        List<Component> toComponents = allComponents.stream().filter(c -> toNodeNames.contains(c.getName())).collect(Collectors.toList());
        toComponents.forEach(arg_0 -> ((Bom)bom).addComponent(arg_0));
    }

    private void correctIds(Bom bom) {
        for (Component component : CycloneDxUtils.getAllComponents(bom)) {
            try {
                PackageURL packageURL = new PackageURL(component.getPurl());
                component.setName(packageURL.getName());
            }
            catch (MalformedPackageURLException e) {
                log.warn("Could not get name from purl for: {}, fallback to original id.", (Object)component);
            }
        }
    }

    public String getGeneratedXmlBom() {
        return this.generatedXmlBom;
    }

    public String getGeneratedJsonBom() {
        return this.generatedJsonBom;
    }

    public ExportParameters getExportParameters() {
        return this.exportParameters;
    }
}

