/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.cyclonedx;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.metaeffekt.artifact.analysis.bom.PatternHelper;
import com.metaeffekt.artifact.analysis.bom.cyclonedx.AbstractAttributeMapper;
import com.metaeffekt.artifact.analysis.bom.cyclonedx.CycloneDxUtils;
import com.metaeffekt.artifact.analysis.bom.parameters.ImportParameters;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Property;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.ArtifactType;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryModelBaseMapper
extends AbstractAttributeMapper {
    private static final Logger log = LoggerFactory.getLogger(InventoryModelBaseMapper.class);
    private final ImportParameters importParameters;

    public InventoryModelBaseMapper(List<Pattern> includedAttributePatterns, List<Pattern> excludedAttributePatterns, ImportParameters importParameters) {
        super(includedAttributePatterns, excludedAttributePatterns);
        this.importParameters = importParameters;
    }

    public AbstractModelBase map(Component component) {
        Artifact modelBase;
        if (CycloneDxUtils.isAsset(component)) {
            if (!this.importParameters.isIncludeAssets()) {
                return null;
            }
            modelBase = new AssetMetaData();
        } else {
            modelBase = new Artifact();
        }
        this.mapOrganizationInformation(component, (AbstractModelBase)modelBase);
        this.mapBaseInformation(component, (AbstractModelBase)modelBase);
        this.mapName(component, (AbstractModelBase)modelBase);
        this.mapTypes((AbstractModelBase)modelBase, component);
        this.mapChecksums(component, (AbstractModelBase)modelBase);
        this.mapFileLocationInformation(component, (AbstractModelBase)modelBase);
        if (this.importParameters.isIncludeLicenses()) {
            this.mapLicenses(component, (AbstractModelBase)modelBase);
        }
        this.mapPropertiesToAttributes(component, (AbstractModelBase)modelBase);
        this.mapPurlRelated(component, (AbstractModelBase)modelBase);
        this.mapCpe(component, (AbstractModelBase)modelBase);
        this.removeAeProperties((AbstractModelBase)modelBase);
        return modelBase;
    }

    private void mapCpe(Component component, AbstractModelBase modelBase) {
        String cpe = component.getCpe();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cpe)) {
            modelBase.set(InventoryAttribute.ADDITIONAL_CPE.getKey(), cpe);
        }
    }

    private void mapBaseInformation(Component component, AbstractModelBase modelBase) {
        String qualifier = component.getName();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)component.getVersion())) {
            qualifier = qualifier + "-" + component.getVersion();
        }
        if (CycloneDxUtils.isAsset(component)) {
            this.setAttributeIfNotBlank(modelBase, "Asset Id", component.getName());
        } else {
            this.setAttributeIfNotBlank(modelBase, "Id", qualifier);
        }
        this.setAttributeIfNotBlank(modelBase, "Version", component.getVersion());
        this.setAttributeIfNotBlank(modelBase, "Description", component.getDescription());
        List properties = component.getProperties();
        if (properties != null) {
            Property property = properties.stream().filter(p -> p.getName().equals("com.metaeffekt.component.type")).findFirst().orElse(null);
            if (property != null) {
                this.setAttributeIfNotBlank(modelBase, "Type", property.getValue());
            }
            if ((property = (Property)properties.stream().filter(p -> p.getName().equals(Artifact.Attribute.COMMENT.getKey())).findFirst().orElse(null)) != null) {
                this.setAttributeIfNotBlank(modelBase, Artifact.Attribute.COMMENT.getKey(), property.getValue());
            }
        }
    }

    private void mapName(Component component, AbstractModelBase modelBase) {
        String idKey;
        List properties = component.getProperties();
        String string = idKey = CycloneDxUtils.isAsset(component) ? AssetMetaData.Attribute.ASSET_ID.getKey() : Artifact.Attribute.ID.getKey();
        if (properties != null) {
            Property property = properties.stream().filter(p -> p.getName().equals("com.metaeffekt.component.id")).findFirst().orElse(null);
            if (property != null) {
                this.setAttributeIfNotBlank(modelBase, idKey, property.getValue());
            } else {
                this.setAttributeIfNotBlank(modelBase, idKey, component.getName());
            }
        }
    }

    private void mapChecksums(Component component, AbstractModelBase modelBase) {
        if (component.getHashes() == null || component.getHashes().isEmpty()) {
            return;
        }
        for (Hash hash : component.getHashes()) {
            if (hash.getAlgorithm().equals(Hash.Algorithm.MD5.getSpec())) {
                modelBase.set("Checksum", hash.getValue());
                continue;
            }
            if (hash.getAlgorithm().equals(Hash.Algorithm.SHA1.getSpec())) {
                modelBase.set("Hash (SHA-1)", hash.getValue());
                continue;
            }
            if (hash.getAlgorithm().equals(Hash.Algorithm.SHA_256.getSpec())) {
                modelBase.set("Hash (SHA-256)", hash.getValue());
                continue;
            }
            if (!hash.getAlgorithm().equals(Hash.Algorithm.SHA_512.getSpec())) continue;
            modelBase.set("Hash (SHA-512)", hash.getValue());
        }
    }

    private void mapFileLocationInformation(Component component, AbstractModelBase modelBase) {
        this.setIfPropertyExists(modelBase, "Root Paths", "Path", component);
    }

    private void mapLicenses(Component component, AbstractModelBase modelBase) {
        String licenseString = null;
        LicenseChoice licenseChoice = component.getLicenses();
        if (licenseChoice != null) {
            List licenseList;
            if (licenseChoice.getExpression() != null) {
                licenseString = licenseChoice.getExpression().getValue();
            }
            if ((licenseList = licenseChoice.getLicenses()) != null) {
                licenseString = licenseList.stream().map(this::licenseToName).collect(Collectors.joining(", "));
            }
        }
        this.setAttributeIfNotBlank(modelBase, "Component Specified License", licenseString);
    }

    private void mapOrganizationInformation(Component component, AbstractModelBase modelBase) {
        this.setAttributeIfNotBlank(modelBase, "URL", component.getPublisher());
        this.setAttributeIfNotBlank(modelBase, "Group Id", component.getGroup());
        this.setIfPropertyExists(modelBase, "Organization URL", "Organization URL", component);
        this.setIfPropertyExists(modelBase, "Organization", "Organization", component);
    }

    private void mapPropertiesToAttributes(Component component, AbstractModelBase modelBase) {
        List properties = component.getProperties();
        if (properties != null) {
            for (Property property : properties) {
                String attribute = property.getName();
                boolean excluded = PatternHelper.isExcluded(attribute, this.getIncludedAttributePatterns(), this.getExcludedAttributePatterns());
                if (excluded) continue;
                modelBase.set(attribute, property.getValue());
            }
        }
    }

    private void setAttributeIfNotBlank(AbstractModelBase modelBase, String key, String value) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) {
            modelBase.set(key, value);
        }
    }

    private void setIfPropertyExists(AbstractModelBase modelBase, String key, String name, Component component) {
        Optional<Property> optionalProperty;
        List properties = component.getProperties();
        if (properties != null && (optionalProperty = properties.stream().filter(p -> p.getName().equals(name)).findFirst()).isPresent()) {
            Property property = optionalProperty.get();
            this.setAttributeIfNotBlank(modelBase, key, property.getValue());
        }
    }

    private String licenseToName(License l) {
        if (l.getId() != null) {
            return l.getId();
        }
        return l.getName();
    }

    private void removeAeProperties(AbstractModelBase modelBase) {
        modelBase.set("com.metaeffekt.component.id", null);
        modelBase.set("com.metaeffekt.component.class", null);
        modelBase.set("com.metaeffekt.component.type", null);
        modelBase.set("com.metaeffekt.component.version", null);
    }

    private void mapPurlRelated(Component component, AbstractModelBase modelBase) {
        String purl = component.getPurl();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purl)) {
            this.setAttributeIfNotBlank(modelBase, "PURL", purl);
            if (this.importParameters.isDeriveAttributesFromPurl()) {
                try {
                    PackageURL packageURL = new PackageURL(purl);
                    this.setAttributeIfNotBlank(modelBase, Artifact.Attribute.COMPONENT.getKey(), packageURL.getName());
                    String ecosystem = packageURL.getType();
                    this.setAttributeIfNotBlank(modelBase, InventoryAttribute.ECOSYSTEM.getKey(), ecosystem);
                    this.setAttributeIfNotBlank(modelBase, Artifact.Attribute.TYPE.getKey(), ecosystem);
                    this.mapTypes(modelBase, component, ecosystem);
                    if (component.getVersion() == null) {
                        this.setAttributeIfNotBlank(modelBase, "Version", packageURL.getVersion());
                    }
                }
                catch (MalformedPackageURLException e) {
                    log.warn("Could not get component attribute from invalid purl: {}", (Object)purl);
                }
            }
        }
    }

    private void mapTypes(AbstractModelBase modelBase, Component component) {
        String componentType = InventoryModelBaseMapper.extractComponentTypeOrNull(component);
        Pair<String, String> derivedArtifactTypeInformation = this.deriveArtifactTypeFromComponentInformation(componentType);
        InventoryModelBaseMapper.applyTypePair(modelBase, derivedArtifactTypeInformation);
    }

    private static String extractComponentTypeOrNull(Component component) {
        if (component == null) {
            return null;
        }
        Component.Type componentType = component.getType();
        if (componentType == null) {
            return null;
        }
        return componentType.getTypeName();
    }

    private void mapTypes(AbstractModelBase modelBase, Component component, String ecosystem) {
        String componentType = InventoryModelBaseMapper.extractComponentTypeOrNull(component);
        Pair<String, String> derivedArtifactTypeInformation = this.deriveArtifactTypeFromComponentTypeOrPurl(componentType, ecosystem);
        InventoryModelBaseMapper.applyTypePair(modelBase, derivedArtifactTypeInformation);
    }

    private static void applyTypePair(AbstractModelBase modelBase, Pair<String, String> derivedArtifactTypeInformation) {
        if (derivedArtifactTypeInformation.getLeft() != null) {
            modelBase.set((AbstractModelBase.Attribute)Artifact.Attribute.TYPE, (String)derivedArtifactTypeInformation.getLeft());
            if (derivedArtifactTypeInformation.getRight() != null) {
                modelBase.set((AbstractModelBase.Attribute)Artifact.Attribute.COMPONENT_SOURCE_TYPE, (String)derivedArtifactTypeInformation.getRight());
            }
        }
    }

    private Pair<String, String> deriveArtifactTypeFromComponentInformation(String componentType) {
        if (StringUtils.hasText(componentType)) {
            switch (componentType) {
                case "operating-system": {
                    return Pair.of((Object)ArtifactType.OPERATING_SYSTEM.getCategory(), null);
                }
                case "device": {
                    return Pair.of((Object)ArtifactType.CATEGORY_HARDWARE.getCategory(), null);
                }
                case "device-driver": {
                    return Pair.of((Object)ArtifactType.DRIVER.getCategory(), null);
                }
                case "firmware": {
                    return Pair.of((Object)ArtifactType.BIOS.getCategory(), null);
                }
                case "file": {
                    return Pair.of((Object)ArtifactType.FILE.getCategory(), null);
                }
                case "container": {
                    return Pair.of((Object)"container", null);
                }
                case "application": {
                    return Pair.of((Object)"application", null);
                }
            }
        }
        return Pair.of(null, null);
    }

    private Pair<String, String> deriveArtifactTypeFromComponentTypeOrPurl(String componentType, String purlType) {
        Pair<String, String> typePair = this.deriveArtifactTypeFromComponentInformation(componentType);
        if (StringUtils.hasText(purlType)) {
            switch (purlType) {
                case "maven": {
                    return Pair.of((Object)"module", (Object)"jar-module");
                }
                case "npm": {
                    return Pair.of((Object)ArtifactType.WEB_MODULE.getCategory(), (Object)"npm-module");
                }
                case "nuget": {
                    return Pair.of((Object)"module", (Object)"nuget-module");
                }
                case "pypi": {
                    return Pair.of((Object)ArtifactType.PYTHON_MODULE.getCategory(), null);
                }
                case "deb": 
                case "rpm": 
                case "apk": 
                case "portage": 
                case "opkg": 
                case "swid": {
                    return Pair.of((Object)ArtifactType.LINUX_PACKAGE.getCategory(), null);
                }
            }
        }
        return typePair;
    }
}

