/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseStringUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseStringUtils.class);
    protected static final String escapeSequenceStart = "-.H0x";
    protected static final String escapeSequenceEnd = "-";
    protected static final String hexFormatter = "%x";
    protected static final String escapeFormatter = "-.H0x%x-";
    public static final String PREFIX_LICENSE_REF_COMMON = "LicenseRef-";
    protected static final String[] supportedNamespaces = new String[]{"ae", "scancode", "spdx", "unknown"};
    protected static final Set<String> supportedNamespacesSet = new HashSet<String>(Arrays.asList(supportedNamespaces));
    protected static final Set<String> supportedLicenseRefPrefixes = Collections.unmodifiableSet(Arrays.stream(supportedNamespaces).map(namespaceString -> PREFIX_LICENSE_REF_COMMON + LicenseStringUtils.escapeForLicenseRef(namespaceString) + escapeSequenceEnd).collect(LinkedHashSet::new, Set::add, Set::addAll));

    public static boolean containsTopAnd(String licensesString) {
        NavigableMap<Integer, Integer> skippable = LicenseStringUtils.findTopBrackets(licensesString);
        for (int i = 0; i < licensesString.length(); ++i) {
            Integer queryResult = (Integer)skippable.get(i);
            if (queryResult != null) {
                i = queryResult;
            }
            if (licensesString.charAt(i) != ',') continue;
            return true;
        }
        return false;
    }

    public static NavigableMap<Integer, Integer> findTopBrackets(String string) throws IllegalArgumentException {
        return LicenseStringUtils.findTopBrackets(string, '(', ')');
    }

    public static NavigableMap<Integer, Integer> findTopBrackets(String string, char openingBracket, char closingBracket) throws IllegalArgumentException {
        Objects.requireNonNull(string);
        TreeMap<Integer, Integer> beginToEndBracketIndex = new TreeMap<Integer, Integer>();
        while (string.contains(Character.toString(openingBracket)) || string.contains(Character.toString(closingBracket))) {
            int openBracketPos = string.indexOf(openingBracket);
            if (openBracketPos == -1) {
                throw new IllegalArgumentException("Imbalanced brackets in string '" + string + "'.");
            }
            int closeBracketPos = LicenseStringUtils.findClosingBracket(string, openBracketPos, openingBracket, closingBracket);
            if (closeBracketPos == -1) {
                throw new IllegalArgumentException("Imbalanced brackets in string '" + string + "'.");
            }
            string = string.substring(0, openBracketPos) + StringUtils.repeat((char)'*', (int)(closeBracketPos - openBracketPos + 1)) + string.substring(closeBracketPos + 1);
            beginToEndBracketIndex.put(openBracketPos, closeBracketPos);
        }
        return beginToEndBracketIndex;
    }

    public static int findClosingBracket(String stringToSearch, int openingBracketIndex, char openingBracket, char closingBracket) {
        if (stringToSearch.charAt(openingBracketIndex) != openingBracket) {
            throw new IllegalArgumentException("Didn't find opening bracket at specified index.");
        }
        int depth = 0;
        int searchIndex = openingBracketIndex;
        do {
            if (searchIndex >= stringToSearch.length()) {
                return -1;
            }
            char foundChar = stringToSearch.charAt(searchIndex);
            if (foundChar == openingBracket) {
                ++depth;
            } else if (foundChar == closingBracket) {
                --depth;
            }
            ++searchIndex;
        } while (depth > 0);
        return searchIndex - 1;
    }

    public static String escapeForLicenseRef(String licenseName) {
        licenseName = licenseName.replaceAll("\\s+", escapeSequenceEnd);
        licenseName = licenseName.replaceAll("!", "");
        if ((licenseName = licenseName.replaceAll("\\+", "-or-later")).endsWith("-?")) {
            licenseName = licenseName.substring(0, licenseName.length() - 2);
        }
        if (licenseName.contains(escapeSequenceStart)) {
            StringBuilder escapeSequenceReplacementBuilder = new StringBuilder();
            for (int codepoint : escapeSequenceStart.codePoints().toArray()) {
                escapeSequenceReplacementBuilder.append(String.format(escapeFormatter, codepoint));
            }
            licenseName = licenseName.replace(escapeSequenceStart, escapeSequenceReplacementBuilder.toString());
        }
        StringBuilder licenseRef = new StringBuilder();
        for (int codepoint : licenseName.codePoints().toArray()) {
            if (codepoint < 123 && (Character.isAlphabetic(codepoint) || Character.isDigit(codepoint) || codepoint == 45 || codepoint == 46)) {
                licenseRef.appendCodePoint(codepoint);
                continue;
            }
            licenseRef.append(String.format(escapeFormatter, codepoint));
        }
        return licenseRef.toString();
    }

    public static String unescapeFromLicenseRef(String escapedLicenseId) {
        String escapeSequenceStart = escapeSequenceStart;
        String escapeSequenceEnd = escapeSequenceEnd;
        Pattern escapeSequenceBeginPattern = Pattern.compile(Pattern.quote(escapeSequenceStart));
        ArrayList<String> split = new ArrayList<String>(Arrays.asList(escapeSequenceBeginPattern.split(escapedLicenseId)));
        StringBuilder resultBuilder = new StringBuilder();
        resultBuilder.append((String)split.remove(0));
        for (String sub : split) {
            int resultCodepoint;
            int endIndex = sub.indexOf(escapeSequenceEnd);
            String hex = sub.substring(0, endIndex);
            String rest = sub.substring(endIndex + escapeSequenceEnd.length());
            try {
                resultCodepoint = (int)Long.parseUnsignedLong(hex, 16);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid escaped hex codepoint in input string: " + e);
            }
            resultBuilder.appendCodePoint(resultCodepoint);
            resultBuilder.append(rest);
        }
        return resultBuilder.toString();
    }

    protected static String createLicenseRef(String namespaceId, String licenseName) {
        String escapedNamespaceId;
        if (!supportedNamespacesSet.contains(namespaceId)) {
            LOG.warn("Unsupported namespace [{}].", (Object)namespaceId);
        }
        if (!namespaceId.equals(escapedNamespaceId = LicenseStringUtils.escapeForLicenseRef(namespaceId))) {
            LOG.warn("The namespaceId [{}] will be escaped to [{}]. Namespaces shouldn't need escaping!", (Object)namespaceId, (Object)escapedNamespaceId);
        }
        return PREFIX_LICENSE_REF_COMMON + escapedNamespaceId + escapeSequenceEnd + LicenseStringUtils.escapeForLicenseRef(licenseName);
    }

    public static String createAeLicenseRef(String licenseName) {
        return LicenseStringUtils.createLicenseRef("ae", licenseName);
    }

    public static String createScancodeLicenseRef(String licenseName) {
        return LicenseStringUtils.createLicenseRef("scancode", licenseName);
    }

    public static String createUnknownLicenseRef(String licenseName) {
        return LicenseStringUtils.createLicenseRef("unknown", licenseName);
    }

    public static String createSpdxLicenseRef(String licenseName) {
        return LicenseStringUtils.createLicenseRef("spdx", licenseName);
    }

    public static String unwrapLicenseRef(String licenseRef) {
        for (String prefix : supportedLicenseRefPrefixes) {
            if (!licenseRef.startsWith(prefix)) continue;
            return LicenseStringUtils.unescapeFromLicenseRef(licenseRef.substring(prefix.length()));
        }
        throw new IllegalArgumentException("Argument should be a license ref.");
    }
}

