/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx.mapper;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.Purpose;

public class InventoryModelBaseMapper {
    private static final Logger log = LoggerFactory.getLogger(InventoryModelBaseMapper.class);
    private static final String ASSET_KEY_TYPE = "Type";
    private static final String ASSET_KEY_CHECKSUM = "Checksum";
    private static final String ASSET_KEY_HASH_SHA1 = "Hash (SHA-1)";
    private static final String ASSET_KEY_HASH_SHA256 = "Hash (SHA-256)";
    private static final String ASSET_KEY_HASH_SHA512 = "Hash (SHA-512)";
    private static final String ARTIFACT_KEY_HASH_SHA1 = "Hash (SHA-1)";
    private static final String ARTIFACT_KEY_HASH_SHA256 = "Hash (SHA-256)";
    private static final String ARTIFACT_KEY_HASH_SHA512 = "Hash (SHA-512)";

    public AbstractModelBase map(SpdxPackage spdxPackage) {
        Object modelBase = this.isAsset(spdxPackage) ? new AssetMetaData() : new Artifact();
        this.mapBaseInformation((AbstractModelBase)modelBase, spdxPackage);
        this.mapPurl((AbstractModelBase)modelBase, spdxPackage);
        this.mapChecksums((AbstractModelBase)modelBase, spdxPackage);
        this.mapAnnotations((AbstractModelBase)modelBase, spdxPackage);
        return modelBase;
    }

    private void mapBaseInformation(AbstractModelBase modelBase, SpdxPackage spdxPackage) {
        Optional purpose;
        Optional version;
        Optional name;
        try {
            name = spdxPackage.getName();
            version = spdxPackage.getVersionInfo();
            purpose = spdxPackage.getPrimaryPurpose();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
        if (name.isPresent()) {
            this.setAttributeNoDuplicates(modelBase, AssetMetaData.Attribute.ASSET_ID.getKey(), Artifact.Attribute.ID.getKey(), (String)name.get());
        } else {
            log.error("SpdxPackage: {} has no name.", (Object)spdxPackage);
        }
        if (version.isPresent()) {
            this.setAttributeNoDuplicates(modelBase, AssetMetaData.Attribute.VERSION.getKey(), Artifact.Attribute.VERSION.getKey(), (String)version.get());
        } else {
            log.error("SpdxPackage: {} has no version.", (Object)spdxPackage);
        }
        if (purpose.isPresent()) {
            this.setAttributeNoDuplicates(modelBase, ASSET_KEY_TYPE, Artifact.Attribute.TYPE.getKey(), ((Purpose)purpose.get()).name());
        } else {
            log.error("SpdxPackage: {} has no type / primaryPackagePurpose.", (Object)spdxPackage);
        }
    }

    private void mapPurl(AbstractModelBase modelBase, SpdxPackage spdxPackage) {
        try {
            ArrayList refs = new ArrayList(spdxPackage.getExternalRefs());
            for (ExternalRef ref : refs) {
                if (!ref.getReferenceType().getIndividualURI().contains("purl")) continue;
                this.setAttributeNoDuplicates(modelBase, Artifact.Attribute.PURL.getKey(), ref.getReferenceLocator());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    private void mapChecksums(AbstractModelBase modelBase, SpdxPackage spdxPackage) {
        try {
            ArrayList checksums = new ArrayList(spdxPackage.getChecksums());
            for (Checksum checksum : checksums) {
                if (checksum.getAlgorithm().equals((Object)ChecksumAlgorithm.MD5)) {
                    this.setAttributeNoDuplicates(modelBase, ASSET_KEY_CHECKSUM, Artifact.Attribute.CHECKSUM.getKey(), checksum.getValue());
                    continue;
                }
                if (checksum.getAlgorithm().equals((Object)ChecksumAlgorithm.SHA1)) {
                    this.setAttributeNoDuplicates(modelBase, "Hash (SHA-1)", "Hash (SHA-1)", checksum.getValue());
                    continue;
                }
                if (checksum.getAlgorithm().equals((Object)ChecksumAlgorithm.SHA256)) {
                    this.setAttributeNoDuplicates(modelBase, "Hash (SHA-256)", "Hash (SHA-256)", checksum.getValue());
                    continue;
                }
                if (!checksum.getAlgorithm().equals((Object)ChecksumAlgorithm.SHA512)) continue;
                this.setAttributeNoDuplicates(modelBase, "Hash (SHA-512)", "Hash (SHA-512)", checksum.getValue());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    private void mapOrganizationInformation(AbstractModelBase modelBase, SpdxPackage spdxPackage) {
    }

    private void mapAnnotations(AbstractModelBase modelBase, SpdxPackage spdxPackage) {
        try {
            ArrayList annotations = new ArrayList(spdxPackage.getAnnotations());
            for (Annotation annotation : annotations) {
                String comment = annotation.getComment();
                this.determineAndSetAttribute(modelBase, comment);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    private void determineAndSetAttribute(AbstractModelBase modelBase, String comment) {
        String key;
        int colonIndex = comment.indexOf(":");
        String value = colonIndex != -1 ? comment.substring(colonIndex + 1).trim() : "";
        String string = key = colonIndex != -1 ? comment.substring(0, colonIndex).trim() : comment.trim();
        if (comment.contains("com.metaeffekt.component.type")) {
            this.setAttributeNoDuplicates(modelBase, ASSET_KEY_TYPE, Artifact.Attribute.TYPE.getKey(), value);
            return;
        }
        if (comment.contains("com.metaeffekt.component.version")) {
            this.setAttributeNoDuplicates(modelBase, AssetMetaData.Attribute.VERSION.getKey(), Artifact.Attribute.VERSION.getKey(), value);
            return;
        }
        if (comment.contains("com.metaeffekt.component.id")) {
            this.setAttributeNoDuplicates(modelBase, AssetMetaData.Attribute.ASSET_ID.getKey(), Artifact.Attribute.ID.getKey(), value);
            return;
        }
        this.setAttributeNoDuplicates(modelBase, key, key, value);
    }

    private void setAttributeNoDuplicates(AbstractModelBase modelBase, String assetKey, String artifactKey, String value) {
        String key = modelBase instanceof AssetMetaData ? assetKey : artifactKey;
        if (StringUtils.isBlank((CharSequence)modelBase.get(key))) {
            modelBase.set(key, value);
        }
    }

    private void setAttributeNoDuplicates(AbstractModelBase modelBase, String key, String value) {
        if (StringUtils.isBlank((CharSequence)modelBase.get(key))) {
            modelBase.set(key, value);
        }
    }

    private boolean isAsset(SpdxPackage spdxPackage) {
        try {
            ArrayList annotations = new ArrayList(spdxPackage.getAnnotations());
            for (Annotation annotation : annotations) {
                String comment = annotation.getComment();
                if (!comment.contains("com.metaeffekt.component.class") || !comment.contains("asset")) continue;
                return true;
            }
            return false;
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }
}

