/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.metaeffekt.artifact.analysis.bom.spdx.DocumentSpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.enumerations.AnnotationType;

public class MappingUtils {
    public static Annotation getOverflowAnnotation(SpdxDocument spdxDocument, DocumentSpec documentSpec, Map<String, String> overflowMap) throws InvalidSPDXAnalysisException {
        String jsonString;
        if (overflowMap.isEmpty()) {
            throw new IllegalArgumentException("Map must not be empty.");
        }
        MapType type = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, String.class);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonString = objectMapper.writerWithDefaultPrettyPrinter().forType((JavaType)type).writeValueAsString(overflowMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        SimpleDateFormat spdxDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return spdxDocument.createAnnotation("Tool: " + documentSpec.getTool(), AnnotationType.OTHER, spdxDateFormat.format(new Date()), jsonString);
    }

    public static Map<AssetMetaData, Artifact> getAssetToArtifactMap(Inventory inventory) {
        HashMap<AssetMetaData, Artifact> assetToArtifactMap = new HashMap<AssetMetaData, Artifact>();
        List artifacts = inventory.getArtifacts();
        List assetMetaDataList = inventory.getAssetMetaData();
        for (Artifact artifact : artifacts) {
            for (AssetMetaData assetMetaData : assetMetaDataList) {
                String assetId = assetMetaData.get(AssetMetaData.Attribute.ASSET_ID);
                if (artifact.get(assetId) == null || !artifact.get(assetId).equals("x")) continue;
                assetToArtifactMap.put(assetMetaData, artifact);
            }
        }
        return assetToArtifactMap;
    }
}

