/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx.mapper;

import com.metaeffekt.artifact.analysis.bom.LicenseProcessor;
import com.metaeffekt.artifact.analysis.bom.spdx.LicenseStringConverter;
import com.metaeffekt.artifact.analysis.bom.spdx.facade.SpdxApiFacade;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;

public class SpdxLicenseMapper {
    public static AnyLicenseInfo deriveConcludedLicense(NoticeParameters noticeParameters, Set<TermsMetaData> referencedLicenses, SpdxDocument spdxDocument, LicenseStringConverter licenseStringConverter, Map<String, String> customLicenseMappings) throws InvalidLicenseStringException {
        if (noticeParameters != null) {
            List<String> effectiveLicenses = LicenseProcessor.aggregateEffectiveLicenses(noticeParameters);
            if (effectiveLicenses.isEmpty() || effectiveLicenses.stream().allMatch(StringUtils::isBlank)) {
                return SpdxApiFacade.parseLicenseString(SpdxConstants.NOASSERTION_VALUE, spdxDocument);
            }
            return SpdxLicenseMapper.convertToLicenseInfo(spdxDocument, referencedLicenses, effectiveLicenses, licenseStringConverter, customLicenseMappings);
        }
        return SpdxApiFacade.parseLicenseString(SpdxConstants.NOASSERTION_VALUE, spdxDocument);
    }

    private static AnyLicenseInfo convertToLicenseInfo(SpdxDocument spdxDocument, Set<TermsMetaData> referencedLicenses, List<String> effectiveLicenses, LicenseStringConverter licenseStringConverter, Map<String, String> customLicenseMappings) throws InvalidLicenseStringException {
        StringJoiner joiner = new StringJoiner(") AND (", "(", ")");
        if (customLicenseMappings != null) {
            Iterator<String> iterator = effectiveLicenses.iterator();
            while (iterator.hasNext()) {
                String effectiveLicense = iterator.next();
                if (!customLicenseMappings.containsKey(effectiveLicense)) continue;
                joiner.add("LicenseRef-" + customLicenseMappings.get(effectiveLicense));
                iterator.remove();
            }
        }
        List results = effectiveLicenses.stream().map(s -> licenseStringConverter.licenseStringToSpdxExpression((String)s)).collect(Collectors.toList());
        for (LicenseStringConverter.ToSpdxResult converterResult : results) {
            if (!StringUtils.isNotBlank((CharSequence)converterResult.getExpression())) continue;
            referencedLicenses.addAll(converterResult.getReferencedLicenses());
            joiner.add(converterResult.getExpression());
        }
        return SpdxApiFacade.parseLicenseString(joiner.toString(), spdxDocument);
    }

    public static String deriveCopyrightText(NoticeParameters noticeParameters) {
        String copyrights;
        List copyrightsList;
        if (noticeParameters != null && !(copyrightsList = noticeParameters.aggregateCopyrights()).isEmpty() && StringUtils.isNotBlank((CharSequence)(copyrights = StringUtils.join((Iterable)copyrightsList, (String)"\n")))) {
            return copyrights;
        }
        return SpdxConstants.NOASSERTION_VALUE;
    }

    public static AnyLicenseInfo deriveDeclaredLicense(NoticeParameters noticeParameters, Set<TermsMetaData> referencedLicenses, SpdxDocument spdxDocument, LicenseStringConverter licenseStringConverter, Map<String, String> customLicenseMappings) throws InvalidLicenseStringException {
        if (noticeParameters != null) {
            List associatedLicenses = noticeParameters.aggregateAssociatedLicenses();
            if (associatedLicenses.isEmpty() || associatedLicenses.stream().allMatch(StringUtils::isBlank)) {
                return SpdxApiFacade.parseLicenseString(SpdxConstants.NOASSERTION_VALUE, spdxDocument);
            }
            return SpdxLicenseMapper.convertToLicenseInfo(spdxDocument, referencedLicenses, associatedLicenses, licenseStringConverter, customLicenseMappings);
        }
        return SpdxApiFacade.parseLicenseString(SpdxConstants.NOASSERTION_VALUE, spdxDocument);
    }
}

