/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.metaeffekt.artifact.analysis.bom.LicenseProcessor;
import com.metaeffekt.artifact.analysis.bom.PatternHelper;
import com.metaeffekt.artifact.analysis.bom.cyclonedx.AbstractAttributeMapper;
import com.metaeffekt.artifact.analysis.bom.parameters.ExportParameters;
import com.metaeffekt.artifact.analysis.bom.spdx.DocumentSpec;
import com.metaeffekt.artifact.analysis.bom.spdx.LicenseStringConverter;
import com.metaeffekt.artifact.analysis.bom.spdx.facade.SpdxApiFacade;
import com.metaeffekt.artifact.analysis.bom.spdx.mapper.SpdxLicenseMapper;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.ReferenceType;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.AnnotationType;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.Purpose;
import org.spdx.library.model.enumerations.ReferenceCategory;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.storage.IModelStore;

public class SpdxPackageMapper
extends AbstractAttributeMapper {
    private static final Logger log = LoggerFactory.getLogger(SpdxPackageMapper.class);
    private final SpdxDocument spdxDocument;
    private final DocumentSpec documentSpec;
    private final LicenseStringConverter licenseStringConverter;
    private ExportParameters exportParameters;
    private final HashSet<TermsMetaData> referencedLicenses;
    private Map<String, String> customLicenseMappings;

    public SpdxPackageMapper(DocumentSpec documentSpec, SpdxDocument spdxDocument, LicenseStringConverter licenseStringConverter, List<Pattern> includedAttributePatterns, List<Pattern> excludedAttributePatterns, ExportParameters exportParameters) {
        super(includedAttributePatterns, excludedAttributePatterns);
        this.spdxDocument = spdxDocument;
        this.documentSpec = documentSpec;
        this.licenseStringConverter = licenseStringConverter;
        this.referencedLicenses = new HashSet();
        this.exportParameters = exportParameters;
        File licenseMappingsFile = exportParameters.getCustomLicenseMappings();
        if (licenseMappingsFile == null || licenseMappingsFile.length() == 0L) {
            this.customLicenseMappings = null;
        } else {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                this.customLicenseMappings = (Map)objectMapper.readValue(licenseMappingsFile, Map.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read custom license mappings file: " + licenseMappingsFile, e);
            }
        }
    }

    public SpdxPackage map(AbstractModelBase modelBase) throws InvalidSPDXAnalysisException {
        HashSet<String> writtenAttributes = new HashSet<String>();
        SpdxPackage.SpdxPackageBuilder spdxPackageBuilder = null;
        if (modelBase instanceof Artifact) {
            spdxPackageBuilder = this.spdxDocument.createPackage(this.spdxDocument.getModelStore().getNextId(IModelStore.IdType.SpdxId, this.documentSpec.getDocumentId()), modelBase.get("Id"), (AnyLicenseInfo)new SpdxNoAssertionLicense(), SpdxConstants.NOASSERTION_VALUE, (AnyLicenseInfo)new SpdxNoAssertionLicense());
        } else if (modelBase instanceof AssetMetaData) {
            spdxPackageBuilder = this.spdxDocument.createPackage(this.spdxDocument.getModelStore().getNextId(IModelStore.IdType.SpdxId, this.documentSpec.getDocumentId()), modelBase.get("Asset Id"), (AnyLicenseInfo)new SpdxNoAssertionLicense(), SpdxConstants.NOASSERTION_VALUE, (AnyLicenseInfo)new SpdxNoAssertionLicense());
        }
        this.mapAdditionals(modelBase, spdxPackageBuilder);
        this.mapPrimaryPackagePurpose(modelBase, spdxPackageBuilder, writtenAttributes);
        this.mapUrls(modelBase, spdxPackageBuilder, writtenAttributes);
        this.mapFileTypeInformation(modelBase, spdxPackageBuilder);
        this.mapVersionInfo(modelBase, spdxPackageBuilder, writtenAttributes);
        this.mapChecksums(modelBase, spdxPackageBuilder, writtenAttributes);
        this.mapAuthors(modelBase, spdxPackageBuilder, writtenAttributes);
        this.mapAnnotations(modelBase, spdxPackageBuilder);
        this.mapExternalRefs(modelBase, spdxPackageBuilder);
        if (spdxPackageBuilder != null) {
            SpdxPackage built = spdxPackageBuilder.build();
            this.mapLicensesAndCopyrights(modelBase, this.referencedLicenses, built, writtenAttributes);
            return built;
        }
        throw new RuntimeException("AbstractModelBase: " + modelBase + " is neither an asset or artifact.");
    }

    private void mapAdditionals(AbstractModelBase modelBase, SpdxPackage.SpdxPackageBuilder spdxPackageBuilder) {
        if (StringUtils.isNotBlank((CharSequence)modelBase.get("Deployable URL"))) {
            spdxPackageBuilder.setDownloadLocation(modelBase.get("Deployable URL"));
        } else {
            spdxPackageBuilder.setDownloadLocation(SpdxConstants.NOASSERTION_VALUE);
        }
        if (StringUtils.isNotEmpty((CharSequence)modelBase.get("Component Source Type"))) {
            spdxPackageBuilder.setSourceInfo(modelBase.get("Component Source Type"));
        }
        if (StringUtils.isNotEmpty((CharSequence)modelBase.get((AbstractModelBase.Attribute)Artifact.Attribute.ROOT_PATHS))) {
            spdxPackageBuilder.setPackageFileName(SpdxApiFacade.getFilePathFromProjectLocations(modelBase.get((AbstractModelBase.Attribute)Artifact.Attribute.ROOT_PATHS)));
        }
        if (StringUtils.isNotBlank((CharSequence)modelBase.get("Primary"))) {
            spdxPackageBuilder.setComment("Primary");
        }
    }

    private void mapPrimaryPackagePurpose(AbstractModelBase modelBase, SpdxPackage.SpdxPackageBuilder spdxPackageBuilder, Set<String> writtenAttributes) {
        if (StringUtils.isBlank((CharSequence)modelBase.get("Type"))) {
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            InputStream inputStream = SpdxPackageMapper.class.getClassLoader().getResourceAsStream("sbom/typeMap.json");
            JsonNode jsonNode = objectMapper.readTree(inputStream);
            Iterator iterator = jsonNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ArrayList valuesList = new ArrayList();
                if (((JsonNode)entry.getValue()).isArray()) {
                    ((JsonNode)entry.getValue()).forEach(e -> valuesList.add(e.asText()));
                }
                if (!valuesList.contains(modelBase.get("Type"))) continue;
                try {
                    spdxPackageBuilder.setPrimaryPurpose(Purpose.valueOf((String)((String)entry.getKey())));
                }
                catch (IllegalArgumentException e2) {
                    spdxPackageBuilder.setPrimaryPurpose(Purpose.OTHER);
                }
                writtenAttributes.add("Type");
            }
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    private void mapUrls(AbstractModelBase modelBase, SpdxPackage.SpdxPackageBuilder spdxPackageBuilder, Set<String> writtenAttributes) {
        String url = modelBase.get("URL");
        String orgUrl = modelBase.get("Organization URL");
        String sourceCodeUrl = modelBase.get("Source Code URL");
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            try {
                new URL(url);
                spdxPackageBuilder.setHomepage(url);
                writtenAttributes.add("URL");
            }
            catch (MalformedURLException e) {
                log.warn("The url [{}] contained in [{}], is not a valid URL.", (Object)url, (Object)this.getModelBaseId(modelBase));
            }
        } else if (StringUtils.isNotBlank((CharSequence)orgUrl)) {
            try {
                new URL(orgUrl);
                spdxPackageBuilder.setHomepage(orgUrl);
                writtenAttributes.add("Organization URL");
            }
            catch (MalformedURLException e) {
                log.warn("The url [{}] contained in [{}], is not a valid URL.", (Object)orgUrl, (Object)this.getModelBaseId(modelBase));
            }
        } else {
            spdxPackageBuilder.setHomepage(SpdxConstants.NOASSERTION_VALUE);
        }
        if (StringUtils.isNotBlank((CharSequence)sourceCodeUrl)) {
            spdxPackageBuilder.setSourceInfo(sourceCodeUrl);
        } else {
            spdxPackageBuilder.setSourceInfo(SpdxConstants.NOASSERTION_VALUE);
        }
    }

    private void mapFileTypeInformation(AbstractModelBase modelBase, SpdxPackage.SpdxPackageBuilder spdxPackageBuilder) {
        String archive = modelBase.get("Archive");
        String structured = modelBase.get("Structured");
        String executable = modelBase.get("Executable");
        String comment = "";
        if (StringUtils.isNotBlank((CharSequence)archive)) {
            comment = comment + "Archive: " + archive + "\n";
        }
        if (StringUtils.isNotBlank((CharSequence)structured)) {
            comment = comment + "Structured: " + structured + "\n";
        }
        if (StringUtils.isNotBlank((CharSequence)executable)) {
            comment = comment + "Executable: " + executable + "\n";
        }
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            spdxPackageBuilder.setComment(comment);
        }
    }

    private void mapVersionInfo(AbstractModelBase modelBase, SpdxPackage.SpdxPackageBuilder spdxPackageBuilder, Set<String> writtenAttributes) {
        if (StringUtils.isBlank((CharSequence)modelBase.get("Version"))) {
            spdxPackageBuilder.setVersionInfo(SpdxConstants.NOASSERTION_VALUE);
            return;
        }
        spdxPackageBuilder.setVersionInfo(modelBase.get("Version"));
        writtenAttributes.add(Artifact.Attribute.VERSION.getKey());
    }

    private void mapChecksums(AbstractModelBase modelBase, SpdxPackage.SpdxPackageBuilder spdxPackageBuilder, Set<String> writtenAttributes) throws InvalidSPDXAnalysisException {
        String digest;
        ArrayList<Checksum> checksums = new ArrayList<Checksum>();
        HashMap<ChecksumAlgorithm, List<String>> checksumMappings = new HashMap<ChecksumAlgorithm, List<String>>();
        checksumMappings.put(ChecksumAlgorithm.MD5, Arrays.asList("Checksum", "Checksum (MD5)"));
        checksumMappings.put(ChecksumAlgorithm.SHA1, Arrays.asList("Checksum (SHA-1)", "Hash (SHA-1)"));
        checksumMappings.put(ChecksumAlgorithm.SHA256, Arrays.asList("Checksum (SHA-256)", "Hash (SHA-256)", "Binary Artifact - Hash (SHA-256)"));
        checksumMappings.put(ChecksumAlgorithm.SHA512, Arrays.asList("Checksum (SHA-512)", "HASH (SHA-512)"));
        for (Map.Entry entry : checksumMappings.entrySet()) {
            ChecksumAlgorithm algorithm = (ChecksumAlgorithm)entry.getKey();
            List possibleKeys = (List)entry.getValue();
            String checksumValue = this.getFirstNonBlankValue(modelBase, possibleKeys);
            if (!StringUtils.isNotBlank((CharSequence)checksumValue)) continue;
            checksums.add(this.spdxDocument.createChecksum(algorithm, checksumValue));
            writtenAttributes.addAll(possibleKeys);
        }
        if (!checksums.isEmpty()) {
            spdxPackageBuilder.setChecksums(checksums);
        }
        if (StringUtils.isNotBlank((CharSequence)(digest = modelBase.get("Digest"))) && digest.startsWith("sha256:")) {
            Checksum sha256sum = this.spdxDocument.createChecksum(ChecksumAlgorithm.SHA256, digest.substring(7));
            checksums.add(sha256sum);
            spdxPackageBuilder.setChecksums(checksums);
        }
    }

    private void mapAuthors(AbstractModelBase modelBase, SpdxPackage.SpdxPackageBuilder spdxPackageBuilder, Set<String> writtenAttributes) {
        String authorsKey = "Extracted Authors (ScanCode)";
        String authors = modelBase.get(authorsKey);
        if (StringUtils.isNotBlank((CharSequence)authors)) {
            spdxPackageBuilder.setAttributionText(Arrays.asList(authors.split("\\|\n")));
        }
        writtenAttributes.add(authorsKey);
        if (StringUtils.isNotBlank((CharSequence)modelBase.get("Supplier"))) {
            spdxPackageBuilder.setSupplier("Organization: " + modelBase.get("Supplier"));
        }
    }

    private void mapExternalRefs(AbstractModelBase modelBase, SpdxPackage.SpdxPackageBuilder spdxPackageBuilder) throws InvalidSPDXAnalysisException {
        String purl = modelBase.get("PURL");
        if (StringUtils.isNotBlank((CharSequence)purl)) {
            ReferenceType referenceType = new ReferenceType((IndividualUriValue)new ReferenceType("http://spdx.org/rdf/references/purl"));
            ExternalRef externalRef = this.spdxDocument.createExternalRef(ReferenceCategory.PACKAGE_MANAGER, referenceType, purl, null);
            spdxPackageBuilder.addExternalRef(externalRef);
        }
        if (StringUtils.isNotBlank((CharSequence)modelBase.get("Repository"))) {
            spdxPackageBuilder.addExternalRef(this.spdxDocument.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://spdx.org/rdf/references/url"), modelBase.get("Repository"), null));
        }
    }

    private void mapAnnotations(AbstractModelBase modelBase, SpdxPackage.SpdxPackageBuilder spdxPackageBuilder) {
        Set attributes = modelBase.getAttributes();
        for (String attribute : attributes) {
            boolean excluded = PatternHelper.isExcluded(attribute, this.getIncludedAttributePatterns(), this.getExcludedAttributePatterns());
            if (excluded) continue;
            spdxPackageBuilder.addAnnotation(this.buildAnnotation(attribute + ": " + modelBase.get(attribute)));
        }
        if (this.exportParameters.isIncludeTechnicalProperties()) {
            if (modelBase instanceof AssetMetaData) {
                spdxPackageBuilder.addAnnotation(this.buildAnnotation("com.metaeffekt.component.class: asset"));
            } else {
                spdxPackageBuilder.addAnnotation(this.buildAnnotation("com.metaeffekt.component.class: artifact"));
            }
            spdxPackageBuilder.addAnnotation(this.buildAnnotation("com.metaeffekt.component.type: " + modelBase.get("Type")));
            spdxPackageBuilder.addAnnotation(this.buildAnnotation("com.metaeffekt.component.version: " + modelBase.get("Version")));
        }
        if (modelBase instanceof AssetMetaData) {
            spdxPackageBuilder.addAnnotation(this.buildAnnotation("com.metaeffekt.component.id: " + modelBase.get("Asset Id")));
        } else {
            spdxPackageBuilder.addAnnotation(this.buildAnnotation("com.metaeffekt.component.id: " + modelBase.get("Id")));
        }
    }

    private Annotation buildAnnotation(String annotationString) {
        try {
            return this.spdxDocument.createAnnotation("Tool: " + this.documentSpec.getTool(), AnnotationType.OTHER, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()), annotationString);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    private void mapLicensesAndCopyrights(AbstractModelBase modelBase, Set<TermsMetaData> referencedLicenses, SpdxPackage built, Set<String> writtenAttributes) throws InvalidSPDXAnalysisException {
        NoticeParameters noticeParameters = LicenseProcessor.readNoticeParameters(modelBase);
        built.setLicenseConcluded(SpdxLicenseMapper.deriveConcludedLicense(noticeParameters, referencedLicenses, this.spdxDocument, this.licenseStringConverter, this.customLicenseMappings));
        built.setLicenseDeclared(SpdxLicenseMapper.deriveDeclaredLicense(noticeParameters, referencedLicenses, this.spdxDocument, this.licenseStringConverter, this.customLicenseMappings));
        built.setCopyrightText(SpdxLicenseMapper.deriveCopyrightText(noticeParameters));
        writtenAttributes.add(Artifact.Attribute.LICENSE.getKey());
        writtenAttributes.add("Derived Notice Parameter");
        writtenAttributes.add("Inherited Notice Parameter");
        writtenAttributes.add("Inherited License");
        writtenAttributes.add("Derived Licenses");
        writtenAttributes.add("Binary Artifact - Derived Licenses");
        writtenAttributes.add("Descriptor - Derived Licenses");
        writtenAttributes.add("Source Archive - Derived Licenses");
        writtenAttributes.add("Source Artifact - Derived Licenses");
        writtenAttributes.add("Derived Markers");
        writtenAttributes.add("Binary Artifact - Derived Markers");
        writtenAttributes.add("Source Artifact - Derived Markers");
        writtenAttributes.add("Source Archive - Derived Markers");
        writtenAttributes.add("Descriptor - Derived Markers");
    }

    private String getFirstNonBlankValue(AbstractModelBase modelBase, List<String> keys) {
        for (String key : keys) {
            String value = modelBase.get(key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return value;
        }
        return null;
    }

    private String getModelBaseId(AbstractModelBase modelBase) {
        if (modelBase instanceof Artifact) {
            return modelBase.get("Id");
        }
        return modelBase.get("Asset Id");
    }

    public HashSet<TermsMetaData> getReferencedLicenses() {
        return this.referencedLicenses;
    }
}

