/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx.relationship;

import com.metaeffekt.artifact.analysis.bom.spdx.relationship.RelationshipGraphEdge;
import com.metaeffekt.artifact.analysis.bom.spdx.relationship.RelationshipGraphNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.model.enumerations.RelationshipType;

public class RelationshipGraph {
    private static final Logger log = LoggerFactory.getLogger(RelationshipGraph.class);
    private final Map<String, RelationshipGraphNode> nodes = new HashMap<String, RelationshipGraphNode>();
    private final List<RelationshipGraphEdge> relationships = new ArrayList<RelationshipGraphEdge>();

    public RelationshipGraph(Inventory inventory, Map<AssetMetaData, Artifact> assetToArtifactMap) {
        this.mapRelationships(inventory, assetToArtifactMap);
    }

    public void addNode(RelationshipGraphNode node) {
        this.nodes.put(node.getId(), node);
    }

    public void addRelationship(String fromId, String toId, RelationshipType relationshipType) {
        RelationshipGraphNode fromNode = this.nodes.get(fromId);
        RelationshipGraphNode toNode = this.nodes.get(toId);
        boolean edgeExists = false;
        for (RelationshipGraphEdge edge : this.relationships) {
            if (!edge.getFromNode().getId().equals(fromId)) continue;
            edge.addToNode(toNode);
            edgeExists = true;
        }
        if (!edgeExists) {
            ArrayList<RelationshipGraphNode> toNodes = new ArrayList<RelationshipGraphNode>();
            toNodes.add(toNode);
            this.relationships.add(new RelationshipGraphEdge(fromNode, toNodes, relationshipType));
        }
    }

    public List<RelationshipGraphEdge> getAllRelationships() {
        return this.relationships;
    }

    private void mapRelationships(Inventory inventory, Map<AssetMetaData, Artifact> assetToArtifactMap) {
        List assetMetaDataList = inventory.getAssetMetaData();
        List artifactList = inventory.getArtifacts();
        this.addNode(new RelationshipGraphNode("DOCUMENT"));
        artifactList.forEach(artifact -> this.addNode(new RelationshipGraphNode(artifact.getId())));
        assetMetaDataList.forEach(assetMetaData -> {
            if (!assetToArtifactMap.containsKey(assetMetaData)) {
                this.addNode(new RelationshipGraphNode(assetMetaData.get(AssetMetaData.Attribute.ASSET_ID)));
            }
        });
        if (assetMetaDataList.isEmpty()) {
            for (Artifact artifact2 : artifactList) {
                this.addRelationship("DOCUMENT", artifact2.getId(), RelationshipType.DESCRIBES);
            }
            return;
        }
        if (assetToArtifactMap.isEmpty()) {
            for (AssetMetaData assetMetaData2 : assetMetaDataList) {
                this.addRelationship("DOCUMENT", assetMetaData2.get("Asset Id"), RelationshipType.DESCRIBES);
            }
        }
        for (Artifact artifact3 : artifactList) {
            boolean hasContainsMarker = false;
            String describesId = null;
            for (AssetMetaData assetMetaData3 : assetMetaDataList) {
                String assetId = assetMetaData3.get(AssetMetaData.Attribute.ASSET_ID);
                if (artifact3.get(assetId) != null && artifact3.get(assetId).equals("c")) {
                    if (!assetToArtifactMap.containsKey(assetMetaData3)) {
                        this.addRelationship(assetId, artifact3.getId(), RelationshipType.CONTAINS);
                    } else {
                        this.addRelationship(assetToArtifactMap.get(assetMetaData3).getId(), artifact3.getId(), RelationshipType.CONTAINS);
                    }
                    hasContainsMarker = true;
                    continue;
                }
                if (artifact3.get(assetId) == null || !artifact3.get(assetId).equals("x")) continue;
                if (!assetToArtifactMap.containsKey(assetMetaData3)) {
                    describesId = assetId;
                    continue;
                }
                describesId = assetToArtifactMap.get(assetMetaData3).getId();
            }
            if (describesId == null || hasContainsMarker) continue;
            this.addRelationship("DOCUMENT", describesId, RelationshipType.DESCRIBES);
        }
    }
}

