/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.dashboard;

import com.metaeffekt.artifact.analysis.dashboard.Modal;
import com.metaeffekt.artifact.analysis.dashboard.NavigationCellStyle;
import com.metaeffekt.artifact.analysis.dashboard.NavigationColumnHeaderConfig;
import com.metaeffekt.artifact.analysis.dashboard.NavigationRow;
import com.metaeffekt.artifact.analysis.dashboard.Sheet;
import com.metaeffekt.artifact.analysis.dashboard.SheetParagraph;
import com.metaeffekt.artifact.analysis.dashboard.SidebarElement;
import com.metaeffekt.artifact.analysis.dashboard.SvgIcon;
import com.metaeffekt.artifact.analysis.utils.FileAppendable;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.Text;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.BodyTag;
import j2html.tags.specialized.ButtonTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.HeadTag;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.InputTag;
import j2html.tags.specialized.LabelTag;
import j2html.tags.specialized.LinkTag;
import j2html.tags.specialized.MetaTag;
import j2html.tags.specialized.ScriptTag;
import j2html.tags.specialized.SpanTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TbodyTag;
import j2html.tags.specialized.TdTag;
import j2html.tags.specialized.ThTag;
import j2html.tags.specialized.TheadTag;
import j2html.tags.specialized.TrTag;
import j2html.tags.specialized.UlTag;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.json.JSONObject;
import org.metaeffekt.core.util.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dashboard {
    private static final Logger log = LoggerFactory.getLogger(Dashboard.class);
    private String title;
    private String subtitle;
    private String description;
    private String author;
    private String authorUrl;
    private String version;
    private String[] contentSheetEntryNames = new String[]{"Sheet Name", "Sheet Names"};
    private LinkTag favicon;
    private final List<String> keywords = new ArrayList<String>();
    private final List<Sheet> sheets = new ArrayList<Sheet>();
    private final List<Modal> modals = new ArrayList<Modal>();
    private final List<SidebarElement> sidebarElements = new ArrayList<SidebarElement>();
    private final List<NavigationColumnHeaderConfig> navigationColumnHeaders = new ArrayList<NavigationColumnHeaderConfig>();
    private final SpanTag additionalContent = TagCreator.span();
    private final List<DomContent> additionalBottomLeftBadges = new ArrayList<DomContent>();
    private final List<DomContent> additionalInformationModalContent = new ArrayList<DomContent>();
    private boolean enableChartJs = false;
    private final List<DashboardLicenseNotice> dashboardLicenseNotices = new ArrayList<DashboardLicenseNotice>();
    private final int topRightIconSize = 22;
    private final Map<String, List<NavigationFilter>> navigationFilterTemplates = new LinkedHashMap<String, List<NavigationFilter>>();
    private final StringBuilder onFilterApplied = new StringBuilder();
    private final StringBuilder onThemeChange = new StringBuilder();
    private String emptyDashboardText = "There are no sheets to display.";
    private int emptyDashboardTextSize = 141;
    private String emptyDashboardIcon = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"120\" height=\"120\" fill=\"green\" class=\"bi bi-patch-check-fill\" viewBox=\"0 0 16 16\" style=\"position: absolute; left: calc(50% - 60px); top: calc(50% - 90px);\">\n  <path d=\"M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z\"/>  <path d=\"M10.97 4.97a.235.235 0 0 0-.02.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05z\"/></svg>";
    private static final String[] FILTER_OPERATIONS = new String[]{"contains", "not contains", "equal", "not equal", "larger", "larger/equal", "smaller/equal", "smaller"};
    private static final Pattern MD_HEADER_PATTERN = Pattern.compile("^ ?(#+) ?(.+) ?$");
    private static final Pattern MD_LINK_PATTERN = Pattern.compile("(\\[([^\\[\\]]+)]\\(([^()]+)\\))");
    private static final Pattern MD_UL_PATTERN = Pattern.compile("^ ?[*\\-+](?![*\\-+]) ?(.+)$");
    private static final Pattern MD_CODE_PATTERN = Pattern.compile("(`([^`]+)`)");
    private static final Pattern MD_BOLD_PATTERN = Pattern.compile("(\\*+([^*]+)\\*+)");

    public Dashboard() {
        try {
            List<String> bootstrapIconsLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/bootstrap-icons.txt");
            this.addLicenseText("Bootstrap Icons", String.join((CharSequence)"\n", bootstrapIconsLicense), d -> true);
            List<String> chartJsLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/chart-js.txt");
            this.addLicenseText("ChartJs", String.join((CharSequence)"\n", chartJsLicense), d -> d.enableChartJs);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read license file.", e);
        }
    }

    public void setContentSheetEntryNames(String singular, String plural) {
        this.contentSheetEntryNames = new String[]{singular, plural};
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSheet(Sheet sheet) {
        List<Sheet> list = this.sheets;
        synchronized (list) {
            this.sheets.add(sheet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSheet(Sheet sheet) {
        List<Sheet> list = this.sheets;
        synchronized (list) {
            this.sheets.remove(sheet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sheet> getSheets() {
        List<Sheet> list = this.sheets;
        synchronized (list) {
            return this.sheets;
        }
    }

    public void addModal(Modal modal) {
        this.modals.add(modal);
    }

    public void removeModal(Modal modal) {
        this.modals.remove(modal);
    }

    public void addSidebarElement(SidebarElement sidebarElement) {
        this.sidebarElements.add(sidebarElement);
    }

    public void removeSidebarElement(SidebarElement sidebarElement) {
        this.sidebarElements.remove(sidebarElement);
    }

    public void addNavigationColumnHeader(String header, NavigationCellStyle style, NavigationColumnHeaderConfig.Alignment alignment) {
        this.addNavigationColumnHeader(header, style, alignment, false);
    }

    public void addNavigationColumnHeader(String header, NavigationCellStyle style, NavigationColumnHeaderConfig.Alignment alignment, boolean hideIfNoData) {
        this.navigationColumnHeaders.add(new NavigationColumnHeaderConfig(header, style, alignment, hideIfNoData));
    }

    public void setChartJsEnabled(boolean enabled) {
        this.enableChartJs = enabled;
    }

    public boolean isChartJsEnabled() {
        return this.enableChartJs;
    }

    public void addAdditionalContent(Tag<?> content) {
        this.additionalContent.with(content);
    }

    public SpanTag getEditableAdditionalContent() {
        return this.additionalContent;
    }

    public void addBottomLeftBadge(SpanTag badgeContent) {
        this.additionalBottomLeftBadges.add((DomContent)badgeContent.withClasses(new String[]{"badge", "badge-primary"}));
    }

    public void addBottomLeftBadge(SpanTag badgeContent, String style) {
        this.additionalBottomLeftBadges.add((DomContent)badgeContent.withClasses(new String[]{"badge", "badge-" + style}));
    }

    public void addBottomLeftBadge(String badgeContent) {
        this.additionalBottomLeftBadges.add((DomContent)TagCreator.span((String)badgeContent).withClasses(new String[]{"badge", "badge-primary"}));
    }

    public void addLicenseText(String identifier, String license, Function<Dashboard, Boolean> includeFunction) {
        this.dashboardLicenseNotices.add(0, new DashboardLicenseNotice(identifier, license, includeFunction));
    }

    public void addNavigationFilterTemplates(String text, NavigationFilter ... filter) {
        this.navigationFilterTemplates.computeIfAbsent(text, k -> new ArrayList()).addAll(Arrays.asList(filter));
    }

    public void addOnFilterApplied(String script) {
        this.onFilterApplied.append(TagCreator.rawHtml((String)script));
    }

    public void addOnThemeChange(String script) {
        this.onThemeChange.append(TagCreator.rawHtml((String)script));
    }

    public void addAdditionalInformationModalContent(DomContent ... content) {
        this.additionalInformationModalContent.addAll(Arrays.asList(content));
    }

    private void addLibraryFilesToHead(HeadTag dashboardHead) {
        dashboardHead.with((DomContent)TagCreator.style((String)ColorScheme.cssRoot()));
        try {
            List<String> dashboardCss;
            List<String> dashboardJS;
            if (this.enableChartJs) {
                log.info("ChartJs is enabled for dashboard, adding JS contents");
                List<String> chartJS = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/chart.js");
                if (!chartJS.isEmpty()) {
                    dashboardHead.with((DomContent)TagCreator.script((String)String.join((CharSequence)"\n", chartJS)));
                }
            }
            if (!(dashboardJS = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/dashboard.js")).isEmpty()) {
                dashboardHead.with((DomContent)TagCreator.script((String)String.join((CharSequence)"\n", dashboardJS)));
            }
            if (!(dashboardCss = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/dashboard.css")).isEmpty()) {
                dashboardHead.with((DomContent)TagCreator.style((String)dashboardCss.stream().map(String::trim).collect(Collectors.joining())));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read library files for dashboard generation [" + this.getTitle() + "]", e);
        }
    }

    private TrTag generateNavigationRow(Sheet sheet, List<NavigationColumnHeaderConfig> navigationColumnHeaders, Map<String, Integer> maxEntryLengths) {
        TrTag tr = (TrTag)((TrTag)((TrTag)TagCreator.tr().withClasses(new String[]{"slightBorder", "navigation-entry"})).attr("onclick", (Object)("showSheet('" + sheet.getId() + "')"))).withId("nav-row-" + sheet.getId());
        for (int i = 0; i < navigationColumnHeaders.size(); ++i) {
            NavigationColumnHeaderConfig navigationColumnHeader = navigationColumnHeaders.get(i);
            NavigationCellStyle navigationCellStyle = navigationColumnHeader.getStyler();
            Map<String, NavigationRow.Entry> entries = sheet.getNavigationRow().getEntries();
            TdTag td = TagCreator.td();
            if (i == 0) {
                td.attr("oncontextmenu", (Object)("toggleDataSheetBookmark('" + sheet.getId() + "');return false;"));
            }
            if (entries.containsKey(navigationColumnHeader.getName())) {
                String style;
                NavigationRow.Entry cellEntry = entries.get(navigationColumnHeader.getName());
                Object strCellValue = cellEntry.getContent().getClass() == Text.class && cellEntry.getContent().render().matches("-?\\d+.?(?:\\d+)?") ? TagCreator.text((String)this.fillStringFromLeft(cellEntry.getContent().render(), maxEntryLengths.getOrDefault(navigationColumnHeader.getName(), 0))) : cellEntry.getContent();
                ATag cellValueTag = (ATag)TagCreator.a((DomContent[])new DomContent[]{strCellValue}).withClasses(new String[]{"nav-link", "navigation-tile"});
                if (navigationCellStyle != null && (style = cellEntry.computeStyle(navigationCellStyle)) != null) {
                    cellValueTag.withStyle(style);
                }
                if (i == 0) {
                    cellValueTag.withId("navigation-tile-" + sheet.getId());
                }
                td.with((DomContent)cellValueTag);
            }
            tr.with((DomContent)td);
        }
        return tr;
    }

    public void sortSheets(Comparator<Sheet> comparator) {
        for (Sheet sheet : this.sheets) {
            if (sheet.getId() != null) continue;
            throw new IllegalStateException("Sheet has no ID, cannot sort sheets. This is most likely an issue in the dashboard implementation.");
        }
        this.sheets.sort(comparator);
    }

    private String fillStringFromLeft(String s, int totalLength) {
        if (s.length() >= totalLength) {
            return s;
        }
        StringBuilder sBuilder = new StringBuilder(s);
        while (sBuilder.length() < totalLength) {
            sBuilder.insert(0, " ");
        }
        return sBuilder.toString();
    }

    private boolean columnHasData(String columnName) {
        for (Sheet sheet : this.sheets) {
            String content;
            if (!sheet.getNavigationRow().getEntries().containsKey(columnName) || (content = sheet.getNavigationRow().getEntries().get(columnName).getContent().render()).contains("N/A")) continue;
            return true;
        }
        return false;
    }

    private List<NavigationColumnHeaderConfig> filterApplicableNavigationColumnHeaders() {
        return this.navigationColumnHeaders.stream().filter(navigationColumnHeader -> {
            if (navigationColumnHeader.isHideIfNoData()) {
                return this.columnHasData(navigationColumnHeader.getName());
            }
            return true;
        }).collect(Collectors.toList());
    }

    private TdTag buildNavigation() {
        TheadTag navigationTableHead = (TheadTag)TagCreator.thead().withStyle("position: sticky; top: -10px; background-color: var(--background-color); box-shadow: 0px -10px 0px 0px var(--background-color);");
        TrTag navigationTableHeaderElements = (TrTag)TagCreator.tr().attr("valign", (Object)"bottom");
        List<NavigationColumnHeaderConfig> filteredNavigationColumnHeader = this.filterApplicableNavigationColumnHeaders();
        for (int i = 0; i < filteredNavigationColumnHeader.size(); ++i) {
            NavigationColumnHeaderConfig headerItem = filteredNavigationColumnHeader.get(i);
            if (headerItem.isHideIfNoData() && !this.columnHasData(headerItem.getName())) continue;
            ThTag thElement = (ThTag)((ThTag)((ThTag)((ThTag)TagCreator.th((DomContent[])new DomContent[]{TagCreator.rawHtml((String)headerItem.getName())}).attr("onclick", (Object)"onColumnHeaderClicked(event.currentTarget);")).attr("oncontextmenu", (Object)"onColumnHeaderRightClicked(event.currentTarget);return false;")).withId("header-table-id-" + i)).withClasses(new String[]{"navigation-header-tile", "clickable", headerItem.getAlignment().cssClass()});
            navigationTableHeaderElements.with((DomContent)thElement);
        }
        navigationTableHead.with((DomContent)navigationTableHeaderElements);
        HashMap<String, Integer> maxEntryLengths = new HashMap<String, Integer>();
        for (Sheet sheet : this.sheets) {
            Map<String, NavigationRow.Entry> entries = sheet.getNavigationRow().getEntries();
            for (Map.Entry<String, NavigationRow.Entry> entry : entries.entrySet()) {
                int currentLength = entry.getValue().getContent().render().length();
                if (maxEntryLengths.containsKey(entry.getKey())) {
                    if (currentLength <= (Integer)maxEntryLengths.get(entry.getKey())) continue;
                    maxEntryLengths.put(entry.getKey(), currentLength);
                    continue;
                }
                maxEntryLengths.put(entry.getKey(), currentLength);
            }
        }
        TbodyTag navigationTableBody = TagCreator.tbody();
        for (Sheet sheet : this.sheets) {
            navigationTableBody.with((DomContent)this.generateNavigationRow(sheet, filteredNavigationColumnHeader, maxEntryLengths));
        }
        return (TdTag)((TdTag)((TdTag)TagCreator.td().withId("navigation-table")).withClasses(new String[]{"navigation-table-container", "hidden", "card-design", "scrollbox", "horizontal-resize"})).with((DomContent)((TableTag)((TableTag)TagCreator.table().withId("navigation-table-table")).withClass("navigation-table")).with(new DomContent[]{navigationTableHead, navigationTableBody}));
    }

    private SpanTag getTopRightSidebar() {
        DivTag alwaysVisible = (DivTag)((DivTag)TagCreator.div().withId("top-right-badges")).withClasses(new String[]{"top-right-badges", "card-design", "hidden"});
        DivTag overhang = (DivTag)((DivTag)TagCreator.div().withId("top-right-badges-overhang")).withClasses(new String[]{"card-design", "hidden"});
        DivTag itemStorage = (DivTag)((DivTag)TagCreator.div().withId("top-right-badges-storage")).withClass("hidden");
        SpanTag completeSidebar = TagCreator.span();
        completeSidebar.with(new DomContent[]{alwaysVisible, overhang, itemStorage});
        itemStorage.with((DomContent)((DivTag)((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"clickable", "unselectable", "hidden", "previous-sheet-arrow"})).attr("onclick", (Object)"historyBackwards();")).with((DomContent)SvgIcon.ARROW_LEFT_CIRCLE_FILL.getTag(22))).attr("tooltip", (Object)"Go back one sheet<br><code>Backspace</code>"));
        for (SidebarElement sidebarElement : this.sidebarElements) {
            if (sidebarElement.getIcon() == null) continue;
            itemStorage.with((DomContent)((DivTag)((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"clickable", "unselectable"})).attr("onclick", (Object)sidebarElement.getJs())).with((DomContent)sidebarElement.getIcon().getTag(22))).attr("tooltip", (Object)sidebarElement.getTitle()));
        }
        for (Modal modal : this.modals) {
            SidebarElement sidebarElement;
            if (!modal.isShowInSidebar() || (sidebarElement = modal.getSidebarElement()).getIcon() == null) continue;
            itemStorage.with((DomContent)((DivTag)((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"clickable", "unselectable"})).attr("onclick", (Object)sidebarElement.getJs())).with((DomContent)sidebarElement.getIcon().getTag(22))).attr("tooltip", (Object)(sidebarElement.getTitle() + (modal.getToggleKey() != null ? "<br><code>" + modal.getToggleKey().replace("Key", "") + "</code>" : ""))));
        }
        itemStorage.with(new DomContent[]{((DivTag)((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"clickable", "unselectable"})).attr("onclick", (Object)"previousDisplayMode(true);")).with((DomContent)SvgIcon.LAYOUT_TEXT_SIDEBAR.getTag(22))).attr("tooltip", (Object)"Toggle display mode<br><code>alt/opt + \u2192/\u2190</code>"), ((DivTag)((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"clickable", "unselectable"})).attr("onclick", (Object)"openModal('settingsModal');")).with((DomContent)SvgIcon.GEAR_FILL.getTag(22))).attr("tooltip", (Object)"Settings<br><code>s</code>"), (DomContent)TagCreator.iff((this.additionalInformationModalContent.size() > 0 ? 1 : 0) != 0, (Object)((DivTag)((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"clickable", "unselectable"})).attr("onclick", (Object)"openModal('dashboardAdditionalInfo');")).with((DomContent)SvgIcon.INFO_FILL.getTag(22))).attr("tooltip", (Object)"Additional Information<br><code>a</code>")), ((DivTag)((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"clickable", "unselectable"})).attr("onclick", (Object)"openModal('dashboardLicenses');")).with((DomContent)SvgIcon.FLAG_FILL.getTag(22))).attr("tooltip", (Object)"Dashboard Content and Code Licenses<br><code>l</code>"), ((DivTag)((DivTag)((DivTag)((DivTag)((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"clickable", "unselectable"})).withId("dark-mode-switch")).attr("onclick", (Object)"toggleManualDarkMode();")).attr("data-svg-light-mode", (Object)SvgIcon.SUN_FILL.getTag(22))).attr("data-svg-dark-mode", (Object)SvgIcon.MOON_FILL.getTag(20))).with((DomContent)SvgIcon.SUN_FILL.getTag(22))).attr("tooltip", (Object)"Switch theme"), ((DivTag)((DivTag)((DivTag)TagCreator.div().withId("top-right-items-show-more-storage")).withClasses(new String[]{"clickable", "unselectable"})).attr("onclick", (Object)"topRightBadgesOverhangToggle();")).with((DomContent)SvgIcon.THREE_DOTS_VERTICAL.getTag(22))});
        return completeSidebar;
    }

    private void addSidebarElementToTable(TableTag table, SidebarElement sidebarElement) {
        table.with((DomContent)((TrTag)((TrTag)TagCreator.tr().withClasses(new String[]{"unselectable", "clickable"})).attr("onclick", (Object)sidebarElement.getJs())).with((DomContent)TagCreator.td((DomContent[])new DomContent[]{(DomContent)TagCreator.iff((sidebarElement.getIcon() != null ? 1 : 0) != 0, (Object)sidebarElement.getIcon().getTag(22)), ((TdTag)TagCreator.td().withClass("fly-in-sidebar-text")).with((DomContent)TagCreator.b((String)sidebarElement.getTitle()))})));
    }

    private static ByteArrayOutputStream gzipCompress(String dataToBeEncoded) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gzipOutputStream.write(dataToBeEncoded.getBytes(StandardCharsets.UTF_8));
        }
        return byteArrayOutputStream;
    }

    private static String base64Encode(byte[] dataToBeEncoded) {
        return Base64.getEncoder().encodeToString(dataToBeEncoded);
    }

    private SpanTag buildSheetContents() {
        SpanTag dashboardSheetContent = TagCreator.span();
        if (!this.sheets.isEmpty()) {
            log.info("Building [{}] content sheets", (Object)this.sheets.size());
            ScriptTag sheetsScriptTag = TagCreator.script();
            for (Sheet sheet : this.sheets) {
                String key = sheet.getId().replace("\n", "LNBRK").replace("\r", "CARRET").replace("\\", "\\\\").replace("'", "\\'").replace("<", "OPENTAG").replace(">", "CLOSETAG");
                String value = sheet.getContent().render();
                try {
                    sheetsScriptTag.with((DomContent)TagCreator.rawHtml((String)("sheetsMap.set('" + key + "', '" + Dashboard.base64Encode(Dashboard.gzipCompress(value).toByteArray()) + "');")));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to compress and encode sheet content for sheet [" + sheet.getId() + "]", e);
                }
            }
            dashboardSheetContent.with(new DomContent[]{TagCreator.br(), TagCreator.br(), ((TableTag)TagCreator.table().withClass("selection-sheet-table")).with((DomContent)TagCreator.tr((DomContent[])new DomContent[]{this.buildNavigation(), ((TdTag)TagCreator.td((DomContent[])new DomContent[]{sheetsScriptTag}).withClass("right-sheet")).withId("sheet-container")})), TagCreator.br(), this.getTopRightSidebar()});
        } else {
            log.info("Dashboard has no data sheets");
            String noVulnerabilitiesBuilder = "<span style=\"position: absolute; left: calc(50% - " + this.emptyDashboardTextSize + "px); top: calc(50% - 150px); font-size: 20px; font-weight: 500;\">" + this.emptyDashboardText + "</span>" + this.emptyDashboardIcon;
            dashboardSheetContent.with((DomContent)TagCreator.rawHtml((String)noVulnerabilitiesBuilder));
        }
        return dashboardSheetContent;
    }

    public List<String> getSheetParagraphTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        for (Sheet sheet : this.sheets) {
            for (SheetParagraph paragraph : sheet.getParagraphs()) {
                if (paragraph.getIdentifier() == null || titles.contains(paragraph.getIdentifier())) continue;
                titles.add(paragraph.getIdentifier());
            }
        }
        return titles;
    }

    private List<String> getSecureSheetParagraphTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        for (Sheet sheet : this.sheets) {
            for (SheetParagraph paragraph : sheet.getParagraphs()) {
                if (paragraph.getSecureIdentifier() == null || titles.contains(paragraph.getSecureIdentifier())) continue;
                titles.add(paragraph.getSecureIdentifier());
            }
        }
        return titles;
    }

    private SpanTag buildModals() {
        Modal settingsModal = this.buildSettingsModal();
        Modal licenseModal = new Modal();
        licenseModal.setId("dashboardLicenses");
        licenseModal.setTitle("Dashboard Content and Code Licenses");
        licenseModal.setShowInSidebar(false);
        licenseModal.setToggleKey("KeyL");
        licenseModal.setToggleKeyActive(true);
        licenseModal.setSize(Modal.Size.LARGE);
        licenseModal.with(new DomContent[]{TagCreator.br()});
        for (Map.Entry<String, String> entry : this.getApplicableLicenseNotices().entrySet()) {
            licenseModal.with(new DomContent[]{TagCreator.h2((String)entry.getKey())}).with(new DomContent[]{TagCreator.rawHtml((String)String.valueOf(entry.getValue()).replace("\n", "<br>"))}).with(new DomContent[]{TagCreator.br(), TagCreator.br()});
        }
        Modal dashboardAdditionalInfoModal = new Modal();
        dashboardAdditionalInfoModal.setId("dashboardAdditionalInfo");
        dashboardAdditionalInfoModal.setTitle("Additional Information");
        dashboardAdditionalInfoModal.setShowInSidebar(false);
        dashboardAdditionalInfoModal.setToggleKey("KeyA");
        dashboardAdditionalInfoModal.setToggleKeyActive(true);
        dashboardAdditionalInfoModal.setSize(Modal.Size.LARGE);
        for (DomContent domContent : this.additionalInformationModalContent) {
            dashboardAdditionalInfoModal.with(domContent);
        }
        SpanTag spanTag = TagCreator.span();
        spanTag.with((DomContent)TagCreator.script((String)"const onOpenModalScripts={};"));
        spanTag.with((DomContent)settingsModal.generateContent());
        spanTag.with((DomContent)licenseModal.generateContent());
        spanTag.with((DomContent)dashboardAdditionalInfoModal.generateContent());
        ArrayList<DivTag> otherModalContents = new ArrayList<DivTag>();
        for (Modal modal : this.modals) {
            if (modal == null) continue;
            log.info("Adding custom modal [{}]", (Object)modal.getTitle());
            otherModalContents.add(modal.generateContent());
        }
        otherModalContents.forEach(arg_0 -> ((SpanTag)spanTag).with(arg_0));
        return spanTag;
    }

    private Modal buildSettingsModal() {
        DivTag displaySettingsSortingButtons = (DivTag)TagCreator.div().withStyle("display:inline;");
        displaySettingsSortingButtons.with(new DomContent[]{TagCreator.b((String)"Navigation sorting"), TagCreator.br()});
        List<NavigationColumnHeaderConfig> filteredNavigationColumnHeader = this.filterApplicableNavigationColumnHeaders();
        for (int i = 0; i < filteredNavigationColumnHeader.size(); ++i) {
            NavigationColumnHeaderConfig headerItem = filteredNavigationColumnHeader.get(i);
            if (headerItem.isHideIfNoData() && !this.columnHasData(headerItem.getName())) continue;
            String actualItemWithoutBr = headerItem.getName().replaceAll("-?<br>", "");
            displaySettingsSortingButtons.with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button((String)actualItemWithoutBr).withId("header-table-sort-" + i)).withClasses(new String[]{"btn", "btn-secondary", "btn-sm", "header-table-sort"})).attr("onclick", (Object)("onColumnHeaderClicked(document.getElementById('header-table-id-" + i + "'))")));
        }
        List<String> visibilityToggleDataLabels = this.getSheetParagraphTitles();
        List<String> visibilityToggleDataIdentifiers = this.getSecureSheetParagraphTitles();
        DivTag displaySettingsContentToggles = (DivTag)TagCreator.div().withStyle("display:inline;");
        displaySettingsContentToggles.with((DomContent)TagCreator.b((String)"Data-Sheet content visibility"));
        ScriptTag dataVisibilityToggleIdentifiers = (ScriptTag)TagCreator.script().with((DomContent)TagCreator.rawHtml((String)"const visibilityToggleDataIdentifiers = [];"));
        for (int i = 0; i < visibilityToggleDataIdentifiers.size(); ++i) {
            String dataToggleIdentifier = "data-sheet-content-toggle-" + visibilityToggleDataIdentifiers.get(i);
            dataVisibilityToggleIdentifiers.with((DomContent)TagCreator.rawHtml((String)("visibilityToggleDataIdentifiers.push('" + dataToggleIdentifier + "');")));
            displaySettingsContentToggles.with((DomContent)((DivTag)TagCreator.div().withClass("form-check form-switch")).with(new DomContent[]{((InputTag)((InputTag)((InputTag)((InputTag)TagCreator.input().withClass("form-check-input")).withType("checkbox")).withId(dataToggleIdentifier)).attr("onclick", (Object)("toggleDataSheetContentVisibility('" + visibilityToggleDataIdentifiers.get(i) + "', true);"))).attr("checked"), ((LabelTag)TagCreator.label((String)visibilityToggleDataLabels.get(i)).withClass("form-check-label")).attr("for", (Object)dataToggleIdentifier)}));
        }
        SpanTag displaySettingsFiltersList = (SpanTag)TagCreator.span().with(new DomContent[]{TagCreator.b((String)"Navigation Filters"), TagCreator.br(), ((SpanTag)((SpanTag)TagCreator.span((String)"+").withClasses(new String[]{"badge", "badge-primary", "clickable"})).withStyle("margin-bottom:5px")).attr("onclick", (Object)"addFilter('','','')"), (DomContent)TagCreator.iff((!this.navigationFilterTemplates.isEmpty() ? 1 : 0) != 0, (Object)TagCreator.join((Object[])new Object[]{TagCreator.each(this.navigationFilterTemplates, e -> (SpanTag)((SpanTag)TagCreator.span((String)("+ " + (String)e.getKey())).withClasses(new String[]{"badge", "badge-secondary", "clickable"})).attr("onclick", (Object)("createFilterFromGETValue('" + ((List)e.getValue()).stream().map(NavigationFilter::toString).collect(Collectors.joining(",")) + "');")))})), ((SpanTag)((SpanTag)((SpanTag)TagCreator.span((String)"Clear All").withId("display-filter-clear-filters")).withClasses(new String[]{"badge", "badge-danger", "clickable", "hidden"})).withStyle("margin-bottom:5px")).attr("onclick", (Object)"clearAllFilters();"), TagCreator.br(), ((DivTag)TagCreator.div().withId("display-filter-listing")).withClasses(new String[]{"card", "card-margin", "card-noflex", "hidden"}), TagCreator.br(), TagCreator.script((String)("const FILTER_OPERATIONS = [\"" + String.join((CharSequence)"\", \"", FILTER_OPERATIONS) + "\"];"))});
        SpanTag copyAllSheetNamesToClipboard = (SpanTag)TagCreator.span().with(new DomContent[]{TagCreator.b((String)"Copy content"), TagCreator.br(), ((SpanTag)TagCreator.span((String)("Copy shown " + this.contentSheetEntryNames[1])).withClasses(new String[]{"badge", "badge-primary", "clickable"})).attr("onclick", (Object)("copyContentSheetNames();this.innerHTML='Copied!';setTimeout(() => { this.innerHTML='Copy shown " + this.contentSheetEntryNames[1] + "'; }, 1400);"))});
        SpanTag displaySettingsHints = (SpanTag)TagCreator.span().with(new DomContent[]{TagCreator.b((String)"Notes"), TagCreator.br(), TagCreator.i((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{"Press ", TagCreator.code((String)"esc"), " to close any modal.", TagCreator.br(), "Use ", TagCreator.code((String)"alt"), "/", TagCreator.code((String)"opt"), " + ", TagCreator.code((String)"\u2191"), "/", TagCreator.code((String)"\u2193"), " to navigate through the data sheets.", TagCreator.br(), "Use ", TagCreator.code((String)"alt"), "/", TagCreator.code((String)"opt"), " + ", TagCreator.code((String)"\u2192"), "/", TagCreator.code((String)"\u2190"), " to switch between display modes (content sheets/navigation).", TagCreator.br(), "Use ", TagCreator.code((String)"alt"), "/", TagCreator.code((String)"opt"), " + ", TagCreator.code((String)"s"), " to create a new sheet content search filter.", TagCreator.br(), "Hold the ", TagCreator.code((String)"alt"), " key to keep a tooltip static when moving the cursor.", TagCreator.br(), "Right-click the data sheet ID in the navigation to bookmark the data sheet.", TagCreator.br(), "The current display settings will be restored on reloading the page.", TagCreator.br(), "The navigation table headers can be left-clicked to sort the navigation.", TagCreator.br(), "The navigation table headers can be right-clicked to create new filters."})})});
        Modal settingsModal = new Modal();
        settingsModal.setId("settingsModal");
        settingsModal.setTitle("Display Settings");
        settingsModal.setToggleKey("KeyS");
        settingsModal.setToggleKeyActive(false);
        settingsModal.setSvgIcon(SvgIcon.GEAR_FILL);
        settingsModal.with(new DomContent[]{dataVisibilityToggleIdentifiers, displaySettingsSortingButtons, TagCreator.br(), TagCreator.br(), displaySettingsFiltersList, displaySettingsContentToggles, TagCreator.br(), copyAllSheetNamesToClipboard, TagCreator.br(), TagCreator.br(), displaySettingsHints});
        return settingsModal;
    }

    private Map<String, String> getApplicableLicenseNotices() {
        return this.dashboardLicenseNotices.stream().filter(e -> e.applies(this)).collect(Collectors.toMap(DashboardLicenseNotice::getTitle, DashboardLicenseNotice::getContent, (u, v) -> u + " - duplicate", LinkedHashMap::new));
    }

    private void addLicensesToScriptTag(ScriptTag scriptTag) {
        Map<String, String> licenses = this.getApplicableLicenseNotices();
        scriptTag.with((DomContent)TagCreator.rawHtml((String)("let licenseMap = \n/*START-LICENSE-MAP*/\n" + new JSONObject(licenses) + "\n/*END-LICENSE-MAP*/\n;")));
        log.info("License texts added: {}", licenses.keySet());
    }

    public void generateIntoFile(File outputFile) throws IOException {
        if (!outputFile.getParentFile().exists()) {
            outputFile.mkdirs();
        }
        FileAppendable writer = new FileAppendable(outputFile, StandardCharsets.UTF_8, true);
        writer.append("<!DOCTYPE html>");
        HtmlTag generated = this.generate();
        log.info("Writing generated dashboard to {}", (Object)outputFile.getAbsolutePath());
        generated.renderModel((Appendable)writer, null);
        writer.append("\n");
        writer.flush();
        writer.close();
        log.info("Done generating dashboard with size [{} MB]", (Object)this.getStringMBSize(outputFile.length()));
    }

    public HtmlTag generate() throws IOException {
        log.info("Generating dashboard [{}] version [{}]", (Object)this.getTitle(), (Object)this.getVersion());
        HeadTag dashboardHead = TagCreator.head();
        dashboardHead.with(new DomContent[]{TagCreator.meta().withCharset("utf-8"), (DomContent)TagCreator.iff((this.title != null ? 1 : 0) != 0, (Object)TagCreator.title().with((DomContent)TagCreator.text((String)this.title))), (DomContent)TagCreator.iff((this.description != null ? 1 : 0) != 0, (Object)((MetaTag)TagCreator.meta().withName("description")).withContent(this.description)), (DomContent)TagCreator.iff((!this.keywords.isEmpty() ? 1 : 0) != 0, (Object)((MetaTag)TagCreator.meta().withName("keywords")).withContent(String.join((CharSequence)", ", this.keywords))), (DomContent)TagCreator.iff((this.author != null ? 1 : 0) != 0, (Object)((MetaTag)TagCreator.meta().withName("author")).withContent(this.author)), ((MetaTag)TagCreator.meta().withName("viewport")).withContent("width=device-width, initial-scale=1.0"), (DomContent)TagCreator.iff((this.favicon != null ? 1 : 0) != 0, (Object)this.favicon)});
        this.addLibraryFilesToHead(dashboardHead);
        SpanTag dashboardSheetContent = this.buildSheetContents();
        ScriptTag finalScripts = (ScriptTag)TagCreator.script().with(new DomContent[]{TagCreator.rawHtml((String)"\nhideRequiredSheetParagraphs(true);\ncheckForTableRowsSortedInit();\nvar viewedSheet = findGetParameter('sheet');\nisFirstSheet = true;\n"), TagCreator.rawHtml((String)(!this.sheets.isEmpty() ? "let defaultSheet = '" + this.sheets.get(0).getId() + "';\n" : "let defaultSheet = '';\n")), TagCreator.rawHtml((String)"async function showFirstSheet() {\n    if (viewedSheet != null && viewedSheet.length > 0) {\n        showSheet(viewedSheet.replaceAll('_', '-'));\n    }"), TagCreator.rawHtml((String)(!this.sheets.isEmpty() ? "    else {        setDisplayMode(0);\n    }\n" : "\n")), TagCreator.rawHtml((String)("}\nsetTimeout(function() { showFirstSheet(); }, 100);\nisFirstSheet = false;\nupdateUrl = true;\nlet modalsToClose = document.getElementsByClassName('modal');\nwindow.onclick = function(event) {\n    if (modalsToClose == null) return;\n    for (let i = 0; i < modalsToClose.length; i++) {\n        if (event.target == modalsToClose[i]) {\n            closeAllModals();\n        }\n    }\n}\nconst removeChartJsDisplayBlock = document.getElementsByClassName('chart-js-remove-display-block');\nfor (var index = 0; index < removeChartJsDisplayBlock.length; index++) {\n    removeChartJsDisplayBlock[index].style.removeProperty('display');\n    removeChartJsDisplayBlock[index].style.removeProperty('box-sizing');\n}\nfunction removeOnLoadFunction() {\n    var removeOnLoad = document.getElementsByClassName('remove-on-load');\n    for (var index = 0; index < removeOnLoad.length; index++) {\n        removeOnLoad[index].parentNode.removeChild(removeOnLoad[index]);\n    }\n}\nsetTimeout(function() { removeOnLoadFunction(); }, 100);\nfunction onFilterApplied() {" + this.onFilterApplied + "}\nfunction onThemeChanged(darkMode) {" + this.onThemeChange + "}"))});
        this.addLicensesToScriptTag(finalScripts);
        ScriptTag onInitScripts = TagCreator.script((String)"document.getElementById('loading-animation').style.display='block';\ndocument.getElementById('js-is-disabled').style.display='none';\n");
        BodyTag dashboardBody = TagCreator.body();
        dashboardBody.with(new DomContent[]{((DivTag)((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"spinner-grow", "text-primary", "remove-on-load"})).withId("loading-animation")).attr("role", (Object)"status")).withStyle("display:none;position:absolute;top:49vh;left:49vw;width:50px;height:50px;color:var(--strong-blue);"), ((SpanTag)TagCreator.span((String)"Please enable JS to use this document").withId("js-is-disabled")).withStyle("display:block;position:absolute;top:40vh;left:40vw;font-size:20px;color:var(--strong-red);border: 2px solid var(--strong-red);border-radius:5px;padding:8px;"), onInitScripts, ((DivTag)((DivTag)TagCreator.div().withClass("main-container")).withStyle("margin-top: 20px; margin-left: 30px")).with(new DomContent[]{TagCreator.span((DomContent[])new DomContent[]{((SpanTag)TagCreator.span((String)(this.title != null ? this.title : "Dashboard")).withId("dashboard-title")).withClass("primary-header"), TagCreator.span((DomContent[])new DomContent[]{TagCreator.br()}).withClass("hidden-on-desktop"), ((SpanTag)TagCreator.span().withClass("hidden-on-mobile")).withStyle("margin-left: 5px;"), (DomContent)TagCreator.iffElse((this.subtitle != null ? 1 : 0) != 0, (Object)((SpanTag)TagCreator.span((String)this.subtitle).withId("dashboard-subtitle")).withStyle("margin-left:6px;"), (Object)TagCreator.span().withId("dashboard-subtitle"))}).withId("dashboard-full-title"), dashboardSheetContent, ((DivTag)TagCreator.div().withClass("bottom-left-badges")).with(new DomContent[]{((ATag)((ATag)((ATag)((ATag)TagCreator.a().withClasses(new String[]{"badge", "badge-primary"})).withStyle("color:var(--text-color-white);")).withHref("http://www.metaeffekt.com/")).withTarget("metaeffekt")).with((DomContent)TagCreator.span((String)"Powered by {met\u00e6ffekt}")), (DomContent)TagCreator.iff((this.version != null ? 1 : 0) != 0, (Object)TagCreator.div((String)this.version).withClasses(new String[]{"badge", "badge-secondary"})), ((DivTag)TagCreator.div().withClasses(new String[]{"badge", "badge-secondary"})).withText("Generated " + new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date())), TagCreator.each(this.additionalBottomLeftBadges, badge -> badge)})}), this.buildModals(), finalScripts, (DomContent)TagCreator.iff((this.additionalContent.getNumChildren() > 0 ? 1 : 0) != 0, (Object)this.additionalContent)});
        return (HtmlTag)((HtmlTag)TagCreator.html().withLang("en-US")).with(new DomContent[]{dashboardHead, dashboardBody});
    }

    private String getStringMBSize(String s) {
        return String.valueOf((double)Math.round((double)s.getBytes(StandardCharsets.UTF_8).length / 1000000.0 * 100.0) / 100.0);
    }

    private String getStringMBSize(long s) {
        return String.valueOf((double)Math.round((double)s / 1000000.0 * 100.0) / 100.0);
    }

    private static InputStream getFileFromResourceAsStream(Class<?> loadingClass, String filename) {
        return loadingClass.getClassLoader().getResourceAsStream(filename);
    }

    public static List<String> readResourceAsStringList(Class<?> loadingClass, String filename) throws IOException {
        InputStream inputStream = Dashboard.getFileFromResourceAsStream(loadingClass, filename);
        if (inputStream == null) {
            throw new FileNotFoundException("File not found: " + filename);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> lines = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        return lines;
    }

    public static String attemptEscapeScripts(String rawHtml) {
        return rawHtml.replace("onload", "_onload").replace("onerror", "_onerror").replace("<input", "&lt;input").replace("</input", "&lt;/input").replace("<img", "&lt;img").replace("</img", "&lt;/img").replace("<iframe", "&lt;iframe").replace("</iframe", "&lt;/iframe").replace("<script", "&lt;script").replace("</script", "&lt;/script");
    }

    public static SpanTag markdownToHtml(String markdown, String linkTarget) {
        if (markdown == null) {
            return TagCreator.span();
        }
        SpanTag markdownContent = TagCreator.span();
        try {
            String[] lines = markdown.replaceAll(" {2}\n", "\n\n").split("(\n|\\\\n)(\r|\\\\r)?");
            UlTag currentUlList = null;
            boolean lastLineWasHeader = false;
            boolean lastLineWasEmpty = false;
            for (int i = 0; i < lines.length; ++i) {
                Matcher headerMatcher;
                lines[i] = lines[i].replace("\\\"", "\"");
                if ((lines[i].isEmpty() || lines[i].matches(" +")) && currentUlList == null && i + 1 < lines.length && !lastLineWasHeader) {
                    markdownContent.with((DomContent)TagCreator.br());
                    lastLineWasEmpty = true;
                    continue;
                }
                if (i + 1 < lines.length) {
                    markdownContent.with((DomContent)TagCreator.text((String)" "));
                }
                if ((headerMatcher = MD_HEADER_PATTERN.matcher(lines[i])).matches()) {
                    if (lastLineWasEmpty) {
                        markdownContent.with((DomContent)TagCreator.br());
                    }
                    int headerSize = headerMatcher.group(1).length();
                    String headerText = headerMatcher.group(2);
                    if (headerSize == 1) {
                        markdownContent.with((DomContent)TagCreator.h2((String)headerText));
                    } else if (headerSize == 2) {
                        markdownContent.with((DomContent)TagCreator.h3((String)headerText));
                    } else if (headerSize == 3) {
                        markdownContent.with((DomContent)TagCreator.h4((String)headerText));
                    } else if (headerSize == 4) {
                        markdownContent.with((DomContent)TagCreator.h5((String)headerText));
                    }
                    lastLineWasHeader = true;
                    continue;
                }
                SpanTag appendTo = markdownContent;
                Matcher ulMatcher = MD_UL_PATTERN.matcher(lines[i]);
                boolean ulMatches = ulMatcher.matches();
                if (!ulMatches && currentUlList != null) {
                    appendTo.with(currentUlList);
                    currentUlList = null;
                } else if (ulMatches) {
                    lines[i] = ulMatcher.group(1);
                    if (currentUlList == null) {
                        currentUlList = TagCreator.ul();
                    }
                    appendTo = currentUlList;
                }
                Matcher linkMatcher = MD_LINK_PATTERN.matcher(lines[i]);
                HashMap<String, Object> links = new HashMap<String, Object>();
                while (linkMatcher.find()) {
                    String entireMatch = linkMatcher.group(1);
                    String linkText = linkMatcher.group(2);
                    String linkHref = linkMatcher.group(3);
                    ATag aTag = (ATag)TagCreator.a((String)linkText).withHref(linkHref);
                    if (linkTarget != null) {
                        aTag.withTarget(linkTarget);
                    }
                    links.put(entireMatch, aTag);
                }
                Matcher codeMatcher = MD_CODE_PATTERN.matcher(lines[i]);
                HashMap<String, Object> code = new HashMap<String, Object>();
                while (codeMatcher.find()) {
                    String entireMatch = codeMatcher.group(1);
                    String codeText = codeMatcher.group(2);
                    code.put(entireMatch, TagCreator.code((String)codeText));
                }
                Matcher boldMatcher = MD_BOLD_PATTERN.matcher(lines[i]);
                HashMap<String, Object> bold = new HashMap<String, Object>();
                while (boldMatcher.find()) {
                    String entireMatch = boldMatcher.group(1);
                    String boldText = boldMatcher.group(2);
                    bold.put(entireMatch, TagCreator.b((String)boldText));
                }
                char[] chars = lines[i].toCharArray();
                SpanTag currentLineTag = TagCreator.span();
                String checkBuffer = "";
                int codeTickCount = 0;
                boolean isInsideBold = false;
                for (int j = 0; j < chars.length; ++j) {
                    if (chars[j] == '`') {
                        ++codeTickCount;
                    }
                    if (!links.isEmpty() && chars[j] == '[') {
                        currentLineTag.with((DomContent)TagCreator.rawHtml((String)checkBuffer));
                        checkBuffer = "";
                    } else if (!code.isEmpty() && codeTickCount % 2 == 1 && chars[j] == '`') {
                        currentLineTag.with((DomContent)TagCreator.rawHtml((String)checkBuffer));
                        checkBuffer = "";
                    } else if (chars[j] == '*' && chars.length > j + 1 && chars[j + 1] != '*' && !isInsideBold) {
                        isInsideBold = true;
                        currentLineTag.with((DomContent)TagCreator.rawHtml((String)checkBuffer.replaceAll("\\*$", "")));
                        checkBuffer = "*";
                    } else if (chars[j] == '*' && chars.length > j + 1 && chars[j + 1] != '*' && isInsideBold) {
                        isInsideBold = false;
                    }
                    checkBuffer = checkBuffer + chars[j];
                    if (links.containsKey(checkBuffer)) {
                        currentLineTag.with((DomContent)links.getOrDefault(checkBuffer, TagCreator.a((String)checkBuffer).withStyle("color:red;")));
                        checkBuffer = "";
                    }
                    if (code.containsKey(checkBuffer)) {
                        currentLineTag.with((DomContent)code.getOrDefault(checkBuffer, TagCreator.code((String)checkBuffer).withStyle("color:red;")));
                        checkBuffer = "";
                    }
                    if (!bold.containsKey(checkBuffer)) continue;
                    currentLineTag.with((DomContent)bold.getOrDefault(checkBuffer, TagCreator.b((String)checkBuffer).withStyle("color:red;")));
                    checkBuffer = "";
                }
                if (!checkBuffer.isEmpty()) {
                    currentLineTag.with((DomContent)TagCreator.rawHtml((String)checkBuffer));
                }
                if (currentLineTag.getNumChildren() > 0) {
                    if (appendTo instanceof SpanTag) {
                        appendTo.with((DomContent)currentLineTag);
                    } else {
                        appendTo.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{currentLineTag}));
                    }
                }
                lastLineWasHeader = false;
                lastLineWasEmpty = false;
            }
            if (currentUlList != null && currentUlList.getNumChildren() > 0) {
                markdownContent.with(currentUlList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return markdownContent;
    }

    public static NavigationFilterBuilder navigationFilterBuilder() {
        return new NavigationFilterBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getAuthorUrl() {
        return this.authorUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public String[] getContentSheetEntryNames() {
        return this.contentSheetEntryNames;
    }

    public LinkTag getFavicon() {
        return this.favicon;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public List<Modal> getModals() {
        return this.modals;
    }

    public List<SidebarElement> getSidebarElements() {
        return this.sidebarElements;
    }

    public List<NavigationColumnHeaderConfig> getNavigationColumnHeaders() {
        return this.navigationColumnHeaders;
    }

    public SpanTag getAdditionalContent() {
        return this.additionalContent;
    }

    public List<DomContent> getAdditionalBottomLeftBadges() {
        return this.additionalBottomLeftBadges;
    }

    public List<DomContent> getAdditionalInformationModalContent() {
        return this.additionalInformationModalContent;
    }

    public boolean isEnableChartJs() {
        return this.enableChartJs;
    }

    public List<DashboardLicenseNotice> getDashboardLicenseNotices() {
        return this.dashboardLicenseNotices;
    }

    public int getTopRightIconSize() {
        return this.topRightIconSize;
    }

    public Map<String, List<NavigationFilter>> getNavigationFilterTemplates() {
        return this.navigationFilterTemplates;
    }

    public StringBuilder getOnFilterApplied() {
        return this.onFilterApplied;
    }

    public StringBuilder getOnThemeChange() {
        return this.onThemeChange;
    }

    public String getEmptyDashboardText() {
        return this.emptyDashboardText;
    }

    public int getEmptyDashboardTextSize() {
        return this.emptyDashboardTextSize;
    }

    public String getEmptyDashboardIcon() {
        return this.emptyDashboardIcon;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setAuthorUrl(String authorUrl) {
        this.authorUrl = authorUrl;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setContentSheetEntryNames(String[] contentSheetEntryNames) {
        this.contentSheetEntryNames = contentSheetEntryNames;
    }

    public void setFavicon(LinkTag favicon) {
        this.favicon = favicon;
    }

    public void setEnableChartJs(boolean enableChartJs) {
        this.enableChartJs = enableChartJs;
    }

    public void setEmptyDashboardText(String emptyDashboardText) {
        this.emptyDashboardText = emptyDashboardText;
    }

    public void setEmptyDashboardTextSize(int emptyDashboardTextSize) {
        this.emptyDashboardTextSize = emptyDashboardTextSize;
    }

    public void setEmptyDashboardIcon(String emptyDashboardIcon) {
        this.emptyDashboardIcon = emptyDashboardIcon;
    }

    private static class DashboardLicenseNotice {
        private final String title;
        private final String content;
        private final Function<Dashboard, Boolean> includeCondition;

        private DashboardLicenseNotice(String title, String content, Function<Dashboard, Boolean> includeCondition) {
            this.title = title;
            this.content = content;
            this.includeCondition = includeCondition;
        }

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }

        public Function<Dashboard, Boolean> getIncludeCondition() {
            return this.includeCondition;
        }

        public boolean applies(Dashboard dashboard) {
            return this.includeCondition.apply(dashboard);
        }
    }

    public static enum FilterOperation {
        CONTAINS("contains"),
        NOT_CONTAINS("not contains"),
        EQUALS("equal"),
        NOT_EQUALS("not equal"),
        LARGER("larger"),
        SMALLER("smaller"),
        LARGER_EQUALS("larger/equal"),
        SMALLER_EQUALS("smaller/equal");

        public final String name;

        private FilterOperation(String name) {
            this.name = name;
        }
    }

    public static class NavigationFilterBuilder {
        private final NavigationFilter filter = new NavigationFilter();

        private NavigationFilterBuilder() {
        }

        public NavigationFilterBuilder column(String column) {
            this.filter.column = column;
            return this;
        }

        public NavigationFilterBuilder operation(FilterOperation operation) {
            this.filter.operation = operation;
            return this;
        }

        public NavigationFilterBuilder value(Object value) {
            this.filter.value = value.toString();
            return this;
        }

        public NavigationFilter build() {
            return this.filter;
        }
    }

    public static class NavigationFilter {
        private String column;
        private FilterOperation operation;
        private String value;

        private NavigationFilter() {
        }

        public String toString() {
            return this.column + ";" + this.operation.name + ";" + this.value;
        }
    }
}

