/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.dashboard;

import com.metaeffekt.artifact.analysis.dashboard.SidebarElement;
import com.metaeffekt.artifact.analysis.dashboard.SvgIcon;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.SpanTag;

public class Modal {
    private String id;
    private String title;
    private String toggleKey;
    private boolean showInSidebar = true;
    private boolean toggleKeyActive = true;
    private Size size = Size.NORMAL;
    private final SpanTag content = TagCreator.span();
    private final StringBuilder onOpenScript = new StringBuilder();
    private final SidebarElement sidebarElement = new SidebarElement();

    public Modal setId(String id) {
        this.id = id;
        this.sidebarElement.setJs("openModal('" + id + "');");
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Modal setTitle(String title) {
        this.title = title;
        this.sidebarElement.setTitle(title);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Modal setToggleKey(String toggleKey) {
        this.toggleKey = toggleKey;
        return this;
    }

    public String getToggleKey() {
        return this.toggleKey;
    }

    public Modal setShowInSidebar(boolean showInSidebar) {
        this.showInSidebar = showInSidebar;
        return this;
    }

    public boolean isShowInSidebar() {
        return this.showInSidebar;
    }

    public Modal setToggleKeyActive(boolean toggleKeyActive) {
        this.toggleKeyActive = toggleKeyActive;
        return this;
    }

    public boolean isToggleKeyActive() {
        return this.toggleKeyActive;
    }

    public Modal setSize(Size size) {
        this.size = size;
        return this;
    }

    public Size getSize() {
        return this.size;
    }

    public Modal setSvgIcon(SvgIcon svgIcon) {
        this.sidebarElement.setIcon(svgIcon);
        return this;
    }

    public SidebarElement getSidebarElement() {
        return this.sidebarElement;
    }

    public Modal with(DomContent ... tag) {
        for (DomContent addTag : tag) {
            this.content.with(addTag);
        }
        return this;
    }

    public Modal with(String content) {
        this.content.with((DomContent)TagCreator.text((String)content));
        return this;
    }

    public Modal withOnOpenScript(String script) {
        this.onOpenScript.append(script);
        return this;
    }

    public SpanTag getEditableContent() {
        return this.content;
    }

    public DivTag generateContent() {
        String toggleKey = this.toggleKey == null ? "" : this.toggleKey;
        return (DivTag)((DivTag)((DivTag)TagCreator.div().withId(this.id)).withClass("modal")).with(new DomContent[]{((DivTag)TagCreator.div().withClasses(new String[]{"modal-content", "modal-content-" + this.size.name().toLowerCase()})).with((DomContent)TagCreator.join((Object[])new Object[]{TagCreator.span((DomContent[])new DomContent[]{((SpanTag)TagCreator.span((DomContent[])new DomContent[]{TagCreator.rawHtml((String)"&times;")}).attr("onclick", (Object)("closeModal('" + this.id + "');"))).withClasses(new String[]{"modal-close", "unselectable"}), TagCreator.h2((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{this.title, TagCreator.iff((toggleKey.length() != 0 ? 1 : 0) != 0, (Object)TagCreator.code((String)(" toggle key: " + toggleKey.replace("Key", ""))).withStyle("font-size: 14px;"))})}), TagCreator.span().withStyle("height:10px; visibility:hidden;")}), this.content})), TagCreator.script((String)("onOpenModalScripts['" + this.id + "'] = () => {" + this.onOpenScript + "};")), (DomContent)TagCreator.iff((!toggleKey.isEmpty() && this.toggleKeyActive ? 1 : 0) != 0, (Object)TagCreator.script((String)("document.addEventListener('keyup', (e) => {    if (doesUserNotSelectInputElement()) {        if (e.code === '" + toggleKey + "' && !e.ctrlKey && !e.metaKey) {            if (!isModalVisible('" + this.id + "')) { openModal('" + this.id + "');}            else { closeModal('" + this.id + "'); }        }    }});")))});
    }

    public static String makeValidJsVarName(String name) {
        return name.replaceAll("[^a-zA-Z0-9]", "_");
    }

    public static enum Size {
        NORMAL,
        LARGE,
        ADJUST;

    }
}

