/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.dashboard.elements;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H5Tag;
import j2html.tags.specialized.SpanTag;

public class ContentCard {
    private final DivTag content = (DivTag)new DivTag().withStyle("padding:0px;padding-left:6px;margin:0px;");
    private final H5Tag title = (H5Tag)new H5Tag().withStyle("margin-bottom:2px");
    private ContentCardType color;
    private int characterCollapseThreshold = Integer.MAX_VALUE;

    public ContentCard() {
        this.withType(ContentCardType.DEFAULT);
    }

    public ContentCard(ContentCardType type) {
        this.withType(type);
    }

    public ContentCard withCharacterCollapseThreshold(int characterCollapseThreshold) {
        this.characterCollapseThreshold = characterCollapseThreshold;
        return this;
    }

    public ContentCard withType(ContentCardType type) {
        this.color = type == null || type == ContentCardType.DEFAULT ? ContentCardType.GRAY : type;
        return this;
    }

    public ContentCard with(String ... content) {
        for (String s : content) {
            this.content.with((DomContent)TagCreator.text((String)s));
        }
        return this;
    }

    public ContentCard with(DomContent ... content) {
        this.content.with(content);
        return this;
    }

    public ContentCard withText(String ... content) {
        for (String s : content) {
            if (StringUtils.isEmpty(s)) continue;
            if (!s.contains("<p>")) {
                this.content.with((DomContent)TagCreator.p((String)s));
                continue;
            }
            this.content.with((DomContent)TagCreator.rawHtml((String)s));
        }
        return this;
    }

    public ContentCard withTitle(String title) {
        this.title.with((DomContent)TagCreator.text((String)title));
        return this;
    }

    public DivTag generate() {
        DivTag generated = (DivTag)TagCreator.div().withClasses(new String[]{"data-sheet-content-card", this.color.name().toLowerCase().replace("_", "-")});
        if (this.title.getNumChildren() > 0) {
            generated.with((DomContent)this.title);
        }
        if (this.content.getNumChildren() > 0) {
            if (this.htmlTextContentLength(this.content.render()) > this.characterCollapseThreshold) {
                generated.withStyle("overflow: hidden; max-height: 180px; position: relative;");
                generated.with((DomContent)this.content);
                generated.with((DomContent)((SpanTag)((SpanTag)TagCreator.span((String)"Show more").withClasses(new String[]{"badge", "badge-primary"})).withStyle("position: absolute; bottom: 8px; left: 14px; cursor: pointer;")).attr("onclick", (Object)"this.parentElement.style.maxHeight = 'none'; this.style.display = 'none';"));
            } else {
                generated.with((DomContent)this.content);
            }
        }
        return generated;
    }

    public void generate(ContainerTag<?> append) {
        append.with((DomContent)this.generate());
    }

    private int htmlTextContentLength(String html) {
        return html.replaceAll("<[^>]*>", "").length();
    }

    public int getNumChildren() {
        return this.content.getNumChildren();
    }

    public static enum ContentCardType {
        DEFAULT,
        LIGHT_GRAY,
        PASTEL_BLUE,
        GRAY,
        GREEN,
        RED;

    }
}

