/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.diffmerge;

import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusReviewedEntry;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryMerger {
    private static final Logger log = LoggerFactory.getLogger(InventoryMerger.class);
    private static final String[] AFFECTED_VULNERABILITY_STATUS_ORDER_DESCENDING = new String[]{"applicable", "in review", "insignificant"};
    private static final Set<String> NOT_AFFECTED_VULNERABILITY_STATUS = Arrays.stream(new String[]{"void", "not applicable"}).collect(Collectors.toSet());
    private final Inventory outputInventory;
    private final Map<Inventory, String> referenceInventories = new LinkedHashMap<Inventory, String>();
    private final CentralSecurityPolicyConfiguration securityPolicy;

    public InventoryMerger(CentralSecurityPolicyConfiguration securityPolicy) {
        this(new Inventory(), securityPolicy);
    }

    public InventoryMerger(Inventory outputInventory, CentralSecurityPolicyConfiguration securityPolicy) {
        this.outputInventory = outputInventory;
        this.securityPolicy = securityPolicy;
    }

    public InventoryMerger(File file, CentralSecurityPolicyConfiguration securityPolicy) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Inventory file must not be null");
        }
        this.outputInventory = !file.exists() ? new Inventory() : new InventoryReader().readInventory(file);
        this.securityPolicy = securityPolicy;
    }

    public void addReferenceInventory(Inventory inventory, String context) {
        this.referenceInventories.put(inventory, context);
    }

    public void addReferenceInventory(File file) throws IOException {
        Inventory inventory = new InventoryReader().readInventory(file);
        this.addReferenceInventory(inventory, file.getName().replace(".xls", ""));
    }

    public void includeArtifacts() {
        log.info("Merging artifacts from [{}] reference inventories", (Object)this.referenceInventories.size());
        for (Map.Entry<Inventory, String> inventoryContext : this.referenceInventories.entrySet()) {
            Inventory inventory = inventoryContext.getKey();
            String context = inventoryContext.getValue();
            for (Artifact artifact : inventory.getArtifacts()) {
                Artifact outputArtifact = this.outputInventory.findArtifact(artifact, true);
                if (outputArtifact == null) {
                    this.appendContext(artifact, context);
                    this.outputInventory.getArtifacts().add(artifact);
                    continue;
                }
                this.appendContext(outputArtifact, context);
                this.appendVulnerabilityData(outputArtifact, artifact);
            }
        }
    }

    public void includeAssets() {
        TimeMeasure timeMeasure = new TimeMeasure();
        log.info("Merging Assets from [{}] reference inventories.", (Object)this.referenceInventories.size());
        for (Map.Entry<Inventory, String> inventoryContext : this.referenceInventories.entrySet()) {
            Inventory inventory = inventoryContext.getKey();
            for (AssetMetaData assetMetaData : inventory.getAssetMetaData()) {
                AssetMetaData outputAsset = this.outputInventory.findAssetMetaData(assetMetaData.get("Asset Id"), false);
                if (outputAsset != null) continue;
                this.outputInventory.getAssetMetaData().add(assetMetaData);
            }
        }
        log.info(" [{}] Merged assets from [{}] reference inventories.", (Object)timeMeasure, (Object)this.referenceInventories.size());
    }

    public void includeVulnerabilities() {
        Vulnerability vulnerability;
        TimeMeasure timeMeasure = new TimeMeasure();
        log.info("Merging vulnerabilities from [{}] reference inventories", (Object)this.referenceInventories.size());
        VulnerabilityContextInventory vOutputInventory = VulnerabilityContextInventory.fromInventory(this.outputInventory);
        LinkedHashMap<Inventory, VulnerabilityContextInventory> vulnerabilityContextInventories = new LinkedHashMap<Inventory, VulnerabilityContextInventory>();
        for (Map.Entry<Inventory, String> entry : this.referenceInventories.entrySet()) {
            Inventory inventory = entry.getKey();
            VulnerabilityContextInventory vulnerabilityContextInventory = VulnerabilityContextInventory.fromInventory(inventory);
            vulnerabilityContextInventory.calculateEffectiveCvssVectorsForVulnerabilities(this.securityPolicy);
            vulnerabilityContextInventories.put(inventory, vulnerabilityContextInventory);
        }
        log.info(" [{}] 1. Parsed [{}] vulnerabilities from [{}] reference inventories", new Object[]{timeMeasure, vulnerabilityContextInventories.values().stream().mapToInt(i -> i.getVulnerabilities().size()).sum(), vulnerabilityContextInventories.size()});
        LinkedHashMap<String, Vulnerability> mostSevereStatusVulnerabilities = new LinkedHashMap<String, Vulnerability>();
        for (Map.Entry entry : vulnerabilityContextInventories.entrySet()) {
            VulnerabilityContextInventory vulnerabilityContextInventory = (VulnerabilityContextInventory)entry.getValue();
            for (Vulnerability vulnerability2 : vulnerabilityContextInventory.getVulnerabilities()) {
                Vulnerability vulnerability3;
                VulnerabilityStatus vulnerabilityStatus = vulnerability2.getVulnerabilityStatus();
                if (vulnerabilityStatus != null) {
                    vulnerabilityStatus.applyToVulnerability(vulnerability2);
                }
                if ((vulnerability3 = (Vulnerability)mostSevereStatusVulnerabilities.get(vulnerability2.getId())) == null) {
                    mostSevereStatusVulnerabilities.put(vulnerability2.getId(), vulnerability2);
                    continue;
                }
                Vulnerability updatedMostSevere = this.selectMostSevereStatusVulnerability(vulnerability3, vulnerability2);
                if (updatedMostSevere == null) continue;
                mostSevereStatusVulnerabilities.put(vulnerability2.getId(), updatedMostSevere);
            }
        }
        log.info(" [{}] 2. Found most severe status for [{}] vulnerabilities", (Object)timeMeasure, (Object)mostSevereStatusVulnerabilities.size());
        for (Vulnerability vulnerability4 : mostSevereStatusVulnerabilities.values()) {
            if (vulnerability4 == null) continue;
            vOutputInventory.findOrAppendVulnerabilityByVulnerability(Vulnerability.fromJson(vulnerability4.toJson()));
        }
        log.info(" [{}] 3. Created [{}] vulnerabilities with most severe status information in output inventory", (Object)timeMeasure, (Object)vOutputInventory.getVulnerabilities().size());
        for (Map.Entry entry : vulnerabilityContextInventories.entrySet()) {
            VulnerabilityContextInventory vulnerabilityContextInventory = (VulnerabilityContextInventory)entry.getValue();
            for (Vulnerability vulnerability5 : vulnerabilityContextInventory.getVulnerabilities()) {
                if (mostSevereStatusVulnerabilities.get(vulnerability5.getId()) != null || (vulnerability = vOutputInventory.findOrAppendVulnerabilityByVulnerability(Vulnerability.fromJson(vulnerability5.toJson()))).getVulnerabilityStatus() == null) continue;
                vulnerability.getVulnerabilityStatus().clearHistoryEntries();
            }
        }
        log.info(" [{}] 4. Appended remaining vulnerabilities to output inventory, now at [{}]", (Object)timeMeasure, (Object)vOutputInventory.getVulnerabilities().size());
        vOutputInventory.pauseReAssociation();
        for (Vulnerability vulnerability6 : vOutputInventory.getVulnerabilities()) {
            for (VulnerabilityContextInventory currentInventory : vulnerabilityContextInventories.values()) {
                Optional<Vulnerability> optional = currentInventory.findVulnerabilityByName(vulnerability6.getId());
                if (!optional.isPresent()) continue;
                vulnerability = optional.get();
                for (AdvisoryEntry advisoryEntry : vulnerability.getSecurityAdvisories()) {
                    AdvisoryEntry mergedAdvisoryEntry = vOutputInventory.findOrAppendAdvisoryEntryByAdvisoryEntry(advisoryEntry);
                    vulnerability6.addSecurityAdvisory(mergedAdvisoryEntry);
                }
            }
        }
        log.info(" [{}] 5. Appended security advisories to output inventory, now at [{}]", (Object)timeMeasure, (Object)vOutputInventory.getSecurityAdvisories().size());
        LinkedHashMap<String, Map> linkedHashMap = new LinkedHashMap<String, Map>();
        for (Map.Entry entry : vulnerabilityContextInventories.entrySet()) {
            VulnerabilityContextInventory vCurrentInventory2 = (VulnerabilityContextInventory)entry.getValue();
            for (Vulnerability currentVulnerability : vCurrentInventory2.getVulnerabilities()) {
                VulnerabilityStatus vulnerabilityStatus = currentVulnerability.getOrCreateNewVulnerabilityStatus();
                List<VulnerabilityStatusReviewedEntry> currentReviewedAdvisories = vulnerabilityStatus.getReviewedAdvisories();
                Set reviewedAdvisoriesPerInventory = linkedHashMap.computeIfAbsent(currentVulnerability.getId(), k -> new LinkedHashMap()).computeIfAbsent(vCurrentInventory2, k -> new LinkedHashSet());
                Iterator<VulnerabilityStatusReviewedEntry> iterator = currentReviewedAdvisories.iterator();
                while (iterator.hasNext()) {
                    VulnerabilityStatusReviewedEntry reviewedAdvisory = iterator.next();
                    reviewedAdvisoriesPerInventory.add(reviewedAdvisory.getId());
                }
            }
        }
        log.info(" [{}] 6. Found [{}] reviewed advisories in [{}] reference inventories", new Object[]{timeMeasure, linkedHashMap.values().stream().mapToInt(i -> i.values().stream().mapToInt(Set::size).sum()).sum(), linkedHashMap.size()});
        for (Map map : linkedHashMap.values()) {
            HashSet<String> advisoryIds = new HashSet<String>();
            for (Object reviewedAdvisoriesPerInventory : map.values()) {
                advisoryIds.addAll((Collection<String>)reviewedAdvisoriesPerInventory);
            }
            advisoryIds.removeIf(e -> {
                for (Set reviewedAdvisoriesPerInventory : inventoryRevieweAdvisories.values()) {
                    if (reviewedAdvisoriesPerInventory.contains(e)) continue;
                    log.info("Marking partially reviewed security advisory as unreviewed [{}]", e);
                    return true;
                }
                return false;
            });
            for (Object reviewedAdvisoriesPerInventory : map.values()) {
                reviewedAdvisoriesPerInventory.removeIf(e -> {
                    if (advisoryIds.contains(e)) {
                        advisoryIds.remove(e);
                        return false;
                    }
                    return true;
                });
            }
        }
        log.info(" [{}] 7. Removed partially reviewed advisories, now at [{}] reviewed advisories", (Object)timeMeasure, (Object)linkedHashMap.values().stream().mapToInt(i -> i.values().stream().mapToInt(Set::size).sum()).sum());
        LinkedHashMap<String, Set> linkedHashMap2 = new LinkedHashMap<String, Set>();
        for (Map.Entry reviewedAdvisoriesPerVulnerability : linkedHashMap.entrySet()) {
            String string = (String)reviewedAdvisoriesPerVulnerability.getKey();
            for (Map.Entry entry : ((Map)reviewedAdvisoriesPerVulnerability.getValue()).entrySet()) {
                for (String reviewedAdvisory : (Set)entry.getValue()) {
                    linkedHashMap2.computeIfAbsent(string, k -> new LinkedHashSet()).add(reviewedAdvisory);
                }
            }
        }
        log.info(" [{}] 8. Found [{}] applicable reviewed advisories", (Object)timeMeasure, (Object)linkedHashMap2.values().stream().mapToInt(Set::size).sum());
        for (Map.Entry reviewedAdvisoriesPerVulnerability : linkedHashMap2.entrySet()) {
            Vulnerability vulnerability7 = vOutputInventory.findOrCreateVulnerabilityByName((String)reviewedAdvisoriesPerVulnerability.getKey());
            VulnerabilityStatus outputStatus = vulnerability7.getOrCreateNewVulnerabilityStatus();
            for (String advisory : (Set)reviewedAdvisoriesPerVulnerability.getValue()) {
                outputStatus.addReviewedAdvisoryEntry(advisory);
            }
        }
        log.info(" [{}] 9. Wrote effective status back to vulnerabilities", (Object)timeMeasure);
        vOutputInventory.writeBack(true);
        log.info(" [{}] 10. Wrote output inventory back to file", (Object)timeMeasure);
    }

    public void includeAdvisories() {
        TimeMeasure timeMeasure = new TimeMeasure();
        log.info("Merging advisories from [{}] reference inventories", (Object)this.referenceInventories.size());
        VulnerabilityContextInventory vOutputInventory = VulnerabilityContextInventory.fromInventory(this.outputInventory);
        LinkedHashMap<Inventory, VulnerabilityContextInventory> vulnerabilityContextInventories = new LinkedHashMap<Inventory, VulnerabilityContextInventory>();
        for (Map.Entry<Inventory, String> inventoryContext : this.referenceInventories.entrySet()) {
            Inventory inventory = inventoryContext.getKey();
            VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
            vulnerabilityContextInventories.put(inventory, vInventory);
        }
        log.info(" [{}] 1. Parsed [{}] advisories from [{}] reference inventories", new Object[]{timeMeasure, vulnerabilityContextInventories.values().stream().mapToInt(i -> i.getSecurityAdvisories().size()).sum(), vulnerabilityContextInventories.size()});
        LinkedHashMap<String, AdvisoryEntry> entries = new LinkedHashMap<String, AdvisoryEntry>();
        for (Map.Entry contextInventoryEntry : vulnerabilityContextInventories.entrySet()) {
            VulnerabilityContextInventory vCurrentInventory = (VulnerabilityContextInventory)contextInventoryEntry.getValue();
            for (AdvisoryEntry advisoryEntry : vCurrentInventory.getSecurityAdvisories()) {
                entries.put(advisoryEntry.getId(), advisoryEntry);
            }
        }
        log.info(" [{}] 2. Found [{}] unique advisories", (Object)timeMeasure, (Object)entries.size());
        for (AdvisoryEntry advisoryEntry : entries.values()) {
            vOutputInventory.findOrAppendAdvisoryEntryByAdvisoryEntry(advisoryEntry);
        }
        log.info(" [{}] 3. Appended [{}] unique advisories to output inventory", (Object)timeMeasure, (Object)entries.size());
        vOutputInventory.pauseReAssociation();
        vOutputInventory.writeBack(true);
        log.info(" [{}] 4. Wrote output inventory back to file", (Object)timeMeasure);
    }

    public void includeVulnerabilityScores() {
        TimeMeasure timeMeasure = new TimeMeasure();
        log.info("Calculating effective CVSS vectors for vulnerabilities in output inventory");
        VulnerabilityContextInventory vOutputInventory = VulnerabilityContextInventory.fromInventory(this.outputInventory);
        log.info(" [{}] 1. Parsed [{}] vulnerabilities from output inventory", (Object)timeMeasure, (Object)vOutputInventory.getVulnerabilities().size());
        vOutputInventory.calculateEffectiveCvssVectorsForVulnerabilities(this.securityPolicy);
        log.info(" [{}] 2. Calculated effective CVSS vectors for vulnerabilities", (Object)timeMeasure);
        vOutputInventory.pauseReAssociation();
        vOutputInventory.writeBack(true);
        log.info(" [{}] 3. Wrote base output inventory back to file", (Object)timeMeasure);
        vOutputInventory.writeAdditionalInformationBack(this.securityPolicy);
        log.info(" [{}] 4. Wrote additional CVSS information back to output inventory", (Object)timeMeasure);
    }

    private Vulnerability selectMostSevereStatusVulnerability(Vulnerability lhs, Vulnerability rhs) {
        double rhsOverallScore;
        boolean lhsAffectsAsset = this.affectsAsset(lhs);
        boolean rhsAffectsAsset = this.affectsAsset(rhs);
        if (lhsAffectsAsset && !rhsAffectsAsset) {
            return lhs;
        }
        if (!lhsAffectsAsset && rhsAffectsAsset) {
            return rhs;
        }
        if (!rhsAffectsAsset) {
            return null;
        }
        double lhsOverallScore = InventoryMerger.getContextOrInitialScore(lhs);
        if (lhsOverallScore > (rhsOverallScore = InventoryMerger.getContextOrInitialScore(rhs))) {
            return lhs;
        }
        if (lhsOverallScore < rhsOverallScore) {
            return rhs;
        }
        for (String checkStatus : AFFECTED_VULNERABILITY_STATUS_ORDER_DESCENDING) {
            String lhsStatus = InventoryMerger.getStatus(lhs);
            String rhsStatus = InventoryMerger.getStatus(rhs);
            if (checkStatus.equalsIgnoreCase(lhsStatus)) {
                return lhs;
            }
            if (!checkStatus.equalsIgnoreCase(rhsStatus)) continue;
            return rhs;
        }
        return lhs;
    }

    private static double getContextOrInitialScore(Vulnerability lhs) {
        CvssVector selectedContextIfAvailableOtherwiseInitial = lhs.getCvssSelectionResult().getSelectedContextIfAvailableOtherwiseInitial();
        if (selectedContextIfAvailableOtherwiseInitial != null) {
            return selectedContextIfAvailableOtherwiseInitial.getBakedScores().getOverallScore();
        }
        return 0.0;
    }

    private boolean affectsAsset(Vulnerability vulnerability) {
        if (vulnerability == null) {
            return false;
        }
        String status = InventoryMerger.getStatus(vulnerability);
        if (status == null) {
            return true;
        }
        return !NOT_AFFECTED_VULNERABILITY_STATUS.contains(status);
    }

    private static String getStatus(Vulnerability vulnerability) {
        VulnerabilityStatus vulnerabilityStatus = vulnerability.getVulnerabilityStatus();
        if (vulnerabilityStatus == null) {
            return null;
        }
        VulnerabilityStatusHistoryEntry lastStatus = vulnerabilityStatus.getLatestActiveStatusHistoryEntry();
        if (lastStatus == null) {
            return null;
        }
        return lastStatus.getStatus();
    }

    private void appendContext(Artifact artifact, String context) {
        String combinedContext = artifact.get(InventoryAttribute.INVENTORY_CONTEXT.getKey());
        combinedContext = combinedContext != null ? combinedContext + ", " + context : context;
        artifact.set(InventoryAttribute.INVENTORY_CONTEXT.getKey(), combinedContext);
    }

    private void appendVulnerabilityData(Artifact outputArtifact, Artifact artifact) {
        this.appendCsvValueUnique(outputArtifact, artifact, Artifact.Attribute.VULNERABILITY.getKey());
        this.appendCsvValueUnique(outputArtifact, artifact, InventoryAttribute.VULNERABILITIES_FIXED_BY_KB.getKey());
        this.appendCsvValueUnique(outputArtifact, artifact, InventoryAttribute.ADDON_CVES.getKey());
        this.appendCsvValueUnique(outputArtifact, artifact, InventoryAttribute.INAPPLICABLE_CVE.getKey());
        this.appendCsvValueUnique(outputArtifact, artifact, InventoryAttribute.MATCHED_CPES.getKey());
        this.appendCsvValueUnique(outputArtifact, artifact, InventoryAttribute.DERIVED_CPE_URIS.getKey());
        this.appendCsvValueUnique(outputArtifact, artifact, InventoryAttribute.INAPPLICABLE_CPE.getKey());
        this.appendCsvValueUnique(outputArtifact, artifact, InventoryAttribute.ADDITIONAL_CPE.getKey());
        this.appendCsvValueUnique(outputArtifact, artifact, InventoryAttribute.INITIAL_CPE_URIS.getKey());
    }

    private void appendCsvValueUnique(Artifact outputArtifact, Artifact artifact, String attribute) {
        String existingValue = outputArtifact.get(attribute);
        String appendValue = artifact.get(attribute);
        if (appendValue == null) {
            return;
        }
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        if (existingValue != null) {
            values.addAll(Arrays.asList(existingValue.split(", ")));
        }
        values.addAll(Arrays.asList(appendValue.split(", ")));
        if (!values.isEmpty()) {
            outputArtifact.set(attribute, String.join((CharSequence)", ", values));
        } else {
            outputArtifact.set(attribute, null);
        }
    }

    public Inventory getOutputInventory() {
        return this.outputInventory;
    }

    public Map<Inventory, String> getReferenceInventories() {
        return this.referenceInventories;
    }

    public CentralSecurityPolicyConfiguration getSecurityPolicy() {
        return this.securityPolicy;
    }

    protected static class TimeMeasure {
        private final long start;
        private long last;

        protected TimeMeasure() {
            this.last = this.start = System.currentTimeMillis();
        }

        public long sinceStart() {
            return System.currentTimeMillis() - this.start;
        }

        public long sinceLast() {
            long now = System.currentTimeMillis();
            long diff = now - this.last;
            this.last = now;
            return diff;
        }

        public String sinceStartString() {
            return TimeUtils.formatTimeDiff(this.sinceStart());
        }

        public String sinceLastString() {
            return TimeUtils.formatTimeDiff(this.sinceLast());
        }

        public String toString() {
            return String.format("%1$9s -> %2$9s", this.sinceLastString(), this.sinceStartString());
        }
    }
}

