/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.metascan;

import com.metaeffekt.artifact.analysis.model.DefaultPropertyProvider;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScanSupport {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final NormalizationMetaData normalizationMetaData;
    private final PropertyProvider propertyProvider;

    public AbstractScanSupport(NormalizationMetaData normalizationMetaData, PropertyProvider propertyProvider) {
        this.normalizationMetaData = normalizationMetaData;
        this.propertyProvider = propertyProvider == null ? new DefaultPropertyProvider() : propertyProvider;
    }

    protected NormalizationMetaData getNormalizationMetaData() {
        return this.normalizationMetaData;
    }

    protected PropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    protected void init(File logFile, CharSequence line) throws IOException {
        FileUtils.writeLines((File)logFile, (String)"UTF-8", Collections.singleton(line), (boolean)false);
    }

    protected void log(File logFile, CharSequence line) throws IOException {
        FileUtils.writeLines((File)logFile, (String)"UTF-8", Collections.singleton(line), (boolean)true);
    }

    protected void logFileAndConsole(File logFile, CharSequence line) throws IOException {
        this.LOG.info(line.toString());
        FileUtils.writeLines((File)logFile, (String)"UTF-8", Collections.singleton(line), (boolean)true);
    }
}

