/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.metascan;

import com.metaeffekt.artifact.analysis.metascan.CopyrightScanResult;
import com.metaeffekt.artifact.analysis.utils.StringStats;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CopyrightScanSupport {
    public CopyrightScanResult scanForCopyrights(StringStats text) {
        CopyrightScanResult copyrightScanResult = new CopyrightScanResult();
        HashSet<CopyrightSeed> seeds = new HashSet<CopyrightSeed>();
        this.seed(text, seeds, "copyright");
        this.seed(text, seeds, "Copyright");
        this.seed(text, seeds, "GmbH");
        this.seed(text, seeds, "Ltd");
        this.seed(text, seeds, "Inc");
        this.seed(text, seeds, "inc");
        this.seed(text, seeds, "(c)");
        this.seed(text, seeds, "(C)");
        this.seedRegexp(text, seeds, ".*?@.*?\\.com");
        return copyrightScanResult;
    }

    private void seed(StringStats text, Set<CopyrightSeed> seeds, String seed) {
        int[] seedIndex;
        for (int i : seedIndex = text.allMatches(StringStats.normalize(seed, true))) {
            seeds.add(new CopyrightSeed(seed, i));
        }
    }

    private void seedRegexp(StringStats text, Set<CopyrightSeed> seeds, String seedRegexp) {
        List<int[]> seedIndexes = text.matchRegexp(StringStats.normalize(seedRegexp, true));
        if (seedIndexes == null) {
            return;
        }
        for (int[] i : seedIndexes) {
            seeds.add(new CopyrightSeed(seedRegexp, i[0]));
        }
    }

    private class CopyrightSeed {
        private String seed;
        private int index;

        CopyrightSeed(String seed, int index) {
            this.seed = seed;
            this.index = index;
        }

        public String toString() {
            return "CopyrightSeed{seed='" + this.seed + '\'' + ", index=" + this.index + '}';
        }
    }
}

