/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.preprocess.filter;

import com.metaeffekt.artifact.analysis.preprocess.filter.StringBuilderUtils;
import com.metaeffekt.artifact.analysis.preprocess.filter.predicate.CharacterAcceptPredicate;
import java.util.function.Predicate;

public class TextFilterFunctions {
    protected static final Predicate<Integer> acceptCodepoint = new CharacterAcceptPredicate();

    public static StringBuilder removeInvalidUnicode(CharSequence data) {
        StringBuilder result = new StringBuilder();
        data.codePoints().sequential().map(codepoint -> acceptCodepoint.test(codepoint) ? codepoint : 0).forEachOrdered(codepoint -> {
            if (codepoint != 0 || result.length() == 0 || result.charAt(result.length() - 1) != '\u0000') {
                result.appendCodePoint(codepoint);
            }
        });
        StringBuilderUtils.replace(result, '\u0000', ' ');
        return result;
    }
}

