/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.preprocess.filter.charfile;

import java.io.BufferedReader;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharFileHelper
implements SeekableByteChannel,
AutoCloseable {
    protected static final int CACHE_BLOCK_NUMBER = 16;
    protected static final int CACHE_BLOCK_SIZE = 32768;
    private static final Logger LOG = LoggerFactory.getLogger(CharFileHelper.class);
    protected final File original;
    protected final File charDataFile;
    protected final Charset inCharset;
    protected final boolean deleteDataOnClose;
    protected final SeekableByteChannel channel;
    protected final LRUMap<Long, CharBuffer> charCache = new LRUMap(16);
    private volatile boolean closed = false;

    protected CharFileHelper(File original, File charDataFile, Charset inCharset, boolean deleteDataOnClose) throws IOException {
        this.original = original;
        this.charDataFile = charDataFile;
        this.inCharset = inCharset;
        this.deleteDataOnClose = deleteDataOnClose;
        this.channel = Files.newByteChannel(charDataFile.toPath(), StandardOpenOption.READ);
    }

    public static CharFileHelper createDataFile(File original, File charDataFile, Charset inCharset, boolean deleteDataOnClose) throws IOException {
        if (charDataFile.exists() && charDataFile.length() != 0L) {
            throw new FileAlreadyExistsException("File already exists: '" + charDataFile.getPath() + "'");
        }
        CharFileHelper.createParentDirectories(charDataFile);
        FileUtils.touch((File)charDataFile);
        CharFileHelper.prepareCharDataFile(original, charDataFile, inCharset);
        return new CharFileHelper(original, charDataFile, inCharset, deleteDataOnClose);
    }

    private static void createParentDirectories(File file) {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    protected static void prepareCharDataFile(File original, File charDataFile, Charset inCharset) throws IOException {
        try (InputStreamReader in = new InputStreamReader(Files.newInputStream(original.toPath(), new OpenOption[0]), inCharset);
             BufferedReader originalReader = new BufferedReader(in, 131072);){
            OpenOption[] openOptions = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.SPARSE};
            try (DataOutputStream myChannel = new DataOutputStream(Files.newOutputStream(charDataFile.toPath(), openOptions));){
                int numRead;
                char[] buf = new char[131072];
                while ((numRead = originalReader.read(buf)) > 0) {
                    CharFileHelper.writeChars(myChannel, buf, numRead);
                }
            }
        }
    }

    protected static void writeChars(DataOutput channel, char[] c, int length) throws IOException {
        byte[] bytesOut = new byte[2 * length];
        int bytesWritten = 0;
        for (int i = 0; i < length; ++i) {
            bytesOut[bytesWritten++] = (byte)(0xFF & c[i] >>> 8);
            bytesOut[bytesWritten++] = (byte)(0xFF & c[i]);
        }
        channel.write(bytesOut);
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public void close() {
        if (!this.closed && this.deleteDataOnClose) {
            if (!this.charDataFile.delete()) {
                LOG.warn("Failed to delete temporary file: '" + this.charDataFile.getPath() + "'.");
            }
            try {
                this.channel.close();
            }
            catch (IOException e) {
                LOG.warn("Cannot close channel: {}", (Object)e.getMessage());
            }
        }
        this.closed = true;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (this.channel.position() != newPosition) {
            return this.channel.position(newPosition);
        }
        return this.channel;
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        return this.channel.truncate(size);
    }

    public char readCharAt(long charIndex) {
        int mod = (int)(charIndex % 32768L);
        long cacheIndex = charIndex - (long)mod;
        CharBuffer cacheResult = (CharBuffer)this.charCache.get((Object)cacheIndex);
        if (cacheResult == null) {
            try {
                int charOverrun = (int)(cacheIndex + 32768L - this.channel.size() / 2L);
                int charsToAllocate = charOverrun > 0 ? 32768 - charOverrun : 32768;
                int bytesToAllocate = charsToAllocate * 2;
                ByteBuffer newBuffer = ByteBuffer.allocate(bytesToAllocate);
                CharBuffer charBuffer = newBuffer.asCharBuffer();
                this.channel.position(cacheIndex * 2L);
                int numRead = this.channel.read(newBuffer);
                if (numRead != bytesToAllocate) {
                    throw new IOException("Could not read all " + bytesToAllocate + " required bytes (read " + numRead + ").");
                }
                cacheResult = charBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.charCache.put((Object)cacheIndex, (Object)cacheResult);
        }
        return cacheResult.get(mod);
    }
}

