/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.preprocess.filter.charfile;

import com.metaeffekt.artifact.analysis.preprocess.filter.charfile.CharFileHelper;
import java.io.IOException;

public class CharSequenceFile
implements CharSequence,
AutoCloseable {
    protected final CharFileHelper channel;
    protected final boolean closeOnClose;
    protected final long length;

    public CharSequenceFile(CharFileHelper channel, boolean closeOnClose) throws IOException {
        this.channel = channel;
        this.closeOnClose = closeOnClose;
        if (channel.size() % 2L != 0L) {
            throw new IOException("Refusing to read file: odd number of bytes indicates invalid char data file.");
        }
        this.length = this.channel.size() / 2L;
        this.channel.position(0L);
    }

    @Override
    public int length() {
        return (int)Math.min(this.length, Integer.MAX_VALUE);
    }

    @Override
    public char charAt(int charIndex) {
        return this.charAt((long)charIndex);
    }

    public char charAt(long charIndex) {
        return this.channel.readCharAt(charIndex);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start >= this.length()) {
            throw new IndexOutOfBoundsException("Start ouf of bounds: " + start);
        }
        if (end < start || end >= this.length()) {
            throw new IndexOutOfBoundsException("End index doesn't make sense: " + end);
        }
        StringBuilder builder = new StringBuilder();
        try {
            long oldPos = this.channel.position();
            for (int i = start; i < end; ++i) {
                char readChar = this.channel.readCharAt(i);
                builder.append(readChar);
            }
            this.channel.position(oldPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            long oldPos = this.channel.position();
            for (long i = 0L; i < (long)this.length(); ++i) {
                builder.append(this.channel.readCharAt(i));
            }
            this.channel.position(oldPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    @Override
    public void close() {
        if (this.closeOnClose) {
            this.channel.close();
        }
    }
}

