/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.report;

import com.metaeffekt.artifact.analysis.report.ResultInventory;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.LiTag;
import j2html.tags.specialized.LinkTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TbodyTag;
import j2html.tags.specialized.TdTag;
import j2html.tags.specialized.ThTag;
import j2html.tags.specialized.TrTag;
import j2html.tags.specialized.UlTag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.Validate;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.util.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryReportModel {
    public static final Logger LOG = LoggerFactory.getLogger(InventoryReportModel.class);
    private File reportBaseDir;
    private File analysisPath;
    private List<ResultInventory> resultInventories = new ArrayList<ResultInventory>();
    private final List<String> resultIds = new ArrayList<String>();
    private Inventory unifiedInventory;
    private Inventory referenceInventory;
    private boolean reportFailure = false;

    public InventoryReportModel from(File reportBaseDir) throws IOException {
        this.reportBaseDir = reportBaseDir;
        FileUtils.validateExists((File)reportBaseDir);
        for (String inventoryFile : FileUtils.scanDirectoryForFiles((File)reportBaseDir, (String[])new String[]{"*.xls"})) {
            if (!inventoryFile.matches("^[0-9]*\\.xls")) continue;
            this.resultInventories.add(ResultInventory.fromFile(new File(reportBaseDir, inventoryFile)));
        }
        this.resultInventories = this.resultInventories.stream().sorted().skip(Math.max(0, this.resultInventories.size() - 5)).collect(Collectors.toList());
        return this;
    }

    public InventoryReportModel withReferenceInventory(File referenceInventoryFile) throws IOException {
        return this.withReferenceInventory(new InventoryReader().readInventory(referenceInventoryFile));
    }

    public InventoryReportModel withReferenceInventory(Inventory referenceInventory) {
        this.referenceInventory = referenceInventory;
        return this;
    }

    public InventoryReportModel withAnalysisPath(File analysisPath) {
        this.analysisPath = analysisPath;
        return this;
    }

    public InventoryReportModel evaluate() throws IOException {
        this.unifiedInventory = new Inventory();
        Map<File, JSONObject> segmentations = this.extractSegmentationFromAnalysisPath();
        if ((segmentations == null || segmentations.size() == 0) && this.analysisPath != null) {
            if (this.analysisPath.exists()) {
                LOG.warn("Analysis path is set to [{}] but the directory does not exist", (Object)this.analysisPath.getAbsolutePath());
            } else {
                LOG.warn("Analysis path is set to [{}] but no segmentation files were found in the directory", (Object)this.analysisPath.getAbsolutePath());
            }
        }
        for (ResultInventory resultInventory : this.resultInventories) {
            Inventory inventory = resultInventory.getInventory();
            this.addArtifactsToUnifiedInventory(inventory);
            for (Artifact artifact : inventory.getArtifacts()) {
                JSONObject segmentation;
                String identifiedTerms;
                Artifact unifiedArtifact = this.findUnifiedArtifact(artifact);
                Validate.notNull((Object)unifiedArtifact, (String)String.format("All artifacts must be covered by the unified inventory. [%s] found missing.", artifact.getId()), (Object[])new Object[0]);
                String key = String.valueOf(resultInventory.getTimestamp());
                if (!this.resultIds.contains(key)) {
                    this.resultIds.add(key);
                }
                String derivedLicense = artifact.get("Derived Licenses");
                unifiedArtifact.set(key, derivedLicense);
                String analysisPath = artifact.get("Analysis Path");
                if (analysisPath != null) {
                    File analysisDir = new File(analysisPath);
                    if (analysisDir.exists()) {
                        analysisPath = FileUtils.asRelativePath((String)this.reportBaseDir.getAbsolutePath(), (String)analysisDir.getAbsolutePath());
                    }
                    String filename = artifact.getId().replace("/", "_");
                    unifiedArtifact.set(key + "-link", analysisPath + "-analysis/" + filename + "_license-segmentation.txt");
                }
                if ((identifiedTerms = artifact.get("Identified Terms")) != null) {
                    unifiedArtifact.set(key + "-terms", identifiedTerms);
                }
                if (segmentations == null || (segmentation = this.findSegmentation(segmentations, analysisPath, unifiedArtifact)) == null) continue;
                unifiedArtifact.set(key + "-segmentation", segmentation.toString());
            }
        }
        Collections.reverse(this.resultIds);
        for (Artifact artifact : this.unifiedInventory.getArtifacts()) {
            Artifact referenceArtifact = this.findReferenceArtifact(artifact);
            if (referenceArtifact == null) continue;
            artifact.setGroupId(referenceArtifact.getGroupId());
            artifact.setVersion(referenceArtifact.getVersion());
            artifact.setLicense(referenceArtifact.getLicense());
            String derivedLicense = referenceArtifact.get("Derived Licenses");
            if (derivedLicense == null) {
                derivedLicense = referenceArtifact.getLicense();
            }
            artifact.set("Derived Licenses", derivedLicense);
        }
        return this;
    }

    private Map<File, JSONObject> extractSegmentationFromAnalysisPath() throws IOException {
        HashMap<File, JSONObject> segmentations = new HashMap<File, JSONObject>();
        if (this.analysisPath != null && this.analysisPath.exists()) {
            List jsonFiles = FileUtils.listFiles((File)this.analysisPath, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)DirectoryFileFilter.DIRECTORY).stream().sorted().collect(Collectors.toList());
            jsonFiles = jsonFiles.stream().filter(f -> f.getName().endsWith("_license-segmentation.json")).collect(Collectors.toList());
            for (File segmentationFile : jsonFiles) {
                segmentations.put(segmentationFile, new JSONObject(String.join((CharSequence)"", FileUtils.readLines((File)segmentationFile, (Charset)StandardCharsets.UTF_8))));
            }
        }
        return segmentations.size() == 0 ? null : segmentations;
    }

    private JSONObject findSegmentation(Map<File, JSONObject> segmentations, String analysisPath, Artifact artifact) {
        if (analysisPath != null) {
            String filename = artifact.getId().replace("/", "_");
            JSONObject result = this.findSegmentation(segmentations, analysisPath.replaceAll("^\\.\\./", "") + "-analysis/" + filename + "_license-segmentation.json");
            if (result != null) {
                return result;
            }
        }
        return this.findSegmentation(segmentations, artifact.getId());
    }

    private JSONObject findSegmentation(Map<File, JSONObject> segmentations, String searchString) {
        for (Map.Entry<File, JSONObject> segmentationEntry : segmentations.entrySet()) {
            if (!segmentationEntry.getKey().getAbsolutePath().contains(searchString)) continue;
            return segmentationEntry.getValue();
        }
        return null;
    }

    protected void addArtifactsToUnifiedInventory(Inventory inventory) {
        for (Artifact artifact : inventory.getArtifacts()) {
            Artifact referenceArtifact = this.findReferenceArtifact(artifact);
            Artifact unifiedArtifact = this.findUnifiedArtifact(artifact);
            Artifact newArtifact = new Artifact();
            if (referenceArtifact == null) {
                newArtifact.setId(artifact.getId());
                newArtifact.setChecksum(null);
                if (unifiedArtifact != null) continue;
                this.unifiedInventory.getArtifacts().add(newArtifact);
                continue;
            }
            newArtifact.setId(referenceArtifact.getId());
            newArtifact.setChecksum(referenceArtifact.getChecksum());
            if (this.unifiedInventory.findArtifact(newArtifact.getId()) != null) continue;
            this.unifiedInventory.getArtifacts().add(newArtifact);
        }
    }

    private Artifact findUnifiedArtifact(Artifact artifact) {
        Artifact unifiedArtifact = this.unifiedInventory.findArtifactByIdAndChecksum(artifact.getId(), artifact.getChecksum());
        if (unifiedArtifact == null) {
            unifiedArtifact = this.unifiedInventory.findArtifact(artifact.getId());
        }
        return unifiedArtifact;
    }

    private Artifact findReferenceArtifact(Artifact artifact) {
        Artifact referenceArtifact = this.referenceInventory.findArtifactByIdAndChecksum(artifact.getId(), artifact.getChecksum());
        if (referenceArtifact == null) {
            referenceArtifact = this.referenceInventory.findArtifactByIdAndChecksum(artifact.getId(), null);
        }
        if (referenceArtifact == null) {
            referenceArtifact = this.referenceInventory.findArtifact(artifact, true);
        }
        return referenceArtifact;
    }

    public void explain() {
        LOG.info(this.toString());
        this.explainUnifiedInventory();
    }

    protected void explainUnifiedInventory() {
        if (this.unifiedInventory != null) {
            for (Artifact artifact : this.unifiedInventory.getArtifacts()) {
                LOG.info("{}<{}>:", (Object)artifact.getId(), (Object)artifact.getChecksum());
                ArrayList orderedAttributes = new ArrayList(artifact.getAttributes());
                Collections.sort(orderedAttributes);
                for (String attribute : orderedAttributes) {
                    LOG.info("  {} = {}", (Object)attribute, (Object)artifact.get(attribute));
                }
            }
        }
    }

    public String toString() {
        return "InventoryReportModel{resultInventories=" + this.resultInventories + '}';
    }

    public void createHtmlReport(File file) {
        String latestKey = !this.resultIds.isEmpty() ? this.resultIds.get(0) : null;
        TbodyTag tableBody = TagCreator.tbody();
        for (Object artifact : this.unifiedInventory.getArtifacts()) {
            String classStatus;
            Status statusDerivedLicenseRef = this.evaluateDerivedLicenseRef((Artifact)artifact);
            Status statusLicenseRef = this.evaluateLicenseRef((Artifact)artifact);
            HashSet<String> highMessages = new HashSet<String>();
            HashSet<String> mediumMessages = new HashSet<String>();
            HashSet lowMessages = new HashSet();
            this.addMessage(highMessages, mediumMessages, statusDerivedLicenseRef);
            this.addMessage(highMessages, mediumMessages, statusLicenseRef);
            TdTag derivedLicensesRefCell = (TdTag)TagCreator.td().withClass("tg-0lax-r" + statusDerivedLicenseRef.risk.name().charAt(0));
            Iterator iterator = Arrays.stream(this.valueOf(artifact.get("Derived Licenses")).split(", ?")).iterator();
            while (true) {
                derivedLicensesRefCell.withText((String)iterator.next());
                if (!iterator.hasNext()) break;
                derivedLicensesRefCell.with((DomContent)TagCreator.hr().withClass("half-linebreak"));
            }
            TdTag expectedLicensesRefCell = (TdTag)TagCreator.td().withClass("tg-0lax-r" + statusLicenseRef.risk.name().charAt(0));
            iterator = Arrays.stream(this.valueOf(artifact.getLicense()).split(", ?")).iterator();
            while (true) {
                expectedLicensesRefCell.withText((String)iterator.next());
                if (!iterator.hasNext()) break;
                expectedLicensesRefCell.with((DomContent)TagCreator.hr().withClass("half-linebreak"));
            }
            ArrayList<TdTag> dynamicTableColumnElements = new ArrayList<TdTag>();
            for (String key : this.resultIds) {
                List licenses = Arrays.stream((StringUtils.isEmpty(artifact.get(key)) || artifact.get(key).equals("<none>") ? "&lt;none&gt;" : artifact.get(key)).split(", ?")).map(String::trim).collect(Collectors.toList());
                String filePathLink = artifact.get(key + "-link");
                Set<Status> statusDerivedLicense = this.evaluateDerivedLicense((Artifact)artifact, key);
                String classDerivedLicense = "tg-0lax-r" + statusDerivedLicense.stream().min(Comparator.comparing(status -> status.risk.ordinal())).map(status -> status.risk.name()).orElse("L").charAt(0);
                boolean containsIncompleteMatch = statusDerivedLicense.stream().anyMatch(status -> status.reason.equals("Incomplete Match."));
                if (key.equalsIgnoreCase(latestKey)) {
                    statusDerivedLicense.forEach(status -> this.addMessage((Set<String>)highMessages, (Set<String>)mediumMessages, (Status)status));
                } else {
                    statusDerivedLicense.forEach(status -> this.addMessage(lowMessages, (Status)status));
                }
                TdTag cellValue = (TdTag)TagCreator.td().withClasses(new String[]{classDerivedLicense, "cell-actual-licenses"});
                Iterator iter = licenses.iterator();
                while (iter.hasNext()) {
                    String license = (String)iter.next();
                    String metaeffektUniverseUrl = this.getMetaeffektUniverseUrl(license);
                    if (metaeffektUniverseUrl != null) {
                        cellValue.with((DomContent)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.rawHtml((String)license)}).withHref(metaeffektUniverseUrl)).withTarget("aeuniverse"));
                    } else if (filePathLink != null) {
                        cellValue.with((DomContent)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.rawHtml((String)license)}).withHref("file:" + filePathLink)).withTarget("filepath"));
                    } else {
                        cellValue.with((DomContent)TagCreator.rawHtml((String)license));
                    }
                    if (key.equalsIgnoreCase(latestKey) && artifact.get(latestKey + "-segmentation") != null) {
                        JSONArray currentLicenseFiles;
                        JSONObject segmentation = new JSONObject(artifact.get(latestKey + "-segmentation"));
                        JSONObject licenseOverview = segmentation.optJSONObject("license.overview");
                        HashSet<String> paths = new HashSet<String>();
                        if (licenseOverview != null && (currentLicenseFiles = licenseOverview.optJSONArray(license)) != null) {
                            for (int i = 0; i < currentLicenseFiles.length(); ++i) {
                                String path = currentLicenseFiles.optString(i, null);
                                if ((path = path.substring(0, path.lastIndexOf("/"))) == null) continue;
                                paths.add(path);
                            }
                        }
                        cellValue.with((DomContent)this.buildDocumentTree(PathNode.makeNodes(paths), null));
                    }
                    if (!iter.hasNext()) continue;
                    cellValue.with((DomContent)TagCreator.hr().withClass("half-linebreak"));
                }
                cellValue.with((DomContent)TagCreator.iff((boolean)containsIncompleteMatch, (Object)TagCreator.i((DomContent[])new DomContent[]{TagCreator.hr().withClass("half-linebreak"), TagCreator.text((String)" (Incomplete Match)")})));
                dynamicTableColumnElements.add(cellValue);
            }
            TrTag tableRow = TagCreator.tr((DomContent[])new DomContent[]{((TdTag)TagCreator.td().withClass("tg-0lax")).with(new DomContent[]{TagCreator.b((DomContent[])new DomContent[]{TagCreator.text((String)this.valueOf(artifact.getId()))}), (DomContent)TagCreator.iff((artifact.getChecksum() != null ? 1 : 0) != 0, (Object)TagCreator.i((DomContent[])new DomContent[]{TagCreator.hr().withClass("half-linebreak"), TagCreator.text((String)artifact.getChecksum())}))}), expectedLicensesRefCell, derivedLicensesRefCell, TagCreator.each(dynamicTableColumnElements.stream().map(d -> d))});
            String string = highMessages.isEmpty() ? (mediumMessages.isEmpty() ? "tg-0lax-rL" : "tg-0lax-rM") : (classStatus = "tg-0lax-rH");
            HashSet<String> reasons = highMessages.isEmpty() ? (mediumMessages.isEmpty() ? lowMessages : mediumMessages) : highMessages;
            tableRow.with((DomContent)((TdTag)TagCreator.td().withClass(classStatus)).withText(reasons.stream().sorted().collect(Collectors.joining(", "))));
            tableBody.with((DomContent)tableRow);
            this.reportFailure |= !highMessages.isEmpty();
        }
        TrTag tableHeadElements = TagCreator.tr((DomContent[])new DomContent[]{((ThTag)TagCreator.th().withClass("tg-0lax")).with((DomContent)TagCreator.b((String)"Artifact Id")), ((ThTag)TagCreator.th().withClass("tg-0lax")).with((DomContent)TagCreator.b((String)"Curated Reference Licenses")), ((ThTag)TagCreator.th().withClass("tg-0lax")).with((DomContent)TagCreator.b((String)"Expected Identified Licenses"))});
        for (String key : this.resultIds) {
            tableHeadElements.with((DomContent)((ThTag)TagCreator.th().withClass("tg-0lax")).with(new DomContent[]{TagCreator.b((String)"Actual Identified Licenses"), TagCreator.br(), TagCreator.text((String)this.dateOf(key)), (DomContent)TagCreator.iff((boolean)key.equalsIgnoreCase(latestKey), (Object)TagCreator.join((Object[])new Object[]{TagCreator.br(), TagCreator.b((String)"LATEST")}))}));
        }
        tableHeadElements.with((DomContent)((ThTag)TagCreator.th().withClass("tg-0lax")).with((DomContent)TagCreator.b((String)"Status")));
        HtmlTag htmlDocument = (HtmlTag)((HtmlTag)TagCreator.html().withLang("en")).with(new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.meta().withCharset("UTF-8"), TagCreator.title((String)"Inventory Report"), ((LinkTag)TagCreator.link().withRel("icon")).withHref("data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" fill=\"%233e8cf0\" viewBox=\"0 0 24 24\"><path d=\"M 8 16 h 8 v 2 H 8 z m 0 -4 h 6 v 2 H 8 z m 6 -10 H 6 c -2 0 -2 0 -2 2 v 16 c 0 2 0 2 1.99 2 H 18 c 2 0 2 0 2 -2 V 7 l -6 -5 z m 4 18 H 6 V 4 h 8 v 3 h 4 v 10 z\"/></svg>"), TagCreator.style((String)(ColorScheme.cssRoot() + "p{font-family:Arial,sans-serif;font-size:10px;font-weight:400;padding:10px 5px;overflow:hidden;word-break:normal;background-color:#fafafa}.tg thead{position:sticky;top:0}.tg{box-shadow:0 0 2px 1px #00000087;border-collapse:collapse;border-spacing:0;border-radius:3px}.tg td{font-family:Arial,sans-serif;font-size:14px;padding:10px 10px;overflow:hidden;word-break:normal}.tg th{padding:10px 5px 7px 10px;font-family:Arial,sans-serif;font-size:14px;font-weight:400;overflow:hidden;word-break:normal;background-color:var(--pastel-gray);background-clip:padding-box}.tg .tg-0lax{text-align:left;vertical-align:top}.tg .tg-0lax-rH{text-align:left;vertical-align:top;background-color:var(--pastel-red);}.tg .tg-0lax-rM{text-align:left;vertical-align:top;background-color:var(--pastel-yellow)}.tg .tg-0lax-rL{text-align:left;vertical-align:top;background-color:var(--pastel-green);}.tg td{border:1px solid #00000045}.tg tr:first-child th{border-top:0}.tg tr:last-child td{border-bottom:0}.tg tr td:first-child,.tg tr th:first-child{border-left:0}.tg tr td:last-child,.tg tr th:last-child{border-right:0}.tg tr:last-child td:first-child{border-bottom-left-radius:3px}.tg tr:last-child td:last-child{border-bottom-right-radius:3px}.tg tr:first-child th:first-child{border-top-left-radius:3px}.tg tr:first-child th:last-child{border-top-right-radius:3px}.tg tbody tr:hover{background-color:var(--pastel-white);}.tg{width:100%;}.cell-actual-licenses{max-width:20%;word-wrap:break-word;}a:link{text-decoration:underline;color:#000}a:visited{text-decoration:underline;color:#000}a:hover{text-decoration:underline;color:#000}a:link{text-decoration:underline;color:#000}a:active{text-decoration:underline;color:#000}tree-view-parent > ul, li{list-style-type:none;}.tree-view-parent{margin:0;margin-left:15px;margin-top:2px;padding:0;}.tree-view-caret{cursor:pointer;-webkit-user-select:none;/* Safari 3.1+ */-moz-user-select:none;/* Firefox 2+ */-ms-user-select:none;/* IE 10+ */user-select:none;margin-left:-15px;}.tree-view-caret::before{content:\"\\25B6\";color:black;display:inline-block;margin-right:6px;font-size:10px;}.tree-view-caret-down::before{-ms-transform:rotate(90deg);/* IE 9 */-webkit-transform:rotate(90deg);/* Safari */transform:rotate(90deg);}.tree-view-nested{display:none;padding-left:13px;}.tree-view-active{display:block;}hr.half-linebreak{margin:0;height:7px;border:none;color:transparent;background-color:transparent;}")).withType("text/css")}), TagCreator.body((DomContent[])new DomContent[]{((TableTag)TagCreator.table().withClass("tg")).with(new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{tableHeadElements}), tableBody}), TagCreator.p((DomContent[])new DomContent[]{TagCreator.i((DomContent[])new DomContent[]{TagCreator.rawHtml((String)"Report created by {met&#230;ffekt} Artifact Analysis Plugin")})}), TagCreator.script((String)"function toggleTreeView(element) {  element.parentElement.querySelector('.tree-view-nested').classList.toggle('tree-view-active');  element.classList.toggle('tree-view-caret-down');}function initialize() {  let toggler = document.getElementsByClassName('tree-view-caret');  console.log(toggler.length);  console.log(toggler);let i = 0;  for (i = 0; i < toggler.length; i++) {    console.log(i);    console.log(toggler[i]);    toggler[i].addEventListener('click', function() {toggleTreeView(this)});  }}document.onload = initialize();").withType("text/javascript")})});
        try {
            FileUtils.write((File)file, (CharSequence)htmlDocument.render(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Unable to write Inventory Report to file [" + file.getAbsolutePath() + "]", (Throwable)e);
        }
    }

    private void addMessage(Set<String> highMessages, Set<String> mediumMessages, Status status) {
        switch (status.risk) {
            case HIGH: {
                highMessages.add(status.reason);
            }
            case MEDIUM: {
                mediumMessages.add(status.reason);
            }
        }
    }

    private void addMessage(Set<String> lowMessages, Status status) {
        switch (status.risk) {
            case HIGH: {
                lowMessages.add(status.reason + " (in a previous iteration)");
            }
            case MEDIUM: {
                lowMessages.add(status.reason + " (in a previous iteration)");
            }
        }
    }

    private Set<Status> evaluateDerivedLicense(Artifact artifact, String key) {
        HashSet<Status> statuses = new HashSet<Status>();
        String derivedLicenseRef = this.valueOf(artifact.get("Derived Licenses"));
        String licenseRef = this.valueOf(artifact.getLicense());
        String derivedLicense = this.valueOf(artifact.get(key));
        String identifiedTerms = artifact.get(key + "-terms");
        if (identifiedTerms != null && Arrays.asList(identifiedTerms.split(", ?")).contains("Incomplete Match")) {
            statuses.add(new Status(Risk.MEDIUM, "Incomplete Match."));
        }
        List derivedLicensesRef = InventoryUtils.tokenizeLicense((String)derivedLicenseRef, (boolean)false, (boolean)true);
        List licensesRef = InventoryUtils.tokenizeLicense((String)licenseRef, (boolean)false, (boolean)true);
        List derivedLicenses = InventoryUtils.tokenizeLicense((String)derivedLicense, (boolean)false, (boolean)true);
        derivedLicenses.remove("<none>");
        if (derivedLicenses.size() == 0 && licensesRef.size() > 0 && ((String)licensesRef.get(0)).equals("<none>")) {
            statuses.add(this.evaluateLicenseRef(artifact));
            return statuses;
        }
        if (derivedLicenses.size() == 0 && derivedLicensesRef.size() > 0 && ((String)derivedLicensesRef.get(0)).equals("<none>")) {
            statuses.add(this.evaluateDerivedLicenseRef(artifact));
            return statuses;
        }
        HashSet overhead = new HashSet(derivedLicenses);
        licensesRef.forEach(overhead::remove);
        HashSet underhead = new HashSet(licensesRef);
        derivedLicenses.forEach(underhead::remove);
        if (overhead.isEmpty() && underhead.isEmpty()) {
            statuses.add(this.evaluateLicenseRef(artifact));
            return statuses;
        }
        HashSet overheadRef = new HashSet(derivedLicenses);
        derivedLicensesRef.forEach(overheadRef::remove);
        HashSet underheadRef = new HashSet(derivedLicensesRef);
        derivedLicenses.forEach(underheadRef::remove);
        if (!overheadRef.isEmpty()) {
            statuses.add(new Status(Risk.HIGH, "Additional license detected."));
            return statuses;
        }
        if (underheadRef.isEmpty()) {
            statuses.add(this.evaluateDerivedLicenseRef(artifact));
            return statuses;
        }
        statuses.add(new Status(Risk.MEDIUM, "Fewer licenses detected."));
        return statuses;
    }

    private Status evaluateDerivedLicenseRef(Artifact artifact) {
        if (artifact.getLicense() == null) {
            return new Status(Risk.HIGH, "No expectation defined.");
        }
        if (!artifact.getLicense().equalsIgnoreCase(artifact.get("Derived Licenses"))) {
            return new Status(Risk.MEDIUM, "Inconsistency between curated and expectation detected.");
        }
        return this.evaluateLicenseRef(artifact);
    }

    private Status evaluateLicenseRef(Artifact artifact) {
        if (artifact.getLicense() == null) {
            return new Status(Risk.HIGH, "No expectation defined.");
        }
        return new Status(Risk.LOW, "Curated license provided.");
    }

    private String dateOf(String key) {
        long l = Long.parseLong(key);
        return new Date(l).toString();
    }

    public String valueOf(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    public boolean isReportFailure() {
        return this.reportFailure;
    }

    public String getMetaeffektUniverseUrl(String license) {
        if (license == null || license.length() == 0 || license.equals("&lt;none&gt;")) {
            return null;
        }
        String namespace = (license.charAt(0) + "").toLowerCase();
        String anchor = license.replace(" ", "%20").replace("-", "%2D");
        String scrollToTextFragment = ":~:text=" + anchor;
        return "https://github.com/org-metaeffekt/metaeffekt-universe/blob/main/src/main/resources/ae-universe/[" + namespace + "]/README.md#" + scrollToTextFragment;
    }

    private UlTag buildDocumentTree(List<PathNode> nodes, UlTag parent) {
        boolean isTopmostLayer;
        boolean bl = isTopmostLayer = parent == null;
        if (parent == null) {
            parent = (UlTag)TagCreator.ul().withClass("tree-view-parent");
        }
        if (nodes == null || nodes.size() == 0) {
            return parent;
        }
        for (PathNode node : nodes.stream().sorted(Comparator.comparing(PathNode::hasChildNodes)).collect(Collectors.toList())) {
            LiTag entry = TagCreator.li();
            if (node.hasChildNodes()) {
                if (isTopmostLayer) {
                    entry.with(new DomContent[]{TagCreator.span((String)node.getIdentifier()).withClasses(new String[]{"tree-view-caret"}), this.buildDocumentTree(node.getChildNodes(), (UlTag)TagCreator.ul().withClasses(new String[]{"tree-view-nested"}))});
                } else {
                    entry.with(new DomContent[]{TagCreator.span((String)node.getIdentifier()).withClasses(new String[]{"tree-view-caret", "tree-view-caret-down"}), this.buildDocumentTree(node.getChildNodes(), (UlTag)TagCreator.ul().withClasses(new String[]{"tree-view-nested", "tree-view-active"}))});
                }
            } else {
                entry.with((DomContent)TagCreator.text((String)node.getIdentifier()));
            }
            parent.with((DomContent)entry);
        }
        return parent;
    }

    private static class PathNode {
        private final List<PathNode> childNodes = new ArrayList<PathNode>();
        private final String identifier;
        private final boolean leadingSlash;

        public PathNode(String path) {
            if (path != null && path.length() > 0) {
                List<String> split = this.splitPath(path);
                this.identifier = split.get(0);
                this.leadingSlash = path.startsWith("/") || path.startsWith("\\");
                this.addPath(split);
            } else {
                this.identifier = null;
                this.leadingSlash = false;
            }
        }

        public PathNode(List<String> path) {
            if (path != null && path.size() > 0) {
                this.identifier = path.get(0);
                this.leadingSlash = false;
                this.addPath(path);
            } else {
                this.identifier = null;
                this.leadingSlash = false;
            }
        }

        public List<PathNode> getChildNodes() {
            return this.childNodes;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean hasChildNodes() {
            return this.childNodes.size() > 0;
        }

        public void addPath(String path) {
            this.addPath(this.splitPath(path));
        }

        private void addPath(List<String> split) {
            if (split.size() <= 1) {
                return;
            }
            split.remove(0);
            for (PathNode childNode : this.childNodes) {
                if (!childNode.isSubPath(split)) continue;
                childNode.addPath(split);
                return;
            }
            this.childNodes.add(new PathNode(split));
        }

        public boolean isSubPath(String path) {
            return this.isSubPath(this.splitPath(path));
        }

        public boolean isSubPath(List<String> path) {
            return path.size() > 0 && path.get(0).equals(this.identifier);
        }

        private List<String> splitPath(String path) {
            return Arrays.stream(path.split("[/\\\\]+")).filter(l -> l.length() > 0).collect(Collectors.toList());
        }

        public List<String> getAllPaths() {
            ArrayList<String> paths = new ArrayList<String>();
            if (this.childNodes.size() > 0) {
                for (PathNode childNode : this.childNodes) {
                    childNode.getAllPaths((this.leadingSlash ? "/" : "") + this.identifier, paths);
                }
            } else {
                paths.add((this.leadingSlash ? "/" : "") + this.identifier);
            }
            return paths;
        }

        private void getAllPaths(String current, List<String> paths) {
            current = current + "/" + this.identifier;
            if (this.childNodes.size() > 0) {
                for (PathNode childNode : this.childNodes) {
                    childNode.getAllPaths(current, paths);
                }
            } else {
                paths.add(current);
            }
        }

        public static List<PathNode> makeNodes(Collection<String> paths) {
            ArrayList<PathNode> nodes = new ArrayList<PathNode>();
            for (String path : paths) {
                if (nodes.size() == 0) {
                    nodes.add(new PathNode(path));
                    continue;
                }
                boolean foundMatching = false;
                for (PathNode node : nodes) {
                    if (!node.isSubPath(path)) continue;
                    node.addPath(path);
                    foundMatching = true;
                    break;
                }
                if (foundMatching) continue;
                nodes.add(new PathNode(path));
            }
            return nodes;
        }

        public String toString() {
            return this.identifier;
        }
    }

    private class Status {
        Risk risk;
        String reason;

        public Status(Risk risk, String reason) {
            this.risk = risk;
            this.reason = reason;
        }
    }

    static enum Risk {
        HIGH,
        MEDIUM,
        LOW;

    }
}

