/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.scancode;

import com.metaeffekt.artifact.analysis.scancode.ScanCodeClient;
import com.metaeffekt.artifact.analysis.scancode.ScanRequestResponse;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.utils.ConfigurationDiscovery;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanCodeProcessClient
implements ScanCodeClient {
    private static final Logger LOG = LoggerFactory.getLogger(ScanCodeProcessClient.class);
    private final String numberOfThreads;

    public ScanCodeProcessClient(String numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public ScanRequestResponse scan(String scanPath, String outputFile) throws IOException {
        this.execute("-l", "-c", "-n", this.getScanCodeThreads(), "--only-findings", "--json-pp", outputFile, scanPath);
        if (!FileUtils.exists(outputFile)) {
            throw new IOException(String.format("Output file %s does not exits.", outputFile));
        }
        return new ScanRequestResponse(scanPath, outputFile, UUID.randomUUID());
    }

    private String getScanCodeThreads() {
        return this.numberOfThreads;
    }

    private void execute(String ... parameter) {
        ExecTask execTask = new ExecTask();
        Project project = new Project();
        execTask.setProject(project);
        Commandline command = new Commandline();
        String pathToScancodeToolkit = this.discoverScanCode();
        command.setExecutable(pathToScancodeToolkit);
        Environment.Variable var = new Environment.Variable();
        var.setKey("LC_ALL");
        var.setValue("en_US.UTF-8");
        execTask.addEnv(var);
        LOG.info("executing: {}", (Object)pathToScancodeToolkit);
        var = new Environment.Variable();
        var.setKey("OBJC_DISABLE_INITIALIZE_FORK_SAFETY");
        var.setValue("YES");
        execTask.addEnv(var);
        command.addArguments(parameter);
        execTask.setCommand(command);
        execTask.setLogError(true);
        execTask.setErrorProperty("ae.error");
        execTask.execute();
        String error = project.getProperty("ae.error");
        if (StringUtils.hasText(error)) {
            LOG.error("ScanCode produced error outputs...");
            Arrays.stream(error.split("\\n")).forEach(arg_0 -> ((Logger)LOG).error(arg_0));
        }
    }

    public String discoverScanCode() {
        String pathToScancodeToolkit = System.getProperty("scancode.toolkit.path");
        if (pathToScancodeToolkit != null && new File(pathToScancodeToolkit).exists()) {
            return pathToScancodeToolkit;
        }
        Properties p = ConfigurationDiscovery.discoverLocalProperties();
        String scancodePath = p.getProperty("scancode.toolkit.path");
        if (scancodePath == null || !new File(scancodePath).exists()) {
            LOG.warn("Cannot resolve scancode. Configured path: scancode.toolkit.path={}", (Object)scancodePath);
        }
        return scancodePath;
    }
}

