/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class DirectoryScanner {
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_BASE_DIRECTORY = "baseDirectory";
    public static final String KEY_AMOUNT_FILES = "amount";
    public static final String KEY_FILES = "files";
    public static final String KEY_FILE_PATH = "path";
    public static final String KEY_FILE_CHECKSUM = "checksum";
    public static final String KEY_FILE_SIZE = "size";
    public static final String KEY_DIFFERENCE_TYPE = "type";
    public static final String KEY_DIFFERENCE_AMOUNT_DIFFERENT = "amountChanged";
    public static final String KEY_DIFFERENCE_FILE_REMOVED = "fileRemoved";
    public static final String KEY_DIFFERENCE_FILE_ADDED = "fileAdded";
    public static final String KEY_DIFFERENCE_CHECKSUM_DIFFERENT = "checksumChanged";
    public static final String KEY_DIFFERENCE_PATH_DIFFERENT = "pathChanged";
    public static final String KEY_DIFFERENCE_SIZE_DIFFERENT = "sizeChanged";
    public static final String KEY_DIFFERENCE_AMOUNT_1 = "amount1";
    public static final String KEY_DIFFERENCE_AMOUNT_2 = "amount2";
    public static final String KEY_DIFFERENCE_PATH_1 = "path1";
    public static final String KEY_DIFFERENCE_PATH_2 = "path2";
    public static final String KEY_DIFFERENCE_CHECKSUM_1 = "checksum1";
    public static final String KEY_DIFFERENCE_CHECKSUM_2 = "checksum2";
    public static final String KEY_DIFFERENCE_SIZE_1 = "size1";
    public static final String KEY_DIFFERENCE_SIZE_2 = "size2";

    public static JSONObject scan(File baseDirectory) throws IOException {
        return DirectoryScanner.scan(baseDirectory, new RegexFileFilter("^(.*?)"), DirectoryFileFilter.DIRECTORY, true);
    }

    public static JSONObject scan(File baseDirectory, boolean forceAbsolutePaths) throws IOException {
        return DirectoryScanner.scan(baseDirectory, new RegexFileFilter("^(.*?)"), DirectoryFileFilter.DIRECTORY, forceAbsolutePaths);
    }

    public static JSONObject scan(File baseDirectory, RegexFileFilter regexFileFilter, IOFileFilter directoryFileFilter, boolean forceAbsolutePaths) throws IOException {
        JSONArray fileList = new JSONArray();
        for (File file : FileUtils.listFiles((File)baseDirectory, (IOFileFilter)regexFileFilter, (IOFileFilter)directoryFileFilter).stream().sorted().collect(Collectors.toList())) {
            JSONObject entry = new JSONObject();
            if (forceAbsolutePaths) {
                entry.put(KEY_FILE_PATH, (Object)file.getCanonicalPath());
            } else {
                entry.put(KEY_FILE_PATH, (Object)file.getPath());
            }
            entry.put(KEY_FILE_CHECKSUM, (Object)FileUtils.computeChecksum((File)file));
            entry.put(KEY_FILE_SIZE, file.length());
            fileList.put((Object)entry);
        }
        JSONObject scanResult = new JSONObject();
        scanResult.put(KEY_TIMESTAMP, System.currentTimeMillis());
        scanResult.put(KEY_BASE_DIRECTORY, (Object)baseDirectory.getCanonicalPath());
        scanResult.put(KEY_AMOUNT_FILES, fileList.length());
        scanResult.put(KEY_FILES, (Object)fileList);
        return scanResult;
    }

    public static List<String> extractPathsFromResult(JSONObject scanResult) {
        if (scanResult == null) {
            return new ArrayList<String>();
        }
        JSONArray fileEntries = scanResult.optJSONArray(KEY_FILES);
        if (fileEntries == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < fileEntries.length(); ++i) {
            String path;
            JSONObject entry = fileEntries.optJSONObject(i);
            if (entry == null || (path = entry.optString(KEY_FILE_PATH, null)) == null) continue;
            paths.add(path);
        }
        return paths.stream().distinct().sorted().collect(Collectors.toList());
    }

    public static JSONArray compare(JSONObject scanResult1, JSONObject scanResult2) {
        int i;
        if (scanResult1 == null || scanResult2 == null) {
            return new JSONArray();
        }
        JSONArray fileEntries1 = scanResult1.optJSONArray(KEY_FILES);
        JSONArray fileEntries2 = scanResult2.optJSONArray(KEY_FILES);
        if (fileEntries1 == null || fileEntries2 == null) {
            return new JSONArray();
        }
        JSONArray differences = new JSONArray();
        if (scanResult1.optInt(KEY_AMOUNT_FILES) != scanResult2.optInt(KEY_AMOUNT_FILES)) {
            JSONObject difference = new JSONObject();
            difference.put(KEY_DIFFERENCE_TYPE, (Object)KEY_DIFFERENCE_AMOUNT_DIFFERENT);
            difference.put(KEY_DIFFERENCE_AMOUNT_1, (Object)scanResult1.optString(KEY_AMOUNT_FILES));
            difference.put(KEY_DIFFERENCE_AMOUNT_2, (Object)scanResult2.optString(KEY_AMOUNT_FILES));
            differences.put((Object)difference);
        }
        for (i = 0; i < fileEntries1.length(); ++i) {
            JSONObject entry1 = fileEntries1.optJSONObject(i);
            if (entry1 == null) continue;
            JSONObject entry2 = DirectoryScanner.findEntry(fileEntries2, entry1);
            if (entry2 == null) {
                differences.put((Object)DirectoryScanner.makeDifferenceJson(entry1, KEY_DIFFERENCE_FILE_REMOVED));
                continue;
            }
            fileEntries2.remove(entry2.optInt("index", 0));
            String path1 = entry1.optString(KEY_FILE_PATH, null);
            if (path1 == null) continue;
            if (!entry1.optString(KEY_FILE_CHECKSUM).equals(entry2.optString(KEY_FILE_CHECKSUM))) {
                differences.put((Object)DirectoryScanner.makeDifferenceJson(entry1, entry2, KEY_DIFFERENCE_CHECKSUM_DIFFERENT));
                continue;
            }
            if (!entry1.optString(KEY_FILE_PATH).equals(entry2.optString(KEY_FILE_PATH))) {
                differences.put((Object)DirectoryScanner.makeDifferenceJson(entry1, entry2, KEY_DIFFERENCE_PATH_DIFFERENT));
                continue;
            }
            if (entry1.optString(KEY_FILE_SIZE).equals(entry2.optString(KEY_FILE_SIZE))) continue;
            differences.put((Object)DirectoryScanner.makeDifferenceJson(entry1, entry2, KEY_DIFFERENCE_SIZE_DIFFERENT));
        }
        for (i = 0; i < fileEntries2.length(); ++i) {
            JSONObject entry2 = fileEntries2.optJSONObject(i);
            if (entry2 == null) continue;
            differences.put((Object)DirectoryScanner.makeDifferenceJson(entry2, KEY_DIFFERENCE_FILE_ADDED));
        }
        return differences;
    }

    private static JSONObject makeDifferenceJson(JSONObject entry1, String type) {
        JSONObject difference = new JSONObject();
        difference.put(KEY_DIFFERENCE_TYPE, (Object)type);
        difference.put(KEY_DIFFERENCE_PATH_1, (Object)entry1.optString(KEY_FILE_PATH));
        difference.put(KEY_DIFFERENCE_CHECKSUM_1, (Object)entry1.optString(KEY_FILE_CHECKSUM));
        difference.put(KEY_DIFFERENCE_SIZE_1, (Object)entry1.optString(KEY_FILE_SIZE));
        return difference;
    }

    private static JSONObject makeDifferenceJson(JSONObject entry1, JSONObject entry2, String type) {
        JSONObject difference = new JSONObject();
        difference.put(KEY_DIFFERENCE_TYPE, (Object)type);
        difference.put(KEY_DIFFERENCE_PATH_1, (Object)entry1.optString(KEY_FILE_PATH));
        difference.put(KEY_DIFFERENCE_CHECKSUM_1, (Object)entry1.optString(KEY_FILE_CHECKSUM));
        difference.put(KEY_DIFFERENCE_SIZE_1, (Object)entry1.optString(KEY_FILE_SIZE));
        difference.put(KEY_DIFFERENCE_PATH_2, (Object)entry2.optString(KEY_FILE_PATH));
        difference.put(KEY_DIFFERENCE_CHECKSUM_2, (Object)entry2.optString(KEY_FILE_CHECKSUM));
        difference.put(KEY_DIFFERENCE_SIZE_2, (Object)entry2.optString(KEY_FILE_SIZE));
        return difference;
    }

    private static JSONObject findEntry(JSONArray entries, JSONObject reference) {
        JSONObject entry;
        int i;
        for (i = 0; i < entries.length(); ++i) {
            entry = entries.optJSONObject(i);
            if (entry == null || !entry.optString(KEY_FILE_PATH).equals(reference.optString(KEY_FILE_PATH))) continue;
            entry.put("index", i);
            return entry;
        }
        for (i = 0; i < entries.length(); ++i) {
            entry = entries.optJSONObject(i);
            if (entry == null || !entry.optString(KEY_FILE_CHECKSUM).equals(reference.optString(KEY_FILE_CHECKSUM))) continue;
            entry.put("index", i);
            return entry;
        }
        return null;
    }
}

