/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.output.FileWriterWithEncoding;

public class FileAppendable
implements Appendable {
    private final FileWriterWithEncoding writer;
    private final StringBuilder buffer;
    private final int bufferSize;

    public FileAppendable(File file, Charset encoding, boolean clearFile, int bufferSize) throws IOException {
        if (clearFile && file.exists()) {
            FileUtils.delete((File)file);
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        this.writer = new FileWriterWithEncoding(file, encoding, true);
        this.buffer = new StringBuilder();
        this.bufferSize = bufferSize;
    }

    public FileAppendable(File file, Charset encoding, boolean clearFile) throws IOException {
        this(file, encoding, clearFile, 1024);
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.buffer.append(csq);
        this.flushBufferIfNeeded();
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.buffer.append(csq, start, end);
        this.flushBufferIfNeeded();
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.buffer.append(c);
        this.flushBufferIfNeeded();
        return this;
    }

    private void flushBufferIfNeeded() throws IOException {
        if (this.buffer.length() >= this.bufferSize) {
            this.writer.write(this.buffer.toString());
            this.writer.flush();
            this.buffer.setLength(0);
        }
    }

    public void flush() throws IOException {
        if (this.buffer.length() > 0) {
            this.writer.write(this.buffer.toString());
            this.writer.flush();
            this.buffer.setLength(0);
        }
    }

    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }
}

