/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeCategoryPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.Args;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public abstract class JFreeChartUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JFreeChartUtils.class);

    public static void writeGraphToFile(JFreeChart chart, File file, int width, int height) throws SVGGraphics2DIOException, FileNotFoundException {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new FileNotFoundException("Parent directory of file [" + file.getAbsolutePath() + "] does not exist and cannot be created for writing chart");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Expected file, got directory for writing chart to [" + file.getAbsolutePath() + "]");
        }
        DOMImplementation svgDOM = GenericDOMImplementation.getDOMImplementation();
        Document document = svgDOM.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        svgGenerator.setSVGCanvasSize(new Dimension(width, height));
        chart.draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height), null);
        svgGenerator.stream(file.getAbsolutePath());
    }

    public static void applyDefaultForLineChartAxis(CategoryAxis axis) {
        axis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        axis.setMaximumCategoryLabelWidthRatio(1.3f);
        axis.setLowerMargin(0.0);
        axis.setUpperMargin(0.0);
    }

    public static void applyDefaultForPieChartPlot(PiePlot<?> plot) {
        plot.setLabelGenerator(null);
        plot.setDefaultSectionOutlinePaint((Paint)Color.WHITE);
        plot.setDefaultSectionOutlineStroke((Stroke)new BasicStroke(1.0f));
    }

    public static <T extends Comparable<T>> void addPieChartData(DefaultPieDataset<T> dataset, PiePlot<?> plot, T key, Number value, Color color) {
        dataset.setValue(key, value);
        plot.setSectionPaint(key, (Paint)color);
    }

    public static <T extends Comparable<T>> void addPieChartDataIfNotZero(DefaultPieDataset<T> dataset, PiePlot<?> plot, T key, Number value, Color color) {
        if (value.doubleValue() == 0.0) {
            return;
        }
        dataset.setValue(key, value);
        plot.setSectionPaint(key, (Paint)color);
    }

    public static void setTransparentBackground(JFreeChart chart) {
        if (chart != null) {
            chart.setBackgroundPaint(null);
            if (chart.getPlot() != null) {
                chart.getPlot().setBackgroundPaint(null);
            }
            if (chart.getLegend() != null) {
                chart.getLegend().setBackgroundPaint(null);
            }
            if (chart.getTitle() != null) {
                chart.getTitle().setBackgroundPaint(null);
            }
        }
    }

    public static void removeChartOutline(JFreeChart chart) {
        if (chart != null && chart.getPlot() != null) {
            chart.getPlot().setOutlinePaint(null);
        }
    }

    public static void setPieChartLabelGenerator(JFreeChart chart, boolean pieSectionKey, boolean absoluteValue, boolean percentageValue, Color backgroundPaint, Color foregroundPaint) {
        if (chart != null && chart.getPlot() instanceof PiePlot) {
            PiePlot plot = (PiePlot)chart.getPlot();
            StringBuilder format = new StringBuilder();
            if (pieSectionKey) {
                format.append("{0}");
                if (absoluteValue || percentageValue) {
                    format.append(":");
                }
            }
            if (absoluteValue) {
                format.append(" {1}");
            }
            if (percentageValue) {
                if (absoluteValue) {
                    format.append(" ({2})");
                } else {
                    format.append(" {2}");
                }
            }
            StandardPieSectionLabelGenerator gen = new StandardPieSectionLabelGenerator(format.toString(), (NumberFormat)new DecimalFormat("0"), (NumberFormat)new DecimalFormat("0%"));
            plot.setLabelGenerator((PieSectionLabelGenerator)gen);
            if (backgroundPaint != null) {
                plot.setLabelBackgroundPaint((Paint)backgroundPaint);
            }
            if (foregroundPaint != null) {
                plot.setLabelPaint((Paint)foregroundPaint);
            }
        }
    }

    public static void setFont(JFreeChart chart, Font font) {
        JFreeChartUtils.setFont(chart, font, -1, -1, -1, -1);
    }

    public static void setFont(JFreeChart chart, Font font, int extraLarge, int large, int regular, int small) {
        StandardChartTheme fontApplierTheme = JFreeChartUtils.createFontApplierTheme();
        fontApplierTheme.setExtraLargeFont(font.deriveFont(1, extraLarge == -1 ? 20.0f : (float)extraLarge));
        fontApplierTheme.setLargeFont(font.deriveFont(1, large == -1 ? 14.0f : (float)large));
        fontApplierTheme.setRegularFont(font.deriveFont(0, regular == -1 ? 12.0f : (float)regular));
        fontApplierTheme.setSmallFont(font.deriveFont(0, small == -1 ? 10.0f : (float)small));
        fontApplierTheme.apply(chart);
    }

    private static StandardChartTheme createFontApplierTheme() {
        return new StandardChartTheme("FontApplier"){

            public void apply(JFreeChart chart) {
                TextTitle title = chart.getTitle();
                if (title != null) {
                    title.setFont(this.getExtraLargeFont());
                }
                int subtitleCount = chart.getSubtitleCount();
                for (int i = 0; i < subtitleCount; ++i) {
                    this.applyToTitle(chart.getSubtitle(i));
                }
                Plot plot = chart.getPlot();
                if (plot != null) {
                    this.applyToPlot(plot);
                }
            }

            protected void applyToTitle(Title title) {
                if (title instanceof TextTitle) {
                    TextTitle tt = (TextTitle)title;
                    tt.setFont(this.getLargeFont());
                } else if (title instanceof LegendTitle) {
                    LegendTitle lt = (LegendTitle)title;
                    lt.setItemFont(this.getRegularFont());
                    if (lt.getWrapper() != null) {
                        this.applyToBlockContainer(lt.getWrapper());
                    }
                } else if (title instanceof PaintScaleLegend) {
                    PaintScaleLegend psl = (PaintScaleLegend)title;
                    ValueAxis axis = psl.getAxis();
                    if (axis != null) {
                        this.applyToValueAxis(axis);
                    }
                } else if (title instanceof CompositeTitle) {
                    CompositeTitle ct = (CompositeTitle)title;
                    BlockContainer bc = ct.getContainer();
                    List blocks = bc.getBlocks();
                    for (Object block : blocks) {
                        Block b = (Block)block;
                        if (!(b instanceof Title)) continue;
                        this.applyToTitle((Title)b);
                    }
                }
            }

            protected void applyToBlockContainer(BlockContainer bc) {
                for (Object o : bc.getBlocks()) {
                    Block b = (Block)o;
                    this.applyToBlock(b);
                }
            }

            protected void applyToBlock(Block b) {
                if (b instanceof Title) {
                    this.applyToTitle((Title)b);
                } else if (b instanceof LabelBlock) {
                    LabelBlock lb = (LabelBlock)b;
                    lb.setFont(this.getRegularFont());
                }
            }

            protected void applyToPlot(Plot plot) {
                Args.nullNotPermitted((Object)plot, (String)"plot");
                if (plot instanceof PiePlot) {
                    this.applyToPiePlot((PiePlot)plot);
                } else if (plot instanceof MultiplePiePlot) {
                    this.applyToMultiplePiePlot((MultiplePiePlot)plot);
                } else if (plot instanceof CategoryPlot) {
                    this.applyToCategoryPlot((CategoryPlot)plot);
                } else if (plot instanceof XYPlot) {
                    this.applyToXYPlot((XYPlot)plot);
                } else if (plot instanceof FastScatterPlot) {
                    this.applyToFastScatterPlot((FastScatterPlot)plot);
                } else if (plot instanceof MeterPlot) {
                    this.applyToMeterPlot((MeterPlot)plot);
                } else if (plot instanceof ThermometerPlot) {
                    this.applyToThermometerPlot((ThermometerPlot)plot);
                } else if (plot instanceof SpiderWebPlot) {
                    this.applyToSpiderWebPlot((SpiderWebPlot)plot);
                } else if (plot instanceof PolarPlot) {
                    this.applyToPolarPlot((PolarPlot)plot);
                }
            }

            protected void applyToPiePlot(PiePlot plot) {
                plot.setLabelFont(this.getRegularFont());
            }

            protected void applyToMultiplePiePlot(MultiplePiePlot plot) {
                this.apply(plot.getPieChart());
            }

            protected void applyToCategoryPlot(CategoryPlot plot) {
                CategoryPlot subplot;
                int domainAxisCount = plot.getDomainAxisCount();
                for (int i = 0; i < domainAxisCount; ++i) {
                    CategoryAxis axis = plot.getDomainAxis(i);
                    if (axis == null) continue;
                    this.applyToCategoryAxis(axis);
                }
                int rangeAxisCount = plot.getRangeAxisCount();
                for (int i = 0; i < rangeAxisCount; ++i) {
                    ValueAxis axis = plot.getRangeAxis(i);
                    if (axis == null) continue;
                    this.applyToValueAxis(axis);
                }
                int rendererCount = plot.getRendererCount();
                for (int i = 0; i < rendererCount; ++i) {
                    CategoryItemRenderer r = plot.getRenderer(i);
                    if (r == null) continue;
                    this.applyToCategoryItemRenderer(r);
                }
                if (plot instanceof CombinedDomainCategoryPlot) {
                    CombinedDomainCategoryPlot cp = (CombinedDomainCategoryPlot)plot;
                    for (Object o : cp.getSubplots()) {
                        subplot = (CategoryPlot)o;
                        if (subplot == null) continue;
                        this.applyToPlot((Plot)subplot);
                    }
                }
                if (plot instanceof CombinedRangeCategoryPlot) {
                    CombinedRangeCategoryPlot cp = (CombinedRangeCategoryPlot)plot;
                    for (Object o : cp.getSubplots()) {
                        subplot = (CategoryPlot)o;
                        if (subplot == null) continue;
                        this.applyToPlot((Plot)subplot);
                    }
                }
            }

            protected void applyToXYPlot(XYPlot plot) {
                XYPlot subplot;
                CombinedDomainXYPlot cp;
                int domainAxisCount = plot.getDomainAxisCount();
                for (int i = 0; i < domainAxisCount; ++i) {
                    ValueAxis axis = plot.getDomainAxis(i);
                    if (axis == null) continue;
                    this.applyToValueAxis(axis);
                }
                int rangeAxisCount = plot.getRangeAxisCount();
                for (int i = 0; i < rangeAxisCount; ++i) {
                    ValueAxis axis = plot.getRangeAxis(i);
                    if (axis == null) continue;
                    this.applyToValueAxis(axis);
                }
                int rendererCount = plot.getRendererCount();
                for (int i = 0; i < rendererCount; ++i) {
                    XYItemRenderer r = plot.getRenderer(i);
                    if (r == null) continue;
                    this.applyToXYItemRenderer(r);
                }
                for (Object o : plot.getAnnotations()) {
                    XYAnnotation a = (XYAnnotation)o;
                    this.applyToXYAnnotation(a);
                }
                if (plot instanceof CombinedDomainXYPlot) {
                    cp = (CombinedDomainXYPlot)plot;
                    for (Object o : cp.getSubplots()) {
                        subplot = (XYPlot)o;
                        if (subplot == null) continue;
                        this.applyToPlot((Plot)subplot);
                    }
                }
                if (plot instanceof CombinedRangeXYPlot) {
                    cp = (CombinedRangeXYPlot)plot;
                    for (Object o : cp.getSubplots()) {
                        subplot = (XYPlot)o;
                        if (subplot == null) continue;
                        this.applyToPlot((Plot)subplot);
                    }
                }
            }

            protected void applyToFastScatterPlot(FastScatterPlot plot) {
                ValueAxis yAxis;
                ValueAxis xAxis = plot.getDomainAxis();
                if (xAxis != null) {
                    this.applyToValueAxis(xAxis);
                }
                if ((yAxis = plot.getRangeAxis()) != null) {
                    this.applyToValueAxis(yAxis);
                }
            }

            protected void applyToPolarPlot(PolarPlot plot) {
                plot.setAngleLabelFont(this.getRegularFont());
                ValueAxis axis = plot.getAxis();
                if (axis != null) {
                    this.applyToValueAxis(axis);
                }
            }

            protected void applyToSpiderWebPlot(SpiderWebPlot plot) {
                plot.setLabelFont(this.getRegularFont());
            }

            protected void applyToMeterPlot(MeterPlot plot) {
                plot.setValueFont(this.getLargeFont());
                plot.setTickLabelFont(this.getRegularFont());
            }

            protected void applyToThermometerPlot(ThermometerPlot plot) {
                plot.setValueFont(this.getLargeFont());
                ValueAxis axis = plot.getRangeAxis();
                if (axis != null) {
                    this.applyToValueAxis(axis);
                }
            }

            protected void applyToCategoryAxis(CategoryAxis axis) {
                axis.setLabelFont(this.getLargeFont());
                axis.setTickLabelFont(this.getRegularFont());
                if (axis instanceof SubCategoryAxis) {
                    SubCategoryAxis sca = (SubCategoryAxis)axis;
                    sca.setSubLabelFont(this.getRegularFont());
                }
            }

            protected void applyToValueAxis(ValueAxis axis) {
                axis.setLabelFont(this.getLargeFont());
                axis.setTickLabelFont(this.getRegularFont());
                if (axis instanceof SymbolAxis) {
                    this.applyToSymbolAxis((SymbolAxis)axis);
                }
                if (axis instanceof PeriodAxis) {
                    this.applyToPeriodAxis((PeriodAxis)axis);
                }
            }

            protected void applyToSymbolAxis(SymbolAxis axis) {
            }

            protected void applyToPeriodAxis(PeriodAxis axis) {
                PeriodAxisLabelInfo[] info = axis.getLabelInfo();
                for (int i = 0; i < info.length; ++i) {
                    PeriodAxisLabelInfo n;
                    PeriodAxisLabelInfo e = info[i];
                    info[i] = n = new PeriodAxisLabelInfo(e.getPeriodClass(), e.getDateFormat(), e.getPadding(), this.getRegularFont(), this.getTickLabelPaint(), e.getDrawDividers(), e.getDividerStroke(), e.getDividerPaint());
                }
                axis.setLabelInfo(info);
            }

            protected void applyToAbstractRenderer(AbstractRenderer renderer) {
            }

            protected void applyToCategoryItemRenderer(CategoryItemRenderer renderer) {
                Args.nullNotPermitted((Object)renderer, (String)"renderer");
                if (renderer instanceof AbstractRenderer) {
                    this.applyToAbstractRenderer((AbstractRenderer)renderer);
                }
                renderer.setDefaultItemLabelFont(this.getRegularFont());
            }

            protected void applyToXYItemRenderer(XYItemRenderer renderer) {
                Args.nullNotPermitted((Object)renderer, (String)"renderer");
                if (renderer instanceof AbstractRenderer) {
                    this.applyToAbstractRenderer((AbstractRenderer)renderer);
                }
                renderer.setDefaultItemLabelFont(this.getRegularFont());
            }

            protected void applyToXYAnnotation(XYAnnotation annotation) {
                Args.nullNotPermitted((Object)annotation, (String)"annotation");
                if (annotation instanceof XYTextAnnotation) {
                    XYTextAnnotation xyta = (XYTextAnnotation)annotation;
                    xyta.setFont(this.getSmallFont());
                }
            }
        };
    }
}

