/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.resource.MapSchemaMapper;
import com.networknt.schema.resource.SchemaMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaValidator.class);
    private static final Map<CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling, Set<ValidatorTypeCode>> REGISTERED_IGNORE_JSON_VALIDATION_ERRORS = new HashMap<CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling, Set<ValidatorTypeCode>>();
    private final JsonSchema yamlValidationSchema;
    private final JsonSchema jsonValidationSchema;

    public JsonSchemaValidator(SpecVersion.VersionFlag schemaVersion, String schema) {
        this.yamlValidationSchema = this.getJsonSchemaFactoryForMapper(new ObjectMapper((JsonFactory)new YAMLFactory()), schemaVersion).getSchema(schema);
        this.jsonValidationSchema = this.getJsonSchemaFactoryForMapper(new ObjectMapper(), schemaVersion).getSchema(schema);
    }

    public JsonSchemaValidator(SpecVersion.VersionFlag schemaVersion, InputStream schemaInputStream) throws IOException {
        int len;
        if (schemaInputStream == null) {
            throw new IllegalArgumentException("Schema input stream must not be null.");
        }
        if (schemaVersion == null) {
            throw new IllegalArgumentException("Schema version must not be null.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = schemaInputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        this.yamlValidationSchema = this.getJsonSchemaFactoryForMapper(new ObjectMapper((JsonFactory)new YAMLFactory()), schemaVersion).getSchema((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        this.jsonValidationSchema = this.getJsonSchemaFactoryForMapper(new ObjectMapper(), schemaVersion).getSchema((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    public JsonSchemaValidator(SpecVersion.VersionFlag schemaVersion, File schemaFile) throws IOException {
        this.yamlValidationSchema = this.getJsonSchemaFactoryForMapper(new ObjectMapper((JsonFactory)new YAMLFactory()), schemaVersion).getSchema(Files.newInputStream(schemaFile.toPath(), new OpenOption[0]));
        this.jsonValidationSchema = this.getJsonSchemaFactoryForMapper(new ObjectMapper(), schemaVersion).getSchema(Files.newInputStream(schemaFile.toPath(), new OpenOption[0]));
    }

    private JsonSchemaFactory getJsonSchemaFactoryForMapper(ObjectMapper jsonSchemaMapper, SpecVersion.VersionFlag schemaVersion) {
        HashMap<String, String> referenceMap = new HashMap<String, String>();
        referenceMap.put("https://www.metaeffekt.com/schema/artifact-analysis/latest/artifact-data.json", "resource:/specification/jsonschema/artifact-data.json");
        referenceMap.put("https://www.metaeffekt.com/schema/artifact-analysis/latest/artifact-data-condition.json", "resource:/specification/jsonschema/artifact-data-condition.json");
        referenceMap.put("https://www.metaeffekt.com/schema/artifact-analysis/latest/artifact-fields.json", "resource:/specification/jsonschema/artifact-fields.json");
        referenceMap.put("https://www.metaeffekt.com/schema/artifact-analysis/latest/vulnerability-keywords.json", "resource:/specification/jsonschema/vulnerability-keywords.json");
        referenceMap.put("https://www.metaeffekt.com/schema/artifact-analysis/latest/vulnerability-status-file.json", "resource:/specification/jsonschema/vulnerability-status-file.json");
        referenceMap.put("https://www.metaeffekt.com/schema/artifact-analysis/latest/vulnerability-status.json", "resource:/specification/jsonschema/vulnerability-status.json");
        referenceMap.put("https://www.metaeffekt.com/schema/artifact-analysis/latest/vulnerability-status-validation.json", "resource:/specification/jsonschema/vulnerability-status-validation.json");
        referenceMap.put("https://www.metaeffekt.com/schema/artifact-analysis/latest/curated-versions-matching.json", "resource:/specification/jsonschema/curated-versions-matching.json");
        referenceMap.forEach((key, value) -> {
            if (jsonSchemaMapper.getClass().getClassLoader().getResource(value.replace("resource:/", "")) == null) {
                throw new RuntimeException("Unable to find resource " + value + " for key " + key);
            }
        });
        return JsonSchemaFactory.builder((JsonSchemaFactory)JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)schemaVersion)).jsonMapper(jsonSchemaMapper).schemaMappers(s -> s.add((SchemaMapper)new MapSchemaMapper(referenceMap))).build();
    }

    public Set<ValidationMessage> validateJson(String input) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(input);
        return this.validateJsonNode(null, jsonNode);
    }

    public Set<ValidationMessage> validateJson(File input) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(Files.newInputStream(input.toPath(), new OpenOption[0]));
        return this.validateJsonNode(input, jsonNode);
    }

    public Set<ValidationMessage> validateYaml(File input) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode jsonNode = mapper.readTree(Files.newInputStream(input.toPath(), new OpenOption[0]));
        return this.validateJsonNode(input, jsonNode);
    }

    private Set<ValidationMessage> validateJsonNode(File input, JsonNode jsonNode) throws IOException {
        try {
            return new HashSet<ValidationMessage>(this.yamlValidationSchema.validate(jsonNode));
        }
        catch (JsonSchemaException e) {
            if (input != null) {
                throw new IOException("Unable to validate YAML file " + input.getAbsolutePath() + " due to SSL handshake error. This is most likely an issue with an unregistered objectMapper in the JsonSchemaValidator.", e);
            }
            throw new IOException("Unable to validate YAML due to SSL handshake error. This is most likely an issue with an unregistered objectMapper in the JsonSchemaValidator.", e);
        }
    }

    public static void assertResourceSchemaAppliesToYamlFile(File file, String specificationResourcePath, SpecVersion.VersionFlag specificationVersion, String identifier) {
        JsonSchemaValidator.assertResourceSchemaAppliesToYamlFile(file, specificationResourcePath, specificationVersion, identifier, CentralSecurityPolicyConfiguration.JSON_SCHEMA_VALIDATION_ERRORS_DEFAULT);
    }

    public static void assertResourceSchemaAppliesToYamlFile(File file, String specificationResourcePath, SpecVersion.VersionFlag specificationVersion, String identifier, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling isStrictJsonSchemaValidation) {
        JsonSchemaValidator.assertResourceSchemaAppliesToYamlFile(file, specificationResourcePath, specificationVersion, identifier, REGISTERED_IGNORE_JSON_VALIDATION_ERRORS.getOrDefault(isStrictJsonSchemaValidation, Collections.emptySet()));
    }

    public static void assertResourceSchemaAppliesToYamlFile(File file, String specificationResourcePath, SpecVersion.VersionFlag specificationVersion, String identifier, Set<ValidatorTypeCode> allowErrorCodes) {
        try {
            Set<ValidationMessage> validateMsg = new JsonSchemaValidator(specificationVersion, VulnerabilityStatus.class.getClassLoader().getResourceAsStream(specificationResourcePath)).validateYaml(file);
            Set allowErrorCodesCodes = allowErrorCodes.stream().map(ValidatorTypeCode::getErrorCode).collect(Collectors.toSet());
            validateMsg.removeIf(msg -> {
                if (allowErrorCodesCodes.contains(msg.getCode())) {
                    log.warn("Ignoring schema validation: {} file does not match specification: {} - {}", new Object[]{identifier, file.getAbsolutePath(), msg});
                    return true;
                }
                return false;
            });
            if (!validateMsg.isEmpty()) {
                throw new RuntimeException(identifier + " file does not match specification: " + file.getAbsolutePath() + "\n  " + validateMsg.stream().map(ValidationMessage::toString).collect(Collectors.joining("\n  ")));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse Json Schema for " + identifier, e);
        }
    }

    static {
        REGISTERED_IGNORE_JSON_VALIDATION_ERRORS.put(CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling.LENIENT, new HashSet<ValidatorTypeCode>(Collections.singletonList(ValidatorTypeCode.ADDITIONAL_PROPERTIES)));
        REGISTERED_IGNORE_JSON_VALIDATION_ERRORS.put(CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling.STRICT, new HashSet());
        if (REGISTERED_IGNORE_JSON_VALIDATION_ERRORS.size() != CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling.values().length) {
            log.warn("There are new CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling values that are not handled in the JsonSchemaValidator. Please update the REGISTERED_IGNORE_JSON_VALIDATION_ERRORS map accordingly.");
        }
    }
}

