/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtils.class);

    public static Properties loadProperties(File file) {
        Properties properties = new Properties();
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(file);){
                properties.load(in);
            }
            catch (IOException e) {
                LOG.error("Cannot load '{}'.", (Object)file, (Object)e);
            }
        }
        return properties;
    }

    public static void saveProperties(File file, Properties p) {
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file);){
            p.store(out, null);
        }
        catch (FileNotFoundException e) {
            LOG.error("Cannot save properties to '{}'.", (Object)file, (Object)e);
        }
        catch (IOException e) {
            LOG.error("Cannot save properties to '{}'.", (Object)file, (Object)e);
        }
        try {
            List strings = FileUtils.readLines((File)file, (String)"UTF-8");
            if (strings != null && strings.size() > 0 && ((String)strings.get(0)).startsWith("#")) {
                strings.remove(0);
            }
            FileUtils.writeLines((File)file, (String)"UTF-8", (Collection)strings);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

