/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.tuple.Pair;

public class SvgCreator {
    private final ArrayList<Shape> shapes = new ArrayList();
    private final ArrayList<Def> defs = new ArrayList();
    private final ArrayList<String> fonts = new ArrayList();
    private int startX = 0;
    private int startY = 0;
    private int width = 100;
    private int height = 100;
    private String svgParameters = "";
    public static final String SHAPE_RECTANGLE = "rect";
    public static final String SHAPE_CIRCLE = "circle";
    public static final String SHAPE_ELLIPSE = "ellipse";
    public static final String SHAPE_LINE = "line";
    public static final String SHAPE_POLYGON = "polygon";
    public static final String SHAPE_POLY_LINE = "polyline";
    public static final String SHAPE_TEXT = "text";
    public static final String ATTRIBUTE_FILL_COLOR = "fill";
    public static final String ATTRIBUTE_FILL_OPACITY = "fill-opacity";
    public static final String ATTRIBUTE_STROKE_OPACITY = "stroke-opacity";
    public static final String ATTRIBUTE_OPACITY = "opacity";
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String ATTRIBUTE_VIEWBOX = "viewbox";
    public static final String ATTRIBUTE_STROKE_WIDTH = "stroke-width";
    public static final String ATTRIBUTE_STROKE_COLOR = "stroke";
    public static final String ATTRIBUTE_X = "x";
    public static final String ATTRIBUTE_Y = "y";
    public static final String ATTRIBUTE_CENTER_X = "cx";
    public static final String ATTRIBUTE_CENTER_Y = "cy";
    public static final String ATTRIBUTE_WIDTH = "width";
    public static final String ATTRIBUTE_HEIGHT = "height";
    public static final String ATTRIBUTE_RX = "rx";
    public static final String ATTRIBUTE_RY = "ry";
    public static final String ATTRIBUTE_RADIUS = "r";
    public static final String ATTRIBUTE_XMLNS = "xmlns";
    public static final String ATTRIBUTE_X1 = "x1";
    public static final String ATTRIBUTE_X2 = "x2";
    public static final String ATTRIBUTE_Y1 = "y1";
    public static final String ATTRIBUTE_Y2 = "y2";
    public static final String ATTRIBUTE_POINTS = "points";
    public static final String ATTRIBUTE_GRADIENT_TRANSFORM = "gradientTransform";
    public static final String ATTRIBUTE_OFFSET = "offset";
    public static final String ATTRIBUTE_STOP_COLOR = "stop-color";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_ROTATE = "rotate";
    public static final String ATTRIBUTE_ = "";
    public static final String GRADIENT_LINEAR = "linearGradient";
    public static final String GRADIENT_RADIAL = "radialGradient";
    public static final String GRADIENT_TRANSFORM_TOP_DOWN = "rotate(90)";
    public static final String GRADIENT_TRANSFORM_LEFT_RIGHT = "rotate(360)";
    private static final String PARAMETER_SPLITTER_EXPRESSION = "[=:] ?";

    public void setViewBox(int startX, int startY, int width, int height) {
        this.startX = startX;
        this.startY = startY;
        this.width = width;
        this.height = height;
    }

    public void setSvgParameters(String parameters) {
        this.svgParameters = parameters;
    }

    public void addShape(String identifier, String type, String ... parameters) {
        this.shapes.add(new Shape(identifier, type, parameters));
    }

    public boolean shapeExists(String identifier) {
        return this.getShape(identifier) != null;
    }

    public boolean setShapeParameter(String identifier, String ... parameter) {
        Shape shape = this.getShape(identifier);
        if (shape == null) {
            return false;
        }
        for (String param : parameter) {
            shape.setParameter(param);
        }
        return true;
    }

    public boolean setShapeStyle(String identifier, String ... parameter) {
        Shape shape = this.getShape(identifier);
        if (shape == null) {
            return false;
        }
        for (String param : parameter) {
            shape.setStyle(param);
        }
        return true;
    }

    public void createRectangle(String identifier, int x, int y, int width, int height) {
        this.createRoundedRectangle(identifier, x, y, width, height, -1, -1);
    }

    public void createRoundedRectangle(String identifier, int x, int y, int width, int height, int rx, int ry) {
        Shape shape = new Shape(identifier, SHAPE_RECTANGLE, "x=" + x, "y=" + y, "width=" + width, "height=" + height);
        if (rx != -1) {
            shape.setParameter("rx=" + rx);
        }
        if (ry != -1) {
            shape.setParameter("ry=" + ry);
        }
        this.shapes.add(shape);
    }

    public void createCircle(String identifier, int cx, int cy, int radius) {
        Shape shape = new Shape(identifier, SHAPE_CIRCLE, "cx=" + cx, "cy=" + cy, "r=" + radius);
        this.shapes.add(shape);
    }

    public void createEllipse(String identifier, int cx, int cy, int rx, int ry) {
        Shape shape = new Shape(identifier, SHAPE_ELLIPSE, "cx=" + cx, "cy=" + cy, "rx=" + rx, "ry=" + ry);
        this.shapes.add(shape);
    }

    public void createLine(String identifier, int x1, int y1, int x2, int y2) {
        Shape shape = new Shape(identifier, SHAPE_ELLIPSE, "x1=" + x1, "y1=" + y1, "x2=" + x2, "y2=" + y2, "stroke=black");
        this.shapes.add(shape);
    }

    public void createLine(String identifier, int x1, int y1, int x2, int y2, int width, String color) {
        Shape shape = new Shape(identifier, SHAPE_LINE, "x1=" + x1, "y1=" + y1, "x2=" + x2, "y2=" + y2, "stroke=" + color, "stroke-width=" + width);
        this.shapes.add(shape);
    }

    public void createPolyLine(String identifier) {
        Polygon polygon = new Polygon(identifier, SHAPE_POLY_LINE, new String[0]);
        this.shapes.add(polygon);
    }

    public void createPolygon(String identifier) {
        Polygon polygon = new Polygon(identifier, SHAPE_POLYGON, new String[0]);
        this.shapes.add(polygon);
    }

    public void addPolyPoint(String identifier, int x, int y) {
        Shape polygon = this.getShape(identifier);
        if (polygon instanceof Polygon) {
            ((Polygon)polygon).addPoint(x, y);
        }
    }

    public void createText(String identifier, int x, int y, String text, String fontIdentifier) {
        Text shape = new Text(identifier, SHAPE_TEXT, "x=" + x, "y=" + y);
        shape.setText(text);
        if (fontIdentifier.length() > 0) {
            shape.setParameter("class=" + fontIdentifier);
        }
        this.shapes.add(shape);
    }

    public void setShapeBorder(String identifier, int strokeWidth, String color) {
        Shape shape = this.getShape(identifier);
        shape.setStyle("stroke-width=" + strokeWidth);
        shape.setStyle("stroke=" + (color.contains("#") ? color : "#" + color));
    }

    public void setShapeFillColor(String identifier, String color) {
        Shape shape = this.getShape(identifier);
        shape.setStyle("fill=" + (color.contains("#") ? color : "#" + color));
    }

    public void setShapeGlobalOpacity(String identifier, double opacity) {
        Shape shape = this.getShape(identifier);
        shape.setParameter("opacity=" + opacity);
    }

    public void setShapeFillOpacity(String identifier, double opacity) {
        Shape shape = this.getShape(identifier);
        shape.setParameter("fill-opacity=" + opacity);
    }

    public void setShapeStrokeOpacity(String identifier, double opacity) {
        Shape shape = this.getShape(identifier);
        shape.setParameter("stroke-opacity=" + opacity);
    }

    public Shape getShape(String identifier) {
        for (Shape shape : this.shapes) {
            if (!shape.getIdentifier().equals(identifier)) continue;
            return shape;
        }
        return null;
    }

    public void addDef(String identifier, String type, String ... parameter) {
        this.defs.add(new Def(identifier, type, parameter));
    }

    public void addDefElement(String identifier, String element) {
        for (Def def : this.defs) {
            if (!def.getIdentifier().equals(identifier)) continue;
            def.addElement(element);
        }
    }

    public void createDefLinearGradient(String identifier, String gradientTransform, String ... steps) {
        Def def = new Def(identifier, GRADIENT_LINEAR);
        def.setParameter("gradientTransform=" + gradientTransform);
        for (String step : steps) {
            String[] stepValues = step.split(PARAMETER_SPLITTER_EXPRESSION);
            def.addElement("<stop offset=\"" + stepValues[0] + "\" " + ATTRIBUTE_STOP_COLOR + "=\"" + stepValues[1] + "\"/>");
        }
        this.defs.add(def);
    }

    public void createDefRadialGradient(String identifier, String ... steps) {
        Def def = new Def(identifier, GRADIENT_RADIAL);
        for (String step : steps) {
            String[] stepValues = step.split(PARAMETER_SPLITTER_EXPRESSION);
            def.addElement("<stop offset=\"" + stepValues[0] + "\" " + ATTRIBUTE_STOP_COLOR + "=\"" + stepValues[1] + "\"/>");
        }
        this.defs.add(def);
    }

    public void createFont(String identifier, String font, String color) {
        StringBuilder fontBuilder = new StringBuilder();
        fontBuilder.append(".").append(identifier).append(" { font: ").append(font).append(";");
        if (color.length() > 0) {
            fontBuilder.append(" fill: ").append(color.contains("#") ? color : "#" + color).append("; }");
        }
        this.fonts.add(fontBuilder.toString());
    }

    public void generate(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<svg " + this.svgParameters + " " + ATTRIBUTE_VIEWBOX + "=\"" + this.startX + " " + this.startY + " " + (this.width != -1 ? Integer.valueOf(this.width) : ATTRIBUTE_) + " " + (this.height != -1 ? Integer.valueOf(this.height) : ATTRIBUTE_) + "\" " + ATTRIBUTE_XMLNS + "=\"http://www.w3.org/2000/svg\">");
        for (Def def : this.defs) {
            lines.add(def.generate().replace(" \"", "\"").replace(" />", "/>").replace(" >", ">"));
        }
        if (this.fonts.size() > 0) {
            lines.add("<style>");
            lines.addAll(this.fonts);
            lines.add("</style>");
        }
        for (Shape shape : this.shapes) {
            lines.add(shape.generate().replace(" \"", "\"").replace(" />", "/>").replace(" >", ">"));
        }
        lines.add("</svg>");
        FileUtils.writeLines((File)file, (String)"UTF-8", lines);
    }

    public ArrayList<String> generateSVG() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<svg " + this.svgParameters + " " + ATTRIBUTE_VIEWBOX + "=\"" + this.startX + " " + this.startY + " " + (this.width != -1 ? Integer.valueOf(this.width) : ATTRIBUTE_) + " " + (this.height != -1 ? Integer.valueOf(this.height) : ATTRIBUTE_) + "\" " + ATTRIBUTE_XMLNS + "=\"http://www.w3.org/2000/svg\">");
        for (Def def : this.defs) {
            lines.add(def.generate().replace(" \"", "\"").replace(" />", "/>").replace(" >", ">"));
        }
        if (this.fonts.size() > 0) {
            lines.add("<style>");
            lines.addAll(this.fonts);
            lines.add("</style>");
        }
        for (Shape shape : this.shapes) {
            lines.add(shape.generate().replace(" \"", "\"").replace(" />", "/>").replace(" >", ">"));
        }
        lines.add("</svg>");
        return lines;
    }

    public static String colorToLinkedColor(String identifier) {
        return "url('#" + identifier + "')";
    }

    private static class Text
    extends Shape {
        private String text;

        public Text(String identifier, String type, String ... parameters) {
            super(identifier, type, parameters);
        }

        public Text(String identifier, String type) {
            super(identifier, type);
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String generate() {
            StringBuilder generated = new StringBuilder();
            generated.append("<").append(((Shape)this).type).append(" id=\"").append(((Shape)this).identifier).append("\" ");
            for (Pair parameter : ((Shape)this).parameters) {
                generated.append((String)parameter.getLeft()).append("=\"").append((String)parameter.getRight()).append("\" ");
            }
            if (((Shape)this).style.size() > 0) {
                generated.append("style=\"");
                for (Pair parameter : ((Shape)this).style) {
                    generated.append((String)parameter.getLeft()).append(": ").append((String)parameter.getRight()).append("; ");
                }
                generated.append("\"");
            }
            generated.append(">").append(this.text).append("</text>");
            return generated.toString();
        }
    }

    private static class Def
    extends Shape {
        private final ArrayList<String> elements = new ArrayList();

        public Def(String identifier, String type, String ... parameters) {
            super(identifier, type, parameters);
        }

        public Def(String identifier, String type) {
            super(identifier, type);
        }

        public void addElement(String element) {
            this.elements.add(element);
        }

        @Override
        public String generate() {
            StringBuilder generated = new StringBuilder();
            generated.append("<").append(((Shape)this).type).append(" id=\"").append(((Shape)this).identifier).append("\" ");
            for (Pair parameter : ((Shape)this).parameters) {
                generated.append((String)parameter.getLeft()).append("=\"").append((String)parameter.getRight()).append("\" ");
            }
            if (((Shape)this).style.size() > 0) {
                generated.append("style=\"");
                for (Pair parameter : ((Shape)this).style) {
                    generated.append((String)parameter.getLeft()).append(": ").append((String)parameter.getRight()).append("; ");
                }
                generated.append("\"");
            }
            generated.append(">");
            for (String element : this.elements) {
                generated.append("\n\t").append(element);
            }
            generated.append("\n").append("</").append(((Shape)this).type).append(">");
            return generated.toString();
        }
    }

    private static class Polygon
    extends Shape {
        private final ArrayList<int[]> points = new ArrayList();

        public Polygon(String identifier, String type, String ... parameters) {
            super(identifier, type, parameters);
        }

        public void addPoint(int x, int y) {
            this.points.add(new int[]{x, y});
        }

        @Override
        public String generate() {
            StringBuilder generated = new StringBuilder();
            generated.append("<").append(((Shape)this).type).append(" id=\"").append(((Shape)this).identifier).append("\" ");
            for (Pair parameter : ((Shape)this).parameters) {
                generated.append((String)parameter.getLeft()).append("=\"").append((String)parameter.getRight()).append("\" ");
            }
            if (this.points.size() > 0) {
                generated.append("points=\"");
                for (int[] point : this.points) {
                    generated.append(point[0]).append(",").append(point[1]).append(" ");
                }
                generated.append("\" ");
            }
            if (((Shape)this).style.size() > 0) {
                generated.append("style=\"");
                for (Pair parameter : ((Shape)this).style) {
                    generated.append((String)parameter.getLeft()).append(": ").append((String)parameter.getRight()).append("; ");
                }
                generated.append("\"");
            }
            generated.append("/>");
            return generated.toString();
        }
    }

    private static class Shape {
        private final String identifier;
        private final String type;
        private final ArrayList<Pair<String, String>> parameters = new ArrayList();
        private final ArrayList<Pair<String, String>> style = new ArrayList();

        public Shape(String identifier, String type, String ... parameters) {
            this.identifier = identifier;
            this.type = type;
            for (String parameter : parameters) {
                this.setParameter(parameter);
            }
        }

        public Shape(String identifier, String type) {
            this.identifier = identifier;
            this.type = type;
        }

        public void setParameter(String parameter) {
            String[] setValues = parameter.split(SvgCreator.PARAMETER_SPLITTER_EXPRESSION);
            for (Pair<String, String> param : this.parameters) {
                if (!((String)param.getLeft()).equals(setValues[0])) continue;
                param.setValue((Object)setValues[1]);
            }
            this.parameters.add((Pair<String, String>)Pair.of((Object)setValues[0], (Object)setValues[1]));
        }

        public void removeParameter(String parameter) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (!((String)this.parameters.get(i).getLeft()).equals(parameter)) continue;
                this.parameters.remove(i);
                return;
            }
        }

        public void setStyle(String parameter) {
            String[] setValues = parameter.split(SvgCreator.PARAMETER_SPLITTER_EXPRESSION);
            for (Pair<String, String> param : this.style) {
                if (!((String)param.getLeft()).equals(setValues[0])) continue;
                param.setValue((Object)setValues[1]);
            }
            this.style.add((Pair<String, String>)Pair.of((Object)setValues[0], (Object)setValues[1]));
        }

        public void removeStyle(String parameter) {
            for (int i = 0; i < this.style.size(); ++i) {
                if (!((String)this.style.get(i).getLeft()).equals(parameter)) continue;
                this.style.remove(i);
                return;
            }
        }

        public String generate() {
            StringBuilder generated = new StringBuilder();
            generated.append("<").append(this.type).append(" id=\"").append(this.identifier).append("\" ");
            for (Pair<String, String> parameter : this.parameters) {
                generated.append((String)parameter.getLeft()).append("=\"").append((String)parameter.getRight()).append("\" ");
            }
            if (this.style.size() > 0) {
                generated.append("style=\"");
                for (Pair<String, String> parameter : this.style) {
                    generated.append((String)parameter.getLeft()).append(": ").append((String)parameter.getRight()).append("; ");
                }
                generated.append("\"");
            }
            generated.append("/>");
            return generated.toString();
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

