/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.AllCategorizedPartsVersionImpl;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.version.token.VersionToken;
import com.metaeffekt.artifact.analysis.version.token.VersionTokenType;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.VersionComparator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CommonPartsVersionImpl
extends AllCategorizedPartsVersionImpl {
    public CommonPartsVersionImpl(String version, String update, VersionContext versionContext) {
        super(version, update, versionContext);
    }

    public CommonPartsVersionImpl(String version, VersionContext versionContext) {
        this(version, null, versionContext);
    }

    CommonPartsVersionImpl(String version, String update) {
        super(version, update, VersionContext.EMPTY);
    }

    CommonPartsVersionImpl(String version) {
        this(version, null, VersionContext.EMPTY);
    }

    @Override
    public int compareTo(CommonPartsVersionImpl o) {
        if (o == null) {
            return 1;
        }
        VersionTokenComparison specVersionResult = new VersionTokenComparison(this.specVersion, o.specVersion);
        VersionTokenComparison semVerResult = new VersionTokenComparison(this.semVersion, o.semVersion);
        VersionTokenComparison buildVersionResult = new VersionTokenComparison(this.buildVersion, o.buildVersion);
        VersionTokenComparison versionModifierResult = new VersionTokenComparison(this.versionModifier, o.versionModifier);
        VersionTokenComparison otherVersionPartResult = new VersionTokenComparison(this.otherVersionPart, o.otherVersionPart);
        VersionTokenComparison afterAllPartResult = new VersionTokenComparison(this.afterAllPart, o.afterAllPart);
        List<VersionTokenComparison> nonEmptyParts = VersionTokenComparison.getAllPartsWhereBothAreNonEmpty(specVersionResult, semVerResult, buildVersionResult, versionModifierResult, otherVersionPartResult, afterAllPartResult);
        if (nonEmptyParts.isEmpty()) {
            return 0;
        }
        for (VersionTokenComparison nonEmptyPart : nonEmptyParts) {
            if (nonEmptyPart.getResult() == 0) continue;
            return nonEmptyPart.getResult();
        }
        return 0;
    }

    private static int compareByPart(VersionToken o1, VersionToken o2) {
        boolean is2VersionModifier;
        if (o1 == null || o2 == null) {
            return 0;
        }
        boolean is1VersionModifier = o1.getType() == VersionTokenType.VERSION_MODIFIER;
        boolean bl = is2VersionModifier = o2.getType() == VersionTokenType.VERSION_MODIFIER;
        if (is1VersionModifier && is2VersionModifier) {
            return VersionToken.VERSION_MODIFIER_COMPARATOR_COMMON_PARTS.compare(o1, o2);
        }
        if (!is1VersionModifier && !is2VersionModifier) {
            if (o1.isLettersOnly() || o2.isLettersOnly()) {
                return o1.getValue().compareTo(o2.getValue());
            }
            return VersionComparator.INSTANCE_COMMON_PARTS.compare(o1.getValue(), o2.getValue());
        }
        return is1VersionModifier ? 1 : -1;
    }

    public int getPartsCount() {
        return this.countParts(this.specVersion, this.semVersion, this.buildVersion, this.versionModifier, this.otherVersionPart, this.afterAllPart);
    }

    public int getSemVerPartsCount() {
        return this.semVersion == null || StringUtils.isEmpty(this.semVersion.getValue()) ? 0 : this.semVersion.getValue().split("\\.").length + 1;
    }

    public int getModifierPartsCount() {
        return this.versionModifier == null ? 0 : this.versionModifier.getSubTokenCount();
    }

    private int countParts(VersionToken ... tokens) {
        int count = 0;
        for (VersionToken token : tokens) {
            if (VersionToken.isEmpty(token)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int compareTo(Version o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof CommonPartsVersionImpl) {
            return this.compareTo((CommonPartsVersionImpl)o);
        }
        return this.compareTo(new CommonPartsVersionImpl(o.getVersion(), o.getUpdate()));
    }

    @Override
    public boolean matchesVersionOf(String checkVersion, String checkUpdate, String versionEndIncluding, String versionEndExcluding, String versionStartExcluding, String versionStartIncluding, VersionContext context) {
        if (this.getVersion() != null && this.getUpdate() == null && (this.getVersion().equals("*") || this.getVersion().equals("-"))) {
            return true;
        }
        if ("-".equals(checkVersion) ? StringUtils.hasText(this.getVersion()) && !this.getVersion().equals("*") && !this.getVersion().equals("-") : "-".equals(checkUpdate) && StringUtils.hasText(this.getUpdate()) && !this.getUpdate().equals("*") && !this.getUpdate().equals("-")) {
            return false;
        }
        String normalisedCheckVersion = this.normalizePart(checkVersion);
        String normalisedCheckUpdate = this.normalizePart(checkUpdate);
        boolean hasVsVersion = StringUtils.hasText(normalisedCheckVersion);
        String normalizedCheckUpdateAppendixForRangeLimits = StringUtils.hasText(normalisedCheckUpdate) && !hasVsVersion ? normalisedCheckUpdate : null;
        CommonPartsVersionImpl vsVersion = Version.of(normalisedCheckVersion, normalisedCheckUpdate, context, CommonPartsVersionImpl::new);
        if (hasVsVersion && (vsVersion == null || vsVersion.equals(this))) {
            return true;
        }
        if (this.normalizePart(this.getVersion()) != null) {
            CommonPartsVersionImpl vsVersionStartIncluding;
            CommonPartsVersionImpl vsVersionEndExcluding;
            String normalisedVersionEndIncluding = this.joinIfFirstNonNull(this.normalizePart(versionEndIncluding), normalizedCheckUpdateAppendixForRangeLimits);
            String normalisedVersionEndExcluding = this.joinIfFirstNonNull(this.normalizePart(versionEndExcluding), normalizedCheckUpdateAppendixForRangeLimits);
            String normalisedVersionStartExcluding = this.joinIfFirstNonNull(this.normalizePart(versionStartExcluding), normalizedCheckUpdateAppendixForRangeLimits);
            String normalisedVersionStartIncluding = this.joinIfFirstNonNull(this.normalizePart(versionStartIncluding), normalizedCheckUpdateAppendixForRangeLimits);
            int partsCountThis = this.getPartsCount();
            int semVerPartsCountThis = this.getSemVerPartsCount();
            int modifierPartsCountThis = this.getModifierPartsCount();
            if (normalisedVersionEndIncluding == null && normalisedVersionEndExcluding == null && normalisedVersionStartExcluding == null && normalisedVersionStartIncluding == null) {
                return vsVersion == null || vsVersion.isEmpty();
            }
            CommonPartsVersionImpl vsVersionStartExcluding = Version.of(normalisedVersionStartExcluding, context, CommonPartsVersionImpl::new);
            if (vsVersionStartExcluding != null && vsVersionStartExcluding.isNotEmpty()) {
                int partsCountStartExcluding = vsVersionStartExcluding.getPartsCount();
                int semVerPartsCountStartExcluding = vsVersionStartExcluding.getSemVerPartsCount();
                int modifierPartsCountStartExcluding = vsVersionStartExcluding.getModifierPartsCount();
                if (partsCountThis <= partsCountStartExcluding && modifierPartsCountThis <= modifierPartsCountStartExcluding && semVerPartsCountThis <= semVerPartsCountStartExcluding ? !this.after(vsVersionStartExcluding) : !this.afterOrEqual(vsVersionStartExcluding)) {
                    return false;
                }
            }
            if ((vsVersionEndExcluding = Version.of(normalisedVersionEndExcluding, context, CommonPartsVersionImpl::new)) != null && vsVersionEndExcluding.isNotEmpty()) {
                int partsCountEndExcluding = vsVersionEndExcluding.getPartsCount();
                int semVerPartsCountEndExcluding = vsVersionEndExcluding.getSemVerPartsCount();
                int modifierPartsCountEndExcluding = vsVersionEndExcluding.getModifierPartsCount();
                if (partsCountThis >= partsCountEndExcluding && modifierPartsCountThis >= modifierPartsCountEndExcluding && semVerPartsCountThis >= semVerPartsCountEndExcluding ? !this.before(vsVersionEndExcluding) : !this.beforeOrEqual(vsVersionEndExcluding)) {
                    return false;
                }
            }
            if ((vsVersionStartIncluding = Version.of(StringUtils.nonNull(normalisedVersionStartIncluding, normalisedVersionStartExcluding, normalisedCheckVersion), context, CommonPartsVersionImpl::new)) != null && vsVersionStartIncluding.isNotEmpty() && !this.afterOrEqual(vsVersionStartIncluding)) {
                return false;
            }
            CommonPartsVersionImpl vsVersionEndIncluding = Version.of(StringUtils.nonNull(normalisedVersionEndIncluding, normalisedVersionEndExcluding, normalisedCheckVersion), context, CommonPartsVersionImpl::new);
            if (vsVersionEndIncluding != null && vsVersionEndIncluding.isNotEmpty() && !this.beforeOrEqual(vsVersionEndIncluding)) {
                return false;
            }
        }
        return true;
    }

    private String joinIfFirstNonNull(String str1, String str2) {
        if (StringUtils.hasText(str1)) {
            return str1 + (StringUtils.hasText(str2) ? "_" + str2 : "");
        }
        return null;
    }

    private static class VersionTokenComparison {
        private final boolean isNotEmpty1;
        private final boolean isNotEmpty2;
        private final int result;

        public VersionTokenComparison(VersionToken o1, VersionToken o2) {
            this.isNotEmpty1 = !VersionToken.isEmpty(o1);
            this.isNotEmpty2 = !VersionToken.isEmpty(o2);
            this.result = this.isBothNotEmpty() ? CommonPartsVersionImpl.compareByPart(o1, o2) : 0;
        }

        public boolean isNotEmpty1() {
            return this.isNotEmpty1;
        }

        public boolean isNotEmpty2() {
            return this.isNotEmpty2;
        }

        public int getResult() {
            return this.result;
        }

        public boolean isBothNotEmpty() {
            return this.isNotEmpty1 && this.isNotEmpty2;
        }

        public static List<VersionTokenComparison> getAllPartsWhereBothAreNonEmpty(VersionTokenComparison ... versions) {
            return Arrays.stream(versions).filter(VersionTokenComparison::isBothNotEmpty).collect(Collectors.toList());
        }

        public String toString() {
            return "VersionTokenComparison{isNotEmpty1=" + this.isNotEmpty1 + ", isNotEmpty2=" + this.isNotEmpty2 + ", result=" + this.result + '}';
        }
    }
}

