/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version.token;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.VersionModifier;
import com.metaeffekt.artifact.analysis.version.token.VersionTokenType;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.VersionComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class VersionToken {
    private final String value;
    private final VersionTokenType type;
    private List<VersionToken> subTokens = null;
    public static final Comparator<VersionToken> VERSION_MODIFIER_COMPARATOR = new VersionModifierComparator(false);
    public static final Comparator<VersionToken> VERSION_MODIFIER_COMPARATOR_COMMON_PARTS = new VersionModifierComparator(true);

    public VersionToken(String value, VersionTokenType type) {
        this(value, type, null);
    }

    public VersionToken(String value, VersionTokenType type, VersionToken subToken) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
        this.value = value;
        this.type = type;
        this.addSubToken(subToken);
    }

    public String getValue() {
        return this.value;
    }

    public VersionTokenType getType() {
        return this.type;
    }

    public List<VersionToken> getSubTokens() {
        return this.subTokens;
    }

    public int getSubTokenCount() {
        return this.subTokens != null ? this.subTokens.size() : 0;
    }

    public void addSubToken(VersionToken subToken) {
        if (subToken == null) {
            return;
        }
        if (this.subTokens == null) {
            this.subTokens = new ArrayList<VersionToken>();
        }
        this.subTokens.add(subToken);
    }

    public boolean isComparableByString() {
        return this.isDateNumberOrSemver() || this.isLetteredSubversion();
    }

    public boolean isDateNumberOrSemver() {
        return this.type == VersionTokenType.NUMBER_OR_SEMVER || this.type == VersionTokenType.DATE;
    }

    public boolean isLetteredSubversion() {
        return this.type == VersionTokenType.STRING && (this.value.length() == 1 || this.value.length() == 2 && this.value.startsWith("z"));
    }

    public boolean isLettersOnly() {
        for (int i = 0; i < this.value.length(); ++i) {
            if (Character.isLetter(this.value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public VersionToken deriveToken(String newValue) {
        return new VersionToken(newValue, this.type);
    }

    public String toString() {
        return this.value + (this.subTokens != null && !this.subTokens.isEmpty() ? " " + this.subTokens.stream().map(VersionToken::toString).collect(Collectors.joining(" ")) : "");
    }

    public static boolean isEmpty(VersionToken token) {
        return token == null || StringUtils.isEmpty(token.getValue());
    }

    private static class VersionModifierComparator
    implements Comparator<VersionToken> {
        private final boolean useOnlyCommonParts;

        private VersionModifierComparator(boolean useOnlyCommonParts) {
            this.useOnlyCommonParts = useOnlyCommonParts;
        }

        @Override
        public int compare(VersionToken o1, VersionToken o2) {
            boolean isNullOrEmpty2;
            VersionModifier m2;
            int m2Value;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            VersionModifier m1 = VersionModifier.fromStringName(o1.getValue());
            int m1Value = m1 != null ? m1.getValue() : 0;
            int modifierComparison = Integer.compare(m1Value, m2Value = (m2 = VersionModifier.fromStringName(o2.getValue())) != null ? m2.getValue() : 0);
            if (modifierComparison != 0) {
                return modifierComparison;
            }
            List<VersionToken> subTokens1 = o1.getSubTokens();
            List<VersionToken> subTokens2 = o2.getSubTokens();
            boolean isNullOrEmpty1 = subTokens1 == null || subTokens1.isEmpty();
            boolean bl = isNullOrEmpty2 = subTokens2 == null || subTokens2.isEmpty();
            if (this.useOnlyCommonParts && (isNullOrEmpty1 || isNullOrEmpty2)) {
                return 0;
            }
            if (isNullOrEmpty1 && isNullOrEmpty2) {
                return 0;
            }
            if (isNullOrEmpty1) {
                return -1;
            }
            if (isNullOrEmpty2) {
                return 1;
            }
            int limit = this.useOnlyCommonParts ? Math.min(subTokens1.size(), subTokens2.size()) : Math.max(subTokens1.size(), subTokens2.size());
            for (int i = 0; i < limit; ++i) {
                if (i >= subTokens1.size()) {
                    return -1;
                }
                if (i >= subTokens2.size()) {
                    return 1;
                }
                String value1 = subTokens1.get(i).getValue();
                String value2 = subTokens2.get(i).getValue();
                boolean isLettersOnly1 = subTokens1.get(i).isLettersOnly();
                boolean isLettersOnly2 = subTokens2.get(i).isLettersOnly();
                int subTokenComparison = !isLettersOnly1 && !isLettersOnly2 ? (this.useOnlyCommonParts ? VersionComparator.INSTANCE_COMMON_PARTS : VersionComparator.INSTANCE).compare(value1, value2) : value1.compareTo(value2);
                if (subTokenComparison == 0) continue;
                return subTokenComparison;
            }
            return 0;
        }
    }
}

