/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.correlation;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.WildcardUtilities;
import com.metaeffekt.artifact.analysis.vulnerability.correlation.ArtifactCorrelationEntryMatcher;
import com.metaeffekt.artifact.analysis.vulnerability.correlation.ArtifactCorrelationWarningEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.validation.VulnerabilityStatusValidationEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarningEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ArtifactCorrelationEntry {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactCorrelationEntry.class);
    private final ArtifactCorrelationEntryMatcher matcher;
    private final Map<String, String> appendData;
    private final Map<String, String> removeData;
    private final Map<String, String> overwriteData;
    private final List<String> clearData;
    private final List<ArtifactCorrelationWarningEntry> inventoryWarnings;
    private static final String[][] ALTERNATIVE_KEY_IDENTIFIERS = new String[][]{{InventoryAttribute.INITIAL_CPE_URIS.getKey(), "CPEs", "Initial CPEs"}, {InventoryAttribute.ADDITIONAL_CPE.getKey(), "Additional CPEs", "Addon CPE URIs", "Addon CPEs"}, {InventoryAttribute.INAPPLICABLE_CPE.getKey(), "Inapplicable CPEs"}, {InventoryAttribute.PURL.getKey(), "Package URLs"}, {InventoryAttribute.DT_PURL_FINDINGS.getKey(), "Dependency Track PURL Findings", "DT Package URLs Findings", "DT Package URL Findings"}, {InventoryAttribute.DT_CVE_FINDINGS.getKey(), "Dependency Track CVE Findings", "DT Package Vulnerability Findings", "DT Package Vulnerabilities Findings"}, {InventoryAttribute.MS_PRODUCT_ID.getKey(), "Microsoft Product IDs", "Microsoft IDs"}, {InventoryAttribute.MS_KB_IDENTIFIER.getKey(), "Microsoft Knowledge Base IDs", "Knowledge Base IDs"}, {InventoryAttribute.INAPPLICABLE_CVE.getKey(), "Inapplicable CVEs", "Inapplicable Vulnerabilities", "Inapplicable Vulnerability"}, {InventoryAttribute.ADDON_CVES.getKey(), "Additional CVEs", "Additional Vulnerabilities", "Additional Vulnerability"}, {Artifact.Attribute.VULNERABILITY.getKey(), "Vulnerabilities", "Vulnerability"}, {Artifact.Attribute.ID.getKey(), "IDs", "ID"}, {Artifact.Attribute.URL.getKey(), "Url", "url"}, {Artifact.Attribute.VERSION.getKey(), "Version", "version"}};

    private ArtifactCorrelationEntry(List<Map<String, Object>> affects, List<Map<String, Object>> ignores, List<List<VulnerabilityStatusValidationEntry>> affectsFn, List<List<VulnerabilityStatusValidationEntry>> ignoresFn, Map<String, String> appendData, Map<String, String> removeData, Map<String, String> overwriteData, List<String> clearData, List<ArtifactCorrelationWarningEntry> inventoryWarnings) {
        this.matcher = new ArtifactCorrelationEntryMatcher(affects, ignores, affectsFn, ignoresFn);
        this.appendData = appendData;
        this.removeData = removeData;
        this.overwriteData = overwriteData;
        this.clearData = clearData;
        this.inventoryWarnings = inventoryWarnings;
    }

    private ArtifactCorrelationEntry(ArtifactCorrelationEntryMatcher correlationMatcher, Map<String, String> appendData, Map<String, String> removeData, Map<String, String> overwriteData, List<String> clearData, List<ArtifactCorrelationWarningEntry> inventoryWarnings) {
        this.matcher = correlationMatcher;
        this.appendData = appendData;
        this.removeData = removeData;
        this.overwriteData = overwriteData;
        this.clearData = clearData;
        this.inventoryWarnings = inventoryWarnings;
    }

    public ArtifactCorrelationEntry() {
        this.matcher = new ArtifactCorrelationEntryMatcher();
        this.appendData = new HashMap<String, String>();
        this.removeData = new HashMap<String, String>();
        this.overwriteData = new HashMap<String, String>();
        this.clearData = new ArrayList<String>();
        this.inventoryWarnings = new ArrayList<ArtifactCorrelationWarningEntry>();
    }

    public ArtifactCorrelationEntryMatcher getMatcher() {
        return this.matcher;
    }

    public boolean affects(Artifact artifact) {
        return this.matcher.affects(artifact);
    }

    public void apply(Artifact artifact, Inventory inventory) {
        String key;
        for (Map.Entry<String, String> append : this.appendData.entrySet()) {
            key = this.findArtifactKey(artifact, append.getKey());
            String newValue = artifact.get(key) == null ? Arrays.stream(append.getValue().split(", ")).filter(StringUtils::hasText).distinct().collect(Collectors.joining(", ")) : Arrays.stream((artifact.get(key) + ", " + append.getValue()).split(", ")).filter(StringUtils::hasText).distinct().collect(Collectors.joining(", "));
            if (newValue.isEmpty()) {
                artifact.set(key, null);
                continue;
            }
            artifact.set(key, newValue);
        }
        for (Map.Entry<String, String> remove : this.removeData.entrySet()) {
            key = this.findArtifactKey(artifact, remove.getKey());
            List<String> removeValues = Arrays.asList(remove.getValue().split(", "));
            if (artifact.get(key) == null) continue;
            String newValue = Arrays.stream(artifact.get(key).split(", ")).filter(StringUtils::hasText).filter(v -> !removeValues.contains(v)).distinct().collect(Collectors.joining(", "));
            if (newValue.isEmpty()) {
                artifact.set(key, null);
                continue;
            }
            artifact.set(key, newValue);
        }
        for (Map.Entry<String, String> overwrite : this.overwriteData.entrySet()) {
            key = this.findArtifactKey(artifact, overwrite.getKey());
            artifact.set(key, overwrite.getValue());
        }
        for (String key2 : this.clearData) {
            String artifactKey = this.findArtifactKey(artifact, key2);
            artifact.set(artifactKey, null);
        }
        InventoryWarnings invWarnings = InventoryWarnings.fromInventory(inventory);
        for (ArtifactCorrelationWarningEntry warning : this.inventoryWarnings) {
            if (warning.isAddToArtifacts()) {
                String joinedVulnerabilities = String.join((CharSequence)", ", warning.getAddToVulnerabilities());
                invWarnings.addArtifactWarning(new InventoryWarningEntry<Artifact>(artifact, warning.getWarning() + (!joinedVulnerabilities.isEmpty() ? " (references " + joinedVulnerabilities + ")" : ""), "correlation"));
            }
            for (String addToVulnerability : warning.getAddToVulnerabilities()) {
                VulnerabilityMetaData found = InventoryWarningEntry.VULNERABILITY_META_DATA_FINDABLE.find(addToVulnerability, inventory);
                if (found != null) {
                    invWarnings.addVulnerabilityWarning(new InventoryWarningEntry<VulnerabilityMetaData>(found, warning.getWarning(), "correlation"));
                    continue;
                }
                VulnerabilityMetaData created = InventoryWarningEntry.VULNERABILITY_META_DATA_FINDABLE.create(addToVulnerability);
                inventory.getVulnerabilityMetaData().add(created);
                invWarnings.addVulnerabilityWarning(new InventoryWarningEntry<VulnerabilityMetaData>(created, warning.getWarning(), "correlation"));
            }
        }
    }

    private String findArtifactKey(Artifact artifact, String key) {
        if (artifact.has(key)) {
            return key;
        }
        String[][] stringArray = ALTERNATIVE_KEY_IDENTIFIERS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] alternativeKeySet;
            for (String alternativeKey : alternativeKeySet = stringArray[i]) {
                if (!key.equalsIgnoreCase(alternativeKey) || !artifact.has(alternativeKey)) continue;
                return alternativeKey;
            }
        }
        return key;
    }

    private static String findOfficialKeyName(String key) {
        String[][] stringArray = ALTERNATIVE_KEY_IDENTIFIERS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] alternativeKeySet;
            for (String alternativeKey : alternativeKeySet = stringArray[i]) {
                if (!key.equalsIgnoreCase(alternativeKey)) continue;
                return alternativeKeySet[0];
            }
        }
        return key;
    }

    protected static Map<String, String> transformToStringMap(Object o) {
        if (o == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (o instanceof Map) {
            for (Map.Entry entry : ((Map)o).entrySet()) {
                map.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        return map;
    }

    protected static Map<String, Object> transformWildcards(Map<String, String> map) {
        HashMap<String, Object> transformed = new HashMap<String, Object>();
        map.forEach((key, value) -> transformed.put((String)key, WildcardUtilities.isWildcardPattern(value) ? WildcardUtilities.convertWildcardStringToPattern(value) : value));
        return transformed;
    }

    static List<ArtifactCorrelationEntry> parseFileToYamlDataEntries(File file, Function<Map<Object, Object>, ArtifactCorrelationEntry> creationFunction, boolean silent) throws IOException {
        Object loadedYaml = new Yaml().load(Files.newInputStream(file.toPath(), new OpenOption[0]));
        if (loadedYaml instanceof ArrayList) {
            if (!silent) {
                LOG.info("Loading Artifact Correlation Data YAML file {}", (Object)file.getAbsolutePath());
            }
            ArrayList<ArtifactCorrelationEntry> dataEntries = new ArrayList<ArtifactCorrelationEntry>();
            for (Object entry : (ArrayList)loadedYaml) {
                if (!(entry instanceof Map)) continue;
                ArtifactCorrelationEntry dataEntry = creationFunction.apply((Map)entry);
                dataEntries.add(dataEntry);
            }
            return Collections.unmodifiableList(dataEntries);
        }
        throw new IOException("Unable to parse YAML file [" + file.getAbsolutePath() + "]: Root object is not a list");
    }

    private static List<ArtifactCorrelationWarningEntry> extractWarningEntries(Object warnings) {
        if (warnings != null) {
            if (!(warnings instanceof List)) {
                throw new RuntimeException("Unsupported type for warnings field: [" + warnings + "] --> [" + warnings.getClass() + "]");
            }
            ArrayList<ArtifactCorrelationWarningEntry> warningEntries = new ArrayList<ArtifactCorrelationWarningEntry>();
            for (Object entry : (List)warnings) {
                if (entry instanceof Map) {
                    warningEntries.add(ArtifactCorrelationWarningEntry.fromYamlMap((Map)entry));
                    continue;
                }
                throw new RuntimeException("Unsupported type for warnings: [" + entry + "] --> [" + entry.getClass() + "]");
            }
            return warningEntries;
        }
        return new ArrayList<ArtifactCorrelationWarningEntry>();
    }

    public static ArtifactCorrelationEntry createEntryFromYamlMap(Map<Object, Object> yaml) {
        ArtifactCorrelationEntryMatcher correlationMatcher = ArtifactCorrelationEntryMatcher.createEntryFromYamlMap(yaml);
        Map<String, String> appendData = ArtifactCorrelationEntry.transformToStringMap(yaml.get("append"));
        Map<String, String> removeData = ArtifactCorrelationEntry.transformToStringMap(yaml.get("remove"));
        Map<String, String> overwriteData = ArtifactCorrelationEntry.transformToStringMap(yaml.get("overwrite"));
        List<String> clearData = yaml.getOrDefault("clear", new ArrayList()).stream().map(Object::toString).collect(Collectors.toList());
        List<ArtifactCorrelationWarningEntry> warnings = ArtifactCorrelationEntry.extractWarningEntries(yaml.get("warnings"));
        return new ArtifactCorrelationEntry(correlationMatcher, appendData, removeData, overwriteData, clearData, warnings);
    }

    public static ArtifactCorrelationEntry createEntryFromLegacyYamlMap(Map<Object, Object> yaml) {
        Map<String, String> parsedMap = yaml.entrySet().stream().map(entry -> {
            String key = ArtifactCorrelationEntry.findOfficialKeyName(entry.getKey().toString());
            String value = String.valueOf(entry.getValue());
            return new AbstractMap.SimpleEntry<String, String>(key, value);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        String id = parsedMap.get(Artifact.Attribute.ID.getKey());
        String version = parsedMap.get(Artifact.Attribute.VERSION.getKey());
        ArrayList<Map<String, Object>> affects = new ArrayList<Map<String, Object>>();
        HashMap<String, String> affectsEntry = new HashMap<String, String>();
        affectsEntry.put(Artifact.Attribute.ID.getKey(), id);
        if (version != null) {
            affectsEntry.put(Artifact.Attribute.VERSION.getKey(), version);
        }
        affects.add(affectsEntry);
        HashMap<String, String> overwriteData = new HashMap<String, String>();
        for (Map.Entry<String, String> entry2 : parsedMap.entrySet()) {
            if (entry2.getKey().equals(Artifact.Attribute.ID.getKey()) || entry2.getKey().equals(Artifact.Attribute.VERSION.getKey())) continue;
            overwriteData.put(entry2.getKey(), entry2.getValue());
        }
        ArrayList<Map<String, Object>> ignores = new ArrayList<Map<String, Object>>();
        ArrayList<List<VulnerabilityStatusValidationEntry>> affectsFn = new ArrayList<List<VulnerabilityStatusValidationEntry>>();
        ArrayList<List<VulnerabilityStatusValidationEntry>> ignoresFn = new ArrayList<List<VulnerabilityStatusValidationEntry>>();
        HashMap<String, String> appendData = new HashMap<String, String>();
        HashMap<String, String> removeData = new HashMap<String, String>();
        ArrayList<String> clearData = new ArrayList<String>();
        ArrayList<ArtifactCorrelationWarningEntry> warnings = new ArrayList<ArtifactCorrelationWarningEntry>();
        return new ArtifactCorrelationEntry(affects, ignores, affectsFn, ignoresFn, appendData, removeData, overwriteData, clearData, warnings);
    }

    public Map<String, String> getAppendData() {
        return this.appendData;
    }

    public Map<String, String> getRemoveData() {
        return this.removeData;
    }

    public List<String> getClearData() {
        return this.clearData;
    }

    public Map<String, String> getOverwriteData() {
        return this.overwriteData;
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(" ");
        if (!this.matcher.isEmpty()) {
            sb.add(this.matcher.toString());
        }
        if (sb.length() > 0) {
            sb.add("-->");
        }
        if (!this.appendData.isEmpty()) {
            sb.add("append: " + this.appendData);
        }
        if (!this.removeData.isEmpty()) {
            sb.add("remove: " + this.removeData);
        }
        if (!this.overwriteData.isEmpty()) {
            sb.add("overwrite: " + this.overwriteData);
        }
        if (!this.clearData.isEmpty()) {
            sb.add("clear: " + this.clearData);
        }
        return sb.toString();
    }

    public Map<String, Object> toYamlMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.matcher.toYamlMap());
        if (!this.appendData.isEmpty()) {
            map.put("append", this.appendData);
        }
        if (!this.removeData.isEmpty()) {
            map.put("remove", this.removeData);
        }
        if (!this.overwriteData.isEmpty()) {
            map.put("overwrite", this.overwriteData);
        }
        if (!this.clearData.isEmpty()) {
            map.put("clear", this.clearData);
        }
        return map;
    }
}

