/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.correlation;

import com.metaeffekt.artifact.analysis.vulnerability.correlation.ArtifactCorrelationEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.validation.VulnerabilityStatusValidationEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class ArtifactCorrelationEntryMatcher {
    private final List<Map<String, Object>> affects;
    private final List<Map<String, Object>> ignores;
    private final List<List<VulnerabilityStatusValidationEntry>> affectsFn;
    private final List<List<VulnerabilityStatusValidationEntry>> ignoresFn;

    public ArtifactCorrelationEntryMatcher(List<Map<String, Object>> affects, List<Map<String, Object>> ignores, List<List<VulnerabilityStatusValidationEntry>> affectsFn, List<List<VulnerabilityStatusValidationEntry>> ignoresFn) {
        this.affects = affects;
        this.ignores = ignores;
        this.affectsFn = affectsFn;
        this.ignoresFn = ignoresFn;
    }

    public ArtifactCorrelationEntryMatcher() {
        this.affects = new ArrayList<Map<String, Object>>();
        this.ignores = new ArrayList<Map<String, Object>>();
        this.affectsFn = new ArrayList<List<VulnerabilityStatusValidationEntry>>();
        this.ignoresFn = new ArrayList<List<VulnerabilityStatusValidationEntry>>();
    }

    public void addAffectsEntry(Map<String, Object> affectsEntry) {
        this.affects.add(affectsEntry);
    }

    public boolean affects(Artifact artifact) {
        return !(!this.affects.isEmpty() && !ArtifactCorrelationEntryMatcher.isArtifactAffectedByAnyEntry(artifact, this.affects) || !this.ignores.isEmpty() && ArtifactCorrelationEntryMatcher.isArtifactAffectedByAnyEntry(artifact, this.ignores) || !this.affectsFn.isEmpty() && !this.isArtifactAffectedByAnyEntryFn(artifact, this.affectsFn) || !this.ignoresFn.isEmpty() && this.isArtifactAffectedByAnyEntryFn(artifact, this.ignoresFn));
    }

    public static boolean isArtifactAffectedByAnyEntry(Artifact artifact, List<Map<String, Object>> affects) {
        for (Map<String, Object> affectsMap : affects) {
            boolean isAffected = true;
            for (Map.Entry<String, Object> affect : affectsMap.entrySet()) {
                if (affect.getKey().equalsIgnoreCase("any")) {
                    boolean isAnyAffected = false;
                    for (String attribute : artifact.getAttributes()) {
                        if (!ArtifactCorrelationEntryMatcher.isArtifactAttributeAffectedByPattern(artifact, attribute, affect.getValue())) continue;
                        isAnyAffected = true;
                        break;
                    }
                    if (isAnyAffected) continue;
                    isAffected = false;
                    break;
                }
                if (ArtifactCorrelationEntryMatcher.isArtifactAttributeAffectedByPattern(artifact, affect.getKey(), affect.getValue())) continue;
                isAffected = false;
                break;
            }
            if (!isAffected) continue;
            return true;
        }
        return false;
    }

    private boolean isArtifactAffectedByAnyEntryFn(Artifact artifact, List<List<VulnerabilityStatusValidationEntry>> setsOfEntries) {
        for (List<VulnerabilityStatusValidationEntry> entrySet : setsOfEntries) {
            boolean isAffected = true;
            for (VulnerabilityStatusValidationEntry affect : entrySet) {
                if (affect.validate((AbstractModelBase)artifact)) continue;
                isAffected = false;
                break;
            }
            if (!isAffected) continue;
            return true;
        }
        return false;
    }

    private static boolean isArtifactAttributeAffectedByPattern(Artifact artifact, String key, Object pattern) {
        if (!artifact.has(key)) {
            return false;
        }
        String artifactValueForKey = artifact.get(key);
        if (pattern instanceof Pattern) {
            return ((Pattern)pattern).matcher(artifactValueForKey).matches();
        }
        if (pattern instanceof String) {
            return pattern.equals(artifactValueForKey);
        }
        throw new RuntimeException("Invalid pattern type [" + pattern.getClass().getName() + "] for pattern [" + pattern + "] on key [" + key + "]");
    }

    public List<Map<String, Object>> getAffects() {
        return this.affects;
    }

    public List<Map<String, Object>> getIgnores() {
        return this.ignores;
    }

    public List<List<VulnerabilityStatusValidationEntry>> getAffectsFn() {
        return this.affectsFn;
    }

    public List<List<VulnerabilityStatusValidationEntry>> getIgnoresFn() {
        return this.ignoresFn;
    }

    public boolean isEmpty() {
        return this.affects.isEmpty() && this.ignores.isEmpty() && this.affectsFn.isEmpty() && this.ignoresFn.isEmpty();
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(" ");
        if (!this.affects.isEmpty()) {
            sb.add("append: " + this.affects);
        }
        if (!this.ignores.isEmpty()) {
            sb.add("ignore: " + this.ignores);
        }
        if (!this.affectsFn.isEmpty()) {
            sb.add("appendFn: " + this.affectsFn);
        }
        if (!this.ignoresFn.isEmpty()) {
            sb.add("ignoreFn: " + this.ignoresFn);
        }
        return sb.toString();
    }

    public Map<String, Object> toYamlMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.affects.isEmpty()) {
            map.put("affects", this.affects.stream().map(this::optionalPatternToYamlMapEntry).collect(Collectors.toList()));
        }
        if (!this.ignores.isEmpty()) {
            map.put("ignores", this.ignores.stream().map(this::optionalPatternToYamlMapEntry).collect(Collectors.toList()));
        }
        if (!this.affectsFn.isEmpty()) {
            map.put("affectsFn", this.affectsFn.stream().map(a -> a.stream().map(VulnerabilityStatusValidationEntry::toYamlMap).collect(Collectors.toList())).collect(Collectors.toList()));
        }
        if (!this.ignoresFn.isEmpty()) {
            map.put("ignoresFn", this.ignoresFn.stream().map(a -> a.stream().map(VulnerabilityStatusValidationEntry::toYamlMap).collect(Collectors.toList())).collect(Collectors.toList()));
        }
        return map;
    }

    private Object optionalPatternToYamlMapEntry(Object pattern) {
        if (pattern instanceof Map) {
            HashMap patternMap = new HashMap();
            for (Map.Entry entry : ((Map)pattern).entrySet()) {
                patternMap.put(entry.getKey(), this.optionalPatternToYamlMapEntry(entry.getValue()));
            }
            return patternMap;
        }
        if (pattern instanceof Pattern) {
            Pattern patternInst = (Pattern)pattern;
            StringBuilder flags = new StringBuilder();
            if (patternInst.flags() != 0) {
                if ((patternInst.flags() & 2) != 0) {
                    flags.append("i");
                }
                if ((patternInst.flags() & 8) != 0) {
                    flags.append("m");
                }
                if ((patternInst.flags() & 0x20) != 0) {
                    flags.append("s");
                }
                if ((patternInst.flags() & 0x40) != 0) {
                    flags.append("u");
                }
                if ((patternInst.flags() & 1) != 0) {
                    flags.append("d");
                }
                if ((patternInst.flags() & 4) != 0) {
                    flags.append("x");
                }
            }
            return "/" + patternInst.pattern() + "/" + flags;
        }
        if (pattern instanceof String) {
            return (String)pattern;
        }
        throw new RuntimeException("Invalid pattern type [" + pattern.getClass().getName() + "] for pattern [" + pattern + "]");
    }

    public JSONObject toJson() {
        return new JSONObject(this.toYamlMap());
    }

    public static ArtifactCorrelationEntryMatcher createEntryFromYamlMap(Map<Object, Object> yaml) {
        List<Map<String, Object>> affects = ArtifactCorrelationEntryMatcher.extractAffectsEntries(yaml.get("affects"));
        List<Map<String, Object>> ignores = ArtifactCorrelationEntryMatcher.extractAffectsEntries(yaml.get("ignores"));
        List<List<VulnerabilityStatusValidationEntry>> affectsFn = ArtifactCorrelationEntryMatcher.extractFnEntries(yaml.get("affects-fn"));
        List<List<VulnerabilityStatusValidationEntry>> ignoresFn = ArtifactCorrelationEntryMatcher.extractFnEntries(yaml.get("ignores-fn"));
        return new ArtifactCorrelationEntryMatcher(affects, ignores, affectsFn, ignoresFn);
    }

    public static ArtifactCorrelationEntryMatcher createEntryFromArtifactIdAffects(String affectsId) {
        return new ArtifactCorrelationEntryMatcher(ArtifactCorrelationEntryMatcher.extractAffectsEntries(Collections.singletonList(Collections.singletonMap(Artifact.Attribute.ID.getKey(), affectsId))), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private static List<Map<String, Object>> extractAffectsEntries(Object affectsMapOrList) {
        ArrayList<Map<String, Object>> affects = new ArrayList<Map<String, Object>>();
        if (affectsMapOrList != null) {
            if (affectsMapOrList instanceof List) {
                for (Map entry : (List)affectsMapOrList) {
                    affects.add(ArtifactCorrelationEntry.transformWildcards(ArtifactCorrelationEntry.transformToStringMap(entry)));
                }
            } else if (affectsMapOrList instanceof Map) {
                affects.add(ArtifactCorrelationEntry.transformWildcards(ArtifactCorrelationEntry.transformToStringMap(affectsMapOrList)));
            } else {
                throw new RuntimeException("Unsupported type for affects: [" + affectsMapOrList + "] --> [" + affectsMapOrList.getClass() + "]");
            }
        }
        return affects;
    }

    private static List<List<VulnerabilityStatusValidationEntry>> extractFnEntries(Object affectsList) {
        if (affectsList != null) {
            if (!(affectsList instanceof List)) {
                throw new RuntimeException("Unsupported type for fn field: [" + affectsList + "] --> [" + affectsList.getClass() + "]");
            }
            ArrayList<List<VulnerabilityStatusValidationEntry>> fnEntries = new ArrayList<List<VulnerabilityStatusValidationEntry>>();
            for (Object entries : (List)affectsList) {
                if (entries instanceof List) {
                    fnEntries.add(VulnerabilityStatusValidationEntry.fromYamlList((List)entries));
                    continue;
                }
                if (affectsList instanceof Map) {
                    fnEntries.add(VulnerabilityStatusValidationEntry.fromYamlMap((Map)entries));
                    continue;
                }
                throw new RuntimeException("Unsupported type for affects: [" + entries + "] --> [" + entries.getClass() + "]");
            }
            return fnEntries;
        }
        return new ArrayList<List<VulnerabilityStatusValidationEntry>>();
    }
}

