/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.correlation;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.JsonSchemaValidator;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.correlation.ArtifactCorrelationEntry;
import com.networknt.schema.SpecVersion;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public abstract class ArtifactCorrelationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactCorrelationUtil.class);

    public static void assertAdditionalYamlDataFileValid(File file, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        JsonSchemaValidator.assertResourceSchemaAppliesToYamlFile(file, "specification/jsonschema/artifact-data.json", SpecVersion.VersionFlag.V201909, "Artifact YAML Data", jsonSchemaValidationErrorsHandling);
    }

    public static void assertAdditionalYamlDataLegacyFileValid(File file, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        JsonSchemaValidator.assertResourceSchemaAppliesToYamlFile(file, "specification/jsonschema/artifact-data-legacy.json", SpecVersion.VersionFlag.V201909, "Artifact YAML Data (Legacy)", jsonSchemaValidationErrorsHandling);
    }

    public static List<ArtifactCorrelationEntry> parseDataEntries(File yamlFileOrDirectory) {
        return ArtifactCorrelationUtil.parseDataEntries(yamlFileOrDirectory, false, CentralSecurityPolicyConfiguration.JSON_SCHEMA_VALIDATION_ERRORS_DEFAULT);
    }

    public static List<ArtifactCorrelationEntry> parseDataEntriesSilent(File yamlFileOrDirectory) {
        return ArtifactCorrelationUtil.parseDataEntries(yamlFileOrDirectory, true, CentralSecurityPolicyConfiguration.JSON_SCHEMA_VALIDATION_ERRORS_DEFAULT);
    }

    public static List<ArtifactCorrelationEntry> parseDataEntries(File yamlFileOrDirectory, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        return ArtifactCorrelationUtil.parseDataEntries(yamlFileOrDirectory, false, jsonSchemaValidationErrorsHandling);
    }

    public static List<ArtifactCorrelationEntry> parseDataEntriesSilent(File yamlFileOrDirectory, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        return ArtifactCorrelationUtil.parseDataEntries(yamlFileOrDirectory, true, jsonSchemaValidationErrorsHandling);
    }

    private static List<ArtifactCorrelationEntry> parseDataEntries(File yamlFileOrDirectory, boolean silent, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        return ArtifactCorrelationUtil.parseDataEntriesRetainFiles(yamlFileOrDirectory, silent, jsonSchemaValidationErrorsHandling).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static Map<File, List<ArtifactCorrelationEntry>> parseDataEntriesRetainFiles(File yamlFileOrDirectory, boolean silent, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        HashMap<File, List<ArtifactCorrelationEntry>> entries = new HashMap<File, List<ArtifactCorrelationEntry>>();
        if (yamlFileOrDirectory != null && yamlFileOrDirectory.exists()) {
            if (yamlFileOrDirectory.isDirectory()) {
                for (File file : FileUtils.listFiles((File)yamlFileOrDirectory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)DirectoryFileFilter.DIRECTORY)) {
                    entries.put(file, ArtifactCorrelationUtil.parseDataEntries(file, silent, jsonSchemaValidationErrorsHandling));
                }
            } else if (yamlFileOrDirectory.isFile()) {
                if (yamlFileOrDirectory.getName().endsWith(".yaml")) {
                    try {
                        ArtifactCorrelationUtil.assertAdditionalYamlDataFileValid(yamlFileOrDirectory, jsonSchemaValidationErrorsHandling);
                        entries.put(yamlFileOrDirectory, ArtifactCorrelationEntry.parseFileToYamlDataEntries(yamlFileOrDirectory, ArtifactCorrelationEntry::createEntryFromYamlMap, silent));
                    }
                    catch (Exception parsingException) {
                        try {
                            ArtifactCorrelationUtil.assertAdditionalYamlDataLegacyFileValid(yamlFileOrDirectory, jsonSchemaValidationErrorsHandling);
                            entries.put(yamlFileOrDirectory, ArtifactCorrelationEntry.parseFileToYamlDataEntries(yamlFileOrDirectory, ArtifactCorrelationEntry::createEntryFromLegacyYamlMap, silent));
                        }
                        catch (Exception legacyParsingException) {
                            throw new RuntimeException("Failed to parse correlation YAML file from " + yamlFileOrDirectory.getAbsolutePath() + "\n" + parsingException.getMessage(), parsingException);
                        }
                    }
                } else if (yamlFileOrDirectory.getName().endsWith(".yml")) {
                    LOG.warn("Yaml file [{}] has a .yml extension. Please rename to .yaml", (Object)yamlFileOrDirectory.getAbsolutePath());
                }
            }
        } else {
            LOG.warn("Yaml file or directory is null or does not exists: [{}]", (Object)yamlFileOrDirectory);
        }
        return entries;
    }

    public static void writeDataEntries(File file, List<ArtifactCorrelationEntry> entries) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        String yamlString = yaml.dump(entries.stream().map(ArtifactCorrelationEntry::toYamlMap).collect(Collectors.toList()));
        try {
            Files.write(file.toPath(), yamlString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.error("Could not write yaml file {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    public static void addYamlToInventory(Inventory inventory, File yamlFileOrDirectory) {
        ArtifactCorrelationUtil.addYamlToInventory(inventory, yamlFileOrDirectory, CentralSecurityPolicyConfiguration.JSON_SCHEMA_VALIDATION_ERRORS_DEFAULT);
    }

    public static void addYamlToInventory(Inventory inventory, File yamlFileOrDirectory, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        ArtifactCorrelationUtil.addYamlToInventory(inventory, ArtifactCorrelationUtil.parseDataEntries(yamlFileOrDirectory, jsonSchemaValidationErrorsHandling));
    }

    public static void addYamlToInventory(Inventory inventory, List<ArtifactCorrelationEntry> dataEntries) {
        if (inventory == null) {
            LOG.error("Inventory is null, canceling enrichment");
            return;
        }
        long totalCount = 0L;
        int appliedArtifacts = 0;
        List artifacts = inventory.getArtifacts();
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact artifact = (Artifact)artifacts.get(i);
            long count = dataEntries.stream().filter(d -> d.affects(artifact)).peek(d -> d.apply(artifact, inventory)).count();
            totalCount += count;
            appliedArtifacts += count > 0L ? 1 : 0;
            if (i % 100 != 0 || i <= 0) continue;
            LOG.info("[{} / {}] Applied [{}] entries to [{}] artifacts", new Object[]{i, artifacts.size(), totalCount, appliedArtifacts});
        }
        LOG.info("Applied [{}] entries to [{}] artifacts", (Object)totalCount, (Object)appliedArtifacts);
        CommonEnumerationUtil.distinctAndSortedWithWildcards(inventory);
    }
}

