/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.correlation.transformation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public abstract class TransformationInstruction {
    private List<Map<String, String>> artifactFilter = new ArrayList<Map<String, String>>();

    public TransformationInstruction addArtifactFilter(Map<String, String> filter) {
        this.artifactFilter.add(filter);
        return this;
    }

    public TransformationInstruction addArtifactFilter(Artifact filter) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (String attribute : filter.getAttributes()) {
            data.put(attribute, filter.get(attribute));
        }
        this.artifactFilter.add(data);
        return this;
    }

    public List<Artifact> getArtifacts() {
        if (this.artifactFilter == null || this.artifactFilter.isEmpty()) {
            return new ArrayList<Artifact>();
        }
        return this.artifactFilter.stream().map(data -> {
            Artifact artifact = new Artifact();
            data.forEach((arg_0, arg_1) -> ((Artifact)artifact).set(arg_0, arg_1));
            return artifact;
        }).collect(Collectors.toList());
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.getClass().getSimpleName());
        if (this.artifactFilter != null && !this.artifactFilter.isEmpty()) {
            JSONArray filterArray = new JSONArray();
            for (Map<String, String> filter : this.artifactFilter) {
                JSONObject filterObj = new JSONObject(filter);
                filterArray.put((Object)filterObj);
            }
            json.put("artifactFilter", (Object)filterArray);
        }
        this.addAttributesToJson(json);
        return json;
    }

    protected abstract void addAttributesToJson(JSONObject var1);

    public static TransformationInstruction fromJson(JSONObject json) {
        TransformationInstruction instruction;
        String type;
        switch (type = json.getString("type")) {
            case "RenameOperation": {
                instruction = new RenameOperation(json.getString("selectionPath"), json.getString("newName"));
                break;
            }
            case "SetFieldOperation": {
                instruction = new SetFieldOperation(json.getString("selectionPath"), json.getString("fieldValue"), json.getBoolean("addIfNotPresent"));
                break;
            }
            case "RemoveFieldOperation": {
                instruction = new RemoveFieldOperation(json.getString("selectionPath"));
                break;
            }
            case "ReplaceFieldOperation": {
                instruction = new ReplaceFieldOperation(json.getString("selectionPath"), json.getString("pattern"), json.getString("replacement"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        }
        if (json.has("artifactFilter")) {
            JSONArray filterArray = json.getJSONArray("artifactFilter");
            for (int i = 0; i < filterArray.length(); ++i) {
                JSONObject filterObj = filterArray.getJSONObject(i);
                HashMap<String, String> filterMap = new HashMap<String, String>();
                for (String key : filterObj.keySet()) {
                    filterMap.put(key, filterObj.getString(key));
                }
                instruction.addArtifactFilter(filterMap);
            }
        }
        return instruction;
    }

    public List<Map<String, String>> getArtifactFilter() {
        return this.artifactFilter;
    }

    public static class ReplaceFieldOperation
    extends TransformationInstruction {
        private final String selectionPath;
        private final String pattern;
        private final String replacement;

        @Override
        protected void addAttributesToJson(JSONObject json) {
            json.put("selectionPath", (Object)this.selectionPath);
            json.put("pattern", (Object)this.pattern);
            json.put("replacement", (Object)this.replacement);
        }

        public ReplaceFieldOperation(String selectionPath, String pattern, String replacement) {
            this.selectionPath = selectionPath;
            this.pattern = pattern;
            this.replacement = replacement;
        }

        public String getSelectionPath() {
            return this.selectionPath;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public String toString() {
            return "TransformationInstruction.ReplaceFieldOperation(selectionPath=" + this.getSelectionPath() + ", pattern=" + this.getPattern() + ", replacement=" + this.getReplacement() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceFieldOperation)) {
                return false;
            }
            ReplaceFieldOperation other = (ReplaceFieldOperation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$selectionPath = this.getSelectionPath();
            String other$selectionPath = other.getSelectionPath();
            if (this$selectionPath == null ? other$selectionPath != null : !this$selectionPath.equals(other$selectionPath)) {
                return false;
            }
            String this$pattern = this.getPattern();
            String other$pattern = other.getPattern();
            if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
                return false;
            }
            String this$replacement = this.getReplacement();
            String other$replacement = other.getReplacement();
            return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReplaceFieldOperation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $selectionPath = this.getSelectionPath();
            result = result * 59 + ($selectionPath == null ? 43 : $selectionPath.hashCode());
            String $pattern = this.getPattern();
            result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
            String $replacement = this.getReplacement();
            result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
            return result;
        }
    }

    public static class RemoveFieldOperation
    extends TransformationInstruction {
        private final String selectionPath;

        @Override
        protected void addAttributesToJson(JSONObject json) {
            json.put("selectionPath", (Object)this.selectionPath);
        }

        public RemoveFieldOperation(String selectionPath) {
            this.selectionPath = selectionPath;
        }

        public String getSelectionPath() {
            return this.selectionPath;
        }

        public String toString() {
            return "TransformationInstruction.RemoveFieldOperation(selectionPath=" + this.getSelectionPath() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveFieldOperation)) {
                return false;
            }
            RemoveFieldOperation other = (RemoveFieldOperation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$selectionPath = this.getSelectionPath();
            String other$selectionPath = other.getSelectionPath();
            return !(this$selectionPath == null ? other$selectionPath != null : !this$selectionPath.equals(other$selectionPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveFieldOperation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $selectionPath = this.getSelectionPath();
            result = result * 59 + ($selectionPath == null ? 43 : $selectionPath.hashCode());
            return result;
        }
    }

    public static class SetFieldOperation
    extends TransformationInstruction {
        private final String selectionPath;
        private final String fieldValue;
        private final boolean addIfNotPresent;

        @Override
        protected void addAttributesToJson(JSONObject json) {
            json.put("selectionPath", (Object)this.selectionPath);
            json.put("fieldValue", (Object)this.fieldValue);
            json.put("addIfNotPresent", this.addIfNotPresent);
        }

        public SetFieldOperation(String selectionPath, String fieldValue, boolean addIfNotPresent) {
            this.selectionPath = selectionPath;
            this.fieldValue = fieldValue;
            this.addIfNotPresent = addIfNotPresent;
        }

        public String getSelectionPath() {
            return this.selectionPath;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public boolean isAddIfNotPresent() {
            return this.addIfNotPresent;
        }

        public String toString() {
            return "TransformationInstruction.SetFieldOperation(selectionPath=" + this.getSelectionPath() + ", fieldValue=" + this.getFieldValue() + ", addIfNotPresent=" + this.isAddIfNotPresent() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetFieldOperation)) {
                return false;
            }
            SetFieldOperation other = (SetFieldOperation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.isAddIfNotPresent() != other.isAddIfNotPresent()) {
                return false;
            }
            String this$selectionPath = this.getSelectionPath();
            String other$selectionPath = other.getSelectionPath();
            if (this$selectionPath == null ? other$selectionPath != null : !this$selectionPath.equals(other$selectionPath)) {
                return false;
            }
            String this$fieldValue = this.getFieldValue();
            String other$fieldValue = other.getFieldValue();
            return !(this$fieldValue == null ? other$fieldValue != null : !this$fieldValue.equals(other$fieldValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetFieldOperation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.isAddIfNotPresent() ? 79 : 97);
            String $selectionPath = this.getSelectionPath();
            result = result * 59 + ($selectionPath == null ? 43 : $selectionPath.hashCode());
            String $fieldValue = this.getFieldValue();
            result = result * 59 + ($fieldValue == null ? 43 : $fieldValue.hashCode());
            return result;
        }
    }

    public static class RenameOperation
    extends TransformationInstruction {
        private final String selectionPath;
        private final String newName;

        @Override
        protected void addAttributesToJson(JSONObject json) {
            json.put("selectionPath", (Object)this.selectionPath);
            json.put("newName", (Object)this.newName);
        }

        public RenameOperation(String selectionPath, String newName) {
            this.selectionPath = selectionPath;
            this.newName = newName;
        }

        public String getSelectionPath() {
            return this.selectionPath;
        }

        public String getNewName() {
            return this.newName;
        }

        public String toString() {
            return "TransformationInstruction.RenameOperation(selectionPath=" + this.getSelectionPath() + ", newName=" + this.getNewName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameOperation)) {
                return false;
            }
            RenameOperation other = (RenameOperation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$selectionPath = this.getSelectionPath();
            String other$selectionPath = other.getSelectionPath();
            if (this$selectionPath == null ? other$selectionPath != null : !this$selectionPath.equals(other$selectionPath)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenameOperation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $selectionPath = this.getSelectionPath();
            result = result * 59 + ($selectionPath == null ? 43 : $selectionPath.hashCode());
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }
    }
}

