/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus;

import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class VulnerabilityStatusReviewedEntry
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityStatusReviewedEntry.class);
    private final String id;
    private String comment;
    private final AdvisoryTypeIdentifier<?> advisor;

    public VulnerabilityStatusReviewedEntry(String id, String comment, AdvisoryTypeIdentifier<?> type) {
        this.id = id;
        this.comment = comment;
        if (type == null) {
            Optional<ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>>> response = AdvisoryTypeStore.get().fromEntryIdentifier(id);
            if (!response.isPresent()) {
                LOG.warn("VulnerabilityStatusReviewedEntry: Unable to parse advisor from id [{}]", (Object)id);
                this.advisor = null;
            } else {
                this.advisor = response.get().getIdentifier();
            }
        } else {
            this.advisor = type;
        }
        if (id == null) {
            LOG.warn("VulnerabilityStatusReviewedEntry: Id is null (comment: {}; type: {})", (Object)comment, type);
        }
    }

    public VulnerabilityStatusReviewedEntry(String id, String comment) {
        this(id, comment, null);
    }

    public VulnerabilityStatusReviewedEntry(String id) {
        this(id, null, null);
    }

    public String toString() {
        return this.id + (this.comment != null && !this.comment.isEmpty() ? " (" + this.comment + ")" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VulnerabilityStatusReviewedEntry that = (VulnerabilityStatusReviewedEntry)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public VulnerabilityStatusReviewedEntry clone() {
        return new VulnerabilityStatusReviewedEntry(this.id, this.comment, this.advisor);
    }

    public static List<VulnerabilityStatusReviewedEntry> fromMultipleFormattedStringOrMapEntries(List<?> entries) {
        try {
            ArrayList<VulnerabilityStatusReviewedEntry> parsed = new ArrayList<VulnerabilityStatusReviewedEntry>();
            for (Object entry : entries) {
                if (entry instanceof String) {
                    parsed.add(VulnerabilityStatusReviewedEntry.fromFormattedString(entry.toString()));
                    continue;
                }
                if (!(entry instanceof Map)) continue;
                parsed.add(VulnerabilityStatusReviewedEntry.fromMap((Map)entry));
            }
            return parsed;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse Vulnerability Status Reviewed Advisory Entries from List of Objects: " + entries, e);
        }
    }

    public static VulnerabilityStatusReviewedEntry fromFormattedString(String entry) {
        String comment;
        String id;
        Pattern valueWithOptionalParenthesisPattern = Pattern.compile("^([^(]+)(?: \\(([^)]+)\\))?$");
        Matcher matcher = valueWithOptionalParenthesisPattern.matcher(entry);
        if (matcher.matches()) {
            id = matcher.group(1);
            comment = matcher.groupCount() == 2 ? matcher.group(2) : null;
        } else {
            id = null;
            comment = null;
        }
        return new VulnerabilityStatusReviewedEntry(id, comment);
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        if (this.advisor != null) {
            json.put("advisor", (Object)this.advisor.getName());
            json.put("advisor-implementation", (Object)this.advisor.getImplementation());
        }
        if (this.comment != null) {
            json.put("comment", (Object)this.comment);
        }
        return json;
    }

    public static VulnerabilityStatusReviewedEntry fromMap(Map<String, Object> entry) {
        AdvisoryTypeIdentifier advisory;
        String id = entry.containsKey("id") ? String.valueOf(entry.get("id")) : null;
        String comment = entry.containsKey("comment") ? String.valueOf(entry.get("comment")) : null;
        Object advisor = ObjectUtils.firstNonNull((Object[])new Object[]{entry.get("advisor"), entry.get("cert")});
        Object advisorImplementation = entry.get("advisor-implementation");
        if (advisor == null || StringUtils.isEmpty(String.valueOf(advisor))) {
            Optional<ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>>> response = AdvisoryTypeStore.get().fromEntryIdentifier(id);
            if (!response.isPresent()) {
                LOG.warn("VulnerabilityStatusReviewedEntry: Unable to parse advisor from id [{}]", (Object)id);
                advisory = null;
            } else {
                advisory = response.get().getIdentifier();
            }
        } else {
            advisory = (AdvisoryTypeIdentifier)AdvisoryTypeStore.get().fromNameAndImplementation(String.valueOf(advisor), advisorImplementation == null ? null : String.valueOf(advisorImplementation));
        }
        return new VulnerabilityStatusReviewedEntry(id, comment, advisory);
    }

    public static List<VulnerabilityStatusReviewedEntry> fromJsonArray(JSONArray jsonArray) {
        ArrayList<VulnerabilityStatusReviewedEntry> entries = new ArrayList<VulnerabilityStatusReviewedEntry>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            entries.add(VulnerabilityStatusReviewedEntry.fromMap(jsonObject.toMap()));
        }
        return entries;
    }

    public static List<VulnerabilityStatusReviewedEntry> fromVulnerabilityMetaData(VulnerabilityMetaData vmd) {
        if (vmd.has(InventoryAttribute.REVIEWED_ADVISORIES.getKey())) {
            return VulnerabilityStatusReviewedEntry.fromJsonArray(new JSONArray(vmd.get(InventoryAttribute.REVIEWED_ADVISORIES.getKey())));
        }
        return new ArrayList<VulnerabilityStatusReviewedEntry>();
    }

    public static List<VulnerabilityStatusReviewedEntry> fromVulnerability(Vulnerability vulnerability) {
        if (vulnerability.getAdditionalAttributes().containsKey(InventoryAttribute.REVIEWED_ADVISORIES.getKey())) {
            return VulnerabilityStatusReviewedEntry.fromJsonArray(new JSONArray(vulnerability.getAdditionalAttribute(InventoryAttribute.REVIEWED_ADVISORIES.getKey())));
        }
        return new ArrayList<VulnerabilityStatusReviewedEntry>();
    }

    public static JSONArray toJsonArray(List<VulnerabilityStatusReviewedEntry> entries) {
        return entries.stream().map(VulnerabilityStatusReviewedEntry::toJson).collect(CustomCollectors.toJsonArray());
    }

    public static JSONArray toJsonArray(VulnerabilityStatusReviewedEntry ... entries) {
        return VulnerabilityStatusReviewedEntry.toJsonArray(Arrays.asList(entries));
    }

    public static void appendToVulnerabilityMetaData(VulnerabilityMetaData vmd, List<VulnerabilityStatusReviewedEntry> entries) {
        List<VulnerabilityStatusReviewedEntry> parsed = VulnerabilityStatusReviewedEntry.fromVulnerabilityMetaData(vmd);
        parsed.addAll(entries);
        vmd.set(InventoryAttribute.REVIEWED_ADVISORIES.getKey(), VulnerabilityStatusReviewedEntry.toJsonArray(parsed).toString());
    }

    public static void appendToVulnerability(Vulnerability vulnerability, List<VulnerabilityStatusReviewedEntry> entries) {
        List<VulnerabilityStatusReviewedEntry> parsed = VulnerabilityStatusReviewedEntry.fromVulnerability(vulnerability);
        parsed.addAll(entries);
        vulnerability.setAdditionalAttribute(InventoryAttribute.REVIEWED_ADVISORIES, VulnerabilityStatusReviewedEntry.toJsonArray(parsed).toString());
    }

    public static boolean isReviewedEntry(@NonNull String id, List<VulnerabilityStatusReviewedEntry> advisories) {
        return advisories.stream().anyMatch(a -> id.equals(a.getId()));
    }

    public static VulnerabilityStatusReviewedEntry findReviewedEntry(@NonNull String id, List<VulnerabilityStatusReviewedEntry> advisories) {
        return advisories.stream().filter(a -> id.equals(a.getId())).findFirst().orElse(null);
    }

    public String getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    public AdvisoryTypeIdentifier<?> getAdvisor() {
        return this.advisor;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

