/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.artifact.analysis.cert.PeriodicDataSourcesOperations;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.enrichment.configurations.VulnerabilitiesFromCpeEnrichmentConfiguration;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvisorPeriodicEnrichmentConfiguration
extends VulnerabilitiesFromCpeEnrichmentConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AdvisorPeriodicEnrichmentConfiguration.class);
    private String advisoryProviders = new JSONArray().put((Object)new JSONObject().put("name", (Object)"all").put("implementation", (Object)"all")).toString();
    private String changedSince = "3 months";
    private String changedUntil = "now";
    private boolean filterUnaffected = false;
    private boolean filterUnclassified = false;
    private List<String> includeAdvisoryTypes = new ArrayList<String>(Collections.singletonList("all"));
    private boolean filterUnaffectedVulnerabilities = false;
    private boolean filterVulnerabilitiesWithoutSpecifiedAdvisory = false;
    private String vulnerabilityAdvisoryFilter = new JSONArray().toString();
    private String includeVulnerabilitiesChangedSince = null;
    private String initialInventoryContextName = "initial";
    private List<File> referenceInventories = new ArrayList<File>();
    private final Map<String, Inventory> referenceInventoriesInventories = new HashMap<String, Inventory>();

    public AdvisorPeriodicEnrichmentConfiguration setAdvisoryProviders(Map<String, String> advisoryProviders) {
        JSONArray advisoryProvidersArray = new JSONArray();
        advisoryProviders.forEach((name, implementation) -> advisoryProvidersArray.put((Object)new JSONObject().put("name", name).put("implementation", (Object)(StringUtils.hasText(implementation) ? implementation : name))));
        this.advisoryProviders = advisoryProvidersArray.toString();
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setAdvisoryProviders(JSONArray advisoryProviders) {
        this.advisoryProviders = advisoryProviders.toString();
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setAdvisoryProviders(AdvisoryTypeIdentifier<?> ... advisoryProviders) {
        JSONArray advisoryProvidersArray = new JSONArray();
        Arrays.stream(advisoryProviders).forEach(advisoryTypeIdentifier -> advisoryProvidersArray.put((Object)new JSONObject().put("name", (Object)advisoryTypeIdentifier.getName()).put("implementation", (Object)advisoryTypeIdentifier.getImplementation())));
        this.advisoryProviders = advisoryProvidersArray.toString();
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setChangedSince(String changedSince) {
        this.changedSince = changedSince.toLowerCase();
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setChangedSince(long changedSince) {
        this.changedSince = String.valueOf(changedSince);
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setChangedUntil(String changedUntil) {
        this.changedUntil = changedUntil.toLowerCase();
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setChangedUntil(long changedUntil) {
        this.changedUntil = String.valueOf(changedUntil);
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setIncludeVulnerabilitiesChangedSince(String includeVulnerabilitiesChangedSince) {
        this.includeVulnerabilitiesChangedSince = includeVulnerabilitiesChangedSince.toLowerCase();
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setIncludeVulnerabilitiesChangedSince(long includeVulnerabilitiesChangedSince) {
        this.includeVulnerabilitiesChangedSince = String.valueOf(includeVulnerabilitiesChangedSince);
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setFilterUnaffected(boolean filterUnaffected) {
        this.filterUnaffected = filterUnaffected;
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setFilterUnaffectedVulnerabilities(boolean filterUnaffectedVulnerabilities) {
        this.filterUnaffectedVulnerabilities = filterUnaffectedVulnerabilities;
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setFilterUnclassified(boolean filterUnclassified) {
        this.filterUnclassified = filterUnclassified;
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setFilterVulnerabilitiesWithoutSpecifiedAdvisory(boolean filterVulnerabilitiesWithoutSpecifiedAdvisory) {
        this.filterVulnerabilitiesWithoutSpecifiedAdvisory = filterVulnerabilitiesWithoutSpecifiedAdvisory;
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setVulnerabilityAdvisoryFilter(Map<String, String> vulnerabilityAdvisoryFilter) {
        JSONArray vulnerabilityAdvisoryFilterArray = new JSONArray();
        vulnerabilityAdvisoryFilter.forEach((name, implementation) -> vulnerabilityAdvisoryFilterArray.put((Object)new JSONObject().put("name", name).put("implementation", (Object)(StringUtils.hasText(implementation) ? implementation : name))));
        this.vulnerabilityAdvisoryFilter = vulnerabilityAdvisoryFilterArray.toString();
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setVulnerabilityAdvisoryFilter(JSONArray vulnerabilityAdvisoryFilter) {
        this.vulnerabilityAdvisoryFilter = vulnerabilityAdvisoryFilter.toString();
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setVulnerabilityAdvisoryFilterCI(Collection<AdvisoryTypeIdentifier<?>> vulnerabilityAdvisoryFilter) {
        JSONArray vulnerabilityAdvisoryFilterArray = new JSONArray();
        vulnerabilityAdvisoryFilter.forEach(advisoryTypeIdentifier -> vulnerabilityAdvisoryFilterArray.put((Object)new JSONObject().put("name", (Object)advisoryTypeIdentifier.getName()).put("implementation", (Object)advisoryTypeIdentifier.getImplementation())));
        this.vulnerabilityAdvisoryFilter = vulnerabilityAdvisoryFilterArray.toString();
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setIncludeAdvisoryTypes(List<String> includeAdvisoryTypes) {
        this.includeAdvisoryTypes = includeAdvisoryTypes;
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setReferenceInventories(List<File> referenceInventories) {
        this.referenceInventories = referenceInventories;
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration addReferenceInventory(File referenceInventory) {
        this.referenceInventories.add(referenceInventory);
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration addReferenceInventory(Inventory referenceInventory, String contextName) {
        this.referenceInventoriesInventories.put(contextName, referenceInventory);
        return this;
    }

    public AdvisorPeriodicEnrichmentConfiguration setInitialInventoryContextName(String initialInventoryContextName) {
        this.initialInventoryContextName = initialInventoryContextName;
        return this;
    }

    public List<AdvisoryTypeIdentifier<?>> getAdvisoryProviders() {
        return AdvisorPeriodicEnrichmentConfiguration.parseAdvisoryProviders(this.advisoryProviders);
    }

    public List<String> getIncludeAdvisoryTypes() {
        return this.includeAdvisoryTypes;
    }

    public List<AdvisoryTypeIdentifier<?>> getVulnerabilityAdvisoryFilter() {
        return AdvisorPeriodicEnrichmentConfiguration.parseAdvisoryProviders(this.vulnerabilityAdvisoryFilter);
    }

    public static List<AdvisoryTypeIdentifier<?>> parseAdvisoryProviders(String jsonArrayProviders) {
        return AdvisorPeriodicEnrichmentConfiguration.parseAdvisoryProviders(new JSONArray(jsonArrayProviders));
    }

    public static List<AdvisoryTypeIdentifier<?>> parseAdvisoryProviders(JSONArray providers) {
        if (providers == null || providers.isEmpty()) {
            return AdvisoryTypeStore.get().values();
        }
        List<AdvisoryTypeIdentifier<?>> parsed = AdvisoryTypeStore.get().fromJsonNamesAndImplementations(providers);
        if (parsed.contains(AdvisoryTypeStore.ANY_ADVISORY_FILTER_WILDCARD)) {
            return AdvisoryTypeStore.get().values();
        }
        return parsed;
    }

    public long getChangedSinceTimestamp() {
        return TimeUtils.parseTimeFromInput(this.changedSince);
    }

    public long getChangedUntilTimestamp() {
        return TimeUtils.parseTimeFromInput(this.changedUntil);
    }

    public PeriodicDataSourcesOperations.QueryTimePeriod getAdvisoryQueryPeriod() {
        return new PeriodicDataSourcesOperations.QueryTimePeriod(this.getChangedSinceTimestamp(), this.getChangedUntilTimestamp());
    }

    public long getIncludeVulnerabilitiesChangedSinceTimestamp() {
        return TimeUtils.parseTimeFromInput(this.includeVulnerabilitiesChangedSince);
    }

    public boolean hasInitialInventoryContextName() {
        return StringUtils.hasText(this.initialInventoryContextName) && !this.initialInventoryContextName.equals("none") && !this.initialInventoryContextName.equals("null");
    }

    public Map<String, Inventory> parseReferenceInventories() {
        ArrayList<File> inventoryFiles = new ArrayList<File>();
        for (File referenceInventory : this.referenceInventories) {
            int amountInventoryFilesBefore = inventoryFiles.size();
            if (referenceInventory.isDirectory()) {
                inventoryFiles.addAll(FileUtils.listFiles((File)referenceInventory, (IOFileFilter)new IOFileFilter(){

                    public boolean accept(File file) {
                        return AdvisorPeriodicEnrichmentConfiguration.this.isInventoryFile(file);
                    }

                    public boolean accept(File dir, String name) {
                        return AdvisorPeriodicEnrichmentConfiguration.this.isInventoryFile(new File(dir, name));
                    }
                }, null));
            } else {
                inventoryFiles.add(referenceInventory);
            }
            if (inventoryFiles.size() != amountInventoryFilesBefore) continue;
            LOG.warn("Reference inventory [{}] does not contain any inventory files", (Object)referenceInventory.getAbsolutePath());
        }
        Map<String, Inventory> parsed = this.parseReferenceInventories(inventoryFiles);
        parsed.putAll(this.referenceInventoriesInventories);
        return parsed;
    }

    private Map<String, Inventory> parseReferenceInventories(List<File> files) {
        LinkedHashMap<String, Inventory> inventories = new LinkedHashMap<String, Inventory>();
        for (File referenceInventory : files) {
            if (!referenceInventory.exists()) {
                throw new RuntimeException("Reference inventory does not exist [" + referenceInventory.getAbsolutePath() + "]");
            }
            if (this.isInventoryFile(referenceInventory)) {
                try {
                    LOG.info("Parsing reference inventory [{}]", (Object)referenceInventory.getAbsolutePath());
                    inventories.put(referenceInventory.getName().replace(".xls", "").replace(".xlsx", ""), new InventoryReader().readInventory(referenceInventory));
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read reference inventory [" + referenceInventory.getAbsolutePath() + "]", e);
                }
            }
            LOG.warn("Skipping reference inventory [{}] as it is not an Excel file", (Object)referenceInventory.getAbsolutePath());
        }
        return inventories;
    }

    private boolean isInventoryFile(File file) {
        return file.getName().endsWith(".xls") || file.getName().endsWith(".xlsx");
    }

    @Override
    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> configuration = super.getProperties();
        configuration.put("advisoryProviders", this.advisoryProviders);
        configuration.put("changedSince", this.changedSince);
        configuration.put("changedSinceTimestamp", this.getChangedSinceTimestamp());
        configuration.put("changedUntil", this.changedUntil);
        configuration.put("changedUntilTimestamp", this.getChangedUntilTimestamp());
        configuration.put("includeVulnerabilitiesChangedSince", this.includeVulnerabilitiesChangedSince);
        configuration.put("includeVulnerabilitiesChangedSinceTimestamp", this.getIncludeVulnerabilitiesChangedSinceTimestamp());
        configuration.put("filterUnaffected", this.filterUnaffected);
        configuration.put("filterUnclassified", this.filterUnclassified);
        configuration.put("filterUnaffectedVulnerabilities", this.filterUnaffectedVulnerabilities);
        configuration.put("filterVulnerabilitiesWithoutSpecifiedAdvisory", this.filterVulnerabilitiesWithoutSpecifiedAdvisory);
        configuration.put("vulnerabilityAdvisoryFilter", this.vulnerabilityAdvisoryFilter);
        configuration.put("includeAdvisoryTypes", this.includeAdvisoryTypes);
        configuration.put("referenceInventories", this.referenceInventories.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
        configuration.put("initialInventoryContextName", this.initialInventoryContextName);
        return configuration;
    }

    @Override
    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.setProperties(properties);
        super.loadJsonArrayProperty(properties, "advisoryProviders", this::setAdvisoryProviders);
        super.loadStringProperty(properties, "changedSince", this::setChangedSince);
        super.loadStringProperty(properties, "changedUntil", this::setChangedUntil);
        super.loadStringProperty(properties, "includeVulnerabilitiesChangedSince", this::setIncludeVulnerabilitiesChangedSince);
        super.loadBooleanProperty(properties, "filterUnaffected", this::setFilterUnaffected);
        super.loadBooleanProperty(properties, "filterUnclassified", this::setFilterUnclassified);
        super.loadBooleanProperty(properties, "filterUnaffectedVulnerabilities", this::setFilterUnaffectedVulnerabilities);
        super.loadBooleanProperty(properties, "filterVulnerabilitiesWithoutSpecifiedAdvisory", this::setFilterVulnerabilitiesWithoutSpecifiedAdvisory);
        super.loadJsonArrayProperty(properties, "vulnerabilityAdvisoryFilter", this::setVulnerabilityAdvisoryFilter);
        super.loadListProperty(properties, "includeAdvisoryTypes", String::valueOf, this::setIncludeAdvisoryTypes);
        super.loadStringProperty(properties, "initialInventoryContextName", this::setInitialInventoryContextName);
    }

    @Override
    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        if (this.advisoryProviders == null || this.advisoryProviders.isEmpty()) {
            misconfigurations.add(new ProcessMisconfiguration("advisoryProviders", "Advisory providers are not specified, use 'all' to include all providers"));
        }
        if (StringUtils.isEmpty(this.changedSince)) {
            misconfigurations.add(new ProcessMisconfiguration("changedSince", "Changed since is not specified, use a string like '3 months' or '2023-11-08'"));
        } else if (this.getChangedSinceTimestamp() == 0L) {
            misconfigurations.add(new ProcessMisconfiguration("changedSince", "Changed since is in an invalid format, use a string like '3 months' or '2023-11-08'"));
        }
        if (this.includeAdvisoryTypes == null || this.includeAdvisoryTypes.isEmpty()) {
            misconfigurations.add(new ProcessMisconfiguration("includeAdvisoryTypes", "Include advisory types is not specified, use 'all' to include all types"));
        }
    }

    public boolean isFilterUnaffected() {
        return this.filterUnaffected;
    }

    public boolean isFilterUnclassified() {
        return this.filterUnclassified;
    }

    public boolean isFilterUnaffectedVulnerabilities() {
        return this.filterUnaffectedVulnerabilities;
    }

    public boolean isFilterVulnerabilitiesWithoutSpecifiedAdvisory() {
        return this.filterVulnerabilitiesWithoutSpecifiedAdvisory;
    }

    public String getInitialInventoryContextName() {
        return this.initialInventoryContextName;
    }
}

