/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.artifact.enrichment.validation.InventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.validators.AdditionalCpeIsNotEffectiveInventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.validators.ArtifactAndCpeVersionsDifferGreatlyInventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.validators.MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.validators.VulnerabilityInvalidNameValidator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryValidationEnrichmentConfiguration
extends ProcessConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryValidationEnrichmentConfiguration.class);
    private boolean failOnValidationErrors = false;
    private boolean addAsCorrelationWarnings = true;
    private AdditionalCpeIsNotEffectiveInventoryValidator additionalCpeIsNotEffectiveInventoryValidator;
    private MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator;
    private ArtifactAndCpeVersionsDifferGreatlyInventoryValidator artifactAndCpeVersionsDifferGreatlyInventoryValidator;
    private VulnerabilityInvalidNameValidator vulnerabilityInvalidNameValidator;
    private final List<InventoryValidator> additionalValidators = new ArrayList<InventoryValidator>();

    public InventoryValidationEnrichmentConfiguration setFailOnValidationErrors(boolean failOnValidationErrors) {
        this.failOnValidationErrors = failOnValidationErrors;
        return this;
    }

    public InventoryValidationEnrichmentConfiguration setAdditionalCpeIsNotEffectiveInventoryValidator(AdditionalCpeIsNotEffectiveInventoryValidator additionalCpeIsNotEffectiveInventoryValidator) {
        this.additionalCpeIsNotEffectiveInventoryValidator = additionalCpeIsNotEffectiveInventoryValidator;
        return this;
    }

    public InventoryValidationEnrichmentConfiguration activateAdditionalCpeIsNotEffectiveInventoryValidator() {
        this.additionalCpeIsNotEffectiveInventoryValidator = new AdditionalCpeIsNotEffectiveInventoryValidator();
        return this;
    }

    public InventoryValidationEnrichmentConfiguration setMultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator(MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator) {
        this.multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator = multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator;
        return this;
    }

    public InventoryValidationEnrichmentConfiguration activateMultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator() {
        this.multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator = new MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator();
        return this;
    }

    public InventoryValidationEnrichmentConfiguration setArtifactAndCpeVersionsDifferGreatlyInventoryValidator(ArtifactAndCpeVersionsDifferGreatlyInventoryValidator artifactAndCpeVersionsDifferGreatlyInventoryValidator) {
        this.artifactAndCpeVersionsDifferGreatlyInventoryValidator = artifactAndCpeVersionsDifferGreatlyInventoryValidator;
        return this;
    }

    public InventoryValidationEnrichmentConfiguration activateArtifactAndCpeVersionsDifferGreatlyInventoryValidator() {
        this.artifactAndCpeVersionsDifferGreatlyInventoryValidator = new ArtifactAndCpeVersionsDifferGreatlyInventoryValidator();
        return this;
    }

    public InventoryValidationEnrichmentConfiguration setVulnerabilityInvalidNameValidator(VulnerabilityInvalidNameValidator vulnerabilityInvalidNameValidator) {
        this.vulnerabilityInvalidNameValidator = vulnerabilityInvalidNameValidator;
        return this;
    }

    public InventoryValidationEnrichmentConfiguration activateVulnerabilityInvalidNameValidator() {
        this.vulnerabilityInvalidNameValidator = new VulnerabilityInvalidNameValidator();
        return this;
    }

    public InventoryValidationEnrichmentConfiguration addAdditionalValidator(InventoryValidator validator) {
        this.additionalValidators.add(validator);
        return this;
    }

    public InventoryValidationEnrichmentConfiguration setValidator(InventoryValidator validator) {
        if (validator == null) {
            return this;
        }
        if (validator instanceof VulnerabilityInvalidNameValidator) {
            this.vulnerabilityInvalidNameValidator = (VulnerabilityInvalidNameValidator)validator;
        } else if (validator instanceof ArtifactAndCpeVersionsDifferGreatlyInventoryValidator) {
            this.artifactAndCpeVersionsDifferGreatlyInventoryValidator = (ArtifactAndCpeVersionsDifferGreatlyInventoryValidator)validator;
        } else if (validator instanceof MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator) {
            this.multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator = (MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator)validator;
        } else if (validator instanceof AdditionalCpeIsNotEffectiveInventoryValidator) {
            this.additionalCpeIsNotEffectiveInventoryValidator = (AdditionalCpeIsNotEffectiveInventoryValidator)validator;
        } else {
            throw new IllegalArgumentException("Unknown validator type: " + validator.getClass().getName());
        }
        return this;
    }

    public List<InventoryValidator> buildValidators() {
        ArrayList<InventoryValidator> validators = new ArrayList<InventoryValidator>();
        if (this.additionalCpeIsNotEffectiveInventoryValidator != null) {
            validators.add(this.additionalCpeIsNotEffectiveInventoryValidator);
        }
        if (this.multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator != null) {
            validators.add(this.multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator);
        }
        if (this.artifactAndCpeVersionsDifferGreatlyInventoryValidator != null) {
            validators.add(this.artifactAndCpeVersionsDifferGreatlyInventoryValidator);
        }
        if (this.vulnerabilityInvalidNameValidator != null) {
            validators.add(this.vulnerabilityInvalidNameValidator);
        }
        validators.addAll(this.additionalValidators);
        return validators;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> configuration = new LinkedHashMap<String, Object>();
        for (InventoryValidator validator : this.buildValidators()) {
            configuration.put(this.getValidatorPropertyName(validator), validator.getProperties());
        }
        configuration.put("failOnValidationErrors", this.failOnValidationErrors);
        configuration.put("addAsCorrelationWarnings", this.addAsCorrelationWarnings);
        return configuration;
    }

    private String getValidatorPropertyName(InventoryValidator validator) {
        if (validator instanceof AdditionalCpeIsNotEffectiveInventoryValidator) {
            return "additionalCpeIsNotEffectiveInventoryValidator";
        }
        if (validator instanceof MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator) {
            return "multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator";
        }
        if (validator instanceof ArtifactAndCpeVersionsDifferGreatlyInventoryValidator) {
            return "artifactAndCpeVersionsDifferGreatlyInventoryValidator";
        }
        if (validator instanceof VulnerabilityInvalidNameValidator) {
            return "vulnerabilityInvalidNameValidator";
        }
        throw new IllegalArgumentException("Unknown validator: " + validator);
    }

    private InventoryValidator constructValidator(String validatorName) {
        switch (validatorName) {
            case "additionalCpeIsNotEffectiveInventoryValidator": {
                return new AdditionalCpeIsNotEffectiveInventoryValidator();
            }
            case "multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator": {
                return new MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator();
            }
            case "artifactAndCpeVersionsDifferGreatlyInventoryValidator": {
                return new ArtifactAndCpeVersionsDifferGreatlyInventoryValidator();
            }
            case "vulnerabilityInvalidNameValidator": {
                return new VulnerabilityInvalidNameValidator();
            }
        }
        return null;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        Object addAsCorrelationWarnings;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String validatorName = entry.getKey();
            Object validatorProperties = entry.getValue();
            InventoryValidator validator = this.constructValidator(validatorName);
            if (validator != null) {
                validator.setProperties((LinkedHashMap)validatorProperties);
            }
            this.setValidator(validator);
        }
        Object failOnValidationErrors = properties.get("failOnValidationErrors");
        if (failOnValidationErrors != null) {
            this.failOnValidationErrors = (Boolean)failOnValidationErrors;
        }
        if ((addAsCorrelationWarnings = properties.get("addAsCorrelationWarnings")) != null) {
            this.addAsCorrelationWarnings = (Boolean)addAsCorrelationWarnings;
        }
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
    }

    public boolean isFailOnValidationErrors() {
        return this.failOnValidationErrors;
    }

    public boolean isAddAsCorrelationWarnings() {
        return this.addAsCorrelationWarnings;
    }

    public void setAddAsCorrelationWarnings(boolean addAsCorrelationWarnings) {
        this.addAsCorrelationWarnings = addAsCorrelationWarnings;
    }

    public AdditionalCpeIsNotEffectiveInventoryValidator getAdditionalCpeIsNotEffectiveInventoryValidator() {
        return this.additionalCpeIsNotEffectiveInventoryValidator;
    }

    public MultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator getMultipleArtifactsAndVersionsOnVulnerabilityInventoryValidator() {
        return this.multipleArtifactsAndVersionsOnVulnerabilityInventoryValidator;
    }

    public ArtifactAndCpeVersionsDifferGreatlyInventoryValidator getArtifactAndCpeVersionsDifferGreatlyInventoryValidator() {
        return this.artifactAndCpeVersionsDifferGreatlyInventoryValidator;
    }

    public VulnerabilityInvalidNameValidator getVulnerabilityInvalidNameValidator() {
        return this.vulnerabilityInvalidNameValidator;
    }
}

