/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.enrichment.configurations.VadDetailLevelMatcher;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;

public class VadDetailLevelConfiguration
extends ProcessConfiguration {
    public static final VadDetailLevelConfiguration DEFAULT_DETAIL_LEVEL = new VadDetailLevelConfiguration();
    private VadDetailLevelMatcher matcher = new VadDetailLevelMatcher();
    private boolean timeline = true;
    private boolean advisoriesGlobal = true;
    private boolean advisoriesReferences = true;
    private boolean references = true;
    private boolean eolDate = true;
    private List<String> advisoryByTypes = new ArrayList<String>();
    private List<String> advisoryByProviders = new ArrayList<String>();

    public VadDetailLevelConfiguration() {
        this.advisoryByTypes.add("any");
        this.advisoryByProviders.add("any");
    }

    public VadDetailLevelConfiguration setMatcher(VadDetailLevelMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    public VadDetailLevelMatcher getMatcher() {
        return this.matcher;
    }

    public boolean isTimeline() {
        return this.timeline;
    }

    public boolean isAdvisoriesGlobal() {
        return this.advisoriesGlobal;
    }

    public boolean isAdvisoriesReferences() {
        return this.advisoriesReferences;
    }

    public List<String> getAdvisoryByTypes() {
        return this.advisoryByTypes;
    }

    public boolean isAdvisoryTypeEnabled(String advisoryType) {
        return this.advisoriesGlobal && (this.advisoryByTypes.contains(advisoryType) || CentralSecurityPolicyConfiguration.isAny((String)advisoryType) || CentralSecurityPolicyConfiguration.containsAny(this.advisoryByTypes));
    }

    public List<String> getAdvisoryByProviders() {
        return this.advisoryByProviders;
    }

    public boolean isAdvisoryProviderEnabled(String advisoryProvider) {
        return this.advisoriesGlobal && (this.advisoryByProviders.contains(advisoryProvider) || CentralSecurityPolicyConfiguration.isAny((String)advisoryProvider) || CentralSecurityPolicyConfiguration.containsAny(this.advisoryByProviders));
    }

    public boolean isAdvisoryProviderEnabled(AdvisoryTypeIdentifier<?> advisoryProvider) {
        return this.isAdvisoryProviderEnabled(advisoryProvider.name()) || this.isAdvisoryProviderEnabled(advisoryProvider.getWellFormedName());
    }

    public boolean isReferences() {
        return this.references;
    }

    public boolean isEolDate() {
        return this.eolDate;
    }

    public VadDetailLevelConfiguration setTimeline(boolean timeline) {
        this.timeline = timeline;
        return this;
    }

    public VadDetailLevelConfiguration setAdvisoriesGlobal(boolean advisoriesGlobal) {
        this.advisoriesGlobal = advisoriesGlobal;
        return this;
    }

    public VadDetailLevelConfiguration setAdvisoriesReferences(boolean advisoriesReferences) {
        this.advisoriesReferences = advisoriesReferences;
        return this;
    }

    public VadDetailLevelConfiguration setAdvisoryByTypes(List<String> advisoryByTypes) {
        this.advisoryByTypes = advisoryByTypes;
        return this;
    }

    public VadDetailLevelConfiguration setAdvisoryByProviders(List<String> advisoryByProviders) {
        this.advisoryByProviders = advisoryByProviders;
        return this;
    }

    public VadDetailLevelConfiguration setReferences(boolean references) {
        this.references = references;
        return this;
    }

    public void setEolDate(boolean eolDate) {
        this.eolDate = eolDate;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("matcher", this.matcher == null ? null : this.matcher.getProperties());
        properties.put("timeline", this.timeline);
        properties.put("references", this.references);
        properties.put("advisoriesGlobal", this.advisoriesGlobal);
        properties.put("advisoriesReferences", this.advisoriesReferences);
        properties.put("advisoryByTypes", this.advisoryByTypes);
        properties.put("advisoryByProviders", this.advisoryByProviders);
        properties.put("eolDate", this.eolDate);
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadBooleanProperty(properties, "timeline", this::setTimeline);
        super.loadBooleanProperty(properties, "references", this::setReferences);
        super.loadBooleanProperty(properties, "advisoriesGlobal", this::setAdvisoriesGlobal);
        super.loadBooleanProperty(properties, "advisoriesReferences", this::setAdvisoriesReferences);
        super.loadBooleanProperty(properties, "eolDate", this::setEolDate);
        super.loadListProperty(properties, "advisoryByTypes", String::valueOf, this::setAdvisoryByTypes);
        super.loadListProperty(properties, "advisoryByProviders", String::valueOf, this::setAdvisoryByProviders);
        if (properties.containsKey("matcher")) {
            this.matcher = new VadDetailLevelMatcher();
            this.matcher.setProperties((LinkedHashMap)properties.get("matcher"));
        }
        super.loadSubConfiguration(properties, "matcher", VadDetailLevelMatcher::new, this::setMatcher);
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        if (this.matcher == null) {
            misconfigurations.add(new ProcessMisconfiguration("matcher", "matcher is not set"));
        } else {
            this.matcher.collectMisconfigurations(misconfigurations);
        }
    }

    public static List<VadDetailLevelConfiguration> fromArtifacts(Set<Artifact> artifacts) {
        return artifacts.stream().map(VadDetailLevelConfiguration::fromArtifact).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<VadDetailLevelConfiguration> fromArtifact(Artifact artifact) {
        String configString = artifact.getComplete(InventoryAttribute.VAD_DETAIL_LEVEL_CONFIGURATIONS.getKey());
        if (configString == null) {
            return new ArrayList<VadDetailLevelConfiguration>();
        }
        return VadDetailLevelConfiguration.fromConfigurationString(configString);
    }

    public static List<VadDetailLevelConfiguration> fromConfigurationString(String configString) {
        int i;
        List lines = Arrays.stream(configString.split("\n")).map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.toList());
        ArrayList<VadDetailLevelConfiguration> configurations = new ArrayList<VadDetailLevelConfiguration>();
        StringBuilder matcherBuilder = new StringBuilder(" ");
        StringBuilder detailsBuilder = new StringBuilder(" ");
        ArrayList<String> matcherLines = new ArrayList<String>();
        ArrayList<String> detailsLines = new ArrayList<String>();
        boolean inMatcher = true;
        for (i = 0; i < lines.size(); ++i) {
            String line2 = (String)lines.get(i);
            if (line2.startsWith("matcher:")) {
                inMatcher = true;
                matcherBuilder.append(line2);
                if (detailsBuilder.length() <= 1) continue;
                detailsLines.add(detailsBuilder.toString());
                detailsBuilder.setLength(0);
                continue;
            }
            if (line2.startsWith("detail:")) {
                inMatcher = false;
                detailsBuilder.append(line2);
                if (matcherBuilder.length() <= 1) continue;
                matcherLines.add(matcherBuilder.toString());
                matcherBuilder.setLength(0);
                continue;
            }
            if (inMatcher) {
                matcherBuilder.append(line2);
                continue;
            }
            detailsBuilder.append(line2);
        }
        if (matcherBuilder.length() > 1) {
            matcherLines.add(matcherBuilder.toString());
        }
        if (detailsBuilder.length() > 1) {
            detailsLines.add(detailsBuilder.toString());
        }
        if (matcherLines.size() != detailsLines.size()) {
            throw new IllegalArgumentException("Invalid configuration string, number of matcher lines (" + matcherLines.size() + ") does not match number of detail lines (" + detailsLines.size() + ")");
        }
        for (i = 0; i < matcherLines.size(); ++i) {
            String matcherLine = ((String)matcherLines.get(i)).trim();
            String detailsLine = ((String)detailsLines.get(i)).trim();
            if (!detailsLine.startsWith("detail:")) {
                throw new IllegalArgumentException("Invalid configuration string, expected 'detail:' but got '" + detailsLine + "'");
            }
            String trimmedPropertiesString = detailsLine.substring("detail:".length()).trim();
            Map<String, String> properties = VadDetailLevelConfiguration.extractPropertiesFromConfigLine(trimmedPropertiesString);
            VadDetailLevelConfiguration configuration = new VadDetailLevelConfiguration();
            VadDetailLevelMatcher matcher = VadDetailLevelMatcher.fromConfigurationString(matcherLine);
            configuration.setMatcher(matcher);
            VadDetailLevelConfiguration.setBooleanProperty(properties, "timeline", configuration::setTimeline);
            VadDetailLevelConfiguration.setBooleanProperty(properties, "references", configuration::setReferences);
            VadDetailLevelConfiguration.setBooleanProperty(properties, "advisoriesGlobal", configuration::setAdvisoriesGlobal);
            VadDetailLevelConfiguration.setBooleanProperty(properties, "advisoriesReferences", configuration::setAdvisoriesReferences);
            VadDetailLevelConfiguration.setBooleanProperty(properties, "eolDate", configuration::setEolDate);
            if (properties.containsKey("advisoryByTypes")) {
                configuration.setAdvisoryByTypes(Arrays.asList(properties.get("advisoryByTypes").split(", ")));
            }
            if (properties.containsKey("advisoryByProviders")) {
                configuration.setAdvisoryByProviders(Arrays.asList(properties.get("advisoryByProviders").split(", ")));
            }
            configurations.add(configuration);
        }
        return configurations;
    }

    private static void setBooleanProperty(Map<String, String> properties, String propertyName, Consumer<Boolean> setter) {
        if (properties.containsKey(propertyName)) {
            setter.accept(Boolean.parseBoolean(properties.get(propertyName)));
        }
    }

    protected static Map<String, String> extractPropertiesFromConfigLine(String configLine) {
        HashMap<String, String> properties = new HashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean inKey = true;
        boolean inString = false;
        for (int i = 0; i < configLine.length(); ++i) {
            char c = configLine.charAt(i);
            if (inString) {
                if (c == '\"') {
                    inString = false;
                    continue;
                }
                if (c == '\\' && i + 1 < configLine.length() && configLine.charAt(i + 1) == '\"') {
                    value.append('\"');
                    ++i;
                    continue;
                }
                value.append(c);
                continue;
            }
            if (c == '\"') {
                inString = true;
                continue;
            }
            if (c == ' ') continue;
            if (c == '=') {
                inKey = false;
                continue;
            }
            if (c == ';') {
                properties.put(key.toString().trim(), value.toString().trim());
                key.setLength(0);
                value.setLength(0);
                inKey = true;
                continue;
            }
            if (inKey) {
                key.append(c);
                continue;
            }
            value.append(c);
        }
        if (inKey && !configLine.endsWith(";")) {
            throw new IllegalArgumentException("Invalid configuration string, string ended with unterminated key '" + configLine + "'");
        }
        if (inString) {
            throw new IllegalArgumentException("Invalid configuration string, string ended with unterminated string value '" + configLine + "'");
        }
        if (key.length() > 0) {
            properties.put(key.toString().trim(), value.toString().trim());
        }
        return properties;
    }

    public static VadDetailLevelConfiguration computeEffective(Collection<VadDetailLevelConfiguration> levels) {
        if (levels == null || levels.isEmpty()) {
            return DEFAULT_DETAIL_LEVEL;
        }
        VadDetailLevelConfiguration effective = new VadDetailLevelConfiguration();
        for (VadDetailLevelConfiguration level : levels) {
            effective.setTimeline(effective.isTimeline() && level.isTimeline());
            effective.setReferences(effective.isReferences() && level.isReferences());
            effective.setAdvisoriesGlobal(effective.isAdvisoriesGlobal() && level.isAdvisoriesGlobal());
            effective.setAdvisoriesReferences(effective.isAdvisoriesReferences() && level.isAdvisoriesReferences());
            effective.setEolDate(effective.isEolDate() && level.isEolDate());
            effective.getAdvisoryByTypes().retainAll(level.getAdvisoryByTypes());
            effective.getAdvisoryByProviders().retainAll(level.getAdvisoryByProviders());
        }
        return effective;
    }
}

