/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;

public class VulnerabilityAssessmentDashboardDetailLevelConfiguration
extends ProcessConfiguration {
    private boolean timeline = true;
    private boolean advisoriesGlobal = true;
    private boolean advisoriesReferences = true;
    private boolean references = true;
    private boolean eol = true;
    private List<String> advisoryByTypes = new ArrayList<String>();
    private List<String> advisoryByProviders = new ArrayList<String>();

    public VulnerabilityAssessmentDashboardDetailLevelConfiguration() {
        this.advisoryByTypes.add("any");
        this.advisoryByProviders.add("any");
    }

    public boolean isTimeline() {
        return this.timeline;
    }

    public boolean isAdvisoriesGlobal() {
        return this.advisoriesGlobal;
    }

    public boolean isAdvisoriesReferences() {
        return this.advisoriesReferences;
    }

    public List<String> getAdvisoryByTypes() {
        return this.advisoryByTypes;
    }

    public boolean isAdvisoryTypeEnabled(String advisoryType) {
        return this.advisoryByTypes.contains(advisoryType) || CentralSecurityPolicyConfiguration.isAny((String)advisoryType) || CentralSecurityPolicyConfiguration.containsAny(this.advisoryByTypes);
    }

    public List<String> getAdvisoryByProviders() {
        return this.advisoryByProviders;
    }

    public boolean isAdvisoryProviderEnabled(String advisoryProvider) {
        return this.advisoryByProviders.contains(advisoryProvider) || CentralSecurityPolicyConfiguration.isAny((String)advisoryProvider) || CentralSecurityPolicyConfiguration.containsAny(this.advisoryByProviders);
    }

    public boolean isAdvisoryProviderEnabled(AdvisoryTypeIdentifier<?> advisoryProvider) {
        return this.isAdvisoryProviderEnabled(advisoryProvider.name()) || this.isAdvisoryProviderEnabled(advisoryProvider.getWellFormedName());
    }

    public boolean isReferences() {
        return this.references;
    }

    public boolean isEol() {
        return this.eol;
    }

    public VulnerabilityAssessmentDashboardDetailLevelConfiguration setTimeline(boolean timeline) {
        this.timeline = timeline;
        return this;
    }

    public VulnerabilityAssessmentDashboardDetailLevelConfiguration setAdvisoriesGlobal(boolean advisoriesGlobal) {
        this.advisoriesGlobal = advisoriesGlobal;
        return this;
    }

    public VulnerabilityAssessmentDashboardDetailLevelConfiguration setAdvisoriesReferences(boolean advisoriesReferences) {
        this.advisoriesReferences = advisoriesReferences;
        return this;
    }

    public VulnerabilityAssessmentDashboardDetailLevelConfiguration setAdvisoryByTypes(List<String> advisoryByTypes) {
        this.advisoryByTypes = advisoryByTypes;
        return this;
    }

    public VulnerabilityAssessmentDashboardDetailLevelConfiguration setAdvisoryByProviders(List<String> advisoryByProviders) {
        this.advisoryByProviders = advisoryByProviders;
        return this;
    }

    public VulnerabilityAssessmentDashboardDetailLevelConfiguration setReferences(boolean references) {
        this.references = references;
        return this;
    }

    public void setEol(boolean eol) {
        this.eol = eol;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("timeline", this.timeline);
        properties.put("references", this.references);
        properties.put("advisoriesGlobal", this.advisoriesGlobal);
        properties.put("advisoriesReferences", this.advisoriesReferences);
        properties.put("advisoryByTypes", this.advisoryByTypes);
        properties.put("advisoryByProviders", this.advisoryByProviders);
        properties.put("eol", this.eol);
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadBooleanProperty(properties, "timeline", this::setTimeline);
        super.loadBooleanProperty(properties, "references", this::setReferences);
        super.loadBooleanProperty(properties, "advisoriesGlobal", this::setAdvisoriesGlobal);
        super.loadBooleanProperty(properties, "advisoriesReferences", this::setAdvisoriesReferences);
        super.loadListProperty(properties, "advisoryByTypes", String::valueOf, this::setAdvisoryByTypes);
        super.loadListProperty(properties, "advisoryByProviders", String::valueOf, this::setAdvisoryByProviders);
        super.loadBooleanProperty(properties, "eol", this::setEol);
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
    }
}

