/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.KeywordSet;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.VulnerabilityKeywords;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;

public class VulnerabilityKeywordsEnrichmentConfiguration
extends ProcessConfiguration {
    private final List<File> yamlFiles = new ArrayList<File>();
    private final List<String> activeLabels = new ArrayList<String>();
    private final List<KeywordSet> addonVulnerabilityKeywords = new ArrayList<KeywordSet>();
    private boolean failOnValidationErrors = false;

    public VulnerabilityKeywordsEnrichmentConfiguration setYamlFiles(List<File> yamlFiles) {
        this.yamlFiles.clear();
        this.yamlFiles.addAll(yamlFiles);
        return this;
    }

    public VulnerabilityKeywordsEnrichmentConfiguration addYamlFile(File yamlFile) {
        this.yamlFiles.add(yamlFile);
        return this;
    }

    public VulnerabilityKeywordsEnrichmentConfiguration addActiveLabel(String ... label) {
        this.activeLabels.addAll(Arrays.asList(label));
        return this;
    }

    public VulnerabilityKeywordsEnrichmentConfiguration addActiveLabels(Collection<String> labels) {
        this.activeLabels.addAll(labels);
        return this;
    }

    public VulnerabilityKeywordsEnrichmentConfiguration setActiveLabels(Collection<String> labels) {
        this.activeLabels.clear();
        this.activeLabels.addAll(labels);
        return this;
    }

    public VulnerabilityKeywordsEnrichmentConfiguration addAddonVulnerabilityKeywords(KeywordSet addonVulnerabilityKeywords) {
        this.addonVulnerabilityKeywords.add(addonVulnerabilityKeywords);
        return this;
    }

    public VulnerabilityKeywordsEnrichmentConfiguration setFailOnValidationErrors(boolean failOnValidationErrors) {
        this.failOnValidationErrors = failOnValidationErrors;
        return this;
    }

    public VulnerabilityKeywordsEnrichmentConfiguration setAddonVulnerabilityKeywords(List<KeywordSet> addonVulnerabilityKeywords) {
        this.addonVulnerabilityKeywords.clear();
        this.addonVulnerabilityKeywords.addAll(addonVulnerabilityKeywords);
        return this;
    }

    public List<File> getYamlFiles() {
        return this.yamlFiles;
    }

    public List<String> getActiveLabels() {
        return this.activeLabels;
    }

    public VulnerabilityKeywords makeKeywords(CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        VulnerabilityKeywords parsedKeywords = new VulnerabilityKeywords(this.yamlFiles, jsonSchemaValidationErrorsHandling);
        parsedKeywords.addKeywords(this.addonVulnerabilityKeywords);
        return parsedKeywords;
    }

    public boolean isFailOnValidationErrors() {
        return this.failOnValidationErrors;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("yamlFiles", this.yamlFiles);
        properties.put("activeLabels", this.activeLabels);
        properties.put("addonVulnerabilityKeywords", this.addonVulnerabilityKeywords.stream().filter(Objects::nonNull).map(KeywordSet::toFullInformationJson).collect(Collectors.toList()));
        properties.put("failOnValidationErrors", this.failOnValidationErrors);
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadListProperty(properties, "yamlFiles", obj -> new File(String.valueOf(obj)), this::setYamlFiles);
        super.loadListProperty(properties, "activeLabels", String::valueOf, this::setActiveLabels);
        super.loadListProperty(properties, "addonVulnerabilityKeywords", obj -> new KeywordSet().setProperties(obj instanceof Map ? new LinkedHashMap<String, Object>((Map)obj) : new LinkedHashMap(0)), this::setAddonVulnerabilityKeywords);
        super.loadBooleanProperty(properties, "failOnValidationErrors", this::setFailOnValidationErrors);
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        if (this.yamlFiles.isEmpty()) {
            misconfigurations.add(new ProcessMisconfiguration("yamlFiles", "No YAML files configured, set enricher to inactive to avoid exception"));
        }
        if (this.yamlFiles.stream().anyMatch(Objects::isNull)) {
            misconfigurations.add(new ProcessMisconfiguration("yamlFiles", "Must not contain null values"));
        }
    }
}

