/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.converter;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.enrichment.EnrichmentIds;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.InventoryEnrichmentPipeline;
import com.metaeffekt.artifact.enrichment.configurations.InventoryValidationEnrichmentConfiguration;
import java.io.File;
import java.io.StringWriter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EnrichmentPipelineConverter {
    private static final Logger LOG = LoggerFactory.getLogger(EnrichmentPipelineConverter.class);

    public static String toPom(InventoryEnrichmentPipeline pipeline) throws ParserConfigurationException, TransformerException {
        EnrichmentIds id;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element project = document.createElement("project");
        document.appendChild(project);
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, project, "modelVersion", "4.0.0");
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, project, "groupId", "org.metaeffekt");
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, project, "artifactId", "ae-generated-pom");
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, project, "version", "1.0.0-SNAPSHOT");
        Element build = document.createElement("build");
        project.appendChild(build);
        Element plugins = document.createElement("plugins");
        build.appendChild(plugins);
        Element plugin = document.createElement("plugin");
        plugins.appendChild(plugin);
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, plugin, "groupId", "com.metaeffekt.artifact.analysis");
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, plugin, "artifactId", "ae-inventory-enrichment-plugin");
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, plugin, "version", "HEAD-SNAPSHOT");
        Element executions = document.createElement("executions");
        plugin.appendChild(executions);
        Element execution = document.createElement("execution");
        executions.appendChild(execution);
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, execution, "id", "inventory-enrichment");
        Element goals = document.createElement("goals");
        execution.appendChild(goals);
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, goals, "goal", "enrich-inventory");
        Element configuration = document.createElement("configuration");
        execution.appendChild(configuration);
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, configuration, "inventoryInputFile", pipeline.getInventorySourceFile(), File::getAbsolutePath);
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, configuration, "inventoryOutputFile", pipeline.getInventoryResultFile(), File::getAbsolutePath);
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, configuration, "mirrorDirectory", pipeline.getBaseMirrorDirectory(), File::getAbsolutePath);
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, configuration, "writeIntermediateInventories", pipeline.isWriteIntermediateInventories());
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, configuration, "storeIntermediateStepsInInventoryInfo", pipeline.isStoreIntermediateStepsInInventoryInfo());
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, configuration, "intermediateInventoriesDirectory", pipeline.getIntermediateInventoriesDirectory(), File::getAbsolutePath);
        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, configuration, "resumeAtEnrichment", pipeline.getResumeAtEnricher(), e -> e.getConfiguration().getId());
        Element enrichmentOrder = document.createElement("enrichmentOrder");
        configuration.appendChild(enrichmentOrder);
        for (InventoryEnricher enricher : pipeline.getEnrichers()) {
            id = EnrichmentIds.fromEnricherClass(enricher.getClass());
            if (id == null) {
                throw new IllegalStateException("Enricher [" + enricher.getClass() + "] is not registered in EnrichmentIds");
            }
            EnrichmentPipelineConverter.createTextContentNodeIfNN(document, enrichmentOrder, "id", id.id);
        }
        for (InventoryEnricher enricher : pipeline.getEnrichers()) {
            id = EnrichmentIds.fromEnricherClass(enricher.getClass());
            if (id == null) {
                throw new IllegalStateException("Enricher [" + enricher.getClass() + "] is not registered in EnrichmentIds");
            }
            Element enrichment = document.createElement(id.id);
            configuration.appendChild(enrichment);
            ProcessConfiguration enricherConfiguration = enricher.getConfiguration();
            if (enricherConfiguration == null) continue;
            LinkedHashMap configurationMap = enricherConfiguration.getProperties();
            if (!enricher.getConfiguration().getId().equals(enricher.getConfiguration().buildInitialId())) {
                EnrichmentPipelineConverter.createTextContentNodeIfNN(document, enrichment, "id", enricher.getConfiguration().getId());
            }
            if (!enricher.getConfiguration().isActive()) {
                EnrichmentPipelineConverter.createTextContentNodeIfNN(document, enrichment, "active", enricher.getConfiguration().isActive());
            }
            boolean isForceAdd = enricherConfiguration instanceof InventoryValidationEnrichmentConfiguration;
            EnrichmentPipelineConverter.createAndAppendConfigTags(document, enrichment, configurationMap, isForceAdd);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    private static void createAndAppendConfigTags(Document document, Element enrichment, Map<String, Object> configurationMap, boolean forceAdd) {
        if (configurationMap != null) {
            for (Map.Entry<String, Object> entry : configurationMap.entrySet()) {
                if (entry.getValue() == null) continue;
                if (entry.getValue() instanceof Map) {
                    String tagName = entry.getKey();
                    if (tagName.contains(" ")) {
                        tagName = tagName.replaceAll(" ", "-");
                        LOG.warn("Replaced whitespace in tag name [{}]", (Object)tagName);
                    }
                    Element mapElement = document.createElement(tagName);
                    Map map = (Map)entry.getValue();
                    EnrichmentPipelineConverter.createAndAppendConfigTags(document, mapElement, map, forceAdd);
                    if (!forceAdd && !mapElement.hasChildNodes()) continue;
                    enrichment.appendChild(mapElement);
                    continue;
                }
                if (entry.getValue() instanceof Collection) {
                    Element listElement = document.createElement(entry.getKey());
                    Collection list = (Collection)entry.getValue();
                    for (Object listEntry : list) {
                        if (EnrichmentPipelineConverter.isUnsupportedPomType(listEntry)) {
                            LOG.warn("Type is not supported in the pom.xml. Skipping entry [{}]", (Object)entry.getKey());
                            continue;
                        }
                        if (listEntry instanceof Map) {
                            Element mapElement = document.createElement("map");
                            Map map = (Map)listEntry;
                            EnrichmentPipelineConverter.createAndAppendConfigTags(document, mapElement, map, forceAdd);
                            if (!forceAdd && !mapElement.hasChildNodes()) continue;
                            listElement.appendChild(mapElement);
                            continue;
                        }
                        EnrichmentPipelineConverter.createTextContentNodeIfNN(document, listElement, "entry", listEntry);
                    }
                    if (!forceAdd && !listElement.hasChildNodes()) continue;
                    enrichment.appendChild(listElement);
                    continue;
                }
                if (EnrichmentPipelineConverter.isUnsupportedPomType(entry.getValue())) {
                    LOG.warn("Type is not supported in the pom.xml. Skipping entry [{}]", (Object)entry.getKey());
                    continue;
                }
                EnrichmentPipelineConverter.createTextContentNodeIfNN(document, enrichment, entry.getKey(), entry.getValue());
            }
        }
    }

    private static boolean isUnsupportedPomType(Object check) {
        return check instanceof VulnerabilityStatus;
    }

    private static <T> void createTextContentNodeIfNN(Document document, Element parent, String tagName, T textContent) {
        if (textContent == null) {
            return;
        }
        if (tagName.contains(" ")) {
            tagName = tagName.replaceAll(" ", "-");
            LOG.warn("Replaced whitespace in tag name [{}]", (Object)tagName);
        }
        Element element = document.createElement(tagName);
        element.appendChild(document.createTextNode(String.valueOf(textContent)));
        parent.appendChild(element);
    }

    private static <T> void createTextContentNodeIfNN(Document document, Element parent, String tagName, T textContent, Function<T, Object> converter) {
        if (textContent == null) {
            return;
        }
        Element element = document.createElement(tagName);
        element.appendChild(document.createTextNode(String.valueOf(converter.apply(textContent))));
        parent.appendChild(element);
    }
}

