/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.details;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.enrichment.configurations.details.DetailsFillingMsrcInventoryEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.details.DetailsFillingEnrichment;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.advisory.MsrcAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.msrcdata.MsrcSupersedeNode;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.MsrcAdvisorIndexQuery;
import com.metaeffekt.mirror.query.MsrcKbChainIndexQuery;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="MSRC Vulnerability Details", phase=InventoryEnrichmentPhase.VULNERABILITY_DETAILS_FILLING, intermediateFileSuffix="details-vulnerability-msrc", mavenPropertyName="msrcAdvisorFillDetailsEnrichment", explicitConfiguration=DetailsFillingMsrcInventoryEnrichmentConfiguration.class)
public class DetailsFillingEnrichmentMsrc
extends DetailsFillingEnrichment<DetailsFillingMsrcInventoryEnrichmentConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(DetailsFillingEnrichmentMsrc.class);
    private final LazySupplier<MsrcAdvisorIndexQuery> msrcAdvisorQuery = new LazySupplier<MsrcAdvisorIndexQuery>(() -> new MsrcAdvisorIndexQuery(baseMirrorDirectory));
    private final LazySupplier<MsrcKbChainIndexQuery> msrcKbChainIndexQuery = new LazySupplier<MsrcKbChainIndexQuery>(() -> new MsrcKbChainIndexQuery(baseMirrorDirectory));

    public DetailsFillingEnrichmentMsrc(File baseMirrorDirectory) {
        this.setConfiguration(new DetailsFillingMsrcInventoryEnrichmentConfiguration());
    }

    @Override
    protected boolean isApplicable(Vulnerability vulnerability) {
        String name = vulnerability.getId();
        return AdvisoryTypeStore.MSRC.patternMatchesId(name) || VulnerabilityTypeStore.CVE.patternMatchesId(name);
    }

    @Override
    protected boolean isApplicable(AdvisoryEntry advisory) {
        return advisory.getSourceIdentifier() == AdvisoryTypeStore.MSRC && StringUtils.isEmpty(advisory.getSummary()) && advisory.getDescription().isEmpty();
    }

    @Override
    protected void fillDetailsOnVulnerability(Inventory inventory, VulnerabilityContextInventory vInventory, Vulnerability queryVulnerability) {
        List<MsrcAdvisorEntry> advisorEntries = super.pickNonEmptyQueryResult(() -> ((MsrcAdvisorIndexQuery)this.msrcAdvisorQuery.get()).findById(queryVulnerability.getId()), () -> ((MsrcAdvisorIndexQuery)this.msrcAdvisorQuery.get()).findByReferencedId(queryVulnerability.getId()));
        if (advisorEntries.isEmpty()) {
            return;
        }
        for (MsrcAdvisorEntry advisoryEntry : advisorEntries) {
            AdvisoryEntry constructedAdvisory = vInventory.findOrCreateAdvisoryEntryByName(advisoryEntry.getId(), MsrcAdvisorEntry::new);
            constructedAdvisory.addMatchingSource(DataSourceIndicator.vulnerability(queryVulnerability));
            queryVulnerability.addSecurityAdvisory(constructedAdvisory);
            if (!this.isApplicable(constructedAdvisory)) continue;
            this.fillDetailsOnAdvisory(inventory, vInventory, constructedAdvisory);
        }
        Set<Artifact> affectedArtifacts = queryVulnerability.getAffectedArtifactsByDefaultKey();
        if (affectedArtifacts == null) {
            return;
        }
        Set<String> msrcProductIdsOnArtifacts = MsrcAdvisorEntry.getAllMsrcProductIds(affectedArtifacts);
        String msFixingIdValue = queryVulnerability.getAdditionalAttribute(InventoryAttribute.MS_FIXING_KB_IDENTIFIER);
        JSONObject fixingKbIds = StringUtils.hasText(msFixingIdValue) ? new JSONObject(msFixingIdValue) : new JSONObject();
        for (MsrcAdvisorEntry advisoryEntry : queryVulnerability.getRelatedAdvisors(AdvisoryTypeStore.MSRC, MsrcAdvisorEntry.class)) {
            for (String msrcProductIdsOnRelatedArtifact : msrcProductIdsOnArtifacts) {
                Set<MsrcSupersedeNode> kbIds;
                if (!advisoryEntry.getAffectedProducts().contains(msrcProductIdsOnRelatedArtifact) || (kbIds = ((MsrcKbChainIndexQuery)this.msrcKbChainIndexQuery.get()).findFixingKbIds(queryVulnerability.getId(), msrcProductIdsOnRelatedArtifact)).isEmpty()) continue;
                JSONArray fixingKbIdsForProduct = fixingKbIds.optJSONArray(msrcProductIdsOnRelatedArtifact) == null ? new JSONArray() : fixingKbIds.getJSONArray(msrcProductIdsOnRelatedArtifact);
                fixingKbIds.put(msrcProductIdsOnRelatedArtifact, (Object)fixingKbIdsForProduct);
                for (MsrcSupersedeNode kbId : kbIds) {
                    fixingKbIdsForProduct.put((Object)kbId.getKbId());
                }
            }
        }
        if (!fixingKbIds.isEmpty()) {
            fixingKbIds.keySet().forEach(key -> {
                JSONArray fixingKbIdsForProduct = fixingKbIds.getJSONArray(key);
                Set distinctKbIds = fixingKbIdsForProduct.toList().stream().map(Object::toString).collect(Collectors.toSet());
                fixingKbIds.put(key, distinctKbIds);
            });
            queryVulnerability.setAdditionalAttribute(InventoryAttribute.MS_FIXING_KB_IDENTIFIER, fixingKbIds.toString());
        }
    }

    @Override
    protected void fillDetailsOnAdvisory(Inventory inventory, VulnerabilityContextInventory vInventory, AdvisoryEntry queryAdvisory) {
        MsrcAdvisorEntry foundAdvisory = ((MsrcAdvisorIndexQuery)this.msrcAdvisorQuery.get()).findById(queryAdvisory.getId());
        if (foundAdvisory != null) {
            queryAdvisory.appendFromDataClass(foundAdvisory);
        }
    }
}

